/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw.connector;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.RoundRectangleFigure;
import org.jhotdraw.draw.connector.ChopRectangleConnector;
import org.jhotdraw.geom.Geom;

public class ChopRoundRectangleConnector
extends ChopRectangleConnector {
    public ChopRoundRectangleConnector() {
    }

    public ChopRoundRectangleConnector(Figure owner) {
        super(owner);
    }

    @Override
    protected Point2D.Double chop(Figure target, Point2D.Double from) {
        double grow;
        target = this.getConnectorTarget(target);
        RoundRectangleFigure rrf = (RoundRectangleFigure)target;
        Rectangle2D.Double outer = rrf.getBounds();
        switch (target.get(AttributeKeys.STROKE_PLACEMENT)) {
            default: {
                grow = AttributeKeys.getStrokeTotalWidth(target) / 2.0;
                break;
            }
            case OUTSIDE: {
                grow = AttributeKeys.getStrokeTotalWidth(target);
                break;
            }
            case INSIDE: {
                grow = 0.0;
            }
        }
        Geom.grow(outer, grow, grow);
        Rectangle2D.Double inner = (Rectangle2D.Double)outer.clone();
        double gw = -(rrf.getArcWidth() + grow * 2.0) / 2.0;
        double gh = -(rrf.getArcHeight() + grow * 2.0) / 2.0;
        inner.x -= gw;
        inner.y -= gh;
        inner.width += gw * 2.0;
        inner.height += gh * 2.0;
        Point2D.Double p = Geom.angleToPoint(outer, Geom.pointToAngle(outer, from));
        if (p.x == outer.x || p.x == outer.x + outer.width) {
            p.y = Math.min(Math.max(p.y, inner.y), inner.y + inner.height);
        } else {
            p.x = Math.min(Math.max(p.x, inner.x), inner.x + inner.width);
        }
        return p;
    }
}

