/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.jython.shaded.jnr.ffi.provider.jffi;

import org.scijava.jython.shaded.com.kenai.jffi.CallContext;
import org.scijava.jython.shaded.com.kenai.jffi.Invoker;
import org.scijava.jython.shaded.com.kenai.jffi.Platform;
import org.scijava.jython.shaded.jnr.ffi.CallingConvention;
import org.scijava.jython.shaded.jnr.ffi.NativeType;
import org.scijava.jython.shaded.jnr.ffi.Pointer;
import org.scijava.jython.shaded.jnr.ffi.provider.ParameterType;
import org.scijava.jython.shaded.jnr.ffi.provider.ResultType;
import org.scijava.jython.shaded.jnr.ffi.provider.SigType;
import org.scijava.jython.shaded.jnr.ffi.provider.jffi.AbstractFastNumericMethodGenerator;
import org.scijava.jython.shaded.jnr.ffi.provider.jffi.CodegenUtils;
import org.scijava.jython.shaded.jnr.ffi.provider.jffi.NumberUtil;
import org.scijava.jython.shaded.jnr.ffi.provider.jffi.Util;

final class FastIntMethodGenerator
extends AbstractFastNumericMethodGenerator {
    private static final boolean ENABLED = Util.getBooleanProperty("org.scijava.jython.shaded.jnr.ffi.fast-int.enabled", true);
    private static final int MAX_FASTINT_PARAMETERS = FastIntMethodGenerator.getMaximumFastIntParameters();
    private static final String[] signatures;
    private static final String[] methodNames;

    FastIntMethodGenerator() {
    }

    @Override
    String getInvokerMethodName(ResultType resultType, ParameterType[] parameterTypes, boolean ignoreErrno) {
        int parameterCount = parameterTypes.length;
        if (parameterCount <= MAX_FASTINT_PARAMETERS && parameterCount <= methodNames.length) {
            return methodNames[parameterCount];
        }
        throw new IllegalArgumentException("invalid fast-int parameter count: " + parameterCount);
    }

    @Override
    String getInvokerSignature(int parameterCount, Class nativeIntType) {
        if (parameterCount <= MAX_FASTINT_PARAMETERS && parameterCount <= signatures.length) {
            return signatures[parameterCount];
        }
        throw new IllegalArgumentException("invalid fast-int parameter count: " + parameterCount);
    }

    @Override
    final Class getInvokerType() {
        return Integer.TYPE;
    }

    @Override
    public boolean isSupported(ResultType resultType, ParameterType[] parameterTypes, CallingConvention callingConvention) {
        int parameterCount = parameterTypes.length;
        if (!ENABLED) {
            return false;
        }
        if (!callingConvention.equals((Object)CallingConvention.DEFAULT) || parameterCount > MAX_FASTINT_PARAMETERS) {
            return false;
        }
        Platform platform2 = Platform.getPlatform();
        if (platform2.getOS().equals((Object)Platform.OS.WINDOWS)) {
            return false;
        }
        if (!platform2.getCPU().equals((Object)Platform.CPU.I386) && !platform2.getCPU().equals((Object)Platform.CPU.X86_64)) {
            return false;
        }
        for (ParameterType parameterType : parameterTypes) {
            if (FastIntMethodGenerator.isFastIntParameter(platform2, parameterType)) continue;
            return false;
        }
        return FastIntMethodGenerator.isFastIntResult(platform2, resultType);
    }

    static int getMaximumFastIntParameters() {
        try {
            Invoker.class.getDeclaredMethod("invokeI6", CallContext.class, Long.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
            return 6;
        }
        catch (Throwable t) {
            return 0;
        }
    }

    static boolean isFastIntType(Platform platform2, SigType type) {
        switch (type.getNativeType()) {
            case SCHAR: 
            case UCHAR: 
            case SSHORT: 
            case USHORT: 
            case SINT: 
            case UINT: 
            case SLONG: 
            case ULONG: {
                return NumberUtil.sizeof(type.getNativeType()) <= 4;
            }
        }
        return false;
    }

    private static boolean isSupportedPointerParameterType(Class javaParameterType) {
        return Pointer.class.isAssignableFrom(javaParameterType);
    }

    static boolean isFastIntResult(Platform platform2, ResultType resultType) {
        return FastIntMethodGenerator.isFastIntType(platform2, resultType) || resultType.getNativeType() == NativeType.VOID || resultType.getNativeType() == NativeType.ADDRESS && NumberUtil.sizeof(resultType) == 4;
    }

    static boolean isFastIntParameter(Platform platform2, ParameterType parameterType) {
        return FastIntMethodGenerator.isFastIntType(platform2, parameterType) || parameterType.getNativeType() == NativeType.ADDRESS && NumberUtil.sizeof(parameterType) == 4 && FastIntMethodGenerator.isSupportedPointerParameterType(parameterType.effectiveJavaType());
    }

    static {
        methodNames = new String[]{"invokeI0", "invokeI1", "invokeI2", "invokeI3", "invokeI4", "invokeI5", "invokeI6"};
        signatures = new String[MAX_FASTINT_PARAMETERS + 1];
        for (int i = 0; i <= MAX_FASTINT_PARAMETERS; ++i) {
            StringBuilder sb = new StringBuilder();
            sb.append('(').append(CodegenUtils.ci(CallContext.class)).append(CodegenUtils.ci(Long.TYPE));
            for (int n = 0; n < i; ++n) {
                sb.append('I');
            }
            FastIntMethodGenerator.signatures[i] = sb.append(")I").toString();
        }
    }
}

