/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.util;

import edu.mines.jtk.util.Parameter;
import edu.mines.jtk.util.ParameterConvertException;
import edu.mines.jtk.util.ParameterSetFormatException;
import edu.mines.jtk.util.ParameterSetParser;
import edu.mines.jtk.util.XmlUtil;
import java.io.BufferedReader;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.StringReader;
import java.util.Iterator;
import java.util.LinkedHashMap;

public class ParameterSet
implements Cloneable,
Externalizable {
    private String _name;
    private ParameterSet _parent;
    private LinkedHashMap<String, Parameter> _pars = new LinkedHashMap(8);
    private LinkedHashMap<String, ParameterSet> _parsets = new LinkedHashMap(8);

    public ParameterSet() {
    }

    public ParameterSet(String name) {
        this.setNameAndParent(name, null);
    }

    public Object clone() throws CloneNotSupportedException {
        try {
            ParameterSet ps = (ParameterSet)super.clone();
            ps._parent = null;
            ps._pars = new LinkedHashMap();
            ps._parsets = new LinkedHashMap();
            return ps.replaceWith(this);
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public ParameterSet replaceWith(ParameterSet parset) {
        if (parset == this) {
            return this;
        }
        this.setName(parset.getName());
        this.clear();
        Iterator<Parameter> pi = parset.getParameters();
        while (pi.hasNext()) {
            pi.next().copyTo(this);
        }
        Iterator<ParameterSet> psi = parset.getParameterSets();
        while (psi.hasNext()) {
            psi.next().copyTo(this);
        }
        return this;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this.moveTo(this._parent, name);
    }

    public Parameter getParameter(String name) {
        return this._pars.get(name);
    }

    public ParameterSet getParameterSet(String name) {
        return this._parsets.get(name);
    }

    public Parameter addParameter(String name) {
        if (name == null) {
            return null;
        }
        Parameter par = new Parameter(name);
        this.insert(name, par);
        return par;
    }

    public ParameterSet addParameterSet(String name) {
        if (name == null) {
            return null;
        }
        ParameterSet parset = new ParameterSet(name, null);
        this.insert(name, parset);
        return parset;
    }

    public boolean getBoolean(String name, boolean defaultValue) throws ParameterConvertException {
        Parameter par = this.getParameter(name);
        return par != null ? par.getBoolean() : defaultValue;
    }

    public int getInt(String name, int defaultValue) throws ParameterConvertException {
        Parameter par = this.getParameter(name);
        return par != null ? par.getInt() : defaultValue;
    }

    public long getLong(String name, long defaultValue) throws ParameterConvertException {
        Parameter par = this.getParameter(name);
        return par != null ? par.getLong() : defaultValue;
    }

    public float getFloat(String name, float defaultValue) throws ParameterConvertException {
        Parameter par = this.getParameter(name);
        return par != null ? par.getFloat() : defaultValue;
    }

    public double getDouble(String name, double defaultValue) throws ParameterConvertException {
        Parameter par = this.getParameter(name);
        return par != null ? par.getDouble() : defaultValue;
    }

    public String getString(String name, String defaultValue) throws ParameterConvertException {
        Parameter par = this.getParameter(name);
        return par != null ? par.getString() : defaultValue;
    }

    public boolean[] getBooleans(String name, boolean[] defaultValues) throws ParameterConvertException {
        Parameter par = this.getParameter(name);
        return par != null ? par.getBooleans() : defaultValues;
    }

    public int[] getInts(String name, int[] defaultValues) throws ParameterConvertException {
        Parameter par = this.getParameter(name);
        return par != null ? par.getInts() : defaultValues;
    }

    public long[] getLongs(String name, long[] defaultValues) throws ParameterConvertException {
        Parameter par = this.getParameter(name);
        return par != null ? par.getLongs() : defaultValues;
    }

    public float[] getFloats(String name, float[] defaultValues) throws ParameterConvertException {
        Parameter par = this.getParameter(name);
        return par != null ? par.getFloats() : defaultValues;
    }

    public double[] getDoubles(String name, double[] defaultValues) throws ParameterConvertException {
        Parameter par = this.getParameter(name);
        return par != null ? par.getDoubles() : defaultValues;
    }

    public String[] getStrings(String name, String[] defaultValues) throws ParameterConvertException {
        Parameter par = this.getParameter(name);
        return par != null ? par.getStrings() : defaultValues;
    }

    public String getUnits(String name, String defaultUnits) {
        Parameter par = this.getParameter(name);
        return par != null ? par.getUnits() : defaultUnits;
    }

    public void setBoolean(String name, boolean value) {
        Parameter par = this.getParameter(name);
        if (par == null) {
            par = this.addParameter(name);
        }
        par.setBoolean(value);
    }

    public void setInt(String name, int value) {
        Parameter par = this.getParameter(name);
        if (par == null) {
            par = this.addParameter(name);
        }
        par.setInt(value);
    }

    public void setLong(String name, long value) {
        Parameter par = this.getParameter(name);
        if (par == null) {
            par = this.addParameter(name);
        }
        par.setLong(value);
    }

    public void setFloat(String name, float value) {
        Parameter par = this.getParameter(name);
        if (par == null) {
            par = this.addParameter(name);
        }
        par.setFloat(value);
    }

    public void setDouble(String name, double value) {
        Parameter par = this.getParameter(name);
        if (par == null) {
            par = this.addParameter(name);
        }
        par.setDouble(value);
    }

    public void setString(String name, String value) {
        Parameter par = this.getParameter(name);
        if (par == null) {
            par = this.addParameter(name);
        }
        par.setString(value);
    }

    public void setBooleans(String name, boolean[] values) {
        Parameter par = this.getParameter(name);
        if (par == null) {
            par = this.addParameter(name);
        }
        par.setBooleans(values);
    }

    public void setInts(String name, int[] values) {
        Parameter par = this.getParameter(name);
        if (par == null) {
            par = this.addParameter(name);
        }
        par.setInts(values);
    }

    public void setLongs(String name, long[] values) {
        Parameter par = this.getParameter(name);
        if (par == null) {
            par = this.addParameter(name);
        }
        par.setLongs(values);
    }

    public void setFloats(String name, float[] values) {
        Parameter par = this.getParameter(name);
        if (par == null) {
            par = this.addParameter(name);
        }
        par.setFloats(values);
    }

    public void setDoubles(String name, double[] values) {
        Parameter par = this.getParameter(name);
        if (par == null) {
            par = this.addParameter(name);
        }
        par.setDoubles(values);
    }

    public void setStrings(String name, String[] values) {
        Parameter par = this.getParameter(name);
        if (par == null) {
            par = this.addParameter(name);
        }
        par.setStrings(values);
    }

    public void setUnits(String name, String units) {
        Parameter par = this.getParameter(name);
        if (par == null) {
            par = this.addParameter(name);
        }
        par.setUnits(units);
    }

    public ParameterSet copyTo(ParameterSet parent) {
        return this.copyTo(parent, this.getName());
    }

    public ParameterSet copyTo(ParameterSet parent, String name) {
        if (this._parent == parent && this._name == name) {
            return this;
        }
        ParameterSet ps = new ParameterSet(name);
        Iterator<Parameter> pi = this.getParameters();
        while (pi.hasNext()) {
            pi.next().copyTo(ps);
        }
        Iterator<ParameterSet> psi = this.getParameterSets();
        while (psi.hasNext()) {
            psi.next().copyTo(ps);
        }
        if (parent != null) {
            parent.insert(name, ps);
        }
        return ps;
    }

    public ParameterSet moveTo(ParameterSet parent) {
        return this.moveTo(parent, this.getName());
    }

    public ParameterSet moveTo(ParameterSet parent, String name) {
        if (this._parent == parent && this._name == name) {
            return this;
        }
        for (ParameterSet ps = parent; ps != null; ps = ps.getParent()) {
            if (ps != this) continue;
            throw new IllegalArgumentException("ParameterSet.moveTo: specified parent \"" + parent.getName() + "\"" + " cannot be this parameter set \"" + this.getName() + "\"" + " or a subset of this parameter set.");
        }
        if (this._parent != null) {
            this._parent.remove(this);
        }
        if (parent != null) {
            parent.insert(name, this);
        } else {
            this.setNameAndParent(name, null);
        }
        return this;
    }

    public void remove() {
        if (this._parent != null) {
            this._parent.remove(this);
        }
    }

    public void remove(String name) {
        Parameter par = this.getParameter(name);
        if (par != null) {
            par.remove();
        } else {
            ParameterSet parset = this.getParameterSet(name);
            if (parset != null) {
                parset.remove();
            }
        }
    }

    public int countParameters() {
        return this._pars.size();
    }

    public int countParameterSets() {
        return this._parsets.size();
    }

    public void clear() {
        Iterator<Parameter> pi = this.getParameters();
        while (pi.hasNext()) {
            pi.next().setParent(null);
        }
        Iterator<ParameterSet> psi = this.getParameterSets();
        while (psi.hasNext()) {
            psi.next().setParent(null);
        }
        this._pars.clear();
        this._parsets.clear();
    }

    public ParameterSet getParent() {
        return this._parent;
    }

    public Iterator<Parameter> getParameters() {
        return this._pars.values().iterator();
    }

    public Iterator<ParameterSet> getParameterSets() {
        return this._parsets.values().iterator();
    }

    public void fromString(String s) throws ParameterSetFormatException {
        this.clear();
        ParameterSetParser psp = new ParameterSetParser();
        psp.parse(new BufferedReader(new StringReader(s)), this);
    }

    public String toString() {
        String indent = "";
        for (ParameterSet parent = this.getParent(); parent != null; parent = parent.getParent()) {
            indent = indent + "  ";
        }
        StringBuffer sb = new StringBuffer(256);
        String name = XmlUtil.quoteAttributeValue(this._name != null ? this._name : "");
        sb.append(indent).append("<parset name=").append(name).append(">\n");
        Iterator<Parameter> pi = this.getParameters();
        while (pi.hasNext()) {
            Parameter p = pi.next();
            sb.append(p.toString());
        }
        Iterator<ParameterSet> psi = this.getParameterSets();
        while (psi.hasNext()) {
            ParameterSet ps = psi.next();
            sb.append(ps.toString());
        }
        sb.append(indent).append("</parset>\n");
        return sb.toString();
    }

    public boolean equals(Object o) {
        int i;
        Cloneable[] those;
        Cloneable[] these;
        if (o == this) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ParameterSet other = (ParameterSet)o;
        if (this._name == null ? other._name != null : !this._name.equals(other._name)) {
            return false;
        }
        int npars = this.countParameters();
        if (npars != other.countParameters()) {
            return false;
        }
        int nparsets = this.countParameterSets();
        if (nparsets != other.countParameterSets()) {
            return false;
        }
        if (npars > 0) {
            these = new Parameter[npars];
            those = new Parameter[npars];
            i = 0;
            Iterator<Parameter> pi = this.getParameters();
            while (pi.hasNext()) {
                these[i++] = pi.next();
            }
            i = 0;
            pi = other.getParameters();
            while (pi.hasNext()) {
                those[i++] = pi.next();
            }
            ParameterSet.sortParametersByName((Parameter[])these);
            ParameterSet.sortParametersByName((Parameter[])those);
            for (i = 0; i < npars; ++i) {
                if (((Parameter)these[i]).equals(those[i])) continue;
                return false;
            }
        }
        if (nparsets > 0) {
            these = new ParameterSet[nparsets];
            those = new ParameterSet[nparsets];
            i = 0;
            Iterator<ParameterSet> psi = this.getParameterSets();
            while (psi.hasNext()) {
                these[i++] = psi.next();
            }
            i = 0;
            psi = other.getParameterSets();
            while (psi.hasNext()) {
                those[i++] = psi.next();
            }
            ParameterSet.sortParameterSetsByName((ParameterSet[])these);
            ParameterSet.sortParameterSetsByName((ParameterSet[])those);
            for (i = 0; i < nparsets; ++i) {
                if (((ParameterSet)these[i]).equals(those[i])) continue;
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        String name = this._name != null ? this._name : "name";
        int code = name.hashCode();
        Iterator<Parameter> pars = this.getParameters();
        while (pars.hasNext()) {
            code ^= pars.next().hashCode();
        }
        Iterator<ParameterSet> parsets = this.getParameterSets();
        while (parsets.hasNext()) {
            code ^= parsets.next().hashCode();
        }
        return code;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.toString());
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException, ParameterSetFormatException {
        String s = in.readUTF();
        this.fromString(s);
    }

    void remove(Parameter par) {
        if (par == null) {
            return;
        }
        this._pars.remove(par.getName());
        par.setParent(null);
    }

    void insert(String name, Parameter par) {
        if (name == null || par == null) {
            return;
        }
        par.remove();
        this.remove(name);
        this._pars.put(name, par);
        par.setNameAndParent(name, this);
    }

    private ParameterSet(String name, ParameterSet parent) {
        this.setNameAndParent(name, parent);
    }

    private void setParent(ParameterSet parent) {
        this._parent = parent;
    }

    private void setNameAndParent(String name, ParameterSet parent) {
        this._name = name;
        if (this._name != null && this._name.equals("")) {
            this._name = null;
        }
        this._parent = parent;
    }

    private void remove(ParameterSet parset) {
        if (parset == null) {
            return;
        }
        this._parsets.remove(parset.getName());
        parset.setParent(null);
    }

    private void insert(String name, ParameterSet parset) {
        if (name == null || parset == null) {
            return;
        }
        parset.remove();
        this.remove(name);
        this._parsets.put(name, parset);
        parset.setNameAndParent(name, this);
    }

    private static void swap(Object[] v, int i, int j) {
        Object temp = v[i];
        v[i] = v[j];
        v[j] = temp;
    }

    private static void qsortParameters(Parameter[] v, int left, int right) {
        if (left >= right) {
            return;
        }
        ParameterSet.swap(v, left, (left + right) / 2);
        int last = left;
        for (int i = left + 1; i <= right; ++i) {
            if (v[i].getName().compareTo(v[left].getName()) >= 0) continue;
            ParameterSet.swap(v, ++last, i);
        }
        ParameterSet.swap(v, left, last);
        ParameterSet.qsortParameters(v, left, last - 1);
        ParameterSet.qsortParameters(v, last + 1, right);
    }

    private static void qsortParameterSets(ParameterSet[] v, int left, int right) {
        if (left >= right) {
            return;
        }
        ParameterSet.swap(v, left, (left + right) / 2);
        int last = left;
        for (int i = left + 1; i <= right; ++i) {
            if (v[i].getName().compareTo(v[left].getName()) >= 0) continue;
            ParameterSet.swap(v, ++last, i);
        }
        ParameterSet.swap(v, left, last);
        ParameterSet.qsortParameterSets(v, left, last - 1);
        ParameterSet.qsortParameterSets(v, last + 1, right);
    }

    private static void sortParametersByName(Parameter[] v) {
        ParameterSet.qsortParameters(v, 0, v.length - 1);
    }

    private static void sortParameterSetsByName(ParameterSet[] v) {
        ParameterSet.qsortParameterSets(v, 0, v.length - 1);
    }
}

