/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.dsp;

import edu.mines.jtk.dsp.Eigen;
import edu.mines.jtk.util.ArrayMath;
import edu.mines.jtk.util.Stopwatch;
import java.util.Random;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class EigenTest
extends TestCase {
    private static final double[][] A100 = new double[][]{{1.0, 0.0, 0.0}, {0.0, 0.0, 0.0}, {0.0, 0.0, 0.0}};
    private static final double[][] A110 = new double[][]{{1.0, 0.0, 0.0}, {0.0, 1.0, 0.0}, {0.0, 0.0, 0.0}};
    private static final double[][] A111 = new double[][]{{1.0, 0.0, 0.0}, {0.0, 1.0, 0.0}, {0.0, 0.0, 1.0}};
    private static final double[][] ASMALL = new double[][]{{-1.08876E-13, 1.87872E-17, 1.29275E-16}, {1.87872E-17, -7.65274E-15, -1.13984E-14}, {1.29275E-16, -1.13984E-14, -2.53222E-14}};
    private static final double[][] ATEST1 = new double[][]{{0.54957539, -0.00555262, 0.09809611}, {-0.00555262, 0.41839826, -0.00414489}, {0.09809611, -0.00414489, 0.49139029}};
    private static Random r = new Random();

    public static void main(String[] args) {
        if (args.length > 0 && args[0].equals("bench")) {
            EigenTest.benchSymmetric33();
        } else {
            TestSuite suite = new TestSuite(EigenTest.class);
            TestRunner.run((Test)suite);
        }
    }

    public void testSymmetric22() {
        int nrand = 10000;
        double[][] v = new double[2][2];
        double[] d = new double[2];
        for (int irand = 0; irand < nrand; ++irand) {
            double[][] a = ArrayMath.randdouble(2, 2);
            a = ArrayMath.add(a, ArrayMath.transpose(a));
            Eigen.solveSymmetric22(a, v, d);
            this.check(a, v, d);
        }
    }

    public void testSymmetric33() {
        double[][] v = new double[3][3];
        double[] d = new double[3];
        int nrand = 10000;
        for (int irand = 0; irand < nrand; ++irand) {
            double[][] a = EigenTest.makeRandomSymmetric33();
            Eigen.solveSymmetric33(a, v, d);
            this.check(a, v, d);
        }
    }

    public void testSymmetric33Special() {
        double[][][] as;
        double[][] v = new double[3][3];
        double[] d = new double[3];
        for (double[][] a : as = new double[][][]{ASMALL, A100, A110, A111, ATEST1}) {
            Eigen.solveSymmetric33(a, v, d);
            this.check(a, v, d);
        }
    }

    private void check(double[][] a, double[][] v, double[] d) {
        int n = a.length;
        for (int k = 0; k < n; ++k) {
            EigenTest.assertTrue((k == 0 || d[k - 1] >= d[k] ? 1 : 0) != 0);
            for (int i = 0; i < n; ++i) {
                double av = 0.0;
                for (int j = 0; j < n; ++j) {
                    av += a[i][j] * v[k][j];
                }
                double vd = v[k][i] * d[k];
                EigenTest.assertEquals((double)av, (double)vd, (double)1.0E-4);
            }
        }
    }

    private static double[][] makeSymmetric33(double[] e, double[] u, double[] w) {
        double eu = e[0];
        double ev = e[1];
        double ew = e[2];
        double u1 = u[0];
        double u2 = u[1];
        double u3 = u[2];
        double w1 = w[0];
        double w2 = w[1];
        double w3 = w[2];
        double[][] a = new double[3][3];
        double esum = eu + ev + ew;
        ev = esum - eu - ew;
        a[0][0] = (eu -= ev) * u1 * u1 + (ew -= ev) * w1 * w1 + ev;
        a[0][1] = eu * u1 * u2 + ew * w1 * w2;
        a[0][2] = eu * u1 * u3 + ew * w1 * w3;
        a[1][0] = a[0][1];
        a[1][1] = eu * u2 * u2 + ew * w2 * w2 + ev;
        a[1][2] = eu * u2 * u3 + ew * w2 * w3;
        a[2][0] = a[0][2];
        a[2][1] = a[1][2];
        a[2][2] = eu * u3 * u3 + ew * w3 * w3 + ev;
        return a;
    }

    private static double[][] makeRandomSymmetric33() {
        double[] e = EigenTest.makeRandomEigenvalues3();
        double[] u = EigenTest.makeRandomEigenvector3();
        double[] w = EigenTest.makeOrthogonalVector3(u);
        return EigenTest.makeSymmetric33(e, u, w);
    }

    private static double[] makeRandomEigenvalues3() {
        double a1 = r.nextDouble();
        double a2 = r.nextDouble();
        double a3 = r.nextDouble();
        double au = Math.max(Math.max(a1, a2), a3);
        double aw = Math.min(Math.min(a1, a2), a3);
        double av = a1 + a2 + a3 - au - aw;
        return new double[]{au, av, aw};
    }

    private static double[] makeRandomEigenvector3() {
        double a = r.nextDouble() - 0.5;
        double b = r.nextDouble() - 0.5;
        double c = r.nextDouble() - 0.5;
        if (c < 0.0) {
            a = -a;
            b = -b;
            c = -c;
        }
        double s = 1.0 / Math.sqrt(a * a + b * b + c * c);
        return new double[]{a * s, b * s, c * s};
    }

    private static double[] makeOrthogonalVector3(double[] v1) {
        double a1 = v1[0];
        double b1 = v1[1];
        double c1 = v1[2];
        double a2 = r.nextDouble() - 0.5;
        double b2 = r.nextDouble() - 0.5;
        double c2 = r.nextDouble() - 0.5;
        double d11 = a1 * a1 + b1 * b1 + c1 * c1;
        double d12 = a1 * a2 + b1 * b2 + c1 * c2;
        double s = d12 / d11;
        double a = a2 - s * a1;
        double b = b2 - s * b1;
        double c = c2 - s * c1;
        if (c < 0.0) {
            a = -a;
            b = -b;
            c = -c;
        }
        s = 1.0 / Math.sqrt(a * a + b * b + c * c);
        return new double[]{a * s, b * s, c * s};
    }

    private static void benchSymmetric33() {
        int irand;
        int nrand = 10000;
        double[][][] a = new double[nrand][][];
        for (int irand2 = 0; irand2 < nrand; ++irand2) {
            a[irand2] = ArrayMath.randdouble(3, 3);
            a[irand2] = ArrayMath.add(a[irand2], ArrayMath.transpose(a[irand2]));
        }
        double[][] v = new double[3][3];
        double[] d = new double[3];
        Stopwatch s = new Stopwatch();
        double maxtime = 2.0;
        s.reset();
        s.start();
        int nloop = 0;
        while (s.time() < maxtime) {
            for (irand = 0; irand < nrand; ++irand) {
                Eigen.solveSymmetric33(a[irand], v, d);
            }
            ++nloop;
        }
        s.stop();
        int rate = (int)((double)nloop * (double)nrand / s.time());
        System.out.println("Number of 3x3 eigen-decompositions per second");
        System.out.println("jacobi: rate=" + rate);
        s.reset();
        s.start();
        nloop = 0;
        while (s.time() < maxtime) {
            for (irand = 0; irand < nrand; ++irand) {
                Eigen.solveSymmetric33Fast(a[irand], v, d);
            }
            ++nloop;
        }
        s.stop();
        rate = (int)((double)nloop * (double)nrand / s.time());
        System.out.println("hybrid: rate=" + rate);
    }
}

