/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.ast.Colon3Node;
import org.jruby.ast.IScopingNode;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.evaluator.ASTInterpreter;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class ClassNode
extends Node
implements IScopingNode {
    private final Colon3Node cpath;
    private final StaticScope scope;
    private final Node bodyNode;
    private final Node superNode;

    public ClassNode(ISourcePosition position, Colon3Node cpath, StaticScope scope, Node bodyNode, Node superNode) {
        super(position);
        assert (cpath != null) : "cpath is not null";
        assert (scope != null) : "scope is not null";
        assert (bodyNode != null) : "bodyNode is not null";
        this.cpath = cpath;
        this.scope = scope;
        this.bodyNode = bodyNode;
        this.superNode = superNode;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.CLASSNODE;
    }

    @Override
    public Object accept(NodeVisitor iVisitor) {
        return iVisitor.visitClassNode(this);
    }

    public Node getBodyNode() {
        return this.bodyNode;
    }

    public StaticScope getScope() {
        return this.scope;
    }

    @Override
    public Colon3Node getCPath() {
        return this.cpath;
    }

    public Node getSuperNode() {
        return this.superNode;
    }

    @Override
    public List<Node> childNodes() {
        return Node.createList((Node)this.cpath, this.bodyNode, this.superNode);
    }

    @Override
    public IRubyObject interpret(Ruby runtime, ThreadContext context, IRubyObject self2, Block aBlock) {
        RubyModule enclosingClass = this.cpath.getEnclosingModule(runtime, context, self2, aBlock);
        if (enclosingClass == null) {
            throw runtime.newTypeError("no outer class/module");
        }
        RubyClass superClass = null;
        if (this.superNode != null) {
            IRubyObject superObj = this.superNode.interpret(runtime, context, self2, aBlock);
            RubyClass.checkInheritable(superObj);
            superClass = (RubyClass)superObj;
        }
        RubyClass clazz = enclosingClass.defineOrGetClassUnder(this.cpath.getName(), superClass);
        this.scope.setModule(clazz);
        IRubyObject classBodyResult = ASTInterpreter.evalClassDefinitionBody(runtime, context, this.scope, this.bodyNode, clazz, self2, aBlock);
        return classBodyResult;
    }
}

