/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.minimaven;

import java.util.Set;

public class Coordinate {
    protected String groupId;
    protected String artifactId;
    protected String version;
    protected String systemPath;
    protected String classifier;
    protected String scope;
    protected String snapshotVersion;
    protected boolean optional;
    protected Set<String> exclusions;

    public Coordinate() {
    }

    public Coordinate(String groupId, String artifactId, String version) {
        this(groupId, artifactId, version, null, false, null, null, null);
    }

    @Deprecated
    public Coordinate(String groupId, String artifactId, String version, String scope, boolean optional, String systemPath, String classifier) {
        this(groupId, artifactId, version, scope, optional, systemPath, classifier, null);
    }

    protected Coordinate(String groupId, String artifactId, String version, String scope, boolean optional, String systemPath, String classifier, Set<String> exclusions) {
        this.groupId = this.normalize(groupId);
        this.artifactId = this.normalize(artifactId);
        this.version = this.normalize(version);
        this.scope = this.normalize(scope);
        this.optional = optional;
        this.systemPath = this.normalize(systemPath);
        this.classifier = classifier;
        this.exclusions = exclusions;
    }

    public String normalize(String s) {
        return "".equals(s) ? null : s;
    }

    public String getJarName() {
        return this.getJarName(false);
    }

    public String getJarName(boolean withProjectPrefix) {
        return this.getFileName(withProjectPrefix, true, "jar");
    }

    public String getPOMName() {
        return this.getPOMName(false);
    }

    public String getPOMName(boolean withProjectPrefix) {
        return this.getFileName(withProjectPrefix, false, "pom");
    }

    public String getFileName(boolean withClassifier, String fileExtension) {
        return this.getFileName(false, withClassifier, fileExtension);
    }

    public String getFileName(boolean withProjectPrefix, boolean withClassifier, String fileExtension) {
        return (withProjectPrefix ? this.groupId + "/" : "") + this.artifactId + "-" + this.getVersion() + (withClassifier && this.classifier != null ? "-" + this.classifier : "") + (fileExtension != null ? "." + fileExtension : "");
    }

    public String getKey() {
        return this.groupId + ">" + this.artifactId + (this.classifier == null ? "" : ">" + this.classifier);
    }

    public void setSnapshotVersion(String version) {
        this.snapshotVersion = version;
    }

    public String getGAV() {
        return this.getGroupId() + ":" + this.getArtifactId() + ":" + this.getVersion();
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.snapshotVersion != null ? this.snapshotVersion : this.version;
    }

    public String toString() {
        String extra = "";
        if (this.optional) {
            extra = extra + " optional";
        }
        if (this.scope != null) {
            extra = extra + " scope=" + this.scope;
        }
        if (extra.startsWith(" ")) {
            extra = "{" + extra.substring(1) + "}";
        }
        return this.getFileName(true, true, null) + extra;
    }
}

