/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.jupyter;

import com.twosigma.jupyter.Config;
import com.twosigma.jupyter.ConfigurationFile;
import com.twosigma.jupyter.message.MessageSerializer;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KernelConfigurationFile
implements ConfigurationFile {
    private static final Logger logger = LoggerFactory.getLogger(KernelConfigurationFile.class);
    private File config;
    private Config configuration;

    public KernelConfigurationFile(String[] args) {
        this.config = this.getConfig(args);
    }

    @Override
    public Config getConfig() {
        if (this.configuration == null) {
            logger.debug("Path to config file : " + this.config.getAbsolutePath());
            this.configuration = MessageSerializer.parse(new String(this.readConfig()), Config.class);
            logger.debug("Creating signing hmac with: {}", (Object)this.configuration.getKey());
        }
        return this.configuration;
    }

    private byte[] readConfig() {
        byte[] bytes = new byte[]{};
        try {
            bytes = Files.readAllBytes(this.config.toPath());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return bytes;
    }

    private File getConfig(String[] args) {
        File config;
        if (args.length != 1) {
            System.out.println("Invalid parameters passed to the Kernel.");
            System.out.println("Expected one parameter, found " + String.valueOf(args.length));
            for (String string : args) {
                System.out.println(string);
            }
            System.exit(1);
        }
        if (!(config = new File(args[0])).exists()) {
            System.out.println("Kernel configuration not found.");
            System.exit(1);
        }
        return config;
    }
}

