/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beaker.jupyter.comm;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twosigma.beaker.BeakerCodeCell;
import com.twosigma.beaker.NamespaceClient;
import com.twosigma.beaker.jupyter.comm.BaseHandler;
import com.twosigma.beaker.jvm.serialization.BasicObjectSerializer;
import com.twosigma.beaker.jvm.serialization.BeakerObjectConverter;
import com.twosigma.jupyter.KernelFunctionality;
import com.twosigma.jupyter.message.Message;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.List;

public class GetCodeCellsHandler
extends BaseHandler<Object> {
    private static final String GET_CODE_CELLS = "code_cells";
    private ObjectMapper objectMapper = new ObjectMapper();
    private BeakerObjectConverter objectSerializer = new BasicObjectSerializer();

    public GetCodeCellsHandler(KernelFunctionality kernel) {
        super(kernel);
    }

    @Override
    public void handle(Message message) {
        try {
            List<BeakerCodeCell> cells = this.getBeakerCodeCells(this.getValueFromData(message, this.getHandlerCommand()));
            NamespaceClient.getMessageQueue("CodeCells").put(cells);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private List<BeakerCodeCell> getBeakerCodeCells(Object value) {
        List<Object> beakerCodeCellList = null;
        StringWriter sw = new StringWriter();
        JsonGenerator jgen = null;
        try {
            jgen = this.objectMapper.getFactory().createGenerator((Writer)sw);
            this.objectSerializer.writeObject(value, jgen, true);
            jgen.flush();
            sw.flush();
            beakerCodeCellList = Arrays.asList((Object[])this.objectMapper.readValue(sw.toString(), BeakerCodeCell[].class));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return beakerCodeCellList;
    }

    @Override
    public String getHandlerCommand() {
        return GET_CODE_CELLS;
    }
}

