/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beaker.jupyter.comm;

import com.twosigma.beaker.evaluator.InternalVariable;
import com.twosigma.beaker.jupyter.KernelManager;
import com.twosigma.beaker.jupyter.Utils;
import com.twosigma.beaker.jupyter.comm.TargetNamesEnum;
import com.twosigma.beaker.jupyter.msg.JupyterMessages;
import com.twosigma.jupyter.KernelFunctionality;
import com.twosigma.jupyter.handler.Handler;
import com.twosigma.jupyter.message.Header;
import com.twosigma.jupyter.message.Message;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Comm {
    private static final Logger logger = LoggerFactory.getLogger(Comm.class);
    public static final String METHOD = "method";
    public static final String UPDATE = "update";
    public static final String STATE = "state";
    public static final String COMM_ID = "comm_id";
    public static final String TARGET_NAME = "target_name";
    public static final String DATA = "data";
    public static final String TARGET_MODULE = "target_module";
    public static final String COMMS = "comms";
    private String commId;
    private String targetName;
    private HashMap<?, ?> data;
    private String targetModule;
    private KernelFunctionality kernel;
    private List<Handler<Message>> msgCallbackList = new ArrayList<Handler<Message>>();
    private List<Handler<Message>> closeCallbackList = new ArrayList<Handler<Message>>();

    public Comm(String commId, String targetName) {
        this.kernel = KernelManager.get();
        this.commId = commId;
        this.targetName = targetName;
        this.data = new HashMap();
    }

    public Comm(String commId, TargetNamesEnum targetName) {
        this(commId, targetName.getTargetName());
    }

    public Comm(TargetNamesEnum targetName) {
        this(Utils.uuid(), targetName.getTargetName());
    }

    public Comm(String targetName) {
        this(Utils.uuid(), targetName);
    }

    public String getCommId() {
        return this.commId;
    }

    public String getTargetName() {
        return this.targetName;
    }

    public HashMap<?, ?> getData() {
        return this.data;
    }

    public void setData(HashMap<?, ?> data) {
        this.data = data;
    }

    public String getTargetModule() {
        return this.targetModule;
    }

    public void setTargetModule(String targetModule) {
        this.targetModule = targetModule;
    }

    public List<Handler<Message>> getMsgCallbackList() {
        return this.msgCallbackList;
    }

    public void addMsgCallbackList(Handler<Message> ... handlers) {
        this.msgCallbackList.addAll(Arrays.asList(handlers));
    }

    public void clearMsgCallbackList() {
        this.msgCallbackList = new ArrayList<Handler<Message>>();
    }

    public List<Handler<Message>> getCloseCallbackList() {
        return this.closeCallbackList;
    }

    public void addCloseCallbackList(Handler<Message> ... handlers) {
        this.closeCallbackList.addAll(Arrays.asList(handlers));
    }

    public void clearCloseCallbackList() {
        this.closeCallbackList = new ArrayList<Handler<Message>>();
    }

    public void open() {
        Message parentMessage = this.getParentMessage();
        Message message = new Message();
        message.setHeader(new Header(JupyterMessages.COMM_OPEN, parentMessage != null ? parentMessage.getHeader().getSession() : null));
        if (parentMessage != null) {
            message.setParentHeader(this.getParentMessage().getHeader());
        }
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        map.put(COMM_ID, (Serializable)((Object)this.getCommId()));
        map.put(TARGET_NAME, (Serializable)((Object)this.getTargetName()));
        map.put(DATA, this.data);
        map.put(TARGET_MODULE, (Serializable)((Object)this.getTargetModule()));
        message.setContent(map);
        this.kernel.publish(message);
        this.kernel.addComm(this.getCommId(), this);
    }

    public void close() {
        Message parentMessage = this.getParentMessage();
        if (this.getCloseCallbackList() != null && !this.getCloseCallbackList().isEmpty()) {
            for (Handler<Message> handler : this.getCloseCallbackList()) {
                handler.handle(parentMessage);
            }
        }
        Message message = new Message();
        message.setHeader(new Header(JupyterMessages.COMM_CLOSE, parentMessage != null ? parentMessage.getHeader().getSession() : null));
        if (parentMessage != null) {
            message.setParentHeader(parentMessage.getHeader());
        }
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        map.put(COMM_ID, (Serializable)((Object)this.getCommId()));
        map.put(DATA, new HashMap());
        message.setContent(map);
        this.kernel.removeComm(this.getCommId());
        this.kernel.publish(message);
    }

    public void send() {
        Message parentMessage = this.getParentMessage();
        Message message = new Message();
        message.setHeader(new Header(JupyterMessages.COMM_MSG, parentMessage != null ? parentMessage.getHeader().getSession() : null));
        if (parentMessage != null) {
            message.setParentHeader(this.getParentMessage().getHeader());
        }
        HashMap<String, Serializable> map = new HashMap<String, Serializable>(6);
        map.put(COMM_ID, (Serializable)((Object)this.getCommId()));
        map.put(DATA, this.data);
        message.setContent(map);
        this.kernel.publish(message);
    }

    public void sendUpdate(String propertyName, Object value) {
        HashMap<String, Object> content = new HashMap<String, Object>();
        content.put(METHOD, UPDATE);
        HashMap<String, Object> state = new HashMap<String, Object>();
        state.put(propertyName, value);
        content.put(STATE, state);
        this.setData(content);
        this.send();
    }

    private Message getParentMessage() {
        return InternalVariable.getParentHeader();
    }

    public void handleMsg(Message parentMessage) {
        if (this.getMsgCallbackList() != null && !this.getMsgCallbackList().isEmpty()) {
            for (Handler<Message> handler : this.getMsgCallbackList()) {
                handler.handle(parentMessage);
            }
        }
    }

    public String toString() {
        return this.commId + "/" + this.targetName + "/" + (this.targetModule != null && !this.targetModule.isEmpty() ? this.targetModule : "");
    }
}

