/*
 * Decompiled with CFR 0.152.
 */
package io.scif.gui;

import io.scif.AbstractReader;
import io.scif.BufferedImagePlane;
import io.scif.FormatException;
import io.scif.ImageMetadata;
import io.scif.Metadata;
import io.scif.TypedMetadata;
import io.scif.gui.AWTImageTools;
import io.scif.util.FormatTools;
import java.io.IOException;

public abstract class BufferedImageReader<M extends TypedMetadata>
extends AbstractReader<M, BufferedImagePlane> {
    public BufferedImageReader() {
        super(BufferedImagePlane.class);
    }

    @Override
    public BufferedImagePlane openThumbPlane(int imageIndex, long planeIndex) throws FormatException, IOException {
        FormatTools.assertStream(this.getStream(), true, 1);
        Metadata meta = this.getMetadata();
        long[] planeBounds = meta.get(imageIndex).getAxesLengthsPlanar();
        long[] planeOffsets = new long[planeBounds.length];
        BufferedImagePlane plane = this.createPlane(planeOffsets, planeBounds);
        plane.setData(AWTImageTools.openThumbImage(this.openPlane(imageIndex, planeIndex), this, imageIndex, planeBounds, (int)meta.get(imageIndex).getThumbSizeX(), (int)meta.get(imageIndex).getThumbSizeY(), false));
        return plane;
    }

    @Override
    public BufferedImagePlane createPlane(long[] planeOffsets, long[] planeBounds) {
        return this.createPlane(this.getMetadata().get(0), planeOffsets, planeBounds);
    }

    @Override
    public BufferedImagePlane createPlane(ImageMetadata meta, long[] planeOffsets, long[] planeBounds) {
        return new BufferedImagePlane(this.getContext(), meta, planeOffsets, planeBounds);
    }
}

