/*
 * Decompiled with CFR 0.152.
 */
package io.scif.formats.dicom;

import java.util.Hashtable;

public class DICOMDictionary {
    private Hashtable<Integer, String[]> table = new Hashtable(4000);

    public DICOMDictionary() {
        this.addAttributes();
    }

    public boolean has(int code) {
        return this.table.containsKey(code);
    }

    public String name(int code) {
        return this.has(code) ? this.table.get(code)[0] : null;
    }

    public String vr(int code) {
        return this.has(code) ? this.table.get(code)[1] : null;
    }

    private void addAttributes() {
        this.addAttributeGroup0002();
        this.addAttributeGroup0008();
        this.addAttributeGroup0010();
        this.addAttributeGroup0012();
        this.addAttributeGroup0014();
        this.addAttributeGroup0018();
        this.addAttributeGroup0020();
        this.addAttributeGroup0022();
        this.addAttributeGroup0024();
        this.addAttributeGroup0028();
        this.addAttributeGroup0032();
        this.addAttributeGroup0038();
        this.addAttributeGroup003A();
        this.addAttributeGroup0042();
        this.addAttributeGroup0044();
        this.addAttributeGroup0046();
        this.addAttributeGroup0048();
        this.addAttributeGroup0050();
        this.addAttributeGroup0052();
        this.addAttributeGroup0054();
        this.addAttributeGroup0060();
        this.addAttributeGroup0062();
        this.addAttributeGroup0064();
        this.addAttributeGroup0066();
        this.addAttributeGroup0068();
        this.addAttributeGroup0070();
        this.addAttributeGroup0072();
        this.addAttributeGroup0074();
        this.addAttributeGroup0076();
        this.addAttributeGroup0078();
        this.addAttributeGroup0080();
        this.addAttributeGroup0088();
        this.addAttributeGroup0100();
        this.addAttributeGroup0400();
        this.addAttributeGroup2000();
        this.addAttributeGroup2010();
        this.addAttributeGroup2020();
        this.addAttributeGroup2030();
        this.addAttributeGroup2040();
        this.addAttributeGroup2050();
        this.addAttributeGroup2100();
        this.addAttributeGroup2110();
        this.addAttributeGroup2120();
        this.addAttributeGroup2130();
        this.addAttributeGroup2200();
        this.addAttributeGroup3002();
        this.addAttributeGroup3004();
        this.addAttributeGroup3006();
        this.addAttributeGroup3008();
        this.addAttributeGroup300A();
        this.addAttributeGroup300C();
        this.addAttributeGroup300E();
        this.addAttributeGroup4000();
        this.addAttributeGroup4008();
        this.addAttributeGroup4010();
        this.addAttributeGroup4FFE();
        this.addAttributeGroup5200();
        this.addAttributeGroup5400();
        this.addAttributeGroup5600();
        this.addAttributeGroup7FE0();
        this.addAttributeGroupFFFA();
    }

    private void addAttributeGroup0002() {
        this.add(131072, "File Meta Information Group Length", "UL");
        this.add(131073, "File Meta Information Version", "OB");
        this.add(131074, "Media Storage SOP Class UID", "UI");
        this.add(131075, "Media Storage SOP Instance UID", "UI");
        this.add(131088, "Transfer Syntax UID", "UI");
        this.add(131090, "Implementation Class UID", "UI");
        this.add(131091, "Implementation Version Name", "SH");
        this.add(131094, "Source Application Entity Title", "AE");
        this.add(131095, "Sending Application Entity Title", "AE");
        this.add(131096, "Receiving Application Entity Title", "AE");
        this.add(131328, "Private Information Creator UID", "UI");
        this.add(131330, "Private Information", "OB");
    }

    private void addAttributeGroup0008() {
        this.add(524289, "Length to End", "UL");
        this.add(524293, "Specific Character Set", "CS");
        this.add(524294, "Language Code Sequence", "SQ");
        this.add(524296, "Image Type", "CS");
        this.add(524304, "Recognition Code", "SH");
        this.add(524306, "Instance Creation Date", "DA");
        this.add(524307, "Instance Creation Time", "TM");
        this.add(524308, "Instance Creator UID", "UI");
        this.add(524309, "Instance Coercion DateTime", "DT");
        this.add(524310, "SOP Class UID", "UI");
        this.add(524312, "SOP Instance UID", "UI");
        this.add(524314, "Related General SOP Class UID", "UI");
        this.add(524315, "Original Specialized SOP ClassUID", "UI");
        this.add(524320, "Study Date", "DA");
        this.add(524321, "Series Date", "DA");
        this.add(524322, "Acquisition Date", "DA");
        this.add(524323, "Content Date", "DA");
        this.add(524324, "Overlay Date", "DA");
        this.add(524325, "Curve Date", "DA");
        this.add(524330, "Acquisition DateTime", "DT");
        this.add(524336, "Study Time", "TM");
        this.add(524337, "Series Time", "TM");
        this.add(524338, "Acquisition Time", "TM");
        this.add(524339, "Content Time", "TM");
        this.add(524340, "Overlay Time", "TM");
        this.add(524341, "Curve Time", "TM");
        this.add(524352, "Data Set Type", "US");
        this.add(524353, "Data Set Subtype", "LO");
        this.add(524354, "Nuclear Medicine Series Type", "CS");
        this.add(524368, "Accession Number", "SH");
        this.add(524369, "Issuer of Accession NumberSequence", "SQ");
        this.add(524370, "Query/Retrieve Level", "CS");
        this.add(524371, "Query/Retrieve View", "CS");
        this.add(524372, "Retrieve AE Title", "AE");
        this.add(524374, "Instance Availability", "CS");
        this.add(524376, "Failed SOP Instance UID List", "UI");
        this.add(524384, "Modality", "CS");
        this.add(524385, "Modalities in Study", "CS");
        this.add(524386, "SOP Classes in Study", "UI");
        this.add(524388, "Conversion Type", "CS");
        this.add(524392, "Presentation Intent Type", "CS");
        this.add(524400, "Manufacturer", "LO");
        this.add(524416, "Institution Name", "LO");
        this.add(524417, "Institution Address", "ST");
        this.add(524418, "Institution Code Sequence", "SQ");
        this.add(524432, "Referring Physician's Name", "PN");
        this.add(524434, "Referring Physician's Address", "ST");
        this.add(524436, "Referring Physician's TelephoneNumbers", "SH");
        this.add(524438, "Referring Physician IdentificationSequence", "SQ");
        this.add(524444, "Consulting Physician's Name", "PN");
        this.add(524445, "Consulting Physician IdentificationSequence", "SQ");
        this.add(524544, "Code Value", "SH");
        this.add(524545, "Extended Code Value", "LO");
        this.add(524546, "Coding Scheme Designator", "SH");
        this.add(524547, "Coding Scheme Version", "SH");
        this.add(524548, "Code Meaning", "LO");
        this.add(524549, "Mapping Resource", "CS");
        this.add(524550, "Context Group Version", "DT");
        this.add(524551, "Context Group Local Version", "DT");
        this.add(524552, "Extended Code Meaning", "LT");
        this.add(524555, "Context Group Extension Flag", "CS");
        this.add(524556, "Coding Scheme UID", "UI");
        this.add(524557, "Context Group Extension CreatorUID", "UI");
        this.add(524559, "Context Identifier", "CS");
        this.add(524560, "Coding Scheme IdentificationSequence", "SQ");
        this.add(524562, "Coding Scheme Registry", "LO");
        this.add(524564, "Coding Scheme External ID", "ST");
        this.add(524565, "Coding Scheme Name", "ST");
        this.add(524566, "Coding Scheme ResponsibleOrganization", "ST");
        this.add(524567, "Context UID", "UI");
        this.add(524568, "Mapping Resource UID", "UI");
        this.add(524569, "Long Code Value", "UC");
        this.add(524576, "URN Code Value", "UR");
        this.add(524577, "Equivalent Code Sequence", "SQ");
        this.add(524801, "Timezone Offset From UTC", "SH");
        this.add(525056, "Private Data ElementCharacteristics Sequence", "SQ");
        this.add(525057, "Private Group Reference", "US");
        this.add(525058, "Private Creator Reference", "LO");
        this.add(525059, "Block Identifying Information Status", "CS");
        this.add(525060, "Nonidentifying Private Elements", "US");
        this.add(525062, "Identifying Private Elements", "US");
        this.add(525061, "Deidentification Action Sequence", "SQ");
        this.add(525063, "Deidentification Action", "CS");
        this.add(528384, "Network ID", "AE");
        this.add(528400, "Station Name", "SH");
        this.add(528432, "Study Description", "LO");
        this.add(528434, "Procedure Code Sequence", "SQ");
        this.add(528446, "Series Description", "LO");
        this.add(528447, "Series Description Code Sequence", "SQ");
        this.add(528448, "Institutional Department Name", "LO");
        this.add(528456, "Physician(s) of Record", "PN");
        this.add(528457, "Physician(s) of RecordIdentification Sequence", "SQ");
        this.add(528464, "Performing Physician's Name", "PN");
        this.add(528466, "Performing Physician IdentificationSequence", "SQ");
        this.add(528480, "Name of Physician(s) ReadingStudy", "PN");
        this.add(528482, "Physician(s) Reading StudyIdentification Sequence", "SQ");
        this.add(528496, "Operators' Name", "PN");
        this.add(528498, "Operator Identification Sequence", "SQ");
        this.add(528512, "Admitting Diagnoses Description", "LO");
        this.add(528516, "Admitting Diagnoses CodeSequence", "SQ");
        this.add(528528, "Manufacturer's Model Name", "LO");
        this.add(528640, "Referenced Results Sequence", "SQ");
        this.add(528656, "Referenced Study Sequence", "SQ");
        this.add(528657, "Referenced Performed ProcedureStep Sequence", "SQ");
        this.add(528661, "Referenced Series Sequence", "SQ");
        this.add(528672, "Referenced Patient Sequence", "SQ");
        this.add(528677, "Referenced Visit Sequence", "SQ");
        this.add(528688, "Referenced Overlay Sequence", "SQ");
        this.add(528692, "Referenced Stereometric InstanceSequence", "SQ");
        this.add(528698, "Referenced Waveform Sequence", "SQ");
        this.add(528704, "Referenced Image Sequence", "SQ");
        this.add(528709, "Referenced Curve Sequence", "SQ");
        this.add(528714, "Referenced Instance Sequence", "SQ");
        this.add(528715, "Referenced Real World ValueMapping Instance Sequence", "SQ");
        this.add(528720, "Referenced SOP Class UID", "UI");
        this.add(528725, "Referenced SOP Instance UID", "UI");
        this.add(528730, "SOP Classes Supported", "UI");
        this.add(528736, "Referenced Frame Number", "IS");
        this.add(528737, "Simple Frame List", "UL");
        this.add(528738, "Calculated Frame List", "UL");
        this.add(528739, "Time Range", "FD");
        this.add(528740, "Frame Extraction Sequence", "SQ");
        this.add(528743, "Multi-frame Source SOP InstanceUID", "UI");
        this.add(528784, "Retrieve URL", "UR");
        this.add(528789, "Transaction UID", "UI");
        this.add(528790, "Warning Reason", "US");
        this.add(528791, "Failure Reason", "US");
        this.add(528792, "Failed SOP Sequence", "SQ");
        this.add(528793, "Referenced SOP Sequence", "SQ");
        this.add(528896, "Studies Containing OtherReferenced Instances Sequence", "SQ");
        this.add(528976, "Related Series Sequence", "SQ");
        this.add(532752, "Lossy Image Compression(Retired)", "CS");
        this.add(532753, "Derivation Description", "ST");
        this.add(532754, "Source Image Sequence", "SQ");
        this.add(532768, "Stage Name", "SH");
        this.add(532770, "Stage Number", "IS");
        this.add(532772, "Number of Stages", "IS");
        this.add(532775, "View Name", "SH");
        this.add(532776, "View Number", "IS");
        this.add(532777, "Number of Event Timers", "IS");
        this.add(532778, "Number of Views in Stage", "IS");
        this.add(532784, "Event Elapsed Time(s)", "DS");
        this.add(532786, "Event Timer Name(s)", "LO");
        this.add(532787, "Event Timer Sequence", "SQ");
        this.add(532788, "Event Time Offset", "FD");
        this.add(532789, "Event Code Sequence", "SQ");
        this.add(532802, "Start Trim", "IS");
        this.add(532803, "Stop Trim", "IS");
        this.add(532804, "Recommended Display FrameRate", "IS");
        this.add(532992, "Transducer Position", "CS");
        this.add(532996, "Transducer Orientation", "CS");
        this.add(533000, "Anatomic Structure", "CS");
        this.add(533016, "Anatomic Region Sequence", "SQ");
        this.add(533024, "Anatomic Region ModifierSequence", "SQ");
        this.add(533032, "Primary Anatomic StructureSequence", "SQ");
        this.add(533033, "Anatomic Structure, Space orRegion Sequence", "SQ");
        this.add(533040, "Primary Anatomic StructureModifier Sequence", "SQ");
        this.add(533056, "Transducer Position Sequence", "SQ");
        this.add(533058, "Transducer Position ModifierSequence", "SQ");
        this.add(533060, "Transducer Orientation Sequence", "SQ");
        this.add(533062, "Transducer Orientation ModifierSequence", "SQ");
        this.add(533073, "Anatomic Structure Space OrRegion Code Sequence (Trial)", "SQ");
        this.add(533075, "Anatomic Portal Of Entrance CodeSequence (Trial)", "SQ");
        this.add(533077, "Anatomic Approach Direction CodeSequence (Trial)", "SQ");
        this.add(533078, "Anatomic Perspective Description(Trial)", "ST");
        this.add(533079, "Anatomic Perspective CodeSequence (Trial)", "SQ");
        this.add(533080, "Anatomic Location Of ExaminingInstrument Description (Trial)", "ST");
        this.add(533081, "Anatomic Location Of ExaminingInstrument Code Sequence (Trial)", "SQ");
        this.add(533082, "Anatomic Structure Space OrRegion Modifier Code Sequence(Trial)", "SQ");
        this.add(533084, "On Axis Background AnatomicStructure Code Sequence (Trial)", "SQ");
        this.add(536577, "Alternate RepresentationSequence", "SQ");
        this.add(536592, "Irradiation Event UID", "UI");
        this.add(536593, "Source Irradiation Event Sequence", "SQ");
        this.add(536594, "RadiopharmaceuticalAdministration Event UID", "UI");
        this.add(540672, "Identifying Comments", "LT");
        this.add(561159, "Frame Type", "CS");
        this.add(561298, "Referenced Image EvidenceSequence", "SQ");
        this.add(561441, "Referenced Raw Data Sequence", "SQ");
        this.add(561443, "Creator-Version UID", "UI");
        this.add(561444, "Derivation Image Sequence", "SQ");
        this.add(561492, "Source Image Evidence Sequence", "SQ");
        this.add(561669, "Pixel Presentation", "CS");
        this.add(561670, "Volumetric Properties", "CS");
        this.add(561671, "Volume Based CalculationTechnique", "CS");
        this.add(561672, "Complex Image Component", "CS");
        this.add(561673, "Acquisition Contrast", "CS");
        this.add(561685, "Derivation Code Sequence", "SQ");
        this.add(561719, "Referenced Presentation StateSequence", "SQ");
        this.add(562192, "Referenced Other Plane Sequence", "SQ");
        this.add(562264, "Frame Display Sequence", "SQ");
        this.add(562265, "Recommended Display FrameRate in Float", "FL");
        this.add(562272, "Skip Frame Range Flag", "CS");
    }

    private void addAttributeGroup0010() {
        this.add(0x100010, "Patient's Name", "PN");
        this.add(0x100020, "Patient ID", "LO");
        this.add(0x100021, "Issuer of Patient ID", "LO");
        this.add(0x100022, "Type of Patient ID", "CS");
        this.add(1048612, "Issuer of Patient ID QualifiersSequence", "SQ");
        this.add(0x100030, "Patient's Birth Date", "DA");
        this.add(1048626, "Patient's Birth Time", "TM");
        this.add(0x100040, "Patient's Sex", "CS");
        this.add(0x100050, "Patient's Insurance Plan CodeSequence", "SQ");
        this.add(0x100101, "Patient's Primary Language CodeSequence", "SQ");
        this.add(0x100102, "Patient's Primary LanguageModifier Code Sequence", "SQ");
        this.add(0x100200, "Quality Control Subject", "CS");
        this.add(0x100201, "Quality Control Subject Type CodeSequence", "SQ");
        this.add(0x101000, "Other Patient IDs", "LO");
        this.add(0x101001, "Other Patient Names", "PN");
        this.add(0x101002, "Other Patient IDs Sequence", "SQ");
        this.add(0x101005, "Patient's Birth Name", "PN");
        this.add(0x101010, "Patient's Age", "AS");
        this.add(0x101020, "Patient's Size", "DS");
        this.add(0x101021, "Patient's Size Code Sequence", "SQ");
        this.add(0x101030, "Patient's Weight", "DS");
        this.add(0x101040, "Patient's Address", "LO");
        this.add(0x101050, "Insurance Plan Identification", "LO");
        this.add(0x101060, "Patient's Mother's Birth Name", "PN");
        this.add(0x101080, "Military Rank", "LO");
        this.add(0x101081, "Branch of Service", "LO");
        this.add(0x101090, "Medical Record Locator", "LO");
        this.add(0x101100, "Referenced Patient PhotoSequence", "SQ");
        this.add(0x102000, "Medical Alerts", "LO");
        this.add(0x102110, "Allergies", "LO");
        this.add(1057104, "Country of Residence", "LO");
        this.add(1057106, "Region of Residence", "LO");
        this.add(1057108, "Patient's Telephone Numbers", "SH");
        this.add(1057109, "Patient's Telecom Information", "LT");
        this.add(1057120, "Ethnic Group", "SH");
        this.add(1057152, "Occupation", "SH");
        this.add(1057184, "Smoking Status", "CS");
        this.add(1057200, "Additional Patient History", "LT");
        this.add(1057216, "Pregnancy Status", "US");
        this.add(1057232, "Last Menstrual Date", "DA");
        this.add(1057264, "Patient's Religious Preference", "LO");
        this.add(0x102201, "Patient Species Description", "LO");
        this.add(0x102202, "Patient Species Code Sequence", "SQ");
        this.add(1057283, "Patient's Sex Neutered", "CS");
        this.add(0x102210, "Anatomical Orientation Type", "CS");
        this.add(1057426, "Patient Breed Description", "LO");
        this.add(1057427, "Patient Breed Code Sequence", "SQ");
        this.add(1057428, "Breed Registration Sequence", "SQ");
        this.add(1057429, "Breed Registration Number", "LO");
        this.add(1057430, "Breed Registry Code Sequence", "SQ");
        this.add(1057431, "Responsible Person", "PN");
        this.add(1057432, "Responsible Person Role", "CS");
        this.add(1057433, "Responsible Organization", "LO");
        this.add(0x104000, "Patient Comments", "LT");
        this.add(1086513, "Examined Body Thickness", "FL");
    }

    private void addAttributeGroup0012() {
        this.add(0x120010, "Clinical Trial Sponsor Name", "LO");
        this.add(0x120020, "Clinical Trial Protocol ID", "LO");
        this.add(0x120021, "Clinical Trial Protocol Name", "LO");
        this.add(1179696, "Clinical Trial Site ID", "LO");
        this.add(1179697, "Clinical Trial Site Name", "LO");
        this.add(1179712, "Clinical Trial Subject ID", "LO");
        this.add(1179714, "Clinical Trial Subject Reading ID", "LO");
        this.add(1179728, "Clinical Trial Time Point ID", "LO");
        this.add(1179729, "Clinical Trial Time Point Description", "ST");
        this.add(1179744, "Clinical Trial Coordinating CenterName", "LO");
        this.add(1179746, "Patient Identity Removed", "CS");
        this.add(1179747, "De-identification Method", "LO");
        this.add(1179748, "De-identification Method CodeSequence", "SQ");
        this.add(1179761, "Clinical Trial Series ID", "LO");
        this.add(1179762, "Clinical Trial Series Description", "LO");
        this.add(1179777, "Clinical Trial Protocol EthicsCommittee Name", "LO");
        this.add(1179778, "Clinical Trial Protocol EthicsCommittee Approval Number", "LO");
        this.add(1179779, "Consent for Clinical Trial UseSequence", "SQ");
        this.add(1179780, "Distribution Type", "CS");
        this.add(1179781, "Consent for Distribution Flag", "CS");
    }

    private void addAttributeGroup0014() {
        this.add(1310755, "CAD File Format", "ST");
        this.add(1310756, "Component Reference System", "ST");
        this.add(1310757, "Component ManufacturingProcedure", "ST");
        this.add(1310760, "Component Manufacturer", "ST");
        this.add(1310768, "Material Thickness", "DS");
        this.add(1310770, "Material Pipe Diameter", "DS");
        this.add(1310772, "Material Isolation Diameter", "DS");
        this.add(1310786, "Material Grade", "ST");
        this.add(0x140044, "Material Properties Description", "ST");
        this.add(1310789, "Material Properties File Format(Retired)", "ST");
        this.add(1310790, "Material Notes", "LT");
        this.add(1310800, "Component Shape", "CS");
        this.add(1310802, "Curvature Type", "CS");
        this.add(1310804, "Outer Diameter", "DS");
        this.add(1310806, "Inner Diameter", "DS");
        this.add(0x141010, "Actual Environmental Conditions", "ST");
        this.add(1314848, "Expiry Date", "DA");
        this.add(0x141040, "Environmental Conditions", "ST");
        this.add(1318914, "Evaluator Sequence", "SQ");
        this.add(1318916, "Evaluator Number", "IS");
        this.add(1318918, "Evaluator Name", "PN");
        this.add(1318920, "Evaluation Attempt", "IS");
        this.add(1318930, "Indication Sequence", "SQ");
        this.add(1318932, "Indication Number", "IS");
        this.add(1318934, "Indication Label", "SH");
        this.add(1318936, "Indication Description", "ST");
        this.add(1318938, "Indication Type", "CS");
        this.add(1318940, "Indication Disposition", "CS");
        this.add(1318942, "Indication ROI Sequence", "SQ");
        this.add(1318960, "Indication Physical PropertySequence", "SQ");
        this.add(1318962, "Property Label", "SH");
        this.add(1319426, "Coordinate System Number ofAxes", "IS");
        this.add(1319428, "Coordinate System Axes Sequence", "SQ");
        this.add(1319430, "Coordinate System AxisDescription", "ST");
        this.add(1319432, "Coordinate System Data SetMapping", "CS");
        this.add(1319434, "Coordinate System Axis Number", "IS");
        this.add(1319436, "Coordinate System Axis Type", "CS");
        this.add(1319438, "Coordinate System Axis Units", "CS");
        this.add(1319440, "Coordinate System Axis Values", "OB");
        this.add(1319456, "Coordinate System TransformSequence", "SQ");
        this.add(0x142222, "Transform Description", "ST");
        this.add(0x142224, "Transform Number of Axes", "IS");
        this.add(1319462, "Transform Order of Axes", "IS");
        this.add(1319464, "Transformed Axis Units", "CS");
        this.add(1319466, "Coordinate System TransformRotation and Scale Matrix", "DS");
        this.add(1319468, "Coordinate System TransformTranslation Matrix", "DS");
        this.add(1323025, "Internal Detector Frame Time", "DS");
        this.add(1323026, "Number of Frames Integrated", "DS");
        this.add(1323040, "Detector Temperature Sequence", "SQ");
        this.add(1323042, "Sensor Name", "ST");
        this.add(1323044, "Horizontal Offset of Sensor", "DS");
        this.add(1323046, "Vertical Offset of Sensor", "DS");
        this.add(1323048, "Sensor Temperature", "DS");
        this.add(1323072, "Dark Current Sequence", "SQ");
        this.add(1323104, "Gain Correction ReferenceSequence", "SQ");
        this.add(1323121, "KV Used in Gain Calibration", "DS");
        this.add(1323122, "MA Used in Gain Calibration", "DS");
        this.add(1323123, "Number of Frames Used forIntegration", "DS");
        this.add(1323124, "Filter Material Used in GainCalibration", "LO");
        this.add(1323125, "Filter Thickness Used in GainCalibration", "DS");
        this.add(1323126, "Date of Gain Calibration", "DA");
        this.add(1323127, "Time of Gain Calibration", "TM");
        this.add(1323136, "Bad Pixel Image", "OB");
        this.add(1323161, "Calibration Notes", "LT");
        this.add(1327106, "Pulser Equipment Sequence", "SQ");
        this.add(0x144004, "Pulser Type", "CS");
        this.add(1327110, "Pulser Notes", "LT");
        this.add(1327112, "Receiver Equipment Sequence", "SQ");
        this.add(1327114, "Amplifier Type", "CS");
        this.add(1327116, "Receiver Notes", "LT");
        this.add(1327118, "Pre-Amplifier Equipment Sequence", "SQ");
        this.add(1327119, "Pre-Amplifier Notes", "LT");
        this.add(0x144010, "Transmit Transducer Sequence", "SQ");
        this.add(0x144011, "Receive Transducer Sequence", "SQ");
        this.add(1327122, "Number of Elements", "US");
        this.add(1327123, "Element Shape", "CS");
        this.add(0x144014, "Element Dimension A", "DS");
        this.add(1327125, "Element Dimension B", "DS");
        this.add(1327126, "Element Pitch A", "DS");
        this.add(1327127, "Measured Beam Dimension A", "DS");
        this.add(1327128, "Measured Beam Dimension B", "DS");
        this.add(1327129, "Location of Measured BeamDiameter", "DS");
        this.add(1327130, "Nominal Frequency", "DS");
        this.add(1327131, "Measured Center Frequency", "DS");
        this.add(1327132, "Measured Bandwidth", "DS");
        this.add(1327133, "Element Pitch B", "DS");
        this.add(1327136, "Pulser Settings Sequence", "SQ");
        this.add(1327138, "Pulse Width", "DS");
        this.add(1327140, "Excitation Frequency", "DS");
        this.add(1327142, "Modulation Type", "CS");
        this.add(1327144, "Damping", "DS");
        this.add(1327152, "Receiver Settings Sequence", "SQ");
        this.add(1327153, "Acquired Soundpath Length", "DS");
        this.add(1327154, "Acquisition Compression Type", "CS");
        this.add(1327155, "Acquisition Sample Size", "IS");
        this.add(1327156, "Rectifier Smoothing", "DS");
        this.add(1327157, "DAC Sequence", "SQ");
        this.add(1327158, "DAC Type", "CS");
        this.add(1327160, "DAC Gain Points", "DS");
        this.add(1327162, "DAC Time Points", "DS");
        this.add(1327164, "DAC Amplitude", "DS");
        this.add(0x144040, "Pre-Amplifier Settings Sequence", "SQ");
        this.add(1327184, "Transmit Transducer SettingsSequence", "SQ");
        this.add(1327185, "Receive Transducer SettingsSequence", "SQ");
        this.add(1327186, "Incident Angle", "DS");
        this.add(1327188, "Coupling Technique", "ST");
        this.add(1327190, "Coupling Medium", "ST");
        this.add(1327191, "Coupling Velocity", "DS");
        this.add(1327192, "Probe Center Location X", "DS");
        this.add(1327193, "Probe Center Location Z", "DS");
        this.add(1327194, "Sound Path Length", "DS");
        this.add(1327196, "Delay Law Identifier", "ST");
        this.add(1327200, "Gate Settings Sequence", "SQ");
        this.add(1327202, "Gate Threshold", "DS");
        this.add(1327204, "Velocity of Sound", "DS");
        this.add(1327216, "Calibration Settings Sequence", "SQ");
        this.add(1327218, "Calibration Procedure", "ST");
        this.add(1327220, "Procedure Version", "SH");
        this.add(1327222, "Procedure Creation Date", "DA");
        this.add(1327224, "Procedure Expiration Date", "DA");
        this.add(1327226, "Procedure Last Modified Date", "DA");
        this.add(1327228, "Calibration Time", "TM");
        this.add(1327230, "Calibration Date", "DA");
        this.add(1327232, "Probe Drive Equipment Sequence", "SQ");
        this.add(1327233, "Drive Type", "CS");
        this.add(1327234, "Probe Drive Notes", "LT");
        this.add(1327235, "Drive Probe Sequence", "SQ");
        this.add(1327236, "Probe Inductance", "DS");
        this.add(1327237, "Probe Resistance", "DS");
        this.add(1327238, "Receive Probe Sequence", "SQ");
        this.add(1327239, "Probe Drive Settings Sequence", "SQ");
        this.add(1327240, "Bridge Resistors", "DS");
        this.add(1327241, "Probe Orientation Angle", "DS");
        this.add(1327243, "User Selected Gain Y", "DS");
        this.add(1327244, "User Selected Phase", "DS");
        this.add(1327245, "User Selected Offset X", "DS");
        this.add(1327246, "User Selected Offset Y", "DS");
        this.add(1327249, "Channel Settings Sequence", "SQ");
        this.add(1327250, "Channel Threshold", "DS");
        this.add(1327258, "Scanner Settings Sequence", "SQ");
        this.add(1327259, "Scan Procedure", "ST");
        this.add(1327260, "Translation Rate X", "DS");
        this.add(1327261, "Translation Rate Y", "DS");
        this.add(1327263, "Channel Overlap", "DS");
        this.add(1327264, "Image Quality Indicator Type", "LO");
        this.add(1327265, "Image Quality Indicator Material", "LO");
        this.add(1327266, "Image Quality Indicator Size", "LO");
        this.add(1331202, "LINAC Energy", "IS");
        this.add(1331204, "LINAC Output", "IS");
        this.add(1331456, "Active Aperture", "US");
        this.add(1331457, "Total Aperture", "DS");
        this.add(1331458, "Aperture Elevation", "DS");
        this.add(1331459, "Main Lobe Angle", "DS");
        this.add(1331460, "Main Roof Angle", "DS");
        this.add(1331461, "Connector Type", "CS");
        this.add(1331462, "Wedge Model Number", "SH");
        this.add(1331463, "Wedge Angle Float", "DS");
        this.add(1331464, "Wedge Roof Angle", "DS");
        this.add(1331465, "Wedge Element 1 Position", "CS");
        this.add(1331466, "Wedge Material Velocity", "DS");
        this.add(1331467, "Wedge Material", "SH");
        this.add(1331468, "Wedge Offset Z", "DS");
        this.add(1331469, "Wedge Origin Offset X", "DS");
        this.add(1331470, "Wedge Time Delay", "DS");
        this.add(1331471, "Wedge Name", "SH");
        this.add(1331472, "Wedge Manufacturer Name", "SH");
        this.add(0x145111, "Wedge Description", "LO");
        this.add(1331474, "Nominal Beam Angle", "DS");
        this.add(1331475, "Wedge Offset X", "DS");
        this.add(0x145114, "Wedge Offset Y", "DS");
        this.add(0x145115, "Wedge Total Length", "DS");
        this.add(1331478, "Wedge In Contact Length", "DS");
        this.add(1331479, "Wedge Front Gap", "DS");
        this.add(1331480, "Wedge Total Height", "DS");
        this.add(1331481, "Wedge Front Height", "DS");
        this.add(1331482, "Wedge Rear Height", "DS");
        this.add(1331483, "Wedge Total Width", "DS");
        this.add(1331484, "Wedge In Contact Width", "DS");
        this.add(1331485, "Wedge Chamfer Height", "DS");
        this.add(1331486, "Wedge Curve", "CS");
        this.add(1331487, "Radius Along the Wedge", "DS");
    }

    private void addAttributeGroup0018() {
        this.add(0x180010, "Contrast/Bolus Agent", "LO");
        this.add(1572882, "Contrast/Bolus Agent Sequence", "SQ");
        this.add(1572883, "Contrast/Bolus T1 Relaxivity", "FL");
        this.add(1572884, "Contrast/Bolus AdministrationRoute Sequence", "SQ");
        this.add(1572885, "Body Part Examined", "CS");
        this.add(1572896, "Scanning Sequence", "CS");
        this.add(1572897, "Sequence Variant", "CS");
        this.add(1572898, "Scan Options", "CS");
        this.add(1572899, "MR Acquisition Type", "CS");
        this.add(1572900, "Sequence Name", "SH");
        this.add(1572901, "Angio Flag", "CS");
        this.add(1572902, "Intervention Drug InformationSequence", "SQ");
        this.add(1572903, "Intervention Drug Stop Time", "TM");
        this.add(1572904, "Intervention Drug Dose", "DS");
        this.add(1572905, "Intervention Drug Code Sequence", "SQ");
        this.add(1572906, "Additional Drug Sequence", "SQ");
        this.add(1572912, "Radionuclide", "LO");
        this.add(1572913, "Radiopharmaceutical", "LO");
        this.add(1572914, "Energy Window Centerline", "DS");
        this.add(1572915, "Energy Window Total Width", "DS");
        this.add(1572916, "Intervention Drug Name", "LO");
        this.add(1572917, "Intervention Drug Start Time", "TM");
        this.add(1572918, "Intervention Sequence", "SQ");
        this.add(1572919, "Therapy Type", "CS");
        this.add(1572920, "Intervention Status", "CS");
        this.add(1572921, "Therapy Description", "CS");
        this.add(1572922, "Intervention Description", "ST");
        this.add(1572928, "Cine Rate", "IS");
        this.add(1572930, "Initial Cine Run State", "CS");
        this.add(1572944, "Slice Thickness", "DS");
        this.add(1572960, "KVP", "DS");
        this.add(1572976, "Counts Accumulated", "IS");
        this.add(1572977, "Acquisition Termination Condition", "CS");
        this.add(1572978, "Effective Duration", "DS");
        this.add(1572979, "Acquisition Start Condition", "CS");
        this.add(1572980, "Acquisition Start Condition Data", "IS");
        this.add(1572981, "Acquisition Termination ConditionData", "IS");
        this.add(0x180080, "Repetition Time", "DS");
        this.add(0x180081, "Echo Time", "DS");
        this.add(1572994, "Inversion Time", "DS");
        this.add(1572995, "Number of Averages", "DS");
        this.add(1572996, "Imaging Frequency", "DS");
        this.add(1572997, "Imaged Nucleus", "SH");
        this.add(1572998, "Echo Number(s)", "IS");
        this.add(1572999, "Magnetic Field Strength", "DS");
        this.add(0x180088, "Spacing Between Slices", "DS");
        this.add(1573001, "Number of Phase Encoding Steps", "IS");
        this.add(1573008, "Data Collection Diameter", "DS");
        this.add(1573009, "Echo Train Length", "IS");
        this.add(1573011, "Percent Sampling", "DS");
        this.add(1573012, "Percent Phase Field of View", "DS");
        this.add(1573013, "Pixel Bandwidth", "DS");
        this.add(0x181000, "Device Serial Number", "LO");
        this.add(1576962, "Device UID", "UI");
        this.add(1576963, "Device ID", "LO");
        this.add(1576964, "Plate ID", "LO");
        this.add(1576965, "Generator ID", "LO");
        this.add(1576966, "Grid ID", "LO");
        this.add(1576967, "Cassette ID", "LO");
        this.add(0x181008, "Gantry ID", "LO");
        this.add(0x181010, "Secondary Capture Device ID", "LO");
        this.add(0x181011, "Hardcopy Creation Device ID", "LO");
        this.add(1576978, "Date of Secondary Capture", "DA");
        this.add(1576980, "Time of Secondary Capture", "TM");
        this.add(1576982, "Secondary Capture DeviceManufacturer", "LO");
        this.add(1576983, "Hardcopy Device Manufacturer", "LO");
        this.add(0x181018, "Secondary Capture DeviceManufacturer's Model Name", "LO");
        this.add(1576985, "Secondary Capture DeviceSoftware Versions", "LO");
        this.add(1576986, "Hardcopy Device Software Version", "LO");
        this.add(1576987, "Hardcopy Device Manufacturer'sModel Name", "LO");
        this.add(1576992, "Software Version(s)", "LO");
        this.add(1576994, "Video Image Format Acquired", "SH");
        this.add(1576995, "Digital Image Format Acquired", "LO");
        this.add(1577008, "Protocol Name", "LO");
        this.add(1577024, "Contrast/Bolus Route", "LO");
        this.add(1577025, "Contrast/Bolus Volume", "DS");
        this.add(1577026, "Contrast/Bolus Start Time", "TM");
        this.add(1577027, "Contrast/Bolus Stop Time", "TM");
        this.add(1577028, "Contrast/Bolus Total Dose", "DS");
        this.add(1577029, "Syringe Counts", "IS");
        this.add(1577030, "Contrast Flow Rate", "DS");
        this.add(1577031, "Contrast Flow Duration", "DS");
        this.add(1577032, "Contrast/Bolus Ingredient", "CS");
        this.add(1577033, "Contrast/Bolus IngredientConcentration", "DS");
        this.add(1577040, "Spatial Resolution", "DS");
        this.add(1577056, "Trigger Time", "DS");
        this.add(1577058, "Nominal Interval", "IS");
        this.add(1577059, "Frame Time", "DS");
        this.add(1577060, "Cardiac Framing Type", "LO");
        this.add(1577061, "Frame Time Vector", "DS");
        this.add(1577062, "Frame Delay", "DS");
        this.add(1577063, "Image Trigger Delay", "DS");
        this.add(1577064, "Multiplex Group Time Offset", "DS");
        this.add(1577065, "Trigger Time Offset", "DS");
        this.add(1577066, "Synchronization Trigger", "CS");
        this.add(1577068, "Synchronization Channel", "US");
        this.add(1577070, "Trigger Sample Position", "UL");
        this.add(1577072, "Radiopharmaceutical Route", "LO");
        this.add(1577073, "Radiopharmaceutical Volume", "DS");
        this.add(1577074, "Radiopharmaceutical Start Time", "TM");
        this.add(1577075, "Radiopharmaceutical Stop Time", "TM");
        this.add(1577076, "Radionuclide Total Dose", "DS");
        this.add(1577077, "Radionuclide Half Life", "DS");
        this.add(1577078, "Radionuclide Positron Fraction", "DS");
        this.add(1577079, "Radiopharmaceutical SpecificActivity", "DS");
        this.add(1577080, "Radiopharmaceutical StartDateTime", "DT");
        this.add(1577081, "Radiopharmaceutical StopDateTime", "DT");
        this.add(0x181080, "Beat Rejection Flag", "CS");
        this.add(0x181081, "Low R-R Value", "IS");
        this.add(1577090, "High R-R Value", "IS");
        this.add(1577091, "Intervals Acquired", "IS");
        this.add(1577092, "Intervals Rejected", "IS");
        this.add(1577093, "PVC Rejection", "LO");
        this.add(1577094, "Skip Beats", "IS");
        this.add(0x181088, "Heart Rate", "IS");
        this.add(1577104, "Cardiac Number of Images", "IS");
        this.add(1577108, "Trigger Window", "IS");
        this.add(0x181100, "Reconstruction Diameter", "DS");
        this.add(0x181110, "Distance Source to Detector", "DS");
        this.add(0x181111, "Distance Source to Patient", "DS");
        this.add(0x181114, "Estimated RadiographicMagnification Factor", "DS");
        this.add(1577248, "Gantry/Detector Tilt", "DS");
        this.add(0x181121, "Gantry/Detector Slew", "DS");
        this.add(1577264, "Table Height", "DS");
        this.add(0x181131, "Table Traverse", "DS");
        this.add(1577268, "Table Motion", "CS");
        this.add(1577269, "Table Vertical Increment", "DS");
        this.add(1577270, "Table Lateral Increment", "DS");
        this.add(1577271, "Table Longitudinal Increment", "DS");
        this.add(0x181138, "Table Angle", "DS");
        this.add(1577274, "Table Type", "CS");
        this.add(1577280, "Rotation Direction", "CS");
        this.add(0x181141, "Angular Position", "DS");
        this.add(1577282, "Radial Position", "DS");
        this.add(1577283, "Scan Arc", "DS");
        this.add(0x181144, "Angular Step", "DS");
        this.add(1577285, "Center of Rotation Offset", "DS");
        this.add(1577286, "Rotation Offset", "DS");
        this.add(1577287, "Field of View Shape", "CS");
        this.add(1577289, "Field of View Dimension(s)", "IS");
        this.add(1577296, "Exposure Time", "IS");
        this.add(0x181151, "X-Ray Tube Current", "IS");
        this.add(1577298, "Exposure", "IS");
        this.add(1577299, "Exposure in uAs", "IS");
        this.add(1577300, "Average Pulse Width", "DS");
        this.add(0x181155, "Radiation Setting", "CS");
        this.add(1577302, "Rectification Type", "CS");
        this.add(1577306, "Radiation Mode", "CS");
        this.add(1577310, "Image and Fluoroscopy Area DoseProduct", "DS");
        this.add(1577312, "Filter Type", "SH");
        this.add(0x181161, "Type of Filters", "LO");
        this.add(1577314, "Intensifier Size", "DS");
        this.add(1577316, "Imager Pixel Spacing", "DS");
        this.add(0x181166, "Grid", "CS");
        this.add(1577328, "Generator Power", "IS");
        this.add(0x181180, "Collimator/grid Name", "SH");
        this.add(0x181181, "Collimator Type", "CS");
        this.add(0x181182, "Focal Distance", "IS");
        this.add(0x181183, "X Focus Center", "DS");
        this.add(0x181184, "Y Focus Center", "DS");
        this.add(1577360, "Focal Spot(s)", "DS");
        this.add(0x181191, "Anode Target Material", "CS");
        this.add(1577376, "Body Part Thickness", "DS");
        this.add(1577378, "Compression Force", "DS");
        this.add(1577380, "Paddle Description", "LO");
        this.add(1577472, "Date of Last Calibration", "DA");
        this.add(1577473, "Time of Last Calibration", "TM");
        this.add(1577474, "DateTime of Last Calibration", "DT");
        this.add(1577488, "Convolution Kernel", "SH");
        this.add(1577536, "Upper/Lower Pixel Values", "IS");
        this.add(1577538, "Actual Frame Duration", "IS");
        this.add(1577539, "Count Rate", "IS");
        this.add(1577540, "Preferred Playback Sequencing", "US");
        this.add(1577552, "Receive Coil Name", "SH");
        this.add(1577553, "Transmit Coil Name", "SH");
        this.add(1577568, "Plate Type", "SH");
        this.add(1577569, "Phosphor Type", "LO");
        this.add(1577728, "Scan Velocity", "DS");
        this.add(1577729, "Whole Body Technique", "CS");
        this.add(1577730, "Scan Length", "IS");
        this.add(1577744, "Acquisition Matrix", "US");
        this.add(1577746, "In-plane Phase Encoding Direction", "CS");
        this.add(1577748, "Flip Angle", "DS");
        this.add(1577749, "Variable Flip Angle Flag", "CS");
        this.add(1577750, "SAR", "DS");
        this.add(0x181318, "dB/dt", "DS");
        this.add(1577984, "Acquisition Device ProcessingDescription", "LO");
        this.add(1577985, "Acquisition Device ProcessingCode", "LO");
        this.add(1577986, "Cassette Orientation", "CS");
        this.add(1577987, "Cassette Size", "CS");
        this.add(1577988, "Exposures on Plate", "US");
        this.add(1577989, "Relative X-Ray Exposure", "IS");
        this.add(0x181411, "Exposure Index", "DS");
        this.add(1578002, "Target Exposure Index", "DS");
        this.add(1578003, "Deviation Index", "DS");
        this.add(1578064, "Column Angulation", "DS");
        this.add(1578080, "Tomo Layer Height", "DS");
        this.add(1578096, "Tomo Angle", "DS");
        this.add(1578112, "Tomo Time", "DS");
        this.add(1578128, "Tomo Type", "CS");
        this.add(1578129, "Tomo Class", "CS");
        this.add(1578133, "Number of Tomosynthesis SourceImages", "IS");
        this.add(1578240, "Positioner Motion", "CS");
        this.add(1578248, "Positioner Type", "CS");
        this.add(1578256, "Positioner Primary Angle", "DS");
        this.add(0x181511, "Positioner Secondary Angle", "DS");
        this.add(1578272, "Positioner Primary Angle Increment", "DS");
        this.add(1578273, "Positioner Secondary AngleIncrement", "DS");
        this.add(1578288, "Detector Primary Angle", "DS");
        this.add(1578289, "Detector Secondary Angle", "DS");
        this.add(1578496, "Shutter Shape", "CS");
        this.add(1578498, "Shutter Left Vertical Edge", "IS");
        this.add(1578500, "Shutter Right Vertical Edge", "IS");
        this.add(1578502, "Shutter Upper Horizontal Edge", "IS");
        this.add(1578504, "Shutter Lower Horizontal Edge", "IS");
        this.add(1578512, "Center of Circular Shutter", "IS");
        this.add(1578514, "Radius of Circular Shutter", "IS");
        this.add(1578528, "Vertices of the Polygonal Shutter", "IS");
        this.add(1578530, "Shutter Presentation Value", "US");
        this.add(1578531, "Shutter Overlay Group", "US");
        this.add(1578532, "Shutter Presentation Color CIELabValue", "US");
        this.add(1578752, "Collimator Shape", "CS");
        this.add(1578754, "Collimator Left Vertical Edge", "IS");
        this.add(1578756, "Collimator Right Vertical Edge", "IS");
        this.add(1578758, "Collimator Upper Horizontal Edge", "IS");
        this.add(1578760, "Collimator Lower Horizontal Edge", "IS");
        this.add(1578768, "Center of Circular Collimator", "IS");
        this.add(1578770, "Radius of Circular Collimator", "IS");
        this.add(1578784, "Vertices of the PolygonalCollimator", "IS");
        this.add(0x181800, "Acquisition Time Synchronized", "CS");
        this.add(0x181801, "Time Source", "SH");
        this.add(1579010, "Time Distribution Protocol", "CS");
        this.add(1579011, "NTP Source Address", "LO");
        this.add(1581057, "Page Number Vector", "IS");
        this.add(1581058, "Frame Label Vector", "SH");
        this.add(1581059, "Frame Primary Angle Vector", "DS");
        this.add(1581060, "Frame Secondary Angle Vector", "DS");
        this.add(1581061, "Slice Location Vector", "DS");
        this.add(1581062, "Display Window Label Vector", "SH");
        this.add(1581072, "Nominal Scanned Pixel Spacing", "DS");
        this.add(1581088, "Digitizing Device TransportDirection", "CS");
        this.add(1581104, "Rotation of Scanned Film", "DS");
        this.add(1581121, "Biopsy Target Sequence", "SQ");
        this.add(1581122, "Target UID", "UI");
        this.add(1581123, "Localizing Cursor Position", "FL");
        this.add(1581124, "Calculated Target Position", "FL");
        this.add(1581125, "Target Label", "SH");
        this.add(1581126, "Displayed Z Value", "FL");
        this.add(1585408, "IVUS Acquisition", "CS");
        this.add(1585409, "IVUS Pullback Rate", "DS");
        this.add(1585410, "IVUS Gated Rate", "DS");
        this.add(1585411, "IVUS Pullback Start Frame Number", "IS");
        this.add(1585412, "IVUS Pullback Stop Frame Number", "IS");
        this.add(1585413, "Lesion Number", "IS");
        this.add(1589248, "Acquisition Comments", "LT");
        this.add(1593344, "Output Power", "SH");
        this.add(1593360, "Transducer Data", "LO");
        this.add(1593362, "Focus Depth", "DS");
        this.add(1593376, "Processing Function", "LO");
        this.add(1593377, "Postprocessing Function", "LO");
        this.add(1593378, "Mechanical Index", "DS");
        this.add(1593380, "Bone Thermal Index", "DS");
        this.add(1593382, "Cranial Thermal Index", "DS");
        this.add(1593383, "Soft Tissue Thermal Index", "DS");
        this.add(1593384, "Soft Tissue-focus Thermal Index", "DS");
        this.add(1593385, "Soft Tissue-surface Thermal Index", "DS");
        this.add(1593392, "Dynamic Range", "DS");
        this.add(1593408, "Total Gain", "DS");
        this.add(1593424, "Depth of Scan Field", "IS");
        this.add(1593600, "Patient Position", "CS");
        this.add(1593601, "View Position", "CS");
        this.add(1593604, "Projection Eponymous Name CodeSequence", "SQ");
        this.add(1593872, "Image Transformation Matrix", "DS");
        this.add(1593874, "Image Translation Vector", "DS");
        this.add(1597440, "Sensitivity", "DS");
        this.add(1597457, "Sequence of Ultrasound Regions", "SQ");
        this.add(1597458, "Region Spatial Format", "US");
        this.add(1597460, "Region Data Type", "US");
        this.add(1597462, "Region Flags", "UL");
        this.add(1597464, "Region Location Min X0", "UL");
        this.add(1597466, "Region Location Min Y0", "UL");
        this.add(1597468, "Region Location Max X1", "UL");
        this.add(1597470, "Region Location Max Y1", "UL");
        this.add(1597472, "Reference Pixel X0", "SL");
        this.add(1597474, "Reference Pixel Y0", "SL");
        this.add(1597476, "Physical Units X Direction", "US");
        this.add(1597478, "Physical Units Y Direction", "US");
        this.add(1597480, "Reference Pixel Physical Value X", "FD");
        this.add(1597482, "Reference Pixel Physical Value Y", "FD");
        this.add(1597484, "Physical Delta X", "FD");
        this.add(1597486, "Physical Delta Y", "FD");
        this.add(1597488, "Transducer Frequency", "UL");
        this.add(1597489, "Transducer Type", "CS");
        this.add(1597490, "Pulse Repetition Frequency", "UL");
        this.add(1597492, "Doppler Correction Angle", "FD");
        this.add(1597494, "Steering Angle", "FD");
        this.add(1597496, "Doppler Sample Volume X Position(Retired)", "UL");
        this.add(1597497, "Doppler Sample Volume X Position", "SL");
        this.add(1597498, "Doppler Sample Volume Y Position(Retired)", "UL");
        this.add(1597499, "Doppler Sample Volume Y Position", "SL");
        this.add(1597500, "TM-Line Position X0 (Retired)", "UL");
        this.add(1597501, "TM-Line Position X0", "SL");
        this.add(1597502, "TM-Line Position Y0 (Retired)", "UL");
        this.add(1597503, "TM-Line Position Y0", "SL");
        this.add(1597504, "TM-Line Position X1 (Retired)", "UL");
        this.add(1597505, "TM-Line Position X1", "SL");
        this.add(1597506, "TM-Line Position Y1 (Retired)", "UL");
        this.add(1597507, "TM-Line Position Y1", "SL");
        this.add(1597508, "Pixel Component Organization", "US");
        this.add(1597510, "Pixel Component Mask", "UL");
        this.add(1597512, "Pixel Component Range Start", "UL");
        this.add(1597514, "Pixel Component Range Stop", "UL");
        this.add(1597516, "Pixel Component Physical Units", "US");
        this.add(1597518, "Pixel Component Data Type", "US");
        this.add(1597520, "Number of Table Break Points", "UL");
        this.add(1597522, "Table of X Break Points", "UL");
        this.add(1597524, "Table of Y Break Points", "FD");
        this.add(1597526, "Number of Table Entries", "UL");
        this.add(1597528, "Table of Pixel Values", "UL");
        this.add(1597530, "Table of Parameter Values", "FL");
        this.add(1597536, "R Wave Time Vector", "FL");
        this.add(1601536, "Detector Conditions Nominal Flag", "CS");
        this.add(1601537, "Detector Temperature", "DS");
        this.add(1601540, "Detector Type", "CS");
        this.add(1601541, "Detector Configuration", "CS");
        this.add(1601542, "Detector Description", "LT");
        this.add(1601544, "Detector Mode", "LT");
        this.add(1601546, "Detector ID", "SH");
        this.add(1601548, "Date of Last Detector Calibration", "DA");
        this.add(1601550, "Time of Last Detector Calibration", "TM");
        this.add(1601552, "Exposures on Detector Since LastCalibration", "IS");
        this.add(1601553, "Exposures on Detector SinceManufactured", "IS");
        this.add(1601554, "Detector Time Since Last Exposure", "DS");
        this.add(1601556, "Detector Active Time", "DS");
        this.add(1601558, "Detector Activation Offset FromExposure", "DS");
        this.add(1601562, "Detector Binning", "DS");
        this.add(1601568, "Detector Element Physical Size", "DS");
        this.add(1601570, "Detector Element Spacing", "DS");
        this.add(1601572, "Detector Active Shape", "CS");
        this.add(1601574, "Detector Active Dimension(s)", "DS");
        this.add(1601576, "Detector Active Origin", "DS");
        this.add(1601578, "Detector Manufacturer Name  DetectorManufacturerName  LO  1 (0018,702B) Detector Manufacturer's ModelName", "LO");
        this.add(1601584, "Field of View Origin", "DS");
        this.add(1601586, "Field of View Rotation", "DS");
        this.add(1601588, "Field of View Horizontal Flip", "CS");
        this.add(1601590, "Pixel Data Area Origin Relative ToFOV", "FL");
        this.add(1601592, "Pixel Data Area Rotation AngleRelative To FOV", "FL");
        this.add(1601600, "Grid Absorbing Material", "LT");
        this.add(1601601, "Grid Spacing Material", "LT");
        this.add(1601602, "Grid Thickness", "DS");
        this.add(1601604, "Grid Pitch", "DS");
        this.add(1601606, "Grid Aspect Ratio", "IS");
        this.add(1601608, "Grid Period", "DS");
        this.add(1601612, "Grid Focal Distance", "DS");
        this.add(1601616, "Filter Material", "CS");
        this.add(1601618, "Filter Thickness Minimum", "DS");
        this.add(1601620, "Filter Thickness Maximum", "DS");
        this.add(1601622, "Filter Beam Path Length Minimum", "FL");
        this.add(1601624, "Filter Beam Path Length Maximum", "FL");
        this.add(1601632, "Exposure Control Mode", "CS");
        this.add(1601634, "Exposure Control Mode Description", "LT");
        this.add(1601636, "Exposure Status", "CS");
        this.add(1601637, "Phototimer Setting", "DS");
        this.add(1605968, "Exposure Time in uS", "DS");
        this.add(0x188151, "X-Ray Tube Current in uA", "DS");
        this.add(1609732, "Content Qualification", "CS");
        this.add(1609733, "Pulse Sequence Name", "SH");
        this.add(1609734, "MR Imaging Modifier Sequence", "SQ");
        this.add(1609736, "Echo Pulse Sequence", "CS");
        this.add(1609737, "Inversion Recovery", "CS");
        this.add(1609744, "Flow Compensation", "CS");
        this.add(1609745, "Multiple Spin Echo", "CS");
        this.add(1609746, "Multi-planar Excitation", "CS");
        this.add(1609748, "Phase Contrast", "CS");
        this.add(1609749, "Time of Flight Contrast", "CS");
        this.add(1609750, "Spoiling", "CS");
        this.add(1609751, "Steady State Pulse Sequence", "CS");
        this.add(1609752, "Echo Planar Pulse Sequence", "CS");
        this.add(1609753, "Tag Angle First Axis", "FD");
        this.add(1609760, "Magnetization Transfer", "CS");
        this.add(1609761, "T2 Preparation", "CS");
        this.add(1609762, "Blood Signal Nulling", "CS");
        this.add(1609764, "Saturation Recovery", "CS");
        this.add(1609765, "Spectrally Selected Suppression", "CS");
        this.add(1609766, "Spectrally Selected Excitation", "CS");
        this.add(1609767, "Spatial Pre-saturation", "CS");
        this.add(1609768, "Tagging", "CS");
        this.add(1609769, "Oversampling Phase", "CS");
        this.add(1609776, "Tag Spacing First Dimension", "FD");
        this.add(1609778, "Geometry of k-Space Traversal", "CS");
        this.add(1609779, "Segmented k-Space Traversal", "CS");
        this.add(1609780, "Rectilinear Phase EncodeReordering", "CS");
        this.add(1609781, "Tag Thickness", "FD");
        this.add(1609782, "Partial Fourier Direction", "CS");
        this.add(1609783, "Cardiac Synchronization Technique", "CS");
        this.add(1609793, "Receive Coil Manufacturer Name", "LO");
        this.add(1609794, "MR Receive Coil Sequence", "SQ");
        this.add(1609795, "Receive Coil Type", "CS");
        this.add(1609796, "Quadrature Receive Coil", "CS");
        this.add(1609797, "Multi-Coil Definition Sequence", "SQ");
        this.add(1609798, "Multi-Coil Configuration", "LO");
        this.add(1609799, "Multi-Coil Element Name", "SH");
        this.add(1609800, "Multi-Coil Element Used", "CS");
        this.add(1609801, "MR Transmit Coil Sequence", "SQ");
        this.add(1609808, "Transmit Coil Manufacturer Name", "LO");
        this.add(1609809, "Transmit Coil Type", "CS");
        this.add(1609810, "Spectral Width", "FD");
        this.add(1609811, "Chemical Shift Reference", "FD");
        this.add(1609812, "Volume Localization Technique", "CS");
        this.add(1609816, "MR Acquisition FrequencyEncoding Steps", "US");
        this.add(1609817, "De-coupling", "CS");
        this.add(1609824, "De-coupled Nucleus", "CS");
        this.add(1609825, "De-coupling Frequency", "FD");
        this.add(1609826, "De-coupling Method", "CS");
        this.add(1609827, "De-coupling Chemical ShiftReference", "FD");
        this.add(1609828, "k-space Filtering", "CS");
        this.add(1609829, "Time Domain Filtering", "CS");
        this.add(1609830, "Number of Zero Fills", "US");
        this.add(1609831, "Baseline Correction", "CS");
        this.add(1609833, "Parallel Reduction Factor In-plane", "FD");
        this.add(1609840, "Cardiac R-R Interval Specified", "FD");
        this.add(1609843, "Acquisition Duration", "FD");
        this.add(1609844, "Frame Acquisition DateTime", "DT");
        this.add(1609845, "Diffusion Directionality", "CS");
        this.add(1609846, "Diffusion Gradient DirectionSequence", "SQ");
        this.add(1609847, "Parallel Acquisition", "CS");
        this.add(1609848, "Parallel Acquisition Technique", "CS");
        this.add(1609849, "Inversion Times", "FD");
        this.add(1609856, "Metabolite Map Description", "ST");
        this.add(1609857, "Partial Fourier", "CS");
        this.add(1609858, "Effective Echo Time", "FD");
        this.add(1609859, "Metabolite Map Code Sequence", "SQ");
        this.add(1609860, "Chemical Shift Sequence", "SQ");
        this.add(1609861, "Cardiac Signal Source", "CS");
        this.add(1609863, "Diffusion b-value", "FD");
        this.add(1609865, "Diffusion Gradient Orientation", "FD");
        this.add(1609872, "Velocity Encoding Direction", "FD");
        this.add(1609873, "Velocity Encoding Minimum Value", "FD");
        this.add(1609874, "Velocity Encoding AcquisitionSequence", "SQ");
        this.add(1609875, "Number of k-Space Trajectories", "US");
        this.add(1609876, "Coverage of k-Space", "CS");
        this.add(1609877, "Spectroscopy Acquisition PhaseRows", "UL");
        this.add(1609878, "Parallel Reduction Factor In-plane(Retired)", "FD");
        this.add(1609880, "Transmitter Frequency", "FD");
        this.add(1609984, "Resonant Nucleus", "CS");
        this.add(1609985, "Frequency Correction", "CS");
        this.add(1609987, "MR Spectroscopy FOV/GeometrySequence", "SQ");
        this.add(1609988, "Slab Thickness", "FD");
        this.add(1609989, "Slab Orientation", "FD");
        this.add(1609990, "Mid Slab Position", "FD");
        this.add(1609991, "MR Spatial Saturation Sequence", "SQ");
        this.add(1610002, "MR Timing and RelatedParameters Sequence", "SQ");
        this.add(1610004, "MR Echo Sequence", "SQ");
        this.add(1610005, "MR Modifier Sequence", "SQ");
        this.add(1610007, "MR Diffusion Sequence", "SQ");
        this.add(0x189118, "Cardiac Synchronization Sequence", "SQ");
        this.add(0x189119, "MR Averages Sequence", "SQ");
        this.add(1610021, "MR FOV/Geometry Sequence", "SQ");
        this.add(1610022, "Volume Localization Sequence", "SQ");
        this.add(1610023, "Spectroscopy Acquisition DataColumns", "UL");
        this.add(1610055, "Diffusion Anisotropy Type", "CS");
        this.add(1610065, "Frame Reference DateTime", "DT");
        this.add(1610066, "MR Metabolite Map Sequence", "SQ");
        this.add(1610069, "Parallel Reduction Factorout-of-plane", "FD");
        this.add(1610073, "Spectroscopy AcquisitionOut-of-plane Phase Steps", "UL");
        this.add(1610086, "Bulk Motion Status", "CS");
        this.add(1610088, "Parallel Reduction Factor SecondIn-plane", "FD");
        this.add(1610089, "Cardiac Beat Rejection Technique", "CS");
        this.add(1610096, "Respiratory Motion CompensationTechnique", "CS");
        this.add(1610097, "Respiratory Signal Source", "CS");
        this.add(1610098, "Bulk Motion CompensationTechnique", "CS");
        this.add(1610099, "Bulk Motion Signal Source", "CS");
        this.add(1610100, "Applicable Safety Standard Agency", "CS");
        this.add(1610101, "Applicable Safety StandardDescription", "LO");
        this.add(1610102, "Operating Mode Sequence", "SQ");
        this.add(1610103, "Operating Mode Type", "CS");
        this.add(1610104, "Operating Mode", "CS");
        this.add(1610105, "Specific Absorption Rate Definition", "CS");
        this.add(1610112, "Gradient Output Type", "CS");
        this.add(0x189181, "Specific Absorption Rate Value", "FD");
        this.add(1610114, "Gradient Output", "FD");
        this.add(1610115, "Flow Compensation Direction", "CS");
        this.add(1610116, "Tagging Delay", "FD");
        this.add(1610117, "Respiratory Motion CompensationTechnique Description", "ST");
        this.add(1610118, "Respiratory Signal Source ID", "SH");
        this.add(1610133, "Chemical Shift Minimum IntegrationLimit in Hz", "FD");
        this.add(1610134, "Chemical Shift MaximumIntegration Limit in Hz", "FD");
        this.add(1610135, "MR Velocity Encoding Sequence", "SQ");
        this.add(0x189198, "First Order Phase Correction", "CS");
        this.add(0x189199, "Water Referenced PhaseCorrection", "CS");
        this.add(1610240, "MR Spectroscopy Acquisition Type", "CS");
        this.add(1610260, "Respiratory Cycle Position", "CS");
        this.add(1610263, "Velocity Encoding Maximum Value", "FD");
        this.add(1610264, "Tag Spacing Second Dimension", "FD");
        this.add(1610265, "Tag Angle Second Axis", "SS");
        this.add(1610272, "Frame Acquisition Duration", "FD");
        this.add(1610278, "MR Image Frame Type Sequence", "SQ");
        this.add(1610279, "MR Spectroscopy Frame TypeSequence", "SQ");
        this.add(1610289, "MR Acquisition Phase EncodingSteps in-plane", "US");
        this.add(1610290, "MR Acquisition Phase EncodingSteps out-of-plane", "US");
        this.add(1610292, "Spectroscopy Acquisition PhaseColumns", "UL");
        this.add(1610294, "Cardiac Cycle Position", "CS");
        this.add(1610297, "Specific Absorption Rate Sequence", "SQ");
        this.add(1610304, "RF Echo Train Length", "US");
        this.add(1610305, "Gradient Echo Train Length", "US");
        this.add(1610320, "Arterial Spin Labeling Contrast", "CS");
        this.add(1610321, "MR Arterial Spin LabelingSequence", "SQ");
        this.add(1610322, "ASL Technique Description", "LO");
        this.add(1610323, "ASL Slab Number", "US");
        this.add(1610324, "ASL Slab Thickness", "FD");
        this.add(1610325, "ASL Slab Orientation", "FD");
        this.add(1610326, "ASL Mid Slab Position", "FD");
        this.add(1610327, "ASL Context", "CS");
        this.add(1610328, "ASL Pulse Train Duration", "UL");
        this.add(1610329, "ASL Crusher Flag", "CS");
        this.add(1610330, "ASL Crusher Flow Limit", "FD");
        this.add(1610331, "ASL Crusher Description", "LO");
        this.add(1610332, "ASL Bolus Cut-off Flag", "CS");
        this.add(1610333, "ASL Bolus Cut-off TimingSequence", "SQ");
        this.add(1610334, "ASL Bolus Cut-off Technique", "LO");
        this.add(1610335, "ASL Bolus Cut-off Delay Time", "UL");
        this.add(1610336, "ASL Slab Sequence", "SQ");
        this.add(1610389, "Chemical Shift Minimum IntegrationLimit in ppm", "FD");
        this.add(1610390, "Chemical Shift MaximumIntegration Limit in ppm", "FD");
        this.add(1610391, "Water Reference Acquisition", "CS");
        this.add(1610392, "Echo Peak Position", "IS");
        this.add(1610497, "CT Acquisition Type Sequence", "SQ");
        this.add(1610498, "Acquisition Type", "CS");
        this.add(1610499, "Tube Angle", "FD");
        this.add(1610500, "CT Acquisition Details Sequence", "SQ");
        this.add(1610501, "Revolution Time", "FD");
        this.add(1610502, "Single Collimation Width", "FD");
        this.add(1610503, "Total Collimation Width", "FD");
        this.add(1610504, "CT Table Dynamics Sequence", "SQ");
        this.add(1610505, "Table Speed", "FD");
        this.add(1610512, "Table Feed per Rotation", "FD");
        this.add(1610513, "Spiral Pitch Factor", "FD");
        this.add(1610514, "CT Geometry Sequence", "SQ");
        this.add(1610515, "Data Collection Center (Patient)", "FD");
        this.add(1610516, "CT Reconstruction Sequence", "SQ");
        this.add(1610517, "Reconstruction Algorithm", "CS");
        this.add(1610518, "Convolution Kernel Group", "CS");
        this.add(1610519, "Reconstruction Field of View", "FD");
        this.add(1610520, "Reconstruction Target Center(Patient)", "FD");
        this.add(1610521, "Reconstruction Angle", "FD");
        this.add(1610528, "Image Filter", "SH");
        this.add(1610529, "CT Exposure Sequence", "SQ");
        this.add(1610530, "Reconstruction Pixel Spacing", "FD");
        this.add(1610531, "Exposure Modulation Type", "CS");
        this.add(1610532, "Estimated Dose Saving", "FD");
        this.add(1610533, "CT X-Ray Details Sequence", "SQ");
        this.add(1610534, "CT Position Sequence", "SQ");
        this.add(1610535, "Table Position", "FD");
        this.add(1610536, "Exposure Time in ms", "FD");
        this.add(1610537, "CT Image Frame Type Sequence", "SQ");
        this.add(1610544, "X-Ray Tube Current in mA", "FD");
        this.add(1610546, "Exposure in mAs", "FD");
        this.add(1610547, "Constant Volume Flag", "CS");
        this.add(1610548, "Fluoroscopy Flag", "CS");
        this.add(1610549, "Distance Source to Data CollectionCenter", "FD");
        this.add(1610551, "Contrast/Bolus Agent Number", "US");
        this.add(1610552, "Contrast/Bolus Ingredient CodeSequence", "SQ");
        this.add(1610560, "Contrast Administration ProfileSequence", "SQ");
        this.add(1610561, "Contrast/Bolus Usage Sequence", "SQ");
        this.add(1610562, "Contrast/Bolus Agent Administered", "CS");
        this.add(1610563, "Contrast/Bolus Agent Detected", "CS");
        this.add(1610564, "Contrast/Bolus Agent Phase", "CS");
        this.add(1610565, "CTDIvol", "FD");
        this.add(1610566, "CTDI Phantom Type CodeSequence", "SQ");
        this.add(1610577, "Calcium Scoring Mass FactorPatient", "FL");
        this.add(1610578, "Calcium Scoring Mass FactorDevice", "FL");
        this.add(1610579, "Energy Weighting Factor", "FL");
        this.add(1610592, "CT Additional X-Ray SourceSequence", "SQ");
        this.add(1610753, "Projection Pixel CalibrationSequence", "SQ");
        this.add(1610754, "Distance Source to Isocenter", "FL");
        this.add(1610755, "Distance Object to Table Top", "FL");
        this.add(1610756, "Object Pixel Spacing in Center ofBeam", "FL");
        this.add(1610757, "Positioner Position Sequence", "SQ");
        this.add(1610758, "Table Position Sequence", "SQ");
        this.add(1610759, "Collimator Shape Sequence", "SQ");
        this.add(1610768, "Planes in Acquisition", "CS");
        this.add(1610770, "XA/XRF Frame CharacteristicsSequence", "SQ");
        this.add(1610775, "Frame Acquisition Sequence", "SQ");
        this.add(1610784, "X-Ray Receptor Type", "CS");
        this.add(1610787, "Acquisition Protocol Name", "LO");
        this.add(1610788, "Acquisition Protocol Description", "LT");
        this.add(1610789, "Contrast/Bolus Ingredient Opaque", "CS");
        this.add(1610790, "Distance Receptor Plane toDetector Housing", "FL");
        this.add(1610791, "Intensifier Active Shape", "CS");
        this.add(1610792, "Intensifier Active Dimension(s)", "FL");
        this.add(1610793, "Physical Detector Size", "FL");
        this.add(1610800, "Position of Isocenter Projection", "FL");
        this.add(1610802, "Field of View Sequence", "SQ");
        this.add(1610803, "Field of View Description", "LO");
        this.add(1610804, "Exposure Control Sensing RegionsSequence", "SQ");
        this.add(1610805, "Exposure Control Sensing RegionShape", "CS");
        this.add(1610806, "Exposure Control Sensing RegionLeft Vertical Edge", "SS");
        this.add(1610807, "Exposure Control Sensing RegionRight Vertical Edge", "SS");
        this.add(1610808, "Exposure Control Sensing RegionUpper Horizontal Edge", "SS");
        this.add(1610809, "Exposure Control Sensing RegionLower Horizontal Edge", "SS");
        this.add(1610816, "Center of Circular ExposureControl Sensing Region", "SS");
        this.add(1610817, "Radius of Circular ExposureControl Sensing Region", "US");
        this.add(1610818, "Vertices of the Polygonal ExposureControl Sensing Region", "SS");
        this.add(1610821, "Column Angulation (Patient)", "FL");
        this.add(1610825, "Beam Angle", "FL");
        this.add(1610833, "Frame Detector ParametersSequence", "SQ");
        this.add(1610834, "Calculated Anatomy Thickness", "FL");
        this.add(1610837, "Calibration Sequence", "SQ");
        this.add(1610838, "Object Thickness Sequence", "SQ");
        this.add(1610839, "Plane Identification", "CS");
        this.add(1610849, "Field of View Dimension(s) in Float", "FL");
        this.add(1610850, "Isocenter Reference SystemSequence", "SQ");
        this.add(1610851, "Positioner Isocenter Primary Angle", "FL");
        this.add(1610852, "Positioner Isocenter SecondaryAngle", "FL");
        this.add(1610853, "Positioner Isocenter DetectorRotation Angle", "FL");
        this.add(1610854, "Table X Position to Isocenter", "FL");
        this.add(1610855, "Table Y Position to Isocenter", "FL");
        this.add(1610856, "Table Z Position to Isocenter", "FL");
        this.add(1610857, "Table Horizontal Rotation Angle", "FL");
        this.add(1610864, "Table Head Tilt Angle", "FL");
        this.add(1610865, "Table Cradle Tilt Angle", "FL");
        this.add(1610866, "Frame Display Shutter Sequence", "SQ");
        this.add(1610867, "Acquired Image Area Dose Product", "FL");
        this.add(1610868, "C-arm Positioner TabletopRelationship", "CS");
        this.add(1610870, "X-Ray Geometry Sequence", "SQ");
        this.add(1610871, "Irradiation Event IdentificationSequence", "SQ");
        this.add(1611012, "X-Ray 3D Frame Type Sequence", "SQ");
        this.add(1611014, "Contributing Sources Sequence", "SQ");
        this.add(1611015, "X-Ray 3D Acquisition Sequence", "SQ");
        this.add(1611016, "Primary Positioner Scan Arc", "FL");
        this.add(1611017, "Secondary Positioner Scan Arc", "FL");
        this.add(1611024, "Primary Positioner Scan StartAngle", "FL");
        this.add(1611025, "Secondary Positioner Scan StartAngle", "FL");
        this.add(1611028, "Primary Positioner Increment", "FL");
        this.add(1611029, "Secondary Positioner Increment", "FL");
        this.add(1611030, "Start Acquisition DateTime", "DT");
        this.add(1611031, "End Acquisition DateTime", "DT");
        this.add(1611032, "Primary Positioner Increment Sign", "SS");
        this.add(1611033, "Secondary Positioner IncrementSign", "SS");
        this.add(1611044, "Application Name", "LO");
        this.add(1611045, "Application Version", "LO");
        this.add(1611046, "Application Manufacturer", "LO");
        this.add(1611047, "Algorithm Type", "CS");
        this.add(1611048, "Algorithm Description", "LO");
        this.add(1611056, "X-Ray 3D ReconstructionSequence", "SQ");
        this.add(1611057, "Reconstruction Description", "LO");
        this.add(1611064, "Per Projection AcquisitionSequence", "SQ");
        this.add(1611073, "Detector Position Sequence", "SQ");
        this.add(1611074, "X-Ray Acquisition Dose Sequence", "SQ");
        this.add(1611075, "X-Ray Source Isocenter PrimaryAngle", "FD");
        this.add(1611076, "X-Ray Source Isocenter SecondaryAngle", "FD");
        this.add(1611077, "Breast Support Isocenter PrimaryAngle", "FD");
        this.add(1611078, "Breast Support IsocenterSecondary Angle", "FD");
        this.add(1611079, "Breast Support X Position toIsocenter", "FD");
        this.add(1611080, "Breast Support Y Position toIsocenter", "FD");
        this.add(1611081, "Breast Support Z Position toIsocenter", "FD");
        this.add(1611088, "Detector Isocenter Primary Angle", "FD");
        this.add(1611089, "Detector Isocenter SecondaryAngle", "FD");
        this.add(1611090, "Detector X Position to Isocenter", "FD");
        this.add(1611091, "Detector Y Position to Isocenter", "FD");
        this.add(1611092, "Detector Z Position to Isocenter", "FD");
        this.add(1611093, "X-Ray Grid Sequence", "SQ");
        this.add(1611094, "X-Ray Filter Sequence", "SQ");
        this.add(1611095, "Detector Active Area TLHCPosition", "FD");
        this.add(1611096, "Detector Active Area Orientation", "FD");
        this.add(1611097, "Positioner Primary Angle Direction", "CS");
        this.add(1611265, "Diffusion b-matrix Sequence", "SQ");
        this.add(1611266, "Diffusion b-value XX", "FD");
        this.add(1611267, "Diffusion b-value XY", "FD");
        this.add(1611268, "Diffusion b-value XZ", "FD");
        this.add(1611269, "Diffusion b-value YY", "FD");
        this.add(1611270, "Diffusion b-value YZ", "FD");
        this.add(1611271, "Diffusion b-value ZZ", "FD");
        this.add(1611521, "Decay Correction DateTime", "DT");
        this.add(1611541, "Start Density Threshold", "FD");
        this.add(1611542, "Start Relative Density DifferenceThreshold", "FD");
        this.add(1611543, "Start Cardiac Trigger CountThreshold", "FD");
        this.add(1611544, "Start Respiratory Trigger CountThreshold", "FD");
        this.add(1611545, "Termination Counts Threshold", "FD");
        this.add(1611552, "Termination Density Threshold", "FD");
        this.add(1611553, "Termination Relative DensityThreshold", "FD");
        this.add(1611554, "Termination Time Threshold", "FD");
        this.add(1611555, "Termination Cardiac Trigger CountThreshold", "FD");
        this.add(1611556, "Termination Respiratory TriggerCount Threshold", "FD");
        this.add(1611557, "Detector Geometry", "CS");
        this.add(1611558, "Transverse Detector Separation", "FD");
        this.add(1611559, "Axial Detector Dimension", "FD");
        this.add(1611561, "Radiopharmaceutical AgentNumber", "US");
        this.add(1611570, "PET Frame Acquisition Sequence", "SQ");
        this.add(1611571, "PET Detector Motion DetailsSequence", "SQ");
        this.add(1611572, "PET Table Dynamics Sequence", "SQ");
        this.add(1611573, "PET Position Sequence", "SQ");
        this.add(1611574, "PET Frame Correction FactorsSequence", "SQ");
        this.add(1611575, "Radiopharmaceutical UsageSequence", "SQ");
        this.add(1611576, "Attenuation Correction Source", "CS");
        this.add(1611577, "Number of Iterations", "US");
        this.add(1611584, "Number of Subsets", "US");
        this.add(1611593, "PET Reconstruction Sequence", "SQ");
        this.add(1611601, "PET Frame Type Sequence", "SQ");
        this.add(1611605, "Time of Flight Information Used", "CS");
        this.add(1611606, "Reconstruction Type", "CS");
        this.add(1611608, "Decay Corrected", "CS");
        this.add(1611609, "Attenuation Corrected", "CS");
        this.add(1611616, "Scatter Corrected", "CS");
        this.add(1611617, "Dead Time Corrected", "CS");
        this.add(1611618, "Gantry Motion Corrected", "CS");
        this.add(1611619, "Patient Motion Corrected", "CS");
        this.add(1611620, "Count Loss NormalizationCorrected", "CS");
        this.add(1611621, "Randoms Corrected", "CS");
        this.add(1611622, "Non-uniform Radial SamplingCorrected", "CS");
        this.add(1611623, "Sensitivity Calibrated", "CS");
        this.add(1611624, "Detector Normalization Correction", "CS");
        this.add(1611625, "Iterative Reconstruction Method", "CS");
        this.add(1611632, "Attenuation Correction TemporalRelationship", "CS");
        this.add(1611633, "Patient Physiological StateSequence", "SQ");
        this.add(1611634, "Patient Physiological State CodeSequence", "SQ");
        this.add(1611777, "Depth(s) of Focus", "FD");
        this.add(1611779, "Excluded Intervals Sequence", "SQ");
        this.add(1611780, "Exclusion Start DateTime", "DT");
        this.add(1611781, "Exclusion Duration", "FD");
        this.add(1611782, "US Image Description Sequence", "SQ");
        this.add(1611783, "Image Data Type Sequence", "SQ");
        this.add(1611784, "Data Type", "CS");
        this.add(1611785, "Transducer Scan Pattern CodeSequence", "SQ");
        this.add(1611787, "Aliased Data Type", "CS");
        this.add(1611788, "Position Measuring Device Used", "CS");
        this.add(1611789, "Transducer Geometry CodeSequence", "SQ");
        this.add(1611790, "Transducer Beam Steering CodeSequence", "SQ");
        this.add(1611791, "Transducer Application CodeSequence", "SQ");
        this.add(1613825, "Contributing Equipment Sequence", "SQ");
        this.add(1613826, "Contribution DateTime", "DT");
        this.add(1613827, "Contribution Description", "ST");
    }

    private void addAttributeGroup0020() {
        this.add(0x20000D, "Study Instance UID", "UI");
        this.add(0x20000E, "Series Instance UID", "UI");
        this.add(0x200010, "Study ID", "SH");
        this.add(0x200011, "Series Number", "IS");
        this.add(0x200012, "Acquisition Number", "IS");
        this.add(2097171, "Instance Number", "IS");
        this.add(2097172, "Isotope Number", "IS");
        this.add(2097173, "Phase Number", "IS");
        this.add(2097174, "Interval Number", "IS");
        this.add(2097175, "Time Slot Number", "IS");
        this.add(2097176, "Angle Number", "IS");
        this.add(2097177, "Item Number", "IS");
        this.add(0x200020, "Patient Orientation", "CS");
        this.add(0x200022, "Overlay Number", "IS");
        this.add(0x200024, "Curve Number", "IS");
        this.add(0x200026, "LUT Number", "IS");
        this.add(0x200030, "Image Position", "DS");
        this.add(0x200032, "Image Position (Patient)", "DS");
        this.add(2097205, "Image Orientation", "DS");
        this.add(2097207, "Image Orientation (Patient)", "DS");
        this.add(0x200050, "Location", "DS");
        this.add(0x200052, "Frame of Reference UID", "UI");
        this.add(0x200060, "Laterality", "CS");
        this.add(0x200062, "Image Laterality", "CS");
        this.add(0x200070, "Image Geometry Type", "LO");
        this.add(0x200080, "Masking Image", "CS");
        this.add(0x2000AA, "Report Number", "IS");
        this.add(0x200100, "Temporal Position Identifier", "IS");
        this.add(2097413, "Number of Temporal Positions", "IS");
        this.add(0x200110, "Temporal Resolution", "DS");
        this.add(0x200200, "Synchronization Frame ofReference UID", "UI");
        this.add(0x200242, "SOP Instance UID ofConcatenation Source", "UI");
        this.add(0x201000, "Series in Study", "IS");
        this.add(0x201001, "Acquisitions in Series", "IS");
        this.add(0x201002, "Images in Acquisition", "IS");
        this.add(2101251, "Images in Series", "IS");
        this.add(2101252, "Acquisitions in Study", "IS");
        this.add(2101253, "Images in Study", "IS");
        this.add(0x201020, "Reference", "LO");
        this.add(2101312, "Position Reference Indicator", "LO");
        this.add(2101313, "Slice Location", "DS");
        this.add(2101360, "Other Study Numbers", "IS");
        this.add(0x201200, "Number of Patient Related Studies", "IS");
        this.add(0x201202, "Number of Patient Related Series", "IS");
        this.add(2101764, "Number of Patient RelatedInstances", "IS");
        this.add(2101766, "Number of Study Related Series", "IS");
        this.add(2101768, "Number of Study Related Instances", "IS");
        this.add(2101769, "Number of Series RelatedInstances", "IS");
        this.add(2110465, "Modifying Device ID", "CS");
        this.add(2110466, "Modified Image ID", "CS");
        this.add(2110467, "Modified Image Date", "DA");
        this.add(2110468, "Modifying Device Manufacturer", "LO");
        this.add(2110469, "Modified Image Time", "TM");
        this.add(2110470, "Modified Image Description", "LO");
        this.add(0x204000, "Image Comments", "LT");
        this.add(0x205000, "Original Image Identification", "AT");
        this.add(0x205002, "Original Image IdentificationNomenclature", "LO");
        this.add(2134102, "Stack ID", "SH");
        this.add(2134103, "In-Stack Position Number", "UL");
        this.add(2134129, "Frame Anatomy Sequence", "SQ");
        this.add(2134130, "Frame Laterality", "CS");
        this.add(2134289, "Frame Content Sequence", "SQ");
        this.add(2134291, "Plane Position Sequence", "SQ");
        this.add(2134294, "Plane Orientation Sequence", "SQ");
        this.add(2134312, "Temporal Position Index", "UL");
        this.add(2134355, "Nominal Cardiac Trigger DelayTime", "FD");
        this.add(2134356, "Nominal Cardiac Trigger Time PriorTo R-Peak", "FL");
        this.add(2134357, "Actual Cardiac Trigger Time PriorTo R-Peak", "FL");
        this.add(2134358, "Frame Acquisition Number", "US");
        this.add(2134359, "Dimension Index Values", "UL");
        this.add(2134360, "Frame Comments", "LT");
        this.add(2134369, "Concatenation UID", "UI");
        this.add(2134370, "In-concatenation Number", "US");
        this.add(2134371, "In-concatenation Total Number", "US");
        this.add(2134372, "Dimension Organization UID", "UI");
        this.add(2134373, "Dimension Index Pointer", "AT");
        this.add(2134375, "Functional Group Pointer", "AT");
        this.add(2134384, "Unassigned Shared ConvertedAttributes Sequence", "SQ");
        this.add(2134385, "Unassigned Per-Frame ConvertedAttributes Sequence", "SQ");
        this.add(2134386, "Conversion Source AttributesSequence", "SQ");
        this.add(2134547, "Dimension Index Private Creator", "LO");
        this.add(2134561, "Dimension Organization Sequence", "SQ");
        this.add(0x209222, "Dimension Index Sequence", "SQ");
        this.add(2134568, "Concatenation Frame OffsetNumber", "UL");
        this.add(2134584, "Functional Group Private Creator", "LO");
        this.add(2134593, "Nominal Percentage of CardiacPhase", "FL");
        this.add(2134597, "Nominal Percentage of RespiratoryPhase", "FL");
        this.add(2134598, "Starting Respiratory Amplitude", "FL");
        this.add(2134599, "Starting Respiratory Phase", "CS");
        this.add(2134600, "Ending Respiratory Amplitude", "FL");
        this.add(2134601, "Ending Respiratory Phase", "CS");
        this.add(2134608, "Respiratory Trigger Type", "CS");
        this.add(2134609, "R-R Interval Time Nominal", "FD");
        this.add(2134610, "Actual Cardiac Trigger Delay Time", "FD");
        this.add(2134611, "Respiratory SynchronizationSequence", "SQ");
        this.add(2134612, "Respiratory Interval Time", "FD");
        this.add(2134613, "Nominal Respiratory Trigger DelayTime", "FD");
        this.add(2134614, "Respiratory Trigger DelayThreshold", "FD");
        this.add(2134615, "Actual Respiratory Trigger DelayTime", "FD");
        this.add(2134785, "Image Position (Volume)", "FD");
        this.add(2134786, "Image Orientation (Volume)", "FD");
        this.add(2134791, "Ultrasound Acquisition Geometry", "CS");
        this.add(2134792, "Apex Position", "FD");
        this.add(2134793, "Volume to Transducer MappingMatrix", "FD");
        this.add(2134794, "Volume to Table Mapping Matrix", "FD");
        this.add(2134795, "Volume to Transducer Relationship", "CS");
        this.add(2134796, "Patient Frame of Reference Source", "CS");
        this.add(2134797, "Temporal Position Time Offset", "FD");
        this.add(2134798, "Plane Position (Volume) Sequence", "SQ");
        this.add(2134799, "Plane Orientation (Volume)  Sequence", "SQ");
        this.add(2134800, "Temporal Position Sequence", "SQ");
        this.add(2134801, "Dimension Organization Type", "CS");
        this.add(2134802, "Volume Frame of Reference UID", "UI");
        this.add(2134803, "Table Frame of Reference UID", "UI");
        this.add(2135073, "Dimension Description Label", "LO");
        this.add(2135120, "Patient Orientation in FrameSequence", "SQ");
        this.add(2135123, "Frame Label", "LO");
        this.add(2135320, "Acquisition Index", "US");
        this.add(2135337, "Contributing SOP InstancesReference Sequence", "SQ");
        this.add(2135350, "Reconstruction Index", "US");
    }

    private void addAttributeGroup0022() {
        this.add(0x220001, "Light Path Filter Pass-ThroughWavelength", "US");
        this.add(0x220002, "Light Path Filter Pass Band", "US");
        this.add(0x220003, "Image Path Filter Pass-ThroughWavelength", "US");
        this.add(0x220004, "Image Path Filter Pass Band", "US");
        this.add(0x220005, "Patient Eye MovementCommanded", "CS");
        this.add(0x220006, "Patient Eye Movement CommandCode Sequence", "SQ");
        this.add(0x220007, "Spherical Lens Power", "FL");
        this.add(0x220008, "Cylinder Lens Power", "FL");
        this.add(0x220009, "Cylinder Axis", "FL");
        this.add(0x22000A, "Emmetropic Magnification", "FL");
        this.add(0x22000B, "Intra Ocular Pressure", "FL");
        this.add(0x22000C, "Horizontal Field of View", "FL");
        this.add(0x22000D, "Pupil Dilated", "CS");
        this.add(0x22000E, "Degree of Dilation", "FL");
        this.add(0x220010, "Stereo Baseline Angle", "FL");
        this.add(0x220011, "Stereo Baseline Displacement", "FL");
        this.add(0x220012, "Stereo Horizontal Pixel Offset", "FL");
        this.add(2228243, "Stereo Vertical Pixel Offset", "FL");
        this.add(2228244, "Stereo Rotation", "FL");
        this.add(2228245, "Acquisition Device Type CodeSequence", "SQ");
        this.add(2228246, "Illumination Type Code Sequence", "SQ");
        this.add(2228247, "Light Path Filter Type Stack CodeSequence", "SQ");
        this.add(2228248, "Image Path Filter Type Stack CodeSequence", "SQ");
        this.add(2228249, "Lenses Code Sequence", "SQ");
        this.add(2228250, "Channel Description CodeSequence", "SQ");
        this.add(2228251, "Refractive State Sequence", "SQ");
        this.add(2228252, "Mydriatic Agent Code Sequence", "SQ");
        this.add(2228253, "Relative Image Position CodeSequence", "SQ");
        this.add(2228254, "Camera Angle of View", "FL");
        this.add(0x220020, "Stereo Pairs Sequence", "SQ");
        this.add(0x220021, "Left Image Sequence", "SQ");
        this.add(0x220022, "Right Image Sequence", "SQ");
        this.add(0x220028, "Stereo Pairs Present", "CS");
        this.add(0x220030, "Axial Length of the Eye", "FL");
        this.add(2228273, "Ophthalmic Frame LocationSequence", "SQ");
        this.add(0x220032, "Reference Coordinates", "FL");
        this.add(2228277, "Depth Spatial Resolution", "FL");
        this.add(2228278, "Maximum Depth Distortion", "FL");
        this.add(2228279, "Along-scan Spatial Resolution", "FL");
        this.add(2228280, "Maximum Along-scan Distortion", "FL");
        this.add(2228281, "Ophthalmic Image Orientation", "CS");
        this.add(2228289, "Depth of Transverse Image", "FL");
        this.add(0x220042, "Mydriatic Agent ConcentrationUnits Sequence", "SQ");
        this.add(2228296, "Across-scan Spatial Resolution", "FL");
        this.add(2228297, "Maximum Across-scan Distortion", "FL");
        this.add(2228302, "Mydriatic Agent Concentration", "DS");
        this.add(0x220055, "Illumination Wave Length", "FL");
        this.add(2228310, "Illumination Power", "FL");
        this.add(2228311, "Illumination Bandwidth", "FL");
        this.add(2228312, "Mydriatic Agent Sequence", "SQ");
        this.add(2232327, "Ophthalmic Axial MeasurementsRight Eye Sequence", "SQ");
        this.add(2232328, "Ophthalmic Axial MeasurementsLeft Eye Sequence", "SQ");
        this.add(2232329, "Ophthalmic Axial MeasurementsDevice Type", "CS");
        this.add(0x221010, "Ophthalmic Axial LengthMeasurements Type", "CS");
        this.add(0x221012, "Ophthalmic Axial Length Sequence", "SQ");
        this.add(2232345, "Ophthalmic Axial Length", "FL");
        this.add(2232356, "Lens Status Code Sequence", "SQ");
        this.add(2232357, "Vitreous Status Code Sequence", "SQ");
        this.add(2232360, "IOL Formula Code Sequence", "SQ");
        this.add(2232361, "IOL Formula Detail", "LO");
        this.add(2232371, "Keratometer Index", "FL");
        this.add(2232373, "Source of Ophthalmic Axial LengthCode Sequence", "SQ");
        this.add(2232375, "Target Refraction", "FL");
        this.add(2232377, "Refractive Procedure Occurred", "CS");
        this.add(2232384, "Refractive Surgery Type CodeSequence", "SQ");
        this.add(2232388, "Ophthalmic Ultrasound MethodCode Sequence", "SQ");
        this.add(2232400, "Ophthalmic Axial LengthMeasurements Sequence", "SQ");
        this.add(2232403, "IOL Power", "FL");
        this.add(2232404, "Predicted Refractive Error", "FL");
        this.add(2232409, "Ophthalmic Axial Length Velocity", "FL");
        this.add(2232421, "Lens Status Description", "LO");
        this.add(2232422, "Vitreous Status Description", "LO");
        this.add(2232464, "IOL Power Sequence", "SQ");
        this.add(2232466, "Lens Constant Sequence", "SQ");
        this.add(2232467, "IOL Manufacturer", "LO");
        this.add(2232468, "Lens Constant Description", "LO");
        this.add(2232469, "Implant Name", "LO");
        this.add(2232470, "Keratometry Measurement TypeCode Sequence", "SQ");
        this.add(2232471, "Implant Part Number", "LO");
        this.add(0x221100, "Referenced Ophthalmic AxialMeasurements Sequence", "SQ");
        this.add(0x221101, "Ophthalmic Axial LengthMeasurements Segment NameCode Sequence", "SQ");
        this.add(2232579, "Refractive Error Before RefractiveSurgery Code Sequence", "SQ");
        this.add(0x221121, "IOL Power For Exact Emmetropia", "FL");
        this.add(0x221122, "IOL Power For Exact TargetRefraction", "FL");
        this.add(0x221125, "Anterior Chamber Depth DefinitionCode Sequence", "SQ");
        this.add(0x221127, "Lens Thickness Sequence", "SQ");
        this.add(0x221128, "Anterior Chamber Depth Sequence", "SQ");
        this.add(2232624, "Lens Thickness", "FL");
        this.add(0x221131, "Anterior Chamber Depth", "FL");
        this.add(0x221132, "Source of Lens Thickness DataCode Sequence", "SQ");
        this.add(0x221133, "Source of Anterior Chamber DepthData Code Sequence", "SQ");
        this.add(2232628, "Source of RefractiveMeasurements Sequence", "SQ");
        this.add(2232629, "Source of RefractiveMeasurements Code Sequence", "SQ");
        this.add(2232640, "Ophthalmic Axial LengthMeasurement Modified", "CS");
        this.add(2232656, "Ophthalmic Axial Length DataSource Code Sequence", "SQ");
        this.add(2232659, "Ophthalmic Axial LengthAcquisition Method CodeSequence", "SQ");
        this.add(0x221155, "Signal to Noise Ratio", "FL");
        this.add(2232665, "Ophthalmic Axial Length DataSource Description", "LO");
        this.add(0x221210, "Ophthalmic Axial LengthMeasurements Total LengthSequence", "SQ");
        this.add(0x221211, "Ophthalmic Axial LengthMeasurements Segmental LengthSequence", "SQ");
        this.add(0x221212, "Ophthalmic Axial LengthMeasurements Length SummationSequence", "SQ");
        this.add(0x221220, "Ultrasound Ophthalmic AxialLength Measurements Sequence", "SQ");
        this.add(0x221225, "Optical Ophthalmic Axial LengthMeasurements Sequence", "SQ");
        this.add(2232880, "Ultrasound Selected OphthalmicAxial Length Sequence", "SQ");
        this.add(2232912, "Ophthalmic Axial Length SelectionMethod Code Sequence", "SQ");
        this.add(0x221255, "Optical Selected Ophthalmic AxialLength Sequence", "SQ");
        this.add(2232919, "Selected Segmental OphthalmicAxial Length Sequence", "SQ");
        this.add(2232928, "Selected Total Ophthalmic AxialLength Sequence", "SQ");
        this.add(0x221262, "Ophthalmic Axial Length QualityMetric Sequence", "SQ");
        this.add(2232933, "Ophthalmic Axial Length QualityMetric Type Code Sequence", "SQ");
        this.add(2232947, "Ophthalmic Axial Length QualityMetric Type Description", "LO");
        this.add(2233088, "Intraocular Lens Calculations RightEye Sequence", "SQ");
        this.add(2233104, "Intraocular Lens Calculations LeftEye Sequence", "SQ");
        this.add(2233136, "Referenced Ophthalmic AxialLength Measurement QC ImageSequence", "SQ");
        this.add(2233365, "Ophthalmic Mapping Device Type", "CS");
        this.add(2233376, "Acquisition Method CodeSequence", "SQ");
        this.add(2233379, "Acquisition Method AlgorithmSequence", "SQ");
        this.add(2233398, "Ophthalmic Thickness Map TypeCode Sequence", "SQ");
        this.add(2233411, "Ophthalmic Thickness MappingNormals Sequence", "SQ");
        this.add(2233413, "Retinal Thickness Definition CodeSequence", "SQ");
        this.add(2233424, "Pixel Value Mapping to CodedConcept Sequence", "SQ");
        this.add(2233428, "Pixel Value Mapping Explanation", "LO");
        this.add(2233432, "Ophthalmic Thickness Map QualityThreshold Sequence", "SQ");
        this.add(2233440, "Ophthalmic Thickness MapThreshold Quality Rating", "FL");
        this.add(2233443, "Anatomic Structure ReferencePoint", "FL");
        this.add(2233445, "Registration to Localizer Sequence", "SQ");
        this.add(2233446, "Registered Localizer Units", "CS");
        this.add(2233447, "Registered Localizer Top Left HandCorner", "FL");
        this.add(2233448, "Registered Localizer Bottom RightHand Corner", "FL");
        this.add(2233456, "Ophthalmic Thickness Map QualityRating Sequence", "SQ");
        this.add(2233458, "Relevant OPT Attributes Sequence", "SQ");
        this.add(0x221512, "Transformation Method CodeSequence", "SQ");
        this.add(2233619, "Transformation AlgorithmSequence", "SQ");
        this.add(0x221515, "Ophthalmic Axial Length Method", "CS");
        this.add(2233623, "Ophthalmic FOV", "FL");
        this.add(2233624, "Two Dimensional to ThreeDimensional Map Sequence", "SQ");
        this.add(0x221525, "Wide Field OphthalmicPhotography Quality RatingSequence", "SQ");
        this.add(2233638, "Wide Field OphthalmicPhotography Quality ThresholdSequence", "SQ");
        this.add(2233639, "Wide Field OphthalmicPhotography Threshold QualityRating", "FL");
        this.add(2233640, "X Coordinates Center Pixel ViewAngle", "FL");
        this.add(2233641, "Y Coordinates Center Pixel ViewAngle", "FL");
        this.add(2233648, "Number of Map Points", "UL");
        this.add(2233649, "Two Dimensional to ThreeDimensional Map Data", "OF");
    }

    private void addAttributeGroup0024() {
        this.add(2359312, "Visual Field Horizontal Extent", "FL");
        this.add(2359313, "Visual Field Vertical Extent", "FL");
        this.add(2359314, "Visual Field Shape", "CS");
        this.add(2359318, "Screening Test Mode CodeSequence", "SQ");
        this.add(2359320, "Maximum Stimulus Luminance", "FL");
        this.add(0x240020, "Background Luminance", "FL");
        this.add(2359329, "Stimulus Color Code Sequence", "SQ");
        this.add(0x240024, "Background Illumination ColorCode Sequence", "SQ");
        this.add(2359333, "Stimulus Area", "FL");
        this.add(2359336, "Stimulus Presentation Time", "FL");
        this.add(2359346, "Fixation Sequence", "SQ");
        this.add(2359347, "Fixation Monitoring CodeSequence", "SQ");
        this.add(2359348, "Visual Field Catch Trial Sequence", "SQ");
        this.add(2359349, "Fixation Checked Quantity", "US");
        this.add(2359350, "Patient Not Properly FixatedQuantity", "US");
        this.add(2359351, "Presented Visual Stimuli Data Flag", "CS");
        this.add(2359352, "Number of Visual Stimuli", "US");
        this.add(2359353, "Excessive Fixation Losses DataFlag", "CS");
        this.add(0x240040, "Excessive Fixation Losses", "CS");
        this.add(0x240042, "Stimuli Retesting Quantity", "US");
        this.add(0x240044, "Comments on Patient'sPerformance of Visual Field", "LT");
        this.add(2359365, "False Negatives Estimate Flag", "CS");
        this.add(2359366, "False Negatives Estimate", "FL");
        this.add(2359368, "Negative Catch Trials Quantity", "US");
        this.add(2359376, "False Negatives Quantity", "US");
        this.add(2359377, "Excessive False Negatives DataFlag", "CS");
        this.add(2359378, "Excessive False Negatives", "CS");
        this.add(2359379, "False Positives Estimate Flag", "CS");
        this.add(2359380, "False Positives Estimate", "FL");
        this.add(2359381, "Catch Trials Data Flag", "CS");
        this.add(2359382, "Positive Catch Trials Quantity", "US");
        this.add(2359383, "Test Point Normals Data Flag", "CS");
        this.add(2359384, "Test Point Normals Sequence", "SQ");
        this.add(2359385, "Global Deviation ProbabilityNormals Flag", "CS");
        this.add(2359392, "False Positives Quantity", "US");
        this.add(2359393, "Excessive False Positives DataFlag", "CS");
        this.add(2359394, "Excessive False Positives", "CS");
        this.add(2359395, "Visual Field Test Normals Flag", "CS");
        this.add(2359396, "Results Normals Sequence", "SQ");
        this.add(2359397, "Age Corrected Sensitivity DeviationAlgorithm Sequence", "SQ");
        this.add(2359398, "Global Deviation From Normal", "FL");
        this.add(2359399, "Generalized Defect SensitivityDeviation Algorithm Sequence", "SQ");
        this.add(2359400, "Localized Deviation From Normal", "FL");
        this.add(2359401, "Patient Reliability Indicator", "LO");
        this.add(2359408, "Visual Field Mean Sensitivity", "FL");
        this.add(2359409, "Global Deviation Probability", "FL");
        this.add(2359410, "Local Deviation Probability NormalsFlag", "CS");
        this.add(2359411, "Localized Deviation Probability", "FL");
        this.add(2359412, "Short Term Fluctuation Calculated", "CS");
        this.add(2359413, "Short Term Fluctuation", "FL");
        this.add(2359414, "Short Term Fluctuation ProbabilityCalculated", "CS");
        this.add(2359415, "Short Term Fluctuation Probability", "FL");
        this.add(2359416, "Corrected Localized DeviationFrom Normal Calculated", "CS");
        this.add(2359417, "Corrected Localized DeviationFrom Normal", "FL");
        this.add(2359424, "Corrected Localized DeviationFrom Normal Probability Calculated", "CS");
        this.add(2359425, "Corrected Localized DeviationFrom Normal Probability", "FL");
        this.add(2359427, "Global Deviation ProbabilitySequence", "SQ");
        this.add(2359429, "Localized Deviation ProbabilitySequence", "SQ");
        this.add(2359430, "Foveal Sensitivity Measured", "CS");
        this.add(2359431, "Foveal Sensitivity", "FL");
        this.add(2359432, "Visual Field Test Duration", "FL");
        this.add(2359433, "Visual Field Test Point Sequence", "SQ");
        this.add(2359440, "Visual Field Test PointX-Coordinate", "FL");
        this.add(2359441, "Visual Field Test PointY-Coordinate", "FL");
        this.add(2359442, "Age Corrected Sensitivity DeviationValue", "FL");
        this.add(2359443, "Stimulus Results", "CS");
        this.add(2359444, "Sensitivity Value", "FL");
        this.add(2359445, "Retest Stimulus Seen", "CS");
        this.add(2359446, "Retest Sensitivity Value", "FL");
        this.add(2359447, "Visual Field Test Point NormalsSequence", "SQ");
        this.add(2359448, "Quantified Defect", "FL");
        this.add(2359552, "Age Corrected Sensitivity DeviationProbability Value", "FL");
        this.add(2359554, "Generalized Defect CorrectedSensitivity Deviation Flag", "CS");
        this.add(2359555, "Generalized Defect CorrectedSensitivity Deviation Value", "FL");
        this.add(2359556, "Generalized Defect CorrectedSensitivity Deviation ProbabilityValue", "FL");
        this.add(2359557, "Minimum Sensitivity Value", "FL");
        this.add(2359558, "Blind Spot Localized", "CS");
        this.add(2359559, "Blind Spot X-Coordinate", "FL");
        this.add(2359560, "Blind Spot Y-Coordinate", "FL");
        this.add(2359568, "Visual Acuity MeasurementSequence", "SQ");
        this.add(2359570, "Refractive Parameters Used onPatient Sequence", "SQ");
        this.add(2359571, "Measurement Laterality", "CS");
        this.add(2359572, "Ophthalmic Patient ClinicalInformation Left Eye Sequence", "SQ");
        this.add(2359573, "Ophthalmic Patient ClinicalInformation Right Eye Sequence", "SQ");
        this.add(2359575, "Foveal Point Normative Data Flag", "CS");
        this.add(2359576, "Foveal Point Probability Value", "FL");
        this.add(2359584, "Screening Baseline Measured", "CS");
        this.add(2359586, "Screening Baseline MeasuredSequence", "SQ");
        this.add(2359588, "Screening Baseline Type", "CS");
        this.add(2359590, "Screening Baseline Value", "FL");
        this.add(0x240202, "Algorithm Source", "LO");
        this.add(2360070, "Data Set Name", "LO");
        this.add(2360071, "Data Set Version", "LO");
        this.add(2360072, "Data Set Source", "LO");
        this.add(2360073, "Data Set Description", "LO");
        this.add(2360087, "Visual Field Test Reliability GlobalIndex Sequence", "SQ");
        this.add(2360096, "Visual Field Global Results IndexSequence", "SQ");
        this.add(2360101, "Data Observation Sequence", "SQ");
        this.add(2360120, "Index Normals Flag", "CS");
        this.add(2360129, "Index Probability", "FL");
        this.add(2360132, "Index Probability Sequence", "SQ");
    }

    private void addAttributeGroup0028() {
        this.add(0x280002, "Samples per Pixel", "US");
        this.add(2621443, "Samples per Pixel Used", "US");
        this.add(2621444, "Photometric Interpretation", "CS");
        this.add(2621445, "Image Dimensions", "US");
        this.add(2621446, "Planar Configuration", "US");
        this.add(0x280008, "Number of Frames", "IS");
        this.add(2621449, "Frame Increment Pointer", "AT");
        this.add(2621450, "Frame Dimension Pointer", "AT");
        this.add(2621456, "Rows", "US");
        this.add(2621457, "Columns", "US");
        this.add(2621458, "Planes", "US");
        this.add(2621460, "Ultrasound Color Data Present", "US");
        this.add(2621488, "Pixel Spacing", "DS");
        this.add(2621489, "Zoom Factor", "DS");
        this.add(2621490, "Zoom Center", "DS");
        this.add(2621492, "Pixel Aspect Ratio", "IS");
        this.add(2621504, "Image Format", "CS");
        this.add(2621520, "Manipulated Image", "LO");
        this.add(2621521, "Corrected Image", "CS");
        this.add(2621535, "Compression Recognition Code", "LO");
        this.add(2621536, "Compression Code", "CS");
        this.add(2621537, "Compression Originator", "SH");
        this.add(2621538, "Compression Label", "LO");
        this.add(2621539, "Compression Description", "SH");
        this.add(2621541, "Compression Sequence", "CS");
        this.add(2621542, "Compression Step Pointers", "AT");
        this.add(2621544, "Repeat Interval", "US");
        this.add(2621545, "Bits Grouped", "US");
        this.add(2621552, "Perimeter Table", "US");
        this.add(0x280080, "Predictor Rows", "US");
        this.add(2621569, "Predictor Columns", "US");
        this.add(0x280082, "Predictor Constants", "US");
        this.add(2621584, "Blocked Pixels", "CS");
        this.add(2621585, "Block Rows", "US");
        this.add(2621586, "Block Columns", "US");
        this.add(2621587, "Row Overlap", "US");
        this.add(2621588, "Column Overlap", "US");
        this.add(2621696, "Bits Allocated", "US");
        this.add(2621697, "Bits Stored", "US");
        this.add(2621698, "High Bit", "US");
        this.add(2621699, "Pixel Representation", "US");
        this.add(2621730, "Float Pixel Padding Value", "FL");
        this.add(2621731, "Double Float Pixel Padding Value", "FD");
        this.add(2621732, "Float Pixel Padding Range Limit", "FL");
        this.add(2621733, "Double Float Pixel Padding RangeLimit", "FD");
        this.add(0x280200, "Image Location", "US");
        this.add(2622208, "Quality Control Image", "CS");
        this.add(2622209, "Burned In Annotation", "CS");
        this.add(2622210, "Recognizable Visual Features", "CS");
        this.add(2622211, "Longitudinal Temporal InformationModified", "CS");
        this.add(2622212, "Referenced Color Palette InstanceUID", "UI");
        this.add(2622464, "Transform Label", "LO");
        this.add(2622465, "Transform Version Number", "LO");
        this.add(2622466, "Number of Transform Steps", "US");
        this.add(2622467, "Sequence of Compressed Data", "LO");
        this.add(2622468, "Details of Coefficients", "AT");
        this.add(2623232, "DCT Label", "LO");
        this.add(2623233, "Data Block Description", "CS");
        this.add(2623234, "Data Block", "AT");
        this.add(2623248, "Normalization Factor Format", "US");
        this.add(2623264, "Zonal Map Number Format", "US");
        this.add(2623265, "Zonal Map Location", "AT");
        this.add(2623266, "Zonal Map Format", "US");
        this.add(2623280, "Adaptive Map Format", "US");
        this.add(2623296, "Code Number Format", "US");
        this.add(2624002, "Pixel Spacing Calibration Type", "CS");
        this.add(2624004, "Pixel Spacing CalibrationDescription", "LO");
        this.add(2625600, "Pixel Intensity Relationship", "CS");
        this.add(2625601, "Pixel Intensity Relationship Sign", "SS");
        this.add(2625616, "Window Center", "DS");
        this.add(2625617, "Window Width", "DS");
        this.add(2625618, "Rescale Intercept", "DS");
        this.add(2625619, "Rescale Slope", "DS");
        this.add(2625620, "Rescale Type", "LO");
        this.add(2625621, "Window Center & WidthExplanation", "LO");
        this.add(2625622, "VOI LUT Function", "CS");
        this.add(2625664, "Gray Scale", "CS");
        this.add(2625680, "Recommended Viewing Mode", "CS");
        this.add(2625796, "Alpha Palette Color Lookup TableDescriptor", "US");
        this.add(2625945, "Palette Color Lookup Table UID", "UI");
        this.add(2626049, "Red Palette Color Lookup TableData", "OW");
        this.add(2626050, "Green Palette Color Lookup TableData", "OW");
        this.add(2626051, "Blue Palette Color Lookup TableData", "OW");
        this.add(2626052, "Alpha Palette Color Lookup TableData", "OW");
        this.add(0x281211, "Large Red Palette Color LookupTable Data", "OW");
        this.add(0x281212, "Large Green Palette Color LookupTable Data", "OW");
        this.add(2626067, "Large Blue Palette Color LookupTable Data", "OW");
        this.add(2626068, "Large Palette Color Lookup TableUID", "UI");
        this.add(0x281221, "Segmented Red Palette ColorLookup Table Data", "OW");
        this.add(0x281222, "Segmented Green Palette ColorLookup Table Data", "OW");
        this.add(2626083, "Segmented Blue Palette ColorLookup Table Data", "OW");
        this.add(2626304, "Breast Implant Present", "CS");
        this.add(2626384, "Partial View", "CS");
        this.add(2626385, "Partial View Description", "ST");
        this.add(2626386, "Partial View Code Sequence", "SQ");
        this.add(2626394, "Spatial Locations Preserved", "CS");
        this.add(2626561, "Data Frame Assignment Sequence", "SQ");
        this.add(2626562, "Data Path Assignment", "CS");
        this.add(2626563, "Bits Mapped to Color Lookup Table", "US");
        this.add(2626564, "Blending LUT 1 Sequence", "SQ");
        this.add(2626565, "Blending LUT 1 Transfer Function", "CS");
        this.add(2626566, "Blending Weight Constant", "FD");
        this.add(2626567, "Blending Lookup Table Descriptor", "US");
        this.add(2626568, "Blending Lookup Table Data", "OW");
        this.add(2626571, "Enhanced Palette Color LookupTable Sequence", "SQ");
        this.add(2626572, "Blending LUT 2 Sequence", "SQ");
        this.add(2626573, "Blending LUT 2 Transfer Function  BlendingLUT2TransferFunction  CS  1 (0028,140E) Data Path ID", "CS");
        this.add(2626575, "RGB LUT Transfer Function", "CS");
        this.add(2626576, "Alpha LUT Transfer Function", "CS");
        this.add(0x282000, "ICC Profile", "OB");
        this.add(2629904, "Lossy Image Compression", "CS");
        this.add(0x282112, "Lossy Image Compression Ratio", "DS");
        this.add(2629908, "Lossy Image Compression Method", "CS");
        this.add(2633728, "Modality LUT Sequence", "SQ");
        this.add(2633731, "LUT Explanation", "LO");
        this.add(2633732, "Modality LUT Type", "LO");
        this.add(2633744, "VOI LUT Sequence", "SQ");
        this.add(2634000, "Softcopy VOI LUT Sequence", "SQ");
        this.add(2637824, "Image Presentation Comments", "LT");
        this.add(2641920, "Bi-Plane Acquisition Sequence", "SQ");
        this.add(2646032, "Representative Frame Number", "US");
        this.add(2646048, "Frame Numbers of Interest (FOI)", "US");
        this.add(2646050, "Frame of Interest Description", "LO");
        this.add(2646051, "Frame of Interest Type", "CS");
        this.add(2646064, "Mask Pointer(s)", "US");
        this.add(2646080, "R Wave Pointer", "US");
        this.add(2646272, "Mask Subtraction Sequence", "SQ");
        this.add(2646273, "Mask Operation", "CS");
        this.add(2646274, "Applicable Frame Range", "US");
        this.add(2646288, "Mask Frame Numbers", "US");
        this.add(2646290, "Contrast Frame Averaging", "US");
        this.add(2646292, "Mask Sub-pixel Shift", "FL");
        this.add(2646304, "TID Offset", "SS");
        this.add(2646416, "Mask Operation Explanation", "ST");
        this.add(2650112, "Equipment Administrator Sequence", "SQ");
        this.add(2650113, "Number of Display Subsystems", "US");
        this.add(2650114, "Current Configuration ID", "US");
        this.add(2650115, "Display Subsystem ID", "US");
        this.add(2650116, "Display Subsystem Name", "SH");
        this.add(2650117, "Display Subsystem Description", "LO");
        this.add(2650118, "System Status", "CS");
        this.add(2650119, "System Status Comment", "LO");
        this.add(2650120, "Target Luminance CharacteristicsSequence", "SQ");
        this.add(2650121, "Luminance Characteristics ID", "US");
        this.add(2650122, "Display Subsystem ConfigurationSequence", "SQ");
        this.add(2650123, "Configuration ID", "US");
        this.add(2650124, "Configuration Name", "SH");
        this.add(2650125, "Configuration Description", "LO");
        this.add(2650126, "Referenced Target LuminanceCharacteristics ID", "US");
        this.add(2650127, "QA Results Sequence", "SQ");
        this.add(2650128, "Display Subsystem QA ResultsSequence", "SQ");
        this.add(2650129, "Configuration QA ResultsSequence", "SQ");
        this.add(2650130, "Measurement EquipmentSequence", "SQ");
        this.add(2650131, "Measurement Functions", "CS");
        this.add(2650132, "Measurement Equipment Type", "CS");
        this.add(2650133, "Visual Evaluation Result Sequence", "SQ");
        this.add(2650134, "Display Calibration ResultSequence", "SQ");
        this.add(2650135, "DDL Value", "US");
        this.add(2650136, "CIExy White Point", "FL");
        this.add(2650137, "Display Function Type", "CS");
        this.add(2650138, "Gamma Value", "FL");
        this.add(2650139, "Number of Luminance Points", "US");
        this.add(2650140, "Luminance Response Sequence", "SQ");
        this.add(2650141, "Target Minimum Luminance", "FL");
        this.add(2650142, "Target Maximum Luminance", "FL");
        this.add(2650143, "Luminance Value", "FL");
        this.add(2650144, "Luminance Response Description", "LO");
        this.add(2650145, "White Point Flag", "CS");
        this.add(2650146, "Display Device Type CodeSequence", "SQ");
        this.add(2650147, "Display Subsystem Sequence", "SQ");
        this.add(2650148, "Luminance Result Sequence", "SQ");
        this.add(2650149, "Ambient Light Value Source", "CS");
        this.add(2650150, "Measured Characteristics", "CS");
        this.add(2650151, "Luminance Uniformity ResultSequence", "SQ");
        this.add(2650152, "Visual Evaluation Test Sequence", "SQ");
        this.add(2650153, "Test Result", "CS");
        this.add(2650154, "Test Result Comment", "LO");
        this.add(2650155, "Test Image Validation", "CS");
        this.add(2650156, "Test Pattern Code Sequence", "SQ");
        this.add(2650157, "Measurement Pattern CodeSequence", "SQ");
        this.add(2650158, "Visual Evaluation Method CodeSequence", "SQ");
        this.add(2654176, "Pixel Data Provider URL", "UR");
        this.add(2658305, "Data Point Rows", "UL");
        this.add(2658306, "Data Point Columns", "UL");
        this.add(2658307, "Signal Domain Columns", "CS");
        this.add(2658457, "Largest Monochrome Pixel Value", "US");
        this.add(2658568, "Data Representation", "CS");
        this.add(2658576, "Pixel Measures Sequence", "SQ");
        this.add(2658610, "Frame VOI LUT Sequence", "SQ");
        this.add(2658629, "Pixel Value TransformationSequence", "SQ");
        this.add(2658869, "Signal Domain Rows", "CS");
        this.add(2659345, "Display Filter Percentage", "FL");
        this.add(2659349, "Frame Pixel Shift Sequence", "SQ");
        this.add(2659350, "Subtraction Item ID", "US");
        this.add(2659362, "Pixel Intensity Relationship LUTSequence", "SQ");
        this.add(2659395, "Frame Pixel Data PropertiesSequence", "SQ");
        this.add(2659396, "Geometrical Properties", "CS");
        this.add(2659397, "Geometric Maximum Distortion", "FL");
        this.add(2659398, "Image Processing Applied", "CS");
        this.add(2659412, "Mask Selection Mode", "CS");
        this.add(2659444, "LUT Function", "CS");
        this.add(2659448, "Mask Visibility Percentage", "FL");
        this.add(2659585, "Pixel Shift Sequence", "SQ");
        this.add(2659586, "Region Pixel Shift Sequence", "SQ");
        this.add(2659587, "Vertices of the Region", "SS");
        this.add(2659589, "Multi-frame Presentation Sequence", "SQ");
        this.add(2659590, "Pixel Shift Frame Range", "US");
        this.add(2659591, "LUT Frame Range", "US");
        this.add(2659616, "Image to Equipment MappingMatrix", "DS");
        this.add(2659639, "Equipment Coordinate SystemIdentification", "CS");
    }

    private void addAttributeGroup0032() {
        this.add(3276810, "Study Status ID", "CS");
        this.add(3276812, "Study Priority ID", "CS");
        this.add(3276818, "Study ID Issuer", "LO");
        this.add(0x320032, "Study Verified Date", "DA");
        this.add(0x320033, "Study Verified Time", "TM");
        this.add(3276852, "Study Read Date", "DA");
        this.add(3276853, "Study Read Time", "TM");
        this.add(3280896, "Scheduled Study Start Date", "DA");
        this.add(3280897, "Scheduled Study Start Time", "TM");
        this.add(3280912, "Scheduled Study Stop Date", "DA");
        this.add(3280913, "Scheduled Study Stop Time", "TM");
        this.add(3280928, "Scheduled Study Location", "LO");
        this.add(3280929, "Scheduled Study Location AE Title", "AE");
        this.add(3280944, "Reason for Study", "LO");
        this.add(3280945, "Requesting Physician IdentificationSequence", "SQ");
        this.add(3280946, "Requesting Physician", "PN");
        this.add(3280947, "Requesting Service", "LO");
        this.add(3280948, "Requesting Service CodeSequence", "SQ");
        this.add(3280960, "Study Arrival Date", "DA");
        this.add(3280961, "Study Arrival Time", "TM");
        this.add(3280976, "Study Completion Date", "DA");
        this.add(3280977, "Study Completion Time", "TM");
        this.add(3280981, "Study Component Status ID", "CS");
        this.add(3280992, "Requested Procedure Description", "LO");
        this.add(3280996, "Requested Procedure CodeSequence", "SQ");
        this.add(3281008, "Requested Contrast Agent", "LO");
        this.add(3293184, "Study Comments", "LT");
    }

    private void addAttributeGroup0038() {
        this.add(3670020, "Referenced Patient Alias Sequence", "SQ");
        this.add(0x380008, "Visit Status ID", "CS");
        this.add(3670032, "Admission ID", "LO");
        this.add(3670033, "Issuer of Admission ID", "LO");
        this.add(3670036, "Issuer of Admission ID Sequence", "SQ");
        this.add(3670038, "Route of Admissions", "LO");
        this.add(3670042, "Scheduled Admission Date", "DA");
        this.add(3670043, "Scheduled Admission Time", "TM");
        this.add(3670044, "Scheduled Discharge Date", "DA");
        this.add(3670045, "Scheduled Discharge Time", "TM");
        this.add(3670046, "Scheduled Patient InstitutionResidence", "LO");
        this.add(3670048, "Admitting Date", "DA");
        this.add(3670049, "Admitting Time", "TM");
        this.add(0x380030, "Discharge Date", "DA");
        this.add(3670066, "Discharge Time", "TM");
        this.add(3670080, "Discharge Diagnosis Description", "LO");
        this.add(3670084, "Discharge Diagnosis CodeSequence", "SQ");
        this.add(3670096, "Special Needs", "LO");
        this.add(3670112, "Service Episode ID", "LO");
        this.add(3670113, "Issuer of Service Episode ID", "LO");
        this.add(3670114, "Service Episode Description", "LO");
        this.add(3670116, "Issuer of Service Episode IDSequence", "SQ");
        this.add(3670272, "Pertinent Documents Sequence", "SQ");
        this.add(3670273, "Pertinent Resources Sequence", "SQ");
        this.add(3670274, "Resource Description", "LO");
        this.add(0x380300, "Current Patient Location", "LO");
        this.add(3671040, "Patient's Institution Residence", "LO");
        this.add(3671296, "Patient State", "LO");
        this.add(3671298, "Patient Clinical Trial ParticipationSequence", "SQ");
        this.add(3686400, "Visit Comments", "LT");
    }

    private void addAttributeGroup003A() {
        this.add(0x400001, "Scheduled Station AE Title", "AE");
        this.add(0x400002, "Scheduled Procedure Step StartDate", "DA");
        this.add(0x400003, "Scheduled Procedure Step StartTime", "TM");
        this.add(0x400004, "Scheduled Procedure Step EndDate", "DA");
        this.add(0x400005, "Scheduled Procedure Step EndTime", "TM");
        this.add(0x400006, "Scheduled Performing Physician'sName", "PN");
        this.add(0x400007, "Scheduled Procedure StepDescription", "LO");
        this.add(0x400008, "Scheduled Protocol CodeSequence", "SQ");
        this.add(0x400009, "Scheduled Procedure Step ID", "SH");
        this.add(0x40000A, "Stage Code Sequence", "SQ");
        this.add(0x40000B, "Scheduled Performing PhysicianIdentification Sequence", "SQ");
        this.add(0x400010, "Scheduled Station Name", "SH");
        this.add(0x400011, "Scheduled Procedure StepLocation", "SH");
        this.add(4194322, "Pre-Medication", "LO");
        this.add(0x400020, "Scheduled Procedure Step Status", "CS");
        this.add(4194342, "Order Placer Identifier Sequence", "SQ");
        this.add(4194343, "Order Filler Identifier Sequence", "SQ");
        this.add(4194353, "Local Namespace Entity ID", "UT");
        this.add(4194354, "Universal Entity ID", "UT");
        this.add(0x400033, "Universal Entity ID Type", "CS");
        this.add(4194357, "Identifier Type Code", "CS");
        this.add(4194358, "Assigning Facility Sequence", "SQ");
        this.add(4194361, "Assigning Jurisdiction CodeSequence", "SQ");
        this.add(0x400100, "Scheduled Procedure StepSequence", "SQ");
        this.add(0x400220, "Referenced Non-Image CompositeSOP Instance Sequence", "SQ");
        this.add(4194881, "Performed Station AE Title", "AE");
        this.add(0x400242, "Performed Station Name", "SH");
        this.add(4194883, "Performed Location", "SH");
        this.add(0x400244, "Performed Procedure Step StartDate", "DA");
        this.add(4194885, "Performed Procedure Step StartTime", "TM");
        this.add(4194896, "Performed Procedure Step EndDate", "DA");
        this.add(4194897, "Performed Procedure Step EndTime", "TM");
        this.add(4194898, "Performed Procedure Step Status", "CS");
        this.add(4194899, "Performed Procedure Step ID", "SH");
        this.add(4194900, "Performed Procedure StepDescription", "LO");
        this.add(4194901, "Performed Procedure TypeDescription", "LO");
        this.add(4194912, "Performed Protocol CodeSequence", "SQ");
        this.add(4194913, "Performed Protocol Type", "CS");
        this.add(4194928, "Scheduled Step AttributesSequence", "SQ");
        this.add(4194933, "Request Attributes Sequence", "SQ");
        this.add(4194944, "Comments on the PerformedProcedure Step", "ST");
        this.add(4194945, "Performed Procedure StepDiscontinuation Reason CodeSequence", "SQ");
        this.add(4194963, "Quantity Sequence", "SQ");
        this.add(4194964, "Quantity", "DS");
        this.add(4194965, "Measuring Units Sequence", "SQ");
        this.add(4194966, "Billing Item Sequence", "SQ");
        this.add(0x400300, "Total Time of Fluoroscopy", "US");
        this.add(4195073, "Total Number of Exposures", "US");
        this.add(4195074, "Entrance Dose", "US");
        this.add(0x400303, "Exposed Area", "US");
        this.add(4195078, "Distance Source to Entrance", "DS");
        this.add(4195079, "Distance Source to Support", "DS");
        this.add(4195086, "Exposure Dose Sequence", "SQ");
        this.add(4195088, "Comments on Radiation Dose", "ST");
        this.add(4195090, "X-Ray Output", "DS");
        this.add(4195092, "Half Value Layer", "DS");
        this.add(4195094, "Organ Dose", "DS");
        this.add(4195096, "Organ Exposed", "CS");
        this.add(4195104, "Billing Procedure Step Sequence", "SQ");
        this.add(4195105, "Film Consumption Sequence", "SQ");
        this.add(4195108, "Billing Supplies and DevicesSequence", "SQ");
        this.add(0x400330, "Referenced Procedure StepSequence", "SQ");
        this.add(0x400340, "Performed Series Sequence", "SQ");
        this.add(0x400400, "Comments on the ScheduledProcedure Step", "LT");
        this.add(0x400440, "Protocol Context Sequence", "SQ");
        this.add(0x400441, "Content Item Modifier Sequence", "SQ");
        this.add(0x400500, "Scheduled Specimen Sequence", "SQ");
        this.add(4195594, "Specimen Accession Number", "LO");
        this.add(4195602, "Container Identifier", "LO");
        this.add(4195603, "Issuer of the Container IdentifierSequence", "SQ");
        this.add(4195605, "Alternate Container IdentifierSequence", "SQ");
        this.add(4195608, "Container Type Code Sequence", "SQ");
        this.add(4195610, "Container Description", "LO");
        this.add(4195616, "Container Component Sequence", "SQ");
        this.add(0x400550, "Specimen Sequence", "SQ");
        this.add(4195665, "Specimen Identifier", "LO");
        this.add(4195666, "Specimen Description Sequence(Trial)", "SQ");
        this.add(4195667, "Specimen Description (Trial)", "ST");
        this.add(0x400554, "Specimen UID", "UI");
        this.add(0x400555, "Acquisition Context Sequence", "SQ");
        this.add(4195670, "Acquisition Context Description", "ST");
        this.add(4195738, "Specimen Type Code Sequence", "SQ");
        this.add(4195680, "Specimen Description Sequence", "SQ");
        this.add(4195682, "Issuer of the Specimen IdentifierSequence", "SQ");
        this.add(0x400600, "Specimen Short Description", "LO");
        this.add(4195842, "Specimen Detailed Description", "UT");
        this.add(4195856, "Specimen Preparation Sequence", "SQ");
        this.add(4195858, "Specimen Preparation StepContent Item Sequence", "SQ");
        this.add(4195872, "Specimen Localization ContentItem Sequence", "SQ");
        this.add(4196090, "Slide Identifier", "LO");
        this.add(4196122, "Image Center Point CoordinatesSequence", "SQ");
        this.add(4196138, "X Offset in Slide CoordinateSystem", "DS");
        this.add(4196154, "Y Offset in Slide CoordinateSystem", "DS");
        this.add(4196170, "Z Offset in Slide CoordinateSystem", "DS");
        this.add(4196568, "Pixel Spacing Sequence", "SQ");
        this.add(4196570, "Coordinate System Axis CodeSequence", "SQ");
        this.add(4196586, "Measurement Units CodeSequence", "SQ");
        this.add(4196856, "Vital Stain Code Sequence (Trial)", "SQ");
        this.add(0x401001, "Requested Procedure ID", "SH");
        this.add(4198402, "Reason for the RequestedProcedure", "LO");
        this.add(4198403, "Requested Procedure Priority", "SH");
        this.add(0x401004, "Patient Transport Arrangements", "LO");
        this.add(4198405, "Requested Procedure Location", "LO");
        this.add(4198406, "Placer Order Number / Procedure", "SH");
        this.add(4198407, "Filler Order Number / Procedure", "SH");
        this.add(4198408, "Confidentiality Code", "LO");
        this.add(4198409, "Reporting Priority", "SH");
        this.add(4198410, "Reason for Requested ProcedureCode Sequence", "SQ");
        this.add(0x401010, "Names of Intended Recipients ofResults", "PN");
        this.add(0x401011, "Intended Recipients of ResultsIdentification Sequence", "SQ");
        this.add(4198418, "Reason For Performed ProcedureCode Sequence", "SQ");
        this.add(4198496, "Requested Procedure Description(Trial)", "LO");
        this.add(0x401101, "Person Identification CodeSequence", "SQ");
        this.add(4198658, "Person's Address", "ST");
        this.add(4198659, "Person's Telephone Numbers", "LO");
        this.add(0x401104, "Person's Telecom Information", "LT");
        this.add(0x401400, "Requested Procedure Comments", "LT");
        this.add(4202497, "Reason for the Imaging ServiceRequest", "LO");
        this.add(0x402004, "Issue Date of Imaging ServiceRequest", "DA");
        this.add(4202501, "Issue Time of Imaging ServiceRequest", "TM");
        this.add(4202502, "Placer Order Number / ImagingService Request (Retired)", "SH");
        this.add(4202503, "Filler Order Number / ImagingService Request (Retired)", "SH");
        this.add(4202504, "Order Entered By", "PN");
        this.add(4202505, "Order Enterer's Location", "SH");
        this.add(4202512, "Order Callback Phone Number", "SH");
        this.add(4202513, "Order Callback TelecomInformation", "LT");
        this.add(4202518, "Placer Order Number / ImagingService Request", "LO");
        this.add(4202519, "Filler Order Number / ImagingService Request", "LO");
        this.add(0x402400, "Imaging Service RequestComments", "LT");
        this.add(4206593, "Confidentiality Constraint onPatient Data Description", "LO");
        this.add(0x404001, "General Purpose ScheduledProcedure Step Status", "CS");
        this.add(0x404002, "General Purpose PerformedProcedure Step Status", "CS");
        this.add(0x404003, "General Purpose ScheduledProcedure Step Priority", "CS");
        this.add(0x404004, "Scheduled Processing ApplicationsCode Sequence", "SQ");
        this.add(0x404005, "Scheduled Procedure Step StartDateTime", "DT");
        this.add(0x404006, "Multiple Copies Flag", "CS");
        this.add(0x404007, "Performed Processing ApplicationsCode Sequence", "SQ");
        this.add(0x404009, "Human Performer Code Sequence", "SQ");
        this.add(0x404010, "Scheduled Procedure StepModification DateTime", "DT");
        this.add(0x404011, "Expected Completion DateTime", "DT");
        this.add(4210709, "Resulting General PurposePerformed Procedure StepsSequence", "SQ");
        this.add(4210710, "Referenced General PurposeScheduled Procedure StepSequence", "SQ");
        this.add(4210712, "Scheduled Workitem CodeSequence", "SQ");
        this.add(4210713, "Performed Workitem CodeSequence", "SQ");
        this.add(0x404020, "Input Availability Flag", "CS");
        this.add(4210721, "Input Information Sequence", "SQ");
        this.add(0x404022, "Relevant Information Sequence", "SQ");
        this.add(4210723, "Referenced General PurposeScheduled Procedure StepTransaction UID", "UI");
        this.add(4210725, "Scheduled Station Name CodeSequence", "SQ");
        this.add(4210726, "Scheduled Station Class CodeSequence", "SQ");
        this.add(4210727, "Scheduled Station GeographicLocation Code Sequence", "SQ");
        this.add(4210728, "Performed Station Name CodeSequence", "SQ");
        this.add(4210729, "Performed Station Class CodeSequence", "SQ");
        this.add(0x404030, "Performed Station GeographicLocation Code Sequence", "SQ");
        this.add(4210737, "Requested Subsequent WorkitemCode Sequence", "SQ");
        this.add(4210738, "Non-DICOM Output CodeSequence", "SQ");
        this.add(0x404033, "Output Information Sequence", "SQ");
        this.add(0x404034, "Scheduled Human PerformersSequence", "SQ");
        this.add(4210741, "Actual Human PerformersSequence", "SQ");
        this.add(4210742, "Human Performer's Organization", "LO");
        this.add(4210743, "Human Performer's Name", "PN");
        this.add(0x404040, "Raw Data Handling", "CS");
        this.add(0x404041, "Input Readiness State", "CS");
        this.add(0x404050, "Performed Procedure Step StartDateTime", "DT");
        this.add(4210769, "Performed Procedure Step EndDateTime", "DT");
        this.add(4210770, "Procedure Step CancellationDateTime", "DT");
        this.add(4227842, "Entrance Dose in mGy", "DS");
        this.add(4231314, "Parametric Map Frame TypeSequence", "SQ");
        this.add(0x409094, "Referenced Image Real WorldValue Mapping Sequence", "SQ");
        this.add(4231318, "Real World Value MappingSequence", "SQ");
        this.add(4231320, "Pixel Value Mapping CodeSequence", "SQ");
        this.add(4231696, "LUT Label", "SH");
        this.add(4231698, "Real World Value LUT Data", "FD");
        this.add(4231712, "Quantity Definition Sequence", "SQ");
        this.add(4231716, "Real World Value Intercept", "FD");
        this.add(4231717, "Real World Value Slope", "FD");
        this.add(4235271, "Findings Flag (Trial)", "CS");
        this.add(4235280, "Relationship Type", "CS");
        this.add(4235296, "Findings Sequence (Trial)", "SQ");
        this.add(4235297, "Findings Group UID (Trial)", "UI");
        this.add(4235298, "Referenced Findings Group UID(Trial)", "UI");
        this.add(4235299, "Findings Group Recording Date(Trial)", "DA");
        this.add(4235300, "Findings Group Recording Time(Trial)", "TM");
        this.add(4235302, "Findings Source Category CodeSequence (Trial)", "SQ");
        this.add(4235303, "Verifying Organization", "LO");
        this.add(4235304, "Documenting OrganizationIdentifier Code Sequence (Trial)", "SQ");
        this.add(4235312, "Verification DateTime", "DT");
        this.add(4235314, "Observation DateTime", "DT");
        this.add(0x40A040, "Value Type", "CS");
        this.add(4235331, "Concept Name Code Sequence", "SQ");
        this.add(4235335, "Measurement Precision Description(Trial)", "LO");
        this.add(4235344, "Continuity Of Content", "CS");
        this.add(4235360, "Sequencing Indicator (Trial)", "LO");
        this.add(4235366, "Document Identifier CodeSequence (Trial)", "SQ");
        this.add(4235367, "Document Author (Trial)", "PN");
        this.add(4235368, "Document Author Identifier CodeSequence (Trial)", "SQ");
        this.add(4235376, "Identifier Code Sequence (Trial)", "SQ");
        this.add(4235379, "Verifying Observer Sequence", "SQ");
        this.add(4235380, "Object Binary Identifier (Trial)", "OB");
        this.add(4235381, "Verifying Observer Name", "PN");
        this.add(4235382, "Documenting Observer IdentifierCode Sequence (Trial)", "SQ");
        this.add(4235384, "Author Observer Sequence", "SQ");
        this.add(4235386, "Participant Sequence", "SQ");
        this.add(4235388, "Custodial Organization Sequence", "SQ");
        this.add(4235392, "Participation Type", "CS");
        this.add(4235394, "Participation DateTime", "DT");
        this.add(4235396, "Observer Type", "CS");
        this.add(4235397, "Procedure Identifier CodeSequence (Trial)", "SQ");
        this.add(4235400, "Verifying Observer IdentificationCode Sequence", "SQ");
        this.add(4235401, "Object Directory Binary Identifier(Trial)", "OB");
        this.add(4235408, "Equivalent CDA DocumentSequence", "SQ");
        this.add(4235440, "Referenced Waveform Channels", "US");
        this.add(4235538, "Time of Document Creation orVerbal Transaction (Trial)", "TM");
        this.add(4235552, "DateTime", "DT");
        this.add(4235553, "Date", "DA");
        this.add(4235554, "Time", "TM");
        this.add(4235555, "Person Name", "PN");
        this.add(4235556, "UID", "UI");
        this.add(4235557, "Report Status ID (Trial)", "CS");
        this.add(4235568, "Temporal Range Type", "CS");
        this.add(4235570, "Referenced Sample Positions", "UL");
        this.add(4235574, "Referenced Frame Numbers", "US");
        this.add(4235576, "Referenced Time Offsets", "DS");
        this.add(4235578, "Referenced DateTime", "DT");
        this.add(4235616, "Text Value", "UT");
        this.add(4235617, "Floating Point Value", "FD");
        this.add(4235618, "Rational Numerator Value", "SL");
        this.add(4235619, "Rational Denominator Value", "UL");
        this.add(4235623, "Observation Category CodeSequence (Trial)", "SQ");
        this.add(4235624, "Concept Code Sequence", "SQ");
        this.add(4235626, "Bibliographic Citation (Trial)", "ST");
        this.add(4235632, "Purpose of Reference CodeSequence", "SQ");
        this.add(4235633, "Observation UID", "UI");
        this.add(4235634, "Referenced Observation UID (Trial)", "UI");
        this.add(4235635, "Referenced Observation Class(Trial)", "CS");
        this.add(4235636, "Referenced Object ObservationClass (Trial)", "CS");
        this.add(4235648, "Annotation Group Number", "US");
        this.add(4235666, "Observation Date (Trial)", "DA");
        this.add(4235667, "Observation Time (Trial)", "TM");
        this.add(4235668, "Measurement Automation (Trial)", "CS");
        this.add(4235669, "Modifier Code Sequence", "SQ");
        this.add(4235812, "Identification Description (Trial)", "ST");
        this.add(4235920, "Coordinates Set Geometric Type(Trial)", "CS");
        this.add(4235926, "Algorithm Code Sequence (Trial)", "SQ");
        this.add(4235927, "Algorithm Description (Trial)", "ST");
        this.add(4235930, "Pixel Coordinates Set (Trial)", "SL");
        this.add(4236032, "Measured Value Sequence", "SQ");
        this.add(4236033, "Numeric Value Qualifier CodeSequence", "SQ");
        this.add(4236039, "Current Observer (Trial)", "PN");
        this.add(4236042, "Numeric Value", "DS");
        this.add(4236051, "Referenced Accession Sequence(Trial)", "SQ");
        this.add(4236090, "Report Status Comment (Trial)", "ST");
        this.add(4236096, "Procedure Context Sequence(Trial)", "SQ");
        this.add(4236114, "Verbal Source (Trial)", "PN");
        this.add(4236115, "Address (Trial)", "ST");
        this.add(4236116, "Telephone Number (Trial)", "LO");
        this.add(4236120, "Verbal Source Identifier CodeSequence (Trial)", "SQ");
        this.add(4236128, "Predecessor Documents Sequence", "SQ");
        this.add(4236144, "Referenced Request Sequence", "SQ");
        this.add(4236146, "Performed Procedure CodeSequence", "SQ");
        this.add(4236149, "Current Requested ProcedureEvidence Sequence", "SQ");
        this.add(4236160, "Report Detail Sequence (Trial)", "SQ");
        this.add(4236165, "Pertinent Other EvidenceSequence", "SQ");
        this.add(4236176, "HL7 Structured DocumentReference Sequence", "SQ");
        this.add(4236290, "Observation Subject UID (Trial)", "UI");
        this.add(4236291, "Observation Subject Class (Trial)", "CS");
        this.add(0x40A404, "Observation Subject Type CodeSequence (Trial)", "SQ");
        this.add(4236433, "Completion Flag", "CS");
        this.add(4236434, "Completion Flag Description", "LO");
        this.add(4236435, "Verification Flag", "CS");
        this.add(4236436, "Archive Requested", "CS");
        this.add(4236438, "Preliminary Flag", "CS");
        this.add(4236548, "Content Template Sequence", "SQ");
        this.add(4236581, "Identical Documents Sequence", "SQ");
        this.add(4236800, "Observation Subject Context Flag(Trial)", "CS");
        this.add(4236801, "Observer Context Flag (Trial)", "CS");
        this.add(4236803, "Procedure Context Flag (Trial)", "CS");
        this.add(4237104, "Content Sequence", "SQ");
        this.add(4237105, "Relationship Sequence (Trial)", "SQ");
        this.add(4237106, "Relationship Type Code Sequence(Trial)", "SQ");
        this.add(4237124, "Language Code Sequence (Trial)", "SQ");
        this.add(4237714, "Uniform Resource Locator (Trial)", "ST");
        this.add(4239392, "Waveform Annotation Sequence", "SQ");
        this.add(4250368, "Template Identifier", "CS");
        this.add(4250374, "Template Version", "DT");
        this.add(4250375, "Template Local Version", "DT");
        this.add(4250379, "Template Extension Flag", "CS");
        this.add(4250380, "Template Extension OrganizationUID", "UI");
        this.add(4250381, "Template Extension Creator UID", "UI");
        this.add(4250483, "Referenced Content Item Identifier", "UL");
        this.add(4251649, "HL7 Instance Identifier", "ST");
        this.add(0x40E004, "HL7 Document Effective Time", "DT");
        this.add(4251654, "HL7 Document Type CodeSequence", "SQ");
        this.add(4251656, "Document Class Code Sequence", "SQ");
        this.add(4251664, "Retrieve URI", "UR");
        this.add(4251665, "Retrieve Location UID", "UI");
        this.add(4251680, "Type of Instances", "CS");
        this.add(4251681, "DICOM Retrieval Sequence", "SQ");
        this.add(4251682, "DICOM Media Retrieval Sequence", "SQ");
        this.add(4251683, "WADO Retrieval Sequence", "SQ");
        this.add(4251684, "XDS Retrieval Sequence", "SQ");
        this.add(4251685, "WADO-RS Retrieval Sequence", "SQ");
        this.add(4251696, "Repository Unique ID", "UI");
        this.add(4251697, "Home Community ID", "UI");
    }

    private void addAttributeGroup0042() {
        this.add(4325392, "Document Title", "ST");
        this.add(4325393, "Encapsulated Document", "OB");
        this.add(4325394, "MIME Type of EncapsulatedDocument", "LO");
        this.add(4325395, "Source Instance Sequence", "SQ");
        this.add(4325396, "List of MIME Types", "LO");
    }

    private void addAttributeGroup0044() {
        this.add(0x440001, "Product Package Identifier", "ST");
        this.add(0x440002, "Substance Administration Approval", "CS");
        this.add(0x440003, "Approval Status FurtherDescription", "LT");
        this.add(0x440004, "Approval Status DateTime", "DT");
        this.add(0x440007, "Product Type Code Sequence", "SQ");
        this.add(0x440008, "Product Name", "LO");
        this.add(0x440009, "Product Description", "LT");
        this.add(0x44000A, "Product Lot Identifier", "LO");
        this.add(0x44000B, "Product Expiration DateTime", "DT");
        this.add(0x440010, "Substance AdministrationDateTime", "DT");
        this.add(0x440011, "Substance Administration Notes", "LO");
        this.add(4456466, "Substance Administration DeviceID", "LO");
        this.add(4456467, "Product Parameter Sequence", "SQ");
        this.add(4456473, "Substance AdministrationParameter Sequence", "SQ");
    }

    private void addAttributeGroup0046() {
        this.add(4587538, "Lens Description", "LO");
        this.add(4587540, "Right Lens Sequence", "SQ");
        this.add(4587541, "Left Lens Sequence", "SQ");
        this.add(4587542, "Unspecified Laterality LensSequence", "SQ");
        this.add(4587544, "Cylinder Sequence", "SQ");
        this.add(4587560, "Prism Sequence", "SQ");
        this.add(4587568, "Horizontal Prism Power", "FD");
        this.add(4587570, "Horizontal Prism Base", "CS");
        this.add(4587572, "Vertical Prism Power", "FD");
        this.add(4587574, "Vertical Prism Base", "CS");
        this.add(4587576, "Lens Segment Type", "CS");
        this.add(0x460040, "Optical Transmittance", "FD");
        this.add(4587586, "Channel Width", "FD");
        this.add(0x460044, "Pupil Size", "FD");
        this.add(0x460046, "Corneal Size", "FD");
        this.add(4587600, "Autorefraction Right Eye Sequence", "SQ");
        this.add(4587602, "Autorefraction Left Eye Sequence", "SQ");
        this.add(0x460060, "Distance Pupillary Distance", "FD");
        this.add(4587618, "Near Pupillary Distance", "FD");
        this.add(4587619, "Intermediate Pupillary Distance", "FD");
        this.add(0x460064, "Other Pupillary Distance", "FD");
        this.add(4587632, "Keratometry Right Eye Sequence", "SQ");
        this.add(4587633, "Keratometry Left Eye Sequence", "SQ");
        this.add(4587636, "Steep Keratometric Axis Sequence", "SQ");
        this.add(4587637, "Radius of Curvature", "FD");
        this.add(4587638, "Keratometric Power", "FD");
        this.add(4587639, "Keratometric Axis", "FD");
        this.add(4587648, "Flat Keratometric Axis Sequence", "SQ");
        this.add(4587666, "Background Color", "CS");
        this.add(4587668, "Optotype", "CS");
        this.add(4587669, "Optotype Presentation", "CS");
        this.add(4587671, "Subjective Refraction Right EyeSequence", "SQ");
        this.add(4587672, "Subjective Refraction Left EyeSequence", "SQ");
        this.add(4587776, "Add Near Sequence", "SQ");
        this.add(4587777, "Add Intermediate Sequence", "SQ");
        this.add(4587778, "Add Other Sequence", "SQ");
        this.add(4587780, "Add Power", "FD");
        this.add(4587782, "Viewing Distance", "FD");
        this.add(4587809, "Visual Acuity Type Code Sequence", "SQ");
        this.add(4587810, "Visual Acuity Right Eye Sequence", "SQ");
        this.add(4587811, "Visual Acuity Left Eye Sequence", "SQ");
        this.add(4587812, "Visual Acuity Both Eyes OpenSequence", "SQ");
        this.add(4587813, "Viewing Distance Type", "CS");
        this.add(4587829, "Visual Acuity Modifiers", "SS");
        this.add(4587831, "Decimal Visual Acuity", "FD");
        this.add(4587833, "Optotype Detailed Definition", "LO");
        this.add(4587845, "Referenced RefractiveMeasurements Sequence", "SQ");
        this.add(4587846, "Sphere Power", "FD");
        this.add(4587847, "Cylinder Power", "FD");
        this.add(4588033, "Corneal Topography Surface", "CS");
        this.add(4588034, "Corneal Vertex Location", "FL");
        this.add(4588035, "Pupil Centroid X-Coordinate", "FL");
        this.add(4588036, "Pupil Centroid Y-Coordinate", "FL");
        this.add(4588037, "Equivalent Pupil Radius", "FL");
        this.add(4588039, "Corneal Topography Map TypeCode Sequence", "SQ");
        this.add(4588040, "Vertices of the Outline of Pupil", "IS");
        this.add(4588048, "Corneal Topography MappingNormals Sequence", "SQ");
        this.add(4588049, "Maximum Corneal CurvatureSequence", "SQ");
        this.add(4588050, "Maximum Corneal Curvature", "FL");
        this.add(4588051, "Maximum Corneal CurvatureLocation", "FL");
        this.add(4588053, "Minimum Keratometric Sequence", "SQ");
        this.add(4588056, "Simulated Keratometric CylinderSequence", "SQ");
        this.add(4588064, "Average Corneal Power", "FL");
        this.add(4588068, "Corneal I-S Value", "FL");
        this.add(4588071, "Analyzed Area", "FL");
        this.add(4588080, "Surface Regularity Index", "FL");
        this.add(4588082, "Surface Asymmetry Index", "FL");
        this.add(4588084, "Corneal Eccentricity Index", "FL");
        this.add(4588086, "Keratoconus Prediction Index", "FL");
        this.add(4588088, "Decimal Potential Visual Acuity", "FL");
        this.add(4588098, "Corneal Topography Map QualityEvaluation", "CS");
        this.add(4588100, "Source Image Corneal ProcessedData Sequence", "SQ");
        this.add(4588103, "Corneal Point Location", "FL");
        this.add(4588104, "Corneal Point Estimated", "CS");
        this.add(4588105, "Axial Power", "FL");
        this.add(4588112, "Tangential Power", "FL");
        this.add(4588113, "Refractive Power", "FL");
        this.add(4588114, "Relative Elevation", "FL");
        this.add(4588115, "Corneal Wavefront", "FL");
    }

    private void addAttributeGroup0048() {
        this.add(4718593, "Imaged Volume Width", "FL");
        this.add(4718594, "Imaged Volume Height", "FL");
        this.add(4718595, "Imaged Volume Depth", "FL");
        this.add(4718598, "Total Pixel Matrix Columns", "UL");
        this.add(4718599, "Total Pixel Matrix Rows", "UL");
        this.add(0x480008, "Total Pixel Matrix Origin Sequence", "SQ");
        this.add(4718608, "Specimen Label in Image", "CS");
        this.add(4718609, "Focus Method", "CS");
        this.add(4718610, "Extended Depth of Field", "CS");
        this.add(4718611, "Number of Focal Planes", "US");
        this.add(4718612, "Distance Between Focal Planes", "FL");
        this.add(4718613, "Recommended Absent PixelCIELab Value", "US");
        this.add(4718848, "Illuminator Type Code Sequence", "SQ");
        this.add(4718850, "Image Orientation (Slide)", "DS");
        this.add(4718853, "Optical Path Sequence", "SQ");
        this.add(4718854, "Optical Path Identifier", "SH");
        this.add(4718855, "Optical Path Description", "ST");
        this.add(4718856, "Illumination Color Code Sequence", "SQ");
        this.add(4718864, "Specimen Reference Sequence", "SQ");
        this.add(4718865, "Condenser Lens Power", "DS");
        this.add(4718866, "Objective Lens Power", "DS");
        this.add(4718867, "Objective Lens Numerical Aperture", "DS");
        this.add(4718880, "Palette Color Lookup TableSequence", "SQ");
        this.add(4719104, "Referenced Image NavigationSequence", "SQ");
        this.add(4719105, "Top Left Hand Corner of LocalizerArea", "US");
        this.add(4719106, "Bottom Right Hand Corner ofLocalizer Area", "US");
        this.add(4719111, "Optical Path IdentificationSequence", "SQ");
        this.add(4719130, "Plane Position (Slide) Sequence", "SQ");
        this.add(4719134, "Column Position In Total ImagePixel Matrix", "SL");
        this.add(4719135, "Row Position In Total Image PixelMatrix", "SL");
        this.add(4719361, "Pixel Origin Interpretation", "CS");
        this.add(4718593, "Imaged Volume Width", "FL");
        this.add(4718594, "Imaged Volume Height", "FL");
        this.add(4718595, "Imaged Volume Depth", "FL");
        this.add(4718598, "Total Pixel Matrix Columns", "UL");
        this.add(4718599, "Total Pixel Matrix Rows", "UL");
        this.add(0x480008, "Total Pixel Matrix Origin Sequence", "SQ");
        this.add(4718608, "Specimen Label in Image", "CS");
        this.add(4718609, "Focus Method", "CS");
        this.add(4718610, "Extended Depth of Field", "CS");
        this.add(4718611, "Number of Focal Planes", "US");
        this.add(4718612, "Distance Between Focal Planes", "FL");
        this.add(4718613, "Recommended Absent PixelCIELab Value", "US");
        this.add(4718848, "Illuminator Type Code Sequence", "SQ");
        this.add(4718850, "Image Orientation (Slide)", "DS");
        this.add(4718853, "Optical Path Sequence", "SQ");
        this.add(4718854, "Optical Path Identifier", "SH");
        this.add(4718855, "Optical Path Description", "ST");
        this.add(4718856, "Illumination Color Code Sequence", "SQ");
        this.add(4718864, "Specimen Reference Sequence", "SQ");
        this.add(4718865, "Condenser Lens Power", "DS");
        this.add(4718866, "Objective Lens Power", "DS");
        this.add(4718867, "Objective Lens Numerical Aperture", "DS");
        this.add(4718880, "Palette Color Lookup TableSequence", "SQ");
        this.add(4719104, "Referenced Image NavigationSequence", "SQ");
        this.add(4719105, "Top Left Hand Corner of LocalizerArea", "US");
        this.add(4719106, "Bottom Right Hand Corner ofLocalizer Area", "US");
        this.add(4719111, "Optical Path IdentificationSequence", "SQ");
        this.add(4719130, "Plane Position (Slide) Sequence", "SQ");
        this.add(4719134, "Column Position In Total ImagePixel Matrix", "SL");
        this.add(4719135, "Row Position In Total Image PixelMatrix", "SL");
        this.add(4719361, "Pixel Origin Interpretation", "CS");
    }

    private void addAttributeGroup0050() {
        this.add(0x500004, "Calibration Image", "CS");
        this.add(0x500010, "Device Sequence", "SQ");
        this.add(5242898, "Container Component Type CodeSequence", "SQ");
        this.add(5242899, "Container Component Thickness", "FD");
        this.add(5242900, "Device Length", "DS");
        this.add(0x500015, "Container Component Width", "FD");
        this.add(5242902, "Device Diameter", "DS");
        this.add(5242903, "Device Diameter Units", "CS");
        this.add(5242904, "Device Volume", "DS");
        this.add(5242905, "Inter-Marker Distance", "DS");
        this.add(5242906, "Container Component Material", "CS");
        this.add(5242907, "Container Component ID", "LO");
        this.add(5242908, "Container Component Length", "FD");
        this.add(5242909, "Container Component Diameter", "FD");
        this.add(5242910, "Container Component Description", "LO");
        this.add(0x500020, "Device Description", "LO");
    }

    private void addAttributeGroup0052() {
        this.add(5373953, "Contrast/Bolus Ingredient Percentby Volume", "FL");
        this.add(0x520002, "OCT Focal Distance", "FD");
        this.add(5373955, "Beam Spot Size", "FD");
        this.add(5373956, "Effective Refractive Index", "FD");
        this.add(5373958, "OCT Acquisition Domain", "CS");
        this.add(5373959, "OCT Optical Center Wavelength", "FD");
        this.add(5373960, "Axial Resolution", "FD");
        this.add(5373961, "Ranging Depth", "FD");
        this.add(5373969, "A-line Rate", "FD");
        this.add(5373970, "A-lines Per Frame", "US");
        this.add(5373971, "Catheter Rotational Rate", "FD");
        this.add(5373972, "A-line Pixel Spacing", "FD");
        this.add(5373974, "Mode of Percutaneous AccessSequence", "SQ");
        this.add(0x520025, "Intravascular OCT Frame TypeSequence", "SQ");
        this.add(5373990, "OCT Z Offset Applied", "CS");
        this.add(5373991, "Intravascular Frame ContentSequence", "SQ");
        this.add(5373992, "Intravascular Longitudinal Distance", "FD");
        this.add(5373993, "Intravascular OCT Frame ContentSequence", "SQ");
        this.add(5374000, "OCT Z Offset Correction", "SS");
        this.add(5374001, "Catheter Direction of Rotation", "CS");
        this.add(5374003, "Seam Line Location", "FD");
        this.add(5374004, "First A-line Location", "FD");
        this.add(5374006, "Seam Line Index", "US");
        this.add(5374008, "Number of Padded A-lines", "US");
        this.add(5374009, "Interpolation Type", "CS");
        this.add(5374010, "Refractive Index Applied", "CS");
    }

    private void addAttributeGroup0054() {
        this.add(5505040, "Energy Window Vector", "US");
        this.add(5505041, "Number of Energy Windows", "US");
        this.add(5505042, "Energy Window InformationSequence", "SQ");
        this.add(5505043, "Energy Window Range Sequence", "SQ");
        this.add(5505044, "Energy Window Lower Limit", "DS");
        this.add(5505045, "Energy Window Upper Limit", "DS");
        this.add(5505046, "Radiopharmaceutical InformationSequence", "SQ");
        this.add(5505047, "Residual Syringe Counts", "IS");
        this.add(5505048, "Energy Window Name", "SH");
        this.add(5505056, "Detector Vector", "US");
        this.add(5505057, "Number of Detectors", "US");
        this.add(5505058, "Detector Information Sequence", "SQ");
        this.add(5505072, "Phase Vector", "US");
        this.add(5505073, "Number of Phases", "US");
        this.add(5505074, "Phase Information Sequence", "SQ");
        this.add(5505075, "Number of Frames in Phase", "US");
        this.add(5505078, "Phase Delay", "IS");
        this.add(5505080, "Pause Between Frames", "IS");
        this.add(5505081, "Phase Description", "CS");
        this.add(0x540050, "Rotation Vector", "US");
        this.add(5505105, "Number of Rotations", "US");
        this.add(5505106, "Rotation Information Sequence", "SQ");
        this.add(5505107, "Number of Frames in Rotation", "US");
        this.add(5505120, "R-R Interval Vector", "US");
        this.add(5505121, "Number of R-R Intervals", "US");
        this.add(5505122, "Gated Information Sequence", "SQ");
        this.add(5505123, "Data Information Sequence", "SQ");
        this.add(5505136, "Time Slot Vector", "US");
        this.add(5505137, "Number of Time Slots", "US");
        this.add(5505138, "Time Slot Information Sequence", "SQ");
        this.add(5505139, "Time Slot Time", "DS");
        this.add(5505152, "Slice Vector", "US");
        this.add(5505153, "Number of Slices", "US");
        this.add(5505168, "Angular View Vector", "US");
        this.add(5505280, "Time Slice Vector", "US");
        this.add(5505281, "Number of Time Slices", "US");
        this.add(5505536, "Start Angle", "DS");
        this.add(5505538, "Type of Detector Motion", "CS");
        this.add(5505552, "Trigger Vector", "IS");
        this.add(5505553, "Number of Triggers in Phase", "US");
        this.add(5505568, "View Code Sequence", "SQ");
        this.add(5505570, "View Modifier Code Sequence", "SQ");
        this.add(5505792, "Radionuclide Code Sequence", "SQ");
        this.add(5505794, "Administration Route CodeSequence", "SQ");
        this.add(5505796, "Radiopharmaceutical CodeSequence", "SQ");
        this.add(5505798, "Calibration Data Sequence", "SQ");
        this.add(5505800, "Energy Window Number", "US");
        this.add(0x540400, "Image ID", "SH");
        this.add(5506064, "Patient Orientation Code Sequence", "SQ");
        this.add(5506066, "Patient Orientation Modifier CodeSequence", "SQ");
        this.add(5506068, "Patient Gantry Relationship CodeSequence", "SQ");
        this.add(0x540500, "Slice Progression Direction", "CS");
        this.add(5506305, "Scan Progression Direction", "CS");
        this.add(5509120, "Series Type", "CS");
        this.add(5509121, "Units", "CS");
        this.add(5509122, "Counts Source", "CS");
        this.add(5509124, "Reprojection Method", "CS");
        this.add(5509126, "SUV Type", "CS");
        this.add(5509376, "Randoms Correction Method", "CS");
        this.add(5509377, "Attenuation Correction Method", "LO");
        this.add(5509378, "Decay Correction", "CS");
        this.add(5509379, "Reconstruction Method", "LO");
        this.add(5509380, "Detector Lines of Response Used", "LO");
        this.add(5509381, "Scatter Correction Method", "LO");
        this.add(5509632, "Axial Acceptance", "DS");
        this.add(5509633, "Axial Mash", "IS");
        this.add(5509634, "Transverse Mash", "IS");
        this.add(5509635, "Detector Element Size", "DS");
        this.add(5509648, "Coincidence Window Width", "DS");
        this.add(5509664, "Secondary Counts Type", "CS");
        this.add(5509888, "Frame Reference Time", "DS");
        this.add(5509904, "Primary (Prompts) CountsAccumulated", "IS");
        this.add(5509905, "Secondary Counts Accumulated", "IS");
        this.add(5509920, "Slice Sensitivity Factor", "DS");
        this.add(5509921, "Decay Factor", "DS");
        this.add(5509922, "Dose Calibration Factor", "DS");
        this.add(5509923, "Scatter Fraction Factor", "DS");
        this.add(5509924, "Dead Time Factor", "DS");
        this.add(5509936, "Image Index", "US");
        this.add(5510144, "Counts Included", "CS");
        this.add(5510145, "Dead Time Correction Flag", "CS");
    }

    private void addAttributeGroup0060() {
        this.add(0x603000, "Histogram Sequence", "SQ");
        this.add(6303746, "Histogram Number of Bins", "US");
        this.add(6303752, "Histogram Bin Width", "US");
        this.add(6303760, "Histogram Explanation", "LO");
        this.add(6303776, "Histogram Data", "UL");
    }

    private void addAttributeGroup0062() {
        this.add(6422529, "Segmentation Type", "CS");
        this.add(0x620002, "Segment Sequence", "SQ");
        this.add(6422531, "Segmented Property CategoryCode Sequence", "SQ");
        this.add(6422532, "Segment Number", "US");
        this.add(6422533, "Segment Label", "LO");
        this.add(0x620006, "Segment Description", "ST");
        this.add(6422536, "Segment Algorithm Type", "CS");
        this.add(6422537, "Segment Algorithm Name", "LO");
        this.add(6422538, "Segment Identification Sequence", "SQ");
        this.add(6422539, "Referenced Segment Number", "US");
        this.add(6422540, "Recommended Display GrayscaleValue", "US");
        this.add(6422541, "Recommended Display CIELabValue", "US");
        this.add(6422542, "Maximum Fractional Value", "US");
        this.add(6422543, "Segmented Property Type CodeSequence", "SQ");
        this.add(6422544, "Segmentation Fractional Type", "CS");
        this.add(6422545, "Segmented Property Type ModifierCode Sequence", "SQ");
        this.add(6422546, "Used Segments Sequence", "SQ");
    }

    private void addAttributeGroup0064() {
        this.add(6553602, "Deformable Registration Sequence", "SQ");
        this.add(6553603, "Source Frame of Reference UID", "UI");
        this.add(6553605, "Deformable Registration GridSequence", "SQ");
        this.add(6553607, "Grid Dimensions", "UL");
        this.add(6553608, "Grid Resolution", "FD");
        this.add(6553609, "Vector Grid Data", "OF");
        this.add(6553615, "Pre Deformation MatrixRegistration Sequence", "SQ");
        this.add(6553616, "Post Deformation MatrixRegistration Sequence", "SQ");
    }

    private void addAttributeGroup0066() {
        this.add(0x660001, "Number of Surfaces", "UL");
        this.add(0x660002, "Surface Sequence", "SQ");
        this.add(0x660003, "Surface Number", "UL");
        this.add(0x660004, "Surface Comments", "LT");
        this.add(0x660009, "Surface Processing", "CS");
        this.add(0x66000A, "Surface Processing Ratio", "FL");
        this.add(0x66000B, "Surface Processing Description", "LO");
        this.add(0x66000C, "Recommended PresentationOpacity", "FL");
        this.add(0x66000D, "Recommended Presentation Type", "CS");
        this.add(0x66000E, "Finite Volume", "CS");
        this.add(0x660010, "Manifold", "CS");
        this.add(0x660011, "Surface Points Sequence", "SQ");
        this.add(6684690, "Surface Points Normals Sequence", "SQ");
        this.add(6684691, "Surface Mesh Primitives Sequence", "SQ");
        this.add(6684693, "Number of Surface Points", "UL");
        this.add(0x660016, "Point Coordinates Data", "OF");
        this.add(6684695, "Point Position Accuracy", "FL");
        this.add(6684696, "Mean Point Distance", "FL");
        this.add(6684697, "Maximum Point Distance", "FL");
        this.add(6684698, "Points Bounding Box Coordinates", "FL");
        this.add(6684699, "Axis of Rotation", "FL");
        this.add(6684700, "Center of Rotation", "FL");
        this.add(6684702, "Number of Vectors", "UL");
        this.add(6684703, "Vector Dimensionality", "US");
        this.add(0x660020, "Vector Accuracy", "FL");
        this.add(6684705, "Vector Coordinate Data", "OF");
        this.add(6684707, "Triangle Point Index List", "OW");
        this.add(6684708, "Edge Point Index List", "OW");
        this.add(6684709, "Vertex Point Index List", "OW");
        this.add(0x660026, "Triangle Strip Sequence", "SQ");
        this.add(6684711, "Triangle Fan Sequence", "SQ");
        this.add(6684712, "Line Sequence", "SQ");
        this.add(6684713, "Primitive Point Index List", "OW");
        this.add(6684714, "Surface Count", "UL");
        this.add(6684715, "Referenced Surface Sequence", "SQ");
        this.add(6684716, "Referenced Surface Number", "UL");
        this.add(6684717, "Segment Surface GenerationAlgorithm Identification Sequence", "SQ");
        this.add(6684718, "Segment Surface Source InstanceSequence", "SQ");
        this.add(6684719, "Algorithm Family Code Sequence", "SQ");
        this.add(0x660030, "Algorithm Name Code Sequence", "SQ");
        this.add(6684721, "Algorithm Version", "LO");
        this.add(6684722, "Algorithm Parameters", "LT");
        this.add(6684724, "Facet Sequence", "SQ");
        this.add(6684725, "Surface Processing AlgorithmIdentification Sequence", "SQ");
        this.add(0x660036, "Algorithm Name", "LO");
        this.add(6684727, "Recommended Point Radius", "FL");
        this.add(6684728, "Recommended Line Thickness", "FL");
        this.add(0x660040, "Long Primitive Point Index List", "UL");
        this.add(6684737, "Long Triangle Point Index List", "UL");
        this.add(6684738, "Long Edge Point Index List", "UL");
        this.add(6684739, "Long Vertex Point Index List", "UL");
    }

    private void addAttributeGroup0068() {
        this.add(6840848, "Implant Size", "LO");
        this.add(6840865, "Implant Template Version", "LO");
        this.add(0x686222, "Replaced Implant TemplateSequence", "SQ");
        this.add(6840867, "Implant Type", "CS");
        this.add(6840868, "Derivation Implant TemplateSequence", "SQ");
        this.add(6840869, "Original Implant TemplateSequence", "SQ");
        this.add(0x686226, "Effective DateTime", "DT");
        this.add(6840880, "Implant Target Anatomy Sequence", "SQ");
        this.add(6840928, "Information From ManufacturerSequence", "SQ");
        this.add(6840933, "Notification From ManufacturerSequence", "SQ");
        this.add(6840944, "Information Issue DateTime", "DT");
        this.add(6840960, "Information Summary", "ST");
        this.add(6840992, "Implant Regulatory DisapprovalCode Sequence", "SQ");
        this.add(6840997, "Overall Template Spatial Tolerance", "FD");
        this.add(6841024, "HPGL Document Sequence", "SQ");
        this.add(6841040, "HPGL Document ID", "US");
        this.add(6841045, "HPGL Document Label", "LO");
        this.add(6841056, "View Orientation Code Sequence", "SQ");
        this.add(6841072, "View Orientation Modifier", "FD");
        this.add(6841074, "HPGL Document Scaling", "FD");
        this.add(6841088, "HPGL Document", "OB");
        this.add(6841104, "HPGL Contour Pen Number", "US");
        this.add(6841120, "HPGL Pen Sequence", "SQ");
        this.add(6841136, "HPGL Pen Number", "US");
        this.add(6841152, "HPGL Pen Label", "LO");
        this.add(6841157, "HPGL Pen Description", "ST");
        this.add(6841158, "Recommended Rotation Point", "FD");
        this.add(6841159, "Bounding Rectangle", "FD");
        this.add(6841168, "Implant Template 3D ModelSurface Number", "US");
        this.add(6841184, "Surface Model DescriptionSequence", "SQ");
        this.add(6841216, "Surface Model Label", "LO");
        this.add(6841232, "Surface Model Scaling Factor", "FD");
        this.add(6841248, "Materials Code Sequence", "SQ");
        this.add(6841252, "Coating Materials Code Sequence", "SQ");
        this.add(6841256, "Implant Type Code Sequence", "SQ");
        this.add(6841260, "Fixation Method Code Sequence", "SQ");
        this.add(6841264, "Mating Feature Sets Sequence", "SQ");
        this.add(6841280, "Mating Feature Set ID", "US");
        this.add(6841296, "Mating Feature Set Label", "LO");
        this.add(6841312, "Mating Feature Sequence", "SQ");
        this.add(6841328, "Mating Feature ID", "US");
        this.add(6841344, "Mating Feature Degree of FreedomSequence", "SQ");
        this.add(6841360, "Degree of Freedom ID", "US");
        this.add(6841376, "Degree of Freedom Type", "CS");
        this.add(6841392, "2D Mating Feature CoordinatesSequence", "SQ");
        this.add(6841408, "Referenced HPGL Document ID", "US");
        this.add(6841424, "2D Mating Point", "FD");
        this.add(6841440, "2D Mating Axes", "FD");
        this.add(6841456, "2D Degree of Freedom Sequence", "SQ");
        this.add(6841488, "3D Degree of Freedom Axis", "FD");
        this.add(6841504, "Range of Freedom", "FD");
        this.add(6841536, "3D Mating Point", "FD");
        this.add(6841552, "3D Mating Axes", "FD");
        this.add(6841584, "2D Degree of Freedom Axis", "FD");
        this.add(6841600, "Planning Landmark PointSequence", "SQ");
        this.add(6841616, "Planning Landmark Line Sequence", "SQ");
        this.add(6841632, "Planning Landmark PlaneSequence", "SQ");
        this.add(6841648, "Planning Landmark ID", "US");
        this.add(6841664, "Planning Landmark Description", "LO");
        this.add(6841669, "Planning Landmark IdentificationCode Sequence", "SQ");
        this.add(6841680, "2D Point Coordinates Sequence", "SQ");
        this.add(6841696, "2D Point Coordinates", "FD");
        this.add(6841744, "3D Point Coordinates", "FD");
        this.add(6841760, "2D Line Coordinates Sequence", "SQ");
        this.add(6841776, "2D Line Coordinates", "FD");
        this.add(6841808, "3D Line Coordinates", "FD");
        this.add(6841824, "2D Plane Coordinates Sequence", "SQ");
        this.add(6841840, "2D Plane Intersection", "FD");
        this.add(6841872, "3D Plane Origin", "FD");
        this.add(6841888, "3D Plane Normal", "FD");
    }

    private void addAttributeGroup0070() {
        this.add(0x700001, "Graphic Annotation Sequence", "SQ");
        this.add(0x700002, "Graphic Layer", "CS");
        this.add(0x700003, "Bounding Box Annotation Units", "CS");
        this.add(0x700004, "Anchor Point Annotation Units", "CS");
        this.add(0x700005, "Graphic Annotation Units", "CS");
        this.add(0x700006, "Unformatted Text Value", "ST");
        this.add(0x700008, "Text Object Sequence", "SQ");
        this.add(0x700009, "Graphic Object Sequence", "SQ");
        this.add(0x700010, "Bounding Box Top Left HandCorner", "FL");
        this.add(0x700011, "Bounding Box Bottom Right HandCorner", "FL");
        this.add(7340050, "Bounding Box Text HorizontalJustification", "CS");
        this.add(7340052, "Anchor Point", "FL");
        this.add(7340053, "Anchor Point Visibility", "CS");
        this.add(0x700020, "Graphic Dimensions", "US");
        this.add(7340065, "Number of Graphic Points", "US");
        this.add(0x700022, "Graphic Data", "FL");
        this.add(7340067, "Graphic Type", "CS");
        this.add(7340068, "Graphic Filled", "CS");
        this.add(0x700040, "Image Rotation (Retired)", "IS");
        this.add(7340097, "Image Horizontal Flip", "CS");
        this.add(7340098, "Image Rotation", "US");
        this.add(0x700050, "Displayed Area Top Left HandCorner (Trial)", "US");
        this.add(7340113, "Displayed Area Bottom Right HandCorner (Trial)", "US");
        this.add(7340114, "Displayed Area Top Left HandCorner", "SL");
        this.add(7340115, "Displayed Area Bottom Right HandCorner", "SL");
        this.add(7340122, "Displayed Area SelectionSequence", "SQ");
        this.add(0x700060, "Graphic Layer Sequence", "SQ");
        this.add(7340130, "Graphic Layer Order", "IS");
        this.add(0x700066, "Graphic Layer RecommendedDisplay Grayscale Value", "US");
        this.add(0x700067, "Graphic Layer RecommendedDisplay RGB Value", "US");
        this.add(7340136, "Graphic Layer Description", "LO");
        this.add(0x700080, "Content Label", "CS");
        this.add(7340161, "Content Description", "LO");
        this.add(7340162, "Presentation Creation Date", "DA");
        this.add(7340163, "Presentation Creation Time", "TM");
        this.add(7340164, "Content Creator's Name", "PN");
        this.add(7340166, "Content Creator's IdentificationCode Sequence", "SQ");
        this.add(0x700087, "Alternate Content DescriptionSequence", "SQ");
        this.add(0x700100, "Presentation Size Mode", "CS");
        this.add(0x700101, "Presentation Pixel Spacing", "DS");
        this.add(7340290, "Presentation Pixel Aspect Ratio", "IS");
        this.add(7340291, "Presentation Pixel MagnificationRatio", "FL");
        this.add(0x700207, "Graphic Group Label", "LO");
        this.add(7340552, "Graphic Group Description", "ST");
        this.add(7340553, "Compound Graphic Sequence", "SQ");
        this.add(7340582, "Compound Graphic Instance ID", "UL");
        this.add(0x700227, "Font Name", "LO");
        this.add(7340584, "Font Name Type", "CS");
        this.add(7340585, "CSS Font Name", "LO");
        this.add(7340592, "Rotation Angle", "FD");
        this.add(7340593, "Text Style Sequence", "SQ");
        this.add(7340594, "Line Style Sequence", "SQ");
        this.add(7340595, "Fill Style Sequence", "SQ");
        this.add(7340596, "Graphic Group Sequence", "SQ");
        this.add(7340609, "Text Color CIELab Value", "US");
        this.add(7340610, "Horizontal Alignment", "CS");
        this.add(7340611, "Vertical Alignment", "CS");
        this.add(7340612, "Shadow Style", "CS");
        this.add(7340613, "Shadow Offset X", "FL");
        this.add(7340614, "Shadow Offset Y", "FL");
        this.add(7340615, "Shadow Color CIELab Value", "US");
        this.add(7340616, "Underlined", "CS");
        this.add(7340617, "Bold", "CS");
        this.add(7340624, "Italic", "CS");
        this.add(7340625, "Pattern On Color CIELab Value", "US");
        this.add(7340626, "Pattern Off Color CIELab Value", "US");
        this.add(7340627, "Line Thickness", "FL");
        this.add(7340628, "Line Dashing Style", "CS");
        this.add(7340629, "Line Pattern", "UL");
        this.add(7340630, "Fill Pattern", "OB");
        this.add(7340631, "Fill Mode", "CS");
        this.add(7340632, "Shadow Opacity", "FL");
        this.add(7340641, "Gap Length", "FL");
        this.add(7340642, "Diameter of Visibility", "FL");
        this.add(7340659, "Rotation Point", "FL");
        this.add(7340660, "Tick Alignment", "CS");
        this.add(7340664, "Show Tick Label", "CS");
        this.add(7340665, "Tick Label Alignment", "CS");
        this.add(7340674, "Compound Graphic Units", "CS");
        this.add(7340676, "Pattern On Opacity", "FL");
        this.add(7340677, "Pattern Off Opacity", "FL");
        this.add(7340679, "Major Ticks Sequence", "SQ");
        this.add(7340680, "Tick Position", "FL");
        this.add(7340681, "Tick Label", "SH");
        this.add(7340692, "Compound Graphic Type", "CS");
        this.add(7340693, "Graphic Group ID", "UL");
        this.add(7340806, "Shape Type", "CS");
        this.add(7340808, "Registration Sequence", "SQ");
        this.add(7340809, "Matrix Registration Sequence", "SQ");
        this.add(7340810, "Matrix Sequence", "SQ");
        this.add(7340812, "Frame of ReferenceTransformation Matrix Type", "CS");
        this.add(7340813, "Registration Type Code Sequence", "SQ");
        this.add(7340815, "Fiducial Description", "ST");
        this.add(7340816, "Fiducial Identifier", "SH");
        this.add(7340817, "Fiducial Identifier Code Sequence", "SQ");
        this.add(7340818, "Contour Uncertainty Radius", "FD");
        this.add(7340820, "Used Fiducials Sequence", "SQ");
        this.add(7340824, "Graphic Coordinates DataSequence", "SQ");
        this.add(7340826, "Fiducial UID", "UI");
        this.add(7340828, "Fiducial Set Sequence", "SQ");
        this.add(7340830, "Fiducial Sequence", "SQ");
        this.add(7341057, "Graphic Layer RecommendedDisplay CIELab Value", "US");
        this.add(7341058, "Blending Sequence", "SQ");
        this.add(7341059, "Relative Opacity", "FL");
        this.add(0x700404, "Referenced Spatial RegistrationSequence", "SQ");
        this.add(7341061, "Blending Position", "CS");
    }

    private void addAttributeGroup0072() {
        this.add(0x720002, "Hanging Protocol Name", "SH");
        this.add(7471108, "Hanging Protocol Description", "LO");
        this.add(7471110, "Hanging Protocol Level", "CS");
        this.add(7471112, "Hanging Protocol Creator", "LO");
        this.add(7471114, "Hanging Protocol CreationDateTime", "DT");
        this.add(7471116, "Hanging Protocol DefinitionSequence", "SQ");
        this.add(7471118, "Hanging Protocol UserIdentification Code Sequence", "SQ");
        this.add(7471120, "Hanging Protocol User GroupName", "LO");
        this.add(7471122, "Source Hanging ProtocolSequence", "SQ");
        this.add(7471124, "Number of Priors Referenced", "US");
        this.add(0x720020, "Image Sets Sequence", "SQ");
        this.add(0x720022, "Image Set Selector Sequence", "SQ");
        this.add(7471140, "Image Set Selector Usage Flag", "CS");
        this.add(7471142, "Selector Attribute", "AT");
        this.add(7471144, "Selector Value Number", "US");
        this.add(7471152, "Time Based Image Sets Sequence", "SQ");
        this.add(7471154, "Image Set Number", "US");
        this.add(7471156, "Image Set Selector Category", "CS");
        this.add(7471160, "Relative Time", "US");
        this.add(7471162, "Relative Time Units", "CS");
        this.add(7471164, "Abstract Prior Value", "SS");
        this.add(7471166, "Abstract Prior Code Sequence", "SQ");
        this.add(7471168, "Image Set Label", "LO");
        this.add(7471184, "Selector Attribute VR", "CS");
        this.add(7471186, "Selector Sequence Pointer", "AT");
        this.add(7471188, "Selector Sequence Pointer PrivateCreator", "LO");
        this.add(7471190, "Selector Attribute Private Creator", "LO");
        this.add(7471200, "Selector AT Value", "AT");
        this.add(7471202, "Selector CS Value", "CS");
        this.add(7471204, "Selector IS Value", "IS");
        this.add(7471206, "Selector LO Value", "LO");
        this.add(7471208, "Selector LT Value", "LT");
        this.add(7471210, "Selector PN Value", "PN");
        this.add(7471212, "Selector SH Value", "SH");
        this.add(7471214, "Selector ST Value", "ST");
        this.add(0x720070, "Selector UT Value", "UT");
        this.add(0x720072, "Selector DS Value", "DS");
        this.add(7471220, "Selector FD Value", "FD");
        this.add(7471222, "Selector FL Value", "FL");
        this.add(7471224, "Selector UL Value", "UL");
        this.add(7471226, "Selector US Value", "US");
        this.add(7471228, "Selector SL Value", "SL");
        this.add(7471230, "Selector SS Value", "SS");
        this.add(7471231, "Selector UI Value", "UI");
        this.add(7471232, "Selector Code Sequence Value", "SQ");
        this.add(7471360, "Number of Screens", "US");
        this.add(7471362, "Nominal Screen DefinitionSequence", "SQ");
        this.add(7471364, "Number of Vertical Pixels", "US");
        this.add(7471366, "Number of Horizontal Pixels", "US");
        this.add(7471368, "Display Environment SpatialPosition", "FD");
        this.add(7471370, "Screen Minimum Grayscale BitDepth", "US");
        this.add(7471372, "Screen Minimum Color Bit Depth", "US");
        this.add(7471374, "Application Maximum Repaint Time", "US");
        this.add(0x720200, "Display Sets Sequence", "SQ");
        this.add(0x720202, "Display Set Number", "US");
        this.add(7471619, "Display Set Label", "LO");
        this.add(7471620, "Display Set Presentation Group", "US");
        this.add(7471622, "Display Set Presentation GroupDescription", "LO");
        this.add(7471624, "Partial Data Display Handling", "CS");
        this.add(7471632, "Synchronized Scrolling Sequence", "SQ");
        this.add(7471634, "Display Set Scrolling Group", "US");
        this.add(7471636, "Navigation Indicator Sequence", "SQ");
        this.add(7471638, "Navigation Display Set", "US");
        this.add(7471640, "Reference Display Sets", "US");
        this.add(7471872, "Image Boxes Sequence", "SQ");
        this.add(7471874, "Image Box Number", "US");
        this.add(7471876, "Image Box Layout Type", "CS");
        this.add(7471878, "Image Box Tile HorizontalDimension", "US");
        this.add(7471880, "Image Box Tile Vertical Dimension", "US");
        this.add(7471888, "Image Box Scroll Direction", "CS");
        this.add(7471890, "Image Box Small Scroll Type", "CS");
        this.add(7471892, "Image Box Small Scroll Amount", "US");
        this.add(7471894, "Image Box Large Scroll Type", "CS");
        this.add(7471896, "Image Box Large Scroll Amount", "US");
        this.add(7471904, "Image Box Overlap Priority", "US");
        this.add(7471920, "Cine Relative to Real-Time", "FD");
        this.add(7472128, "Filter Operations Sequence", "SQ");
        this.add(7472130, "Filter-by Category", "CS");
        this.add(7472132, "Filter-by Attribute Presence", "CS");
        this.add(7472134, "Filter-by Operator", "CS");
        this.add(7472160, "Structured Display BackgroundCIELab Value", "US");
        this.add(7472161, "Empty Image Box CIELab Value", "US");
        this.add(7472162, "Structured Display Image BoxSequence", "SQ");
        this.add(7472164, "Structured Display Text BoxSequence", "SQ");
        this.add(7472167, "Referenced First Frame Sequence", "SQ");
        this.add(7472176, "Image Box SynchronizationSequence", "SQ");
        this.add(7472178, "Synchronized Image Box List", "US");
        this.add(7472180, "Type of Synchronization", "CS");
        this.add(7472384, "Blending Operation Type", "CS");
        this.add(7472400, "Reformatting Operation Type", "CS");
        this.add(7472402, "Reformatting Thickness", "FD");
        this.add(7472404, "Reformatting Interval", "FD");
        this.add(7472406, "Reformatting Operation Initial ViewDirection", "CS");
        this.add(7472416, "3D Rendering Type", "CS");
        this.add(7472640, "Sorting Operations Sequence", "SQ");
        this.add(7472642, "Sort-by Category", "CS");
        this.add(7472644, "Sorting Direction", "CS");
        this.add(0x720700, "Display Set Patient Orientation", "CS");
        this.add(0x720702, "VOI Type", "CS");
        this.add(7472900, "Pseudo-Color Type", "CS");
        this.add(7472901, "Pseudo-Color Palette InstanceReference Sequence", "SQ");
        this.add(7472902, "Show Grayscale Inverted", "CS");
        this.add(7472912, "Show Image True Size Flag", "CS");
        this.add(7472914, "Show Graphic Annotation Flag", "CS");
        this.add(7472916, "Show Patient Demographics Flag", "CS");
        this.add(7472918, "Show Acquisition Techniques Flag", "CS");
        this.add(7472919, "Display Set Horizontal Justification", "CS");
        this.add(7472920, "Display Set Vertical Justification", "CS");
    }

    private void addAttributeGroup0074() {
        this.add(7602464, "Continuation Start Meterset", "FD");
        this.add(7602465, "Continuation End Meterset", "FD");
        this.add(7606272, "Procedure Step State", "CS");
        this.add(7606274, "Procedure Step ProgressInformation Sequence", "SQ");
        this.add(7606276, "Procedure Step Progress", "DS");
        this.add(7606278, "Procedure Step ProgressDescription", "ST");
        this.add(7606280, "Procedure Step CommunicationsURI Sequence", "SQ");
        this.add(7606282, "Contact URI", "UR");
        this.add(7606284, "Contact Display Name", "LO");
        this.add(7606286, "Procedure Step DiscontinuationReason Code Sequence", "SQ");
        this.add(7606304, "Beam Task Sequence", "SQ");
        this.add(7606306, "Beam Task Type", "CS");
        this.add(7606308, "Beam Order Index (Trial)", "IS");
        this.add(7606309, "Autosequence Flag", "CS");
        this.add(7606310, "Table Top Vertical AdjustedPosition", "FD");
        this.add(7606311, "Table Top Longitudinal AdjustedPosition", "FD");
        this.add(7606312, "Table Top Lateral AdjustedPosition", "FD");
        this.add(7606314, "Patient Support Adjusted Angle", "FD");
        this.add(7606315, "Table Top Eccentric AdjustedAngle", "FD");
        this.add(7606316, "Table Top Pitch Adjusted Angle", "FD");
        this.add(7606317, "Table Top Roll Adjusted Angle", "FD");
        this.add(7606320, "Delivery Verification ImageSequence", "SQ");
        this.add(7606322, "Verification Image Timing", "CS");
        this.add(7606324, "Double Exposure Flag", "CS");
        this.add(7606326, "Double Exposure Ordering", "CS");
        this.add(7606328, "Double Exposure Meterset (Trial)", "DS");
        this.add(7606330, "Double Exposure Field Delta (Trial)", "DS");
        this.add(7606336, "Related Reference RT ImageSequence", "SQ");
        this.add(7606338, "General Machine VerificationSequence", "SQ");
        this.add(7606340, "Conventional Machine VerificationSequence", "SQ");
        this.add(7606342, "Ion Machine Verification Sequence", "SQ");
        this.add(7606344, "Failed Attributes Sequence", "SQ");
        this.add(7606346, "Overridden Attributes Sequence", "SQ");
        this.add(7606348, "Conventional Control PointVerification Sequence", "SQ");
        this.add(7606350, "Ion Control Point VerificationSequence", "SQ");
        this.add(7606352, "Attribute Occurrence Sequence", "SQ");
        this.add(7606354, "Attribute Occurrence Pointer", "AT");
        this.add(7606356, "Attribute Item Selector", "UL");
        this.add(7606358, "Attribute Occurrence PrivateCreator", "LO");
        this.add(7606359, "Selector Sequence Pointer Items", "IS");
        this.add(7606784, "Scheduled Procedure Step Priority", "CS");
        this.add(7606786, "Worklist Label", "LO");
        this.add(7606788, "Procedure Step Label", "LO");
        this.add(7606800, "Scheduled Processing ParametersSequence", "SQ");
        this.add(7606802, "Performed Processing ParametersSequence", "SQ");
        this.add(7606806, "Unified Procedure Step PerformedProcedure Sequence", "SQ");
        this.add(7606816, "Related Procedure Step Sequence", "SQ");
        this.add(7606818, "Procedure Step Relationship Type", "LO");
        this.add(7606820, "Replaced Procedure StepSequence", "SQ");
        this.add(7606832, "Deletion Lock", "LO");
        this.add(7606836, "Receiving AE", "AE");
        this.add(7606838, "Requesting AE", "AE");
        this.add(7606840, "Reason for Cancellation", "LT");
        this.add(7606850, "SCP Status", "CS");
        this.add(7606852, "Subscription List Status", "CS");
        this.add(7606854, "Unified Procedure Step List Status", "CS");
        this.add(7607076, "Beam Order Index", "UL");
        this.add(7607096, "Double Exposure Meterset", "FD");
        this.add(7607098, "Double Exposure Field Delta", "FD");
    }

    private void addAttributeGroup0076() {
        this.add(7733249, "Implant Assembly Template Name", "LO");
        this.add(7733251, "Implant Assembly Template Issuer", "LO");
        this.add(0x760006, "Implant Assembly TemplateVersion", "LO");
        this.add(7733256, "Replaced Implant AssemblyTemplate Sequence", "SQ");
        this.add(7733258, "Implant Assembly Template Type", "CS");
        this.add(7733260, "Original Implant AssemblyTemplate Sequence", "SQ");
        this.add(7733262, "Derivation Implant AssemblyTemplate Sequence", "SQ");
        this.add(7733264, "Implant Assembly Template TargetAnatomy Sequence", "SQ");
        this.add(7733280, "Procedure Type Code Sequence", "SQ");
        this.add(7733296, "Surgical Technique", "LO");
        this.add(7733298, "Component Types Sequence", "SQ");
        this.add(7733300, "Component Type Code Sequence", "CS");
        this.add(7733302, "Exclusive Component Type", "CS");
        this.add(7733304, "Mandatory Component Type", "CS");
        this.add(7733312, "Component Sequence", "SQ");
        this.add(7733333, "Component ID", "US");
        this.add(0x760060, "Component Assembly Sequence", "SQ");
        this.add(0x760070, "Component 1 Referenced ID", "US");
        this.add(7733376, "Component 1 Referenced MatingFeature Set ID", "US");
        this.add(7733392, "Component 1 Referenced MatingFeature ID", "US");
        this.add(7733408, "Component 2 Referenced ID", "US");
        this.add(7733424, "Component 2 Referenced MatingFeature Set ID", "US");
        this.add(7733440, "Component 2 Referenced MatingFeature ID", "US");
    }

    private void addAttributeGroup0078() {
        this.add(7864321, "Implant Template Group Name", "LO");
        this.add(7864336, "Implant Template GroupDescription", "ST");
        this.add(7864352, "Implant Template Group Issuer", "LO");
        this.add(7864356, "Implant Template Group Version", "LO");
        this.add(7864358, "Replaced Implant Template GroupSequence", "SQ");
        this.add(7864360, "Implant Template Group TargetAnatomy Sequence", "SQ");
        this.add(7864362, "Implant Template Group MembersSequence", "SQ");
        this.add(7864366, "Implant Template Group MemberID", "US");
        this.add(7864400, "3D Implant Template GroupMember Matching Point", "FD");
        this.add(7864416, "3D Implant Template GroupMember Matching Axes", "FD");
        this.add(0x780070, "Implant Template Group MemberMatching 2D CoordinatesSequence", "SQ");
        this.add(7864464, "2D Implant Template GroupMember Matching Point", "FD");
        this.add(7864480, "2D Implant Template GroupMember Matching Axes", "FD");
        this.add(7864496, "Implant Template Group VariationDimension Sequence", "SQ");
        this.add(7864498, "Implant Template Group VariationDimension Name", "LO");
        this.add(7864500, "Implant Template Group VariationDimension Rank Sequence", "SQ");
        this.add(7864502, "Referenced Implant TemplateGroup Member ID", "US");
        this.add(7864504, "Implant Template Group VariationDimension Rank", "US");
    }

    private void addAttributeGroup0080() {
        this.add(0x800001, "Surface Scan Acquisition TypeCode Sequence", "SQ");
        this.add(0x800002, "Surface Scan Mode CodeSequence", "SQ");
        this.add(0x800003, "Registration Method CodeSequence", "SQ");
        this.add(0x800004, "Shot Duration Time", "FD");
        this.add(0x800005, "Shot Offset Time", "FD");
        this.add(0x800006, "Surface Point Presentation ValueData", "US");
        this.add(0x800007, "Surface Point Color CIELab ValueData", "US");
        this.add(0x800008, "UV Mapping Sequence", "SQ");
        this.add(0x800009, "Texture Label", "SH");
        this.add(0x800010, "U Value Data", "OF");
        this.add(0x800011, "V Value Data", "OF");
        this.add(8388626, "Referenced Texture Sequence", "SQ");
        this.add(8388627, "Referenced Surface DataSequence", "SQ");
    }

    private void addAttributeGroup0088() {
        this.add(8913200, "Storage Media File-set ID", "SH");
        this.add(8913216, "Storage Media File-set UID", "UI");
        this.add(0x880200, "Icon Image Sequence", "SQ");
        this.add(8915204, "Topic Title", "LO");
        this.add(8915206, "Topic Subject", "ST");
        this.add(8915216, "Topic Author", "LO");
        this.add(8915218, "Topic Keywords", "LO");
    }

    private void addAttributeGroup0100() {
        this.add(0x1000410, "SOP Instance Status", "CS");
        this.add(16778272, "SOP Authorization DateTime", "DT");
        this.add(16778276, "SOP Authorization Comment", "LT");
        this.add(16778278, "Authorization EquipmentCertification Number", "LO");
    }

    private void addAttributeGroup0400() {
        this.add(0x4000005, "MAC ID Number", "US");
        this.add(0x4000010, "MAC Calculation Transfer SyntaxUID", "UI");
        this.add(67108885, "MAC Algorithm", "CS");
        this.add(0x4000020, "Data Elements Signed", "AT");
        this.add(0x4000100, "Digital Signature UID", "UI");
        this.add(67109125, "Digital Signature DateTime", "DT");
        this.add(0x4000110, "Certificate Type", "CS");
        this.add(67109141, "Certificate of Signer", "OB");
        this.add(67109152, "Signature", "OB");
        this.add(67109637, "Certified Timestamp Type", "CS");
        this.add(67109648, "Certified Timestamp", "OB");
        this.add(0x4000401, "Digital Signature Purpose CodeSequence", "SQ");
        this.add(0x4000402, "Referenced Digital SignatureSequence", "SQ");
        this.add(0x4000403, "Referenced SOP Instance MACSequence", "SQ");
        this.add(0x4000404, "MAC", "OB");
        this.add(0x4000500, "Encrypted Attributes Sequence", "SQ");
        this.add(67110160, "Encrypted Content Transfer SyntaxUID", "UI");
        this.add(67110176, "Encrypted Content", "OB");
        this.add(0x4000550, "Modified Attributes Sequence", "SQ");
        this.add(67110241, "Original Attributes Sequence", "SQ");
        this.add(67110242, "Attribute Modification DateTime", "DT");
        this.add(67110243, "Modifying System", "LO");
        this.add(67110244, "Source of Previous Values", "LO");
        this.add(67110245, "Reason for the AttributeModification", "CS");
    }

    private void addAttributeGroup2000() {
        this.add(0x20000010, "Number of Copies", "IS");
        this.add(536870942, "Printer Configuration Sequence", "SQ");
        this.add(0x20000020, "Print Priority", "CS");
        this.add(0x20000030, "Medium Type", "CS");
        this.add(0x20000040, "Film Destination", "CS");
        this.add(0x20000050, "Film Session Label", "LO");
        this.add(0x20000060, "Memory Allocation", "IS");
        this.add(536871009, "Maximum Memory Allocation", "IS");
        this.add(0x20000062, "Color Image Printing Flag", "CS");
        this.add(536871011, "Collation Flag", "CS");
        this.add(536871013, "Annotation Flag", "CS");
        this.add(536871015, "Image Overlay Flag", "CS");
        this.add(536871017, "Presentation LUT Flag", "CS");
        this.add(536871018, "Image Box Presentation LUT Flag", "CS");
        this.add(0x200000A0, "Memory Bit Depth", "US");
        this.add(536871073, "Printing Bit Depth", "US");
        this.add(0x200000A2, "Media Installed Sequence", "SQ");
        this.add(536871076, "Other Media Available Sequence", "SQ");
        this.add(536871080, "Supported Image Display FormatsSequence", "SQ");
        this.add(0x20000500, "Referenced Film Box Sequence", "SQ");
        this.add(536872208, "Referenced Stored Print Sequence", "SQ");
    }

    private void addAttributeGroup2010() {
        this.add(0x20100010, "Image Display Format", "ST");
        this.add(537919536, "Annotation Display Format ID", "CS");
        this.add(537919552, "Film Orientation", "CS");
        this.add(537919568, "Film Size ID", "CS");
        this.add(537919570, "Printer Resolution ID", "CS");
        this.add(537919572, "Default Printer Resolution ID", "CS");
        this.add(537919584, "Magnification Type", "CS");
        this.add(537919616, "Smoothing Type", "CS");
        this.add(537919654, "Default Magnification Type", "CS");
        this.add(537919655, "Other Magnification TypesAvailable", "CS");
        this.add(537919656, "Default Smoothing Type", "CS");
        this.add(537919657, "Other Smoothing Types Available", "CS");
        this.add(0x20100100, "Border Density", "CS");
        this.add(0x20100110, "Empty Image Density", "CS");
        this.add(0x20100120, "Min Density", "US");
        this.add(537919792, "Max Density", "US");
        this.add(537919808, "Trim", "CS");
        this.add(537919824, "Configuration Information", "ST");
        this.add(537919826, "Configuration InformationDescription", "LT");
        this.add(537919828, "Maximum Collated Films", "IS");
        this.add(537919838, "Illumination", "US");
        this.add(537919840, "Reflected Ambient Light", "US");
        this.add(537920374, "Printer Pixel Spacing", "DS");
        this.add(537920768, "Referenced Film SessionSequence", "SQ");
        this.add(537920784, "Referenced Image Box Sequence", "SQ");
        this.add(537920800, "Referenced Basic Annotation BoxSequence", "SQ");
    }

    private void addAttributeGroup2020() {
        this.add(0x20200010, "Image Box Position", "US");
        this.add(0x20200020, "Polarity", "CS");
        this.add(0x20200030, "Requested Image Size", "DS");
        this.add(0x20200040, "Requested Decimate/CropBehavior", "CS");
        this.add(0x20200050, "Requested Resolution ID", "CS");
        this.add(0x202000A0, "Requested Image Size Flag", "CS");
        this.add(0x202000A2, "Decimate/Crop Result", "CS");
        this.add(0x20200110, "Basic Grayscale Image Sequence", "SQ");
        this.add(0x20200111, "Basic Color Image Sequence", "SQ");
        this.add(538968368, "Referenced Image Overlay BoxSequence", "SQ");
        this.add(538968384, "Referenced VOI LUT BoxSequence", "SQ");
    }

    private void addAttributeGroup2030() {
        this.add(540016656, "Annotation Position", "US");
        this.add(0x20300020, "Text String", "LO");
    }

    private void addAttributeGroup2040() {
        this.add(541065232, "Referenced Overlay PlaneSequence", "SQ");
        this.add(541065233, "Referenced Overlay Plane Groups", "US");
        this.add(0x20400020, "Overlay Pixel Data Sequence", "SQ");
        this.add(541065312, "Overlay Magnification Type", "CS");
        this.add(541065328, "Overlay Smoothing Type", "CS");
        this.add(541065332, "Magnify to Number of Columns", "US");
        this.add(541065344, "Overlay Foreground Density", "CS");
        this.add(541065346, "Overlay Background Density", "CS");
        this.add(541065360, "Overlay Mode", "CS");
        this.add(541065472, "Threshold Density", "CS");
        this.add(541066496, "Referenced Image Box Sequence(Retired)", "SQ");
    }

    private void addAttributeGroup2050() {
        this.add(542113808, "Presentation LUT Sequence", "SQ");
        this.add(0x20500020, "Presentation LUT Shape", "CS");
        this.add(0x20500500, "Referenced Presentation LUTSequence", "SQ");
    }

    private void addAttributeGroup2100() {
        this.add(0x21000010, "Print Job ID", "SH");
        this.add(0x21000020, "Execution Status", "CS");
        this.add(553648176, "Execution Status Info", "CS");
        this.add(553648192, "Creation Date", "DA");
        this.add(553648208, "Creation Time", "TM");
        this.add(553648240, "Originator", "AE");
        this.add(553648448, "Destination AE", "AE");
        this.add(553648480, "Owner ID", "SH");
        this.add(553648496, "Number of Films", "IS");
        this.add(553649408, "Referenced Print Job Sequence(Pull Stored Print)", "SQ");
    }

    private void addAttributeGroup2110() {
        this.add(0x21100010, "Printer Status", "CS");
        this.add(0x21100020, "Printer Status Info", "CS");
        this.add(554696752, "Printer Name", "LO");
        this.add(554696857, "Print Queue ID", "SH");
    }

    private void addAttributeGroup2120() {
        this.add(0x21200010, "Queue Status", "CS");
        this.add(555745360, "Print Job Description Sequence", "SQ");
        this.add(555745392, "Referenced Print Job Sequence", "SQ");
    }

    private void addAttributeGroup2130() {
        this.add(556793872, "Print Management CapabilitiesSequence", "SQ");
        this.add(556793877, "Printer Characteristics Sequence", "SQ");
        this.add(556793904, "Film Box Content Sequence", "SQ");
        this.add(556793920, "Image Box Content Sequence", "SQ");
        this.add(556793936, "Annotation Content Sequence", "SQ");
        this.add(556793952, "Image Overlay Box ContentSequence", "SQ");
        this.add(556793984, "Presentation LUT ContentSequence", "SQ");
        this.add(556794016, "Proposed Study Sequence", "SQ");
        this.add(556794048, "Original Image Sequence", "SQ");
    }

    private void addAttributeGroup2200() {
        this.add(0x22000001, "Label Using Information ExtractedFrom Instances", "CS");
        this.add(0x22000002, "Label Text", "UT");
        this.add(0x22000003, "Label Style Selection", "CS");
        this.add(0x22000004, "Media Disposition", "LT");
        this.add(0x22000005, "Barcode Value", "LT");
        this.add(0x22000006, "Barcode Symbology", "CS");
        this.add(0x22000007, "Allow Media Splitting", "CS");
        this.add(0x22000008, "Include Non-DICOM Objects", "CS");
        this.add(0x22000009, "Include Display Application", "CS");
        this.add(0x2200000A, "Preserve Composite InstancesAfter Media Creation", "CS");
        this.add(0x2200000B, "Total Number of Pieces of MediaCreated", "US");
        this.add(0x2200000C, "Requested Media ApplicationProfile", "LO");
        this.add(0x2200000D, "Referenced Storage MediaSequence", "SQ");
        this.add(0x2200000E, "Failure Attributes  FailureAttributes AT  1-n(2200,000F)  Allow Lossy Compression", "CS");
        this.add(0x22000020, "Request Priority", "CS");
    }

    private void addAttributeGroup3002() {
        this.add(0x30020002, "RT Image Label", "SH");
        this.add(0x30020003, "RT Image Name", "LO");
        this.add(805437444, "RT Image Description", "ST");
        this.add(805437450, "Reported Values Origin", "CS");
        this.add(805437452, "RT Image Plane", "CS");
        this.add(805437453, "X-Ray Image Receptor Translation", "DS");
        this.add(805437454, "X-Ray Image Receptor Angle", "DS");
        this.add(805437456, "RT Image Orientation", "DS");
        this.add(805437457, "Image Plane Pixel Spacing", "DS");
        this.add(805437458, "RT Image Position", "DS");
        this.add(0x30020020, "Radiation Machine Name", "SH");
        this.add(0x30020022, "Radiation Machine SAD", "DS");
        this.add(805437476, "Radiation Machine SSD", "DS");
        this.add(805437478, "RT Image SID", "DS");
        this.add(805437480, "Source to Reference ObjectDistance", "DS");
        this.add(805437481, "Fraction Number", "IS");
        this.add(0x30020030, "Exposure Sequence", "SQ");
        this.add(0x30020032, "Meterset Exposure", "DS");
        this.add(805437492, "Diaphragm Position", "DS");
        this.add(805437504, "Fluence Map Sequence", "SQ");
        this.add(805437505, "Fluence Data Source", "CS");
        this.add(805437506, "Fluence Data Scale", "DS");
        this.add(805437520, "Primary Fluence Mode Sequence", "SQ");
        this.add(805437521, "Fluence Mode", "CS");
        this.add(805437522, "Fluence Mode ID", "SH");
    }

    private void addAttributeGroup3004() {
        this.add(805568513, "DVH Type", "CS");
        this.add(805568514, "Dose Units", "CS");
        this.add(0x30040004, "Dose Type", "CS");
        this.add(805568517, "Spatial Transform of Dose", "CS");
        this.add(805568518, "Dose Comment", "LO");
        this.add(805568520, "Normalization Point", "DS");
        this.add(805568522, "Dose Summation Type", "CS");
        this.add(805568524, "Grid Frame Offset Vector", "DS");
        this.add(805568526, "Dose Grid Scaling", "DS");
        this.add(805568528, "RT Dose ROI Sequence", "SQ");
        this.add(805568530, "Dose Value", "DS");
        this.add(805568532, "Tissue Heterogeneity Correction", "CS");
        this.add(0x30040040, "DVH Normalization Point", "DS");
        this.add(805568578, "DVH Normalization Dose Value", "DS");
        this.add(805568592, "DVH Sequence", "SQ");
        this.add(805568594, "DVH Dose Scaling", "DS");
        this.add(805568596, "DVH Volume Units", "CS");
        this.add(805568598, "DVH Number of Bins", "IS");
        this.add(805568600, "DVH Data", "DS");
        this.add(805568608, "DVH Referenced ROI Sequence", "SQ");
        this.add(805568610, "DVH ROI Contribution Type", "CS");
        this.add(805568624, "DVH Minimum Dose", "DS");
        this.add(805568626, "DVH Maximum Dose", "DS");
        this.add(805568628, "DVH Mean Dose", "DS");
    }

    private void addAttributeGroup3006() {
        this.add(805699586, "Structure Set Label", "SH");
        this.add(805699588, "Structure Set Name", "LO");
        this.add(0x30060006, "Structure Set Description", "ST");
        this.add(805699592, "Structure Set Date", "DA");
        this.add(805699593, "Structure Set Time", "TM");
        this.add(805699600, "Referenced Frame of ReferenceSequence", "SQ");
        this.add(805699602, "RT Referenced Study Sequence", "SQ");
        this.add(805699604, "RT Referenced Series Sequence", "SQ");
        this.add(805699606, "Contour Image Sequence", "SQ");
        this.add(805699608, "Predecessor Structure SetSequence", "SQ");
        this.add(805699616, "Structure Set ROI Sequence", "SQ");
        this.add(805699618, "ROI Number", "IS");
        this.add(805699620, "Referenced Frame of ReferenceUID", "UI");
        this.add(805699622, "ROI Name", "LO");
        this.add(805699624, "ROI Description", "ST");
        this.add(805699626, "ROI Display Color", "IS");
        this.add(805699628, "ROI Volume", "DS");
        this.add(0x30060030, "RT Related ROI Sequence", "SQ");
        this.add(0x30060033, "RT ROI Relationship", "CS");
        this.add(0x30060036, "ROI Generation Algorithm", "CS");
        this.add(805699640, "ROI Generation Description", "LO");
        this.add(805699641, "ROI Contour Sequence", "SQ");
        this.add(805699648, "Contour Sequence", "SQ");
        this.add(805699650, "Contour Geometric Type", "CS");
        this.add(805699652, "Contour Slab Thickness", "DS");
        this.add(805699653, "Contour Offset Vector", "DS");
        this.add(805699654, "Number of Contour Points", "IS");
        this.add(805699656, "Contour Number", "IS");
        this.add(805699657, "Attached Contours", "IS");
        this.add(805699664, "Contour Data", "DS");
        this.add(805699712, "RT ROI Observations Sequence", "SQ");
        this.add(805699714, "Observation Number", "IS");
        this.add(805699716, "Referenced ROI Number", "IS");
        this.add(805699717, "ROI Observation Label", "SH");
        this.add(805699718, "RT ROI Identification CodeSequence", "SQ");
        this.add(805699720, "ROI Observation Description", "ST");
        this.add(805699744, "Related RT ROI ObservationsSequence", "SQ");
        this.add(805699748, "RT ROI Interpreted Type", "CS");
        this.add(805699750, "ROI Interpreter", "PN");
        this.add(805699760, "ROI Physical Properties Sequence", "SQ");
        this.add(805699762, "ROI Physical Property", "CS");
        this.add(805699764, "ROI Physical Property Value", "DS");
        this.add(805699766, "ROI Elemental CompositionSequence", "SQ");
        this.add(805699767, "ROI Elemental Composition AtomicNumber", "US");
        this.add(805699768, "ROI Elemental Composition AtomicMass Fraction", "FL");
        this.add(805699769, "Additional RT ROI IdentificationCode Sequence", "SQ");
        this.add(805699776, "Frame of Reference RelationshipSequence", "SQ");
        this.add(805699778, "Related Frame of Reference UID", "UI");
        this.add(805699780, "Frame of ReferenceTransformation Type", "CS");
        this.add(805699782, "Frame of ReferenceTransformation Matrix", "DS");
        this.add(805699784, "Frame of ReferenceTransformation Comment", "LO");
    }

    private void addAttributeGroup3008() {
        this.add(805830672, "Measured Dose ReferenceSequence", "SQ");
        this.add(805830674, "Measured Dose Description", "ST");
        this.add(805830676, "Measured Dose Type", "CS");
        this.add(805830678, "Measured Dose Value", "DS");
        this.add(805830688, "Treatment Session BeamSequence", "SQ");
        this.add(805830689, "Treatment Session Ion BeamSequence", "SQ");
        this.add(805830690, "Current Fraction Number", "IS");
        this.add(805830692, "Treatment Control Point Date", "DA");
        this.add(805830693, "Treatment Control Point Time", "TM");
        this.add(805830698, "Treatment Termination Status", "CS");
        this.add(805830699, "Treatment Termination Code", "SH");
        this.add(805830700, "Treatment Verification Status", "CS");
        this.add(0x30080030, "Referenced Treatment RecordSequence", "SQ");
        this.add(805830706, "Specified Primary Meterset", "DS");
        this.add(0x30080033, "Specified Secondary Meterset", "DS");
        this.add(805830710, "Delivered Primary Meterset", "DS");
        this.add(805830711, "Delivered Secondary Meterset", "DS");
        this.add(805830714, "Specified Treatment Time", "DS");
        this.add(805830715, "Delivered Treatment Time", "DS");
        this.add(805830720, "Control Point Delivery Sequence", "SQ");
        this.add(805830721, "Ion Control Point DeliverySequence", "SQ");
        this.add(805830722, "Specified Meterset", "DS");
        this.add(805830724, "Delivered Meterset", "DS");
        this.add(805830725, "Meterset Rate Set", "FL");
        this.add(805830726, "Meterset Rate Delivered", "FL");
        this.add(805830727, "Scan Spot Metersets Delivered", "FL");
        this.add(805830728, "Dose Rate Delivered", "DS");
        this.add(805830736, "Treatment Summary CalculatedDose Reference Sequence", "SQ");
        this.add(805830738, "Cumulative Dose to DoseReference", "DS");
        this.add(805830740, "First Treatment Date", "DA");
        this.add(805830742, "Most Recent Treatment Date", "DA");
        this.add(805830746, "Number of Fractions Delivered", "IS");
        this.add(805830752, "Override Sequence", "SQ");
        this.add(805830753, "Parameter Sequence Pointer", "AT");
        this.add(805830754, "Override Parameter Pointer", "AT");
        this.add(805830755, "Parameter Item Index", "IS");
        this.add(805830756, "Measured Dose Reference Number", "IS");
        this.add(805830757, "Parameter Pointer", "AT");
        this.add(805830758, "Override Reason", "ST");
        this.add(805830760, "Corrected Parameter Sequence", "SQ");
        this.add(805830762, "Correction Value", "FL");
        this.add(805830768, "Calculated Dose ReferenceSequence", "SQ");
        this.add(805830770, "Calculated Dose ReferenceNumber", "IS");
        this.add(805830772, "Calculated Dose ReferenceDescription", "ST");
        this.add(805830774, "Calculated Dose Reference DoseValue", "DS");
        this.add(805830776, "Start Meterset", "DS");
        this.add(805830778, "End Meterset", "DS");
        this.add(0x30080080, "Referenced Measured DoseReference Sequence", "SQ");
        this.add(805830786, "Referenced Measured DoseReference Number", "IS");
        this.add(805830800, "Referenced Calculated DoseReference Sequence", "SQ");
        this.add(805830802, "Referenced Calculated DoseReference Number", "IS");
        this.add(805830816, "Beam Limiting Device Leaf PairsSequence", "SQ");
        this.add(805830832, "Recorded Wedge Sequence", "SQ");
        this.add(805830848, "Recorded Compensator Sequence", "SQ");
        this.add(805830864, "Recorded Block Sequence", "SQ");
        this.add(805830880, "Treatment Summary MeasuredDose Reference Sequence", "SQ");
        this.add(805830896, "Recorded Snout Sequence", "SQ");
        this.add(805830898, "Recorded Range Shifter Sequence", "SQ");
        this.add(805830900, "Recorded Lateral SpreadingDevice Sequence", "SQ");
        this.add(805830902, "Recorded Range ModulatorSequence", "SQ");
        this.add(805830912, "Recorded Source Sequence", "SQ");
        this.add(805830917, "Source Serial Number", "LO");
        this.add(805830928, "Treatment Session ApplicationSetup Sequence", "SQ");
        this.add(805830934, "Application Setup Check", "CS");
        this.add(805830944, "Recorded Brachy AccessoryDevice Sequence", "SQ");
        this.add(805830946, "Referenced Brachy AccessoryDevice Number", "IS");
        this.add(805830960, "Recorded Channel Sequence", "SQ");
        this.add(805830962, "Specified Channel Total Time", "DS");
        this.add(805830964, "Delivered Channel Total Time", "DS");
        this.add(805830966, "Specified Number of Pulses", "IS");
        this.add(805830968, "Delivered Number of Pulses", "IS");
        this.add(805830970, "Specified Pulse Repetition Interval", "DS");
        this.add(805830972, "Delivered Pulse Repetition Interval", "DS");
        this.add(805830976, "Recorded Source ApplicatorSequence", "SQ");
        this.add(805830978, "Referenced Source ApplicatorNumber", "IS");
        this.add(805830992, "Recorded Channel ShieldSequence", "SQ");
        this.add(805830994, "Referenced Channel ShieldNumber", "IS");
        this.add(805831008, "Brachy Control Point DeliveredSequence", "SQ");
        this.add(805831010, "Safe Position Exit Date", "DA");
        this.add(805831012, "Safe Position Exit Time", "TM");
        this.add(805831014, "Safe Position Return Date", "DA");
        this.add(805831016, "Safe Position Return Time", "TM");
        this.add(805831025, "Pulse Specific Brachy Control PointDelivered Sequence", "SQ");
        this.add(805831026, "Pulse Number", "US");
        this.add(805831027, "Brachy Pulse Control PointDelivered Sequence", "SQ");
        this.add(805831168, "Current Treatment Status", "CS");
        this.add(805831170, "Treatment Status Comment", "ST");
        this.add(805831200, "Fraction Group SummarySequence", "SQ");
        this.add(805831203, "Referenced Fraction Number", "IS");
        this.add(805831204, "Fraction Group Type", "CS");
        this.add(805831216, "Beam Stopper Position", "CS");
        this.add(805831232, "Fraction Status SummarySequence", "SQ");
        this.add(805831248, "Treatment Date", "DA");
        this.add(805831249, "Treatment Time", "TM");
    }

    private void addAttributeGroup300A() {
        this.add(805961730, "RT Plan Label", "SH");
        this.add(0x300A0003, "RT Plan Name", "LO");
        this.add(805961732, "RT Plan Description", "ST");
        this.add(805961734, "RT Plan Date", "DA");
        this.add(805961735, "RT Plan Time", "TM");
        this.add(805961737, "Treatment Protocols", "LO");
        this.add(0x300A000A, "Plan Intent", "CS");
        this.add(805961739, "Treatment Sites", "LO");
        this.add(805961740, "RT Plan Geometry", "CS");
        this.add(805961742, "Prescription Description", "ST");
        this.add(805961744, "Dose Reference Sequence", "SQ");
        this.add(805961746, "Dose Reference Number", "IS");
        this.add(805961747, "Dose Reference UID", "UI");
        this.add(805961748, "Dose Reference Structure Type", "CS");
        this.add(805961749, "Nominal Beam Energy Unit", "CS");
        this.add(805961750, "Dose Reference Description", "LO");
        this.add(805961752, "Dose Reference Point Coordinates", "DS");
        this.add(805961754, "Nominal Prior Dose", "DS");
        this.add(805961760, "Dose Reference Type", "CS");
        this.add(805961761, "Constraint Weight", "DS");
        this.add(805961762, "Delivery Warning Dose", "DS");
        this.add(805961763, "Delivery Maximum Dose", "DS");
        this.add(805961765, "Target Minimum Dose", "DS");
        this.add(805961766, "Target Prescription Dose", "DS");
        this.add(805961767, "Target Maximum Dose", "DS");
        this.add(805961768, "Target Underdose Volume Fraction", "DS");
        this.add(805961770, "Organ at Risk Full-volume Dose", "DS");
        this.add(805961771, "Organ at Risk Limit Dose", "DS");
        this.add(805961772, "Organ at Risk Maximum Dose", "DS");
        this.add(805961773, "Organ at Risk Overdose VolumeFraction", "DS");
        this.add(805961792, "Tolerance Table Sequence", "SQ");
        this.add(805961794, "Tolerance Table Number", "IS");
        this.add(805961795, "Tolerance Table Label", "SH");
        this.add(805961796, "Gantry Angle Tolerance", "DS");
        this.add(805961798, "Beam Limiting Device AngleTolerance", "DS");
        this.add(805961800, "Beam Limiting Device ToleranceSequence", "SQ");
        this.add(805961802, "Beam Limiting Device PositionTolerance", "DS");
        this.add(805961803, "Snout Position Tolerance", "FL");
        this.add(805961804, "Patient Support Angle Tolerance", "DS");
        this.add(805961806, "Table Top Eccentric AngleTolerance", "DS");
        this.add(805961807, "Table Top Pitch Angle Tolerance", "FL");
        this.add(805961808, "Table Top Roll Angle Tolerance", "FL");
        this.add(805961809, "Table Top Vertical PositionTolerance", "DS");
        this.add(805961810, "Table Top Longitudinal PositionTolerance", "DS");
        this.add(805961811, "Table Top Lateral PositionTolerance", "DS");
        this.add(805961813, "RT Plan Relationship", "CS");
        this.add(805961840, "Fraction Group Sequence", "SQ");
        this.add(805961841, "Fraction Group Number", "IS");
        this.add(805961842, "Fraction Group Description", "LO");
        this.add(805961848, "Number of Fractions Planned", "IS");
        this.add(805961849, "Number of Fraction Pattern DigitsPer Day", "IS");
        this.add(805961850, "Repeat Fraction Cycle Length", "IS");
        this.add(805961851, "Fraction Pattern", "LT");
        this.add(805961856, "Number of Beams", "IS");
        this.add(805961858, "Beam Dose Specification Point", "DS");
        this.add(805961860, "Beam Dose", "DS");
        this.add(805961862, "Beam Meterset", "DS");
        this.add(805961864, "Beam Dose Point Depth", "FL");
        this.add(805961865, "Beam Dose Point Equivalent Depth", "FL");
        this.add(805961866, "Beam Dose Point SSD", "FL");
        this.add(805961867, "Beam Dose Meaning", "CS");
        this.add(805961868, "Beam Dose Verification ControlPoint Sequence", "SQ");
        this.add(805961869, "Average Beam Dose Point Depth", "FL");
        this.add(805961870, "Average Beam Dose PointEquivalent Depth", "FL");
        this.add(805961871, "Average Beam Dose Point SSD", "FL");
        this.add(0x300A00A0, "Number of Brachy ApplicationSetups", "IS");
        this.add(805961890, "Brachy Application Setup DoseSpecification Point", "DS");
        this.add(805961892, "Brachy Application Setup Dose", "DS");
        this.add(805961904, "Beam Sequence", "SQ");
        this.add(805961906, "Treatment Machine Name", "SH");
        this.add(805961907, "Primary Dosimeter Unit", "CS");
        this.add(805961908, "Source-Axis Distance", "DS");
        this.add(805961910, "Beam Limiting Device Sequence", "SQ");
        this.add(805961912, "RT Beam Limiting Device Type", "CS");
        this.add(805961914, "Source to Beam Limiting DeviceDistance", "DS");
        this.add(805961915, "Isocenter to Beam Limiting DeviceDistance", "FL");
        this.add(805961916, "Number of Leaf/Jaw Pairs", "IS");
        this.add(805961918, "Leaf Position Boundaries", "DS");
        this.add(805961920, "Beam Number", "IS");
        this.add(805961922, "Beam Name", "LO");
        this.add(805961923, "Beam Description", "ST");
        this.add(805961924, "Beam Type", "CS");
        this.add(805961925, "Beam Delivery Duration Limit", "FD");
        this.add(805961926, "Radiation Type", "CS");
        this.add(805961927, "High-Dose Technique Type", "CS");
        this.add(805961928, "Reference Image Number", "IS");
        this.add(805961930, "Planned Verification ImageSequence", "SQ");
        this.add(805961932, "Imaging Device-SpecificAcquisition Parameters", "LO");
        this.add(805961934, "Treatment Delivery Type", "CS");
        this.add(805961936, "Number of Wedges", "IS");
        this.add(805961937, "Wedge Sequence", "SQ");
        this.add(805961938, "Wedge Number", "IS");
        this.add(805961939, "Wedge Type", "CS");
        this.add(805961940, "Wedge ID", "SH");
        this.add(805961941, "Wedge Angle", "IS");
        this.add(805961942, "Wedge Factor", "DS");
        this.add(805961943, "Total Wedge TrayWater-Equivalent Thickness", "FL");
        this.add(805961944, "Wedge Orientation", "DS");
        this.add(805961945, "Isocenter to Wedge Tray Distance", "FL");
        this.add(805961946, "Source to Wedge Tray Distance", "DS");
        this.add(805961947, "Wedge Thin Edge Position", "FL");
        this.add(805961948, "Bolus ID", "SH");
        this.add(805961949, "Bolus Description", "ST");
        this.add(805961950, "Effective Wedge Angle", "DS");
        this.add(805961952, "Number of Compensators", "IS");
        this.add(805961953, "Material ID", "SH");
        this.add(805961954, "Total Compensator Tray Factor", "DS");
        this.add(805961955, "Compensator Sequence", "SQ");
        this.add(805961956, "Compensator Number", "IS");
        this.add(805961957, "Compensator ID", "SH");
        this.add(805961958, "Source to Compensator TrayDistance", "DS");
        this.add(805961959, "Compensator Rows", "IS");
        this.add(805961960, "Compensator Columns", "IS");
        this.add(805961961, "Compensator Pixel Spacing", "DS");
        this.add(805961962, "Compensator Position", "DS");
        this.add(805961963, "Compensator Transmission Data", "DS");
        this.add(805961964, "Compensator Thickness Data", "DS");
        this.add(805961965, "Number of Boli", "IS");
        this.add(805961966, "Compensator Type", "CS");
        this.add(805961967, "Compensator Tray ID", "SH");
        this.add(805961968, "Number of Blocks", "IS");
        this.add(805961970, "Total Block Tray Factor", "DS");
        this.add(805961971, "Total Block Tray Water-EquivalentThickness", "FL");
        this.add(805961972, "Block Sequence", "SQ");
        this.add(805961973, "Block Tray ID", "SH");
        this.add(805961974, "Source to Block Tray Distance", "DS");
        this.add(805961975, "Isocenter to Block Tray Distance", "FL");
        this.add(805961976, "Block Type", "CS");
        this.add(805961977, "Accessory Code", "LO");
        this.add(805961978, "Block Divergence", "CS");
        this.add(805961979, "Block Mounting Position", "CS");
        this.add(805961980, "Block Number", "IS");
        this.add(805961982, "Block Name", "LO");
        this.add(805961984, "Block Thickness", "DS");
        this.add(805961986, "Block Transmission", "DS");
        this.add(805961988, "Block Number of Points", "IS");
        this.add(805961990, "Block Data", "DS");
        this.add(805961991, "Applicator Sequence", "SQ");
        this.add(805961992, "Applicator ID", "SH");
        this.add(805961993, "Applicator Type", "CS");
        this.add(805961994, "Applicator Description", "LO");
        this.add(805961996, "Cumulative Dose ReferenceCoefficient", "DS");
        this.add(805961998, "Final Cumulative Meterset Weight", "DS");
        this.add(805962000, "Number of Control Points", "IS");
        this.add(805962001, "Control Point Sequence", "SQ");
        this.add(805962002, "Control Point Index", "IS");
        this.add(805962004, "Nominal Beam Energy", "DS");
        this.add(805962005, "Dose Rate Set", "DS");
        this.add(805962006, "Wedge Position Sequence", "SQ");
        this.add(805962008, "Wedge Position", "CS");
        this.add(805962010, "Beam Limiting Device PositionSequence", "SQ");
        this.add(805962012, "Leaf/Jaw Positions", "DS");
        this.add(805962014, "Gantry Angle", "DS");
        this.add(805962015, "Gantry Rotation Direction", "CS");
        this.add(805962016, "Beam Limiting Device Angle", "DS");
        this.add(805962017, "Beam Limiting Device RotationDirection", "CS");
        this.add(805962018, "Patient Support Angle", "DS");
        this.add(805962019, "Patient Support Rotation Direction", "CS");
        this.add(805962020, "Table Top Eccentric Axis Distance", "DS");
        this.add(805962021, "Table Top Eccentric Angle", "DS");
        this.add(805962022, "Table Top Eccentric RotationDirection", "CS");
        this.add(805962024, "Table Top Vertical Position", "DS");
        this.add(805962025, "Table Top Longitudinal Position", "DS");
        this.add(805962026, "Table Top Lateral Position", "DS");
        this.add(805962028, "Isocenter Position", "DS");
        this.add(805962030, "Surface Entry Point", "DS");
        this.add(805962032, "Source to Surface Distance", "DS");
        this.add(805962033, "Average Beam Dose Point Sourceto External Contour SurfaceDistance", "FL");
        this.add(805962034, "Source to External ContourDistance", "FL");
        this.add(805962035, "External Contour Entry Point", "FL");
        this.add(805962036, "Cumulative Meterset Weight", "DS");
        this.add(805962048, "Table Top Pitch Angle", "FL");
        this.add(805962050, "Table Top Pitch Rotation Direction", "CS");
        this.add(805962052, "Table Top Roll Angle", "FL");
        this.add(805962054, "Table Top Roll Rotation Direction", "CS");
        this.add(805962056, "Head Fixation Angle", "FL");
        this.add(805962058, "Gantry Pitch Angle", "FL");
        this.add(805962060, "Gantry Pitch Rotation Direction", "CS");
        this.add(805962062, "Gantry Pitch Angle Tolerance", "FL");
        this.add(805962112, "Patient Setup Sequence", "SQ");
        this.add(805962114, "Patient Setup Number", "IS");
        this.add(805962115, "Patient Setup Label", "LO");
        this.add(805962116, "Patient Additional Position", "LO");
        this.add(805962128, "Fixation Device Sequence", "SQ");
        this.add(805962130, "Fixation Device Type", "CS");
        this.add(805962132, "Fixation Device Label", "SH");
        this.add(805962134, "Fixation Device Description", "ST");
        this.add(805962136, "Fixation Device Position", "SH");
        this.add(805962137, "Fixation Device Pitch Angle", "FL");
        this.add(805962138, "Fixation Device Roll Angle", "FL");
        this.add(805962144, "Shielding Device Sequence", "SQ");
        this.add(805962146, "Shielding Device Type", "CS");
        this.add(805962148, "Shielding Device Label", "SH");
        this.add(805962150, "Shielding Device Description", "ST");
        this.add(805962152, "Shielding Device Position", "SH");
        this.add(805962160, "Setup Technique", "CS");
        this.add(805962162, "Setup Technique Description", "ST");
        this.add(805962164, "Setup Device Sequence", "SQ");
        this.add(805962166, "Setup Device Type", "CS");
        this.add(805962168, "Setup Device Label", "SH");
        this.add(805962170, "Setup Device Description", "ST");
        this.add(805962172, "Setup Device Parameter", "DS");
        this.add(805962192, "Setup Reference Description", "ST");
        this.add(805962194, "Table Top Vertical SetupDisplacement", "DS");
        this.add(805962196, "Table Top Longitudinal SetupDisplacement", "DS");
        this.add(805962198, "Table Top Lateral SetupDisplacement", "DS");
        this.add(805962240, "Brachy Treatment Technique", "CS");
        this.add(805962242, "Brachy Treatment Type", "CS");
        this.add(805962246, "Treatment Machine Sequence", "SQ");
        this.add(805962256, "Source Sequence", "SQ");
        this.add(805962258, "Source Number", "IS");
        this.add(805962260, "Source Type", "CS");
        this.add(805962262, "Source Manufacturer", "LO");
        this.add(805962264, "Active Source Diameter", "DS");
        this.add(805962266, "Active Source Length", "DS");
        this.add(805962267, "Source Model ID", "SH");
        this.add(805962268, "Source Description", "LO");
        this.add(805962274, "Source Encapsulation NominalThickness", "DS");
        this.add(805962276, "Source Encapsulation NominalTransmission", "DS");
        this.add(805962278, "Source Isotope Name", "LO");
        this.add(805962280, "Source Isotope Half Life", "DS");
        this.add(805962281, "Source Strength Units", "CS");
        this.add(805962282, "Reference Air Kerma Rate", "DS");
        this.add(805962283, "Source Strength", "DS");
        this.add(805962284, "Source Strength Reference Date", "DA");
        this.add(805962286, "Source Strength Reference Time", "TM");
        this.add(805962288, "Application Setup Sequence", "SQ");
        this.add(805962290, "Application Setup Type", "CS");
        this.add(805962292, "Application Setup Number", "IS");
        this.add(805962294, "Application Setup Name", "LO");
        this.add(805962296, "Application Setup Manufacturer", "LO");
        this.add(805962304, "Template Number", "IS");
        this.add(805962306, "Template Type", "SH");
        this.add(805962308, "Template Name", "LO");
        this.add(805962320, "Total Reference Air Kerma", "DS");
        this.add(805962336, "Brachy Accessory DeviceSequence", "SQ");
        this.add(805962338, "Brachy Accessory Device Number", "IS");
        this.add(805962339, "Brachy Accessory Device ID", "SH");
        this.add(805962340, "Brachy Accessory Device Type", "CS");
        this.add(805962342, "Brachy Accessory Device Name", "LO");
        this.add(805962346, "Brachy Accessory Device NominalThickness", "DS");
        this.add(805962348, "Brachy Accessory Device NominalTransmission", "DS");
        this.add(805962368, "Channel Sequence", "SQ");
        this.add(805962370, "Channel Number", "IS");
        this.add(805962372, "Channel Length", "DS");
        this.add(805962374, "Channel Total Time", "DS");
        this.add(805962376, "Source Movement Type", "CS");
        this.add(805962378, "Number of Pulses", "IS");
        this.add(805962380, "Pulse Repetition Interval", "DS");
        this.add(805962384, "Source Applicator Number", "IS");
        this.add(805962385, "Source Applicator ID", "SH");
        this.add(805962386, "Source Applicator Type", "CS");
        this.add(805962388, "Source Applicator Name", "LO");
        this.add(805962390, "Source Applicator Length", "DS");
        this.add(805962392, "Source Applicator Manufacturer", "LO");
        this.add(805962396, "Source Applicator Wall NominalThickness", "DS");
        this.add(805962398, "Source Applicator Wall NominalTransmission", "DS");
        this.add(805962400, "Source Applicator Step Size", "DS");
        this.add(805962402, "Transfer Tube Number", "IS");
        this.add(805962404, "Transfer Tube Length", "DS");
        this.add(805962416, "Channel Shield Sequence", "SQ");
        this.add(805962418, "Channel Shield Number", "IS");
        this.add(805962419, "Channel Shield ID", "SH");
        this.add(805962420, "Channel Shield Name", "LO");
        this.add(805962424, "Channel Shield Nominal Thickness", "DS");
        this.add(805962426, "Channel Shield NominalTransmission", "DS");
        this.add(805962440, "Final Cumulative Time Weight", "DS");
        this.add(805962448, "Brachy Control Point Sequence", "SQ");
        this.add(805962450, "Control Point Relative Position", "DS");
        this.add(805962452, "Control Point 3D Position", "DS");
        this.add(805962454, "Cumulative Time Weight", "DS");
        this.add(805962464, "Compensator Divergence", "CS");
        this.add(805962465, "Compensator Mounting Position", "CS");
        this.add(805962466, "Source to Compensator Distance", "DS");
        this.add(805962467, "Total Compensator TrayWater-Equivalent Thickness", "FL");
        this.add(805962468, "Isocenter to Compensator TrayDistance", "FL");
        this.add(805962469, "Compensator Column Offset", "FL");
        this.add(805962470, "Isocenter to CompensatorDistances", "FL");
        this.add(805962471, "Compensator Relative StoppingPower Ratio", "FL");
        this.add(805962472, "Compensator Milling Tool Diameter", "FL");
        this.add(805962474, "Ion Range Compensator Sequence", "SQ");
        this.add(805962475, "Compensator Description", "LT");
        this.add(805962498, "Radiation Mass Number", "IS");
        this.add(805962500, "Radiation Atomic Number", "IS");
        this.add(805962502, "Radiation Charge State", "SS");
        this.add(805962504, "Scan Mode", "CS");
        this.add(0x300A030A, "Virtual Source-Axis Distances", "FL");
        this.add(805962508, "Snout Sequence", "SQ");
        this.add(805962509, "Snout Position", "FL");
        this.add(805962511, "Snout ID", "SH");
        this.add(805962514, "Number of Range Shifters", "IS");
        this.add(805962516, "Range Shifter Sequence", "SQ");
        this.add(805962518, "Range Shifter Number", "IS");
        this.add(805962520, "Range Shifter ID", "SH");
        this.add(805962528, "Range Shifter Type", "CS");
        this.add(805962530, "Range Shifter Description", "LO");
        this.add(0x300A0330, "Number of Lateral SpreadingDevices", "IS");
        this.add(805962546, "Lateral Spreading DeviceSequence", "SQ");
        this.add(805962548, "Lateral Spreading Device Number", "IS");
        this.add(805962550, "Lateral Spreading Device ID", "SH");
        this.add(805962552, "Lateral Spreading Device Type", "CS");
        this.add(0x300A033A, "Lateral Spreading DeviceDescription", "LO");
        this.add(805962556, "Lateral Spreading Device WaterEquivalent Thickness", "FL");
        this.add(805962560, "Number of Range Modulators", "IS");
        this.add(805962562, "Range Modulator Sequence", "SQ");
        this.add(805962564, "Range Modulator Number", "IS");
        this.add(805962566, "Range Modulator ID", "SH");
        this.add(805962568, "Range Modulator Type", "CS");
        this.add(805962570, "Range Modulator Description", "LO");
        this.add(805962572, "Beam Current Modulation ID", "SH");
        this.add(805962576, "Patient Support Type", "CS");
        this.add(805962578, "Patient Support ID", "SH");
        this.add(805962580, "Patient Support Accessory Code", "LO");
        this.add(805962582, "Fixation Light Azimuthal Angle", "FL");
        this.add(805962584, "Fixation Light Polar Angle", "FL");
        this.add(805962586, "Meterset Rate", "FL");
        this.add(805962592, "Range Shifter Settings Sequence", "SQ");
        this.add(805962594, "Range Shifter Setting", "LO");
        this.add(805962596, "Isocenter to Range Shifter Distance", "FL");
        this.add(805962598, "Range Shifter Water EquivalentThickness", "FL");
        this.add(805962608, "Lateral Spreading Device SettingsSequence", "SQ");
        this.add(805962610, "Lateral Spreading Device Setting", "LO");
        this.add(805962612, "Isocenter to Lateral SpreadingDevice Distance", "FL");
        this.add(805962624, "Range Modulator SettingsSequence", "SQ");
        this.add(805962626, "Range Modulator Gating StartValue", "FL");
        this.add(805962628, "Range Modulator Gating StopValue", "FL");
        this.add(805962630, "Range Modulator Gating StartWater Equivalent Thickness", "FL");
        this.add(805962632, "Range Modulator Gating StopWater Equivalent Thickness", "FL");
        this.add(805962634, "Isocenter to Range ModulatorDistance", "FL");
        this.add(805962640, "Scan Spot Tune ID", "SH");
        this.add(805962642, "Number of Scan Spot Positions", "IS");
        this.add(805962644, "Scan Spot Position Map", "FL");
        this.add(805962646, "Scan Spot Meterset Weights", "FL");
        this.add(805962648, "Scanning Spot Size", "FL");
        this.add(805962650, "Number of Paintings", "IS");
        this.add(0x300A03A0, "Ion Tolerance Table Sequence", "SQ");
        this.add(805962658, "Ion Beam Sequence", "SQ");
        this.add(805962660, "Ion Beam Limiting DeviceSequence", "SQ");
        this.add(805962662, "Ion Block Sequence", "SQ");
        this.add(805962664, "Ion Control Point Sequence", "SQ");
        this.add(0x300A03AA, "Ion Wedge Sequence", "SQ");
        this.add(805962668, "Ion Wedge Position Sequence", "SQ");
        this.add(805962753, "Referenced Setup ImageSequence", "SQ");
        this.add(805962754, "Setup Image Comment", "ST");
        this.add(805962768, "Motion Synchronization Sequence", "SQ");
        this.add(805962770, "Control Point Orientation", "FL");
        this.add(805962784, "General Accessory Sequence", "SQ");
        this.add(805962785, "General Accessory ID", "SH");
        this.add(805962786, "General Accessory Description", "ST");
        this.add(805962787, "General Accessory Type", "CS");
        this.add(805962788, "General Accessory Number", "IS");
        this.add(805962789, "Source to General AccessoryDistance", "FL");
        this.add(805962801, "Applicator Geometry Sequence", "SQ");
        this.add(805962802, "Applicator Aperture Shape", "CS");
        this.add(805962803, "Applicator Opening", "FL");
        this.add(805962804, "Applicator Opening X", "FL");
        this.add(805962805, "Applicator Opening Y", "FL");
        this.add(805962806, "Source to Applicator MountingPosition Distance", "FL");
        this.add(805962816, "Number of Block Slab Items", "IS");
        this.add(805962817, "Block Slab Sequence", "SQ");
        this.add(805962818, "Block Slab Thickness", "DS");
        this.add(805962819, "Block Slab Number", "US");
        this.add(805962832, "Device Motion Control Sequence", "SQ");
        this.add(805962833, "Device Motion Execution Mode", "CS");
        this.add(805962834, "Device Motion Observation Mode", "CS");
        this.add(805962835, "Device Motion Parameter CodeSequence", "SQ");
    }

    private void addAttributeGroup300C() {
        this.add(806092802, "Referenced RT Plan Sequence", "SQ");
        this.add(806092804, "Referenced Beam Sequence", "SQ");
        this.add(806092806, "Referenced Beam Number", "IS");
        this.add(806092807, "Referenced Reference ImageNumber", "IS");
        this.add(806092808, "Start Cumulative Meterset Weight", "DS");
        this.add(806092809, "End Cumulative Meterset Weight", "DS");
        this.add(806092810, "Referenced Brachy ApplicationSetup Sequence", "SQ");
        this.add(0x300C000C, "Referenced Brachy ApplicationSetup Number", "IS");
        this.add(806092814, "Referenced Source Number", "IS");
        this.add(806092832, "Referenced Fraction GroupSequence", "SQ");
        this.add(806092834, "Referenced Fraction GroupNumber", "IS");
        this.add(806092864, "Referenced Verification ImageSequence", "SQ");
        this.add(806092866, "Referenced Reference ImageSequence", "SQ");
        this.add(806092880, "Referenced Dose ReferenceSequence", "SQ");
        this.add(806092881, "Referenced Dose ReferenceNumber", "IS");
        this.add(806092885, "Brachy Referenced DoseReference Sequence", "SQ");
        this.add(806092896, "Referenced Structure SetSequence", "SQ");
        this.add(806092906, "Referenced Patient Setup Number", "IS");
        this.add(806092928, "Referenced Dose Sequence", "SQ");
        this.add(806092960, "Referenced Tolerance TableNumber", "IS");
        this.add(806092976, "Referenced Bolus Sequence", "SQ");
        this.add(0x300C00C0, "Referenced Wedge Number", "IS");
        this.add(806093008, "Referenced Compensator Number", "IS");
        this.add(806093024, "Referenced Block Number", "IS");
        this.add(806093040, "Referenced Control Point Index", "IS");
        this.add(806093042, "Referenced Control PointSequence", "SQ");
        this.add(806093044, "Referenced Start Control PointIndex", "IS");
        this.add(806093046, "Referenced Stop Control PointIndex", "IS");
        this.add(806093056, "Referenced Range Shifter Number", "IS");
        this.add(806093058, "Referenced Lateral SpreadingDevice Number", "IS");
        this.add(806093060, "Referenced Range ModulatorNumber", "IS");
        this.add(806093073, "Omitted Beam Task Sequence", "SQ");
        this.add(806093074, "Reason for Omission", "CS");
        this.add(806093075, "Reason for Omission Description", "LO");
    }

    private void addAttributeGroup300E() {
        this.add(806223874, "Approval Status", "CS");
        this.add(806223876, "Review Date", "DA");
        this.add(806223877, "Review Time", "TM");
        this.add(806223880, "Reviewer Name", "PN");
    }

    private void addAttributeGroup4000() {
        this.add(0x40000010, "Arbitrary", "LT");
        this.add(0x40004000, "Text Comments", "LT");
    }

    private void addAttributeGroup4008() {
        this.add(0x40080040, "Results ID", "SH");
        this.add(1074266178, "Results ID Issuer", "LO");
        this.add(1074266192, "Referenced InterpretationSequence", "SQ");
        this.add(1074266367, "Report Production Status (Trial)", "CS");
        this.add(1074266368, "Interpretation Recorded Date", "DA");
        this.add(1074266369, "Interpretation Recorded Time", "TM");
        this.add(1074266370, "Interpretation Recorder", "PN");
        this.add(1074266371, "Reference to Recorded Sound", "LO");
        this.add(1074266376, "Interpretation Transcription Date", "DA");
        this.add(1074266377, "Interpretation Transcription Time", "TM");
        this.add(1074266378, "Interpretation Transcriber", "PN");
        this.add(1074266379, "Interpretation Text", "ST");
        this.add(1074266380, "Interpretation Author", "PN");
        this.add(1074266385, "Interpretation Approver Sequence", "SQ");
        this.add(1074266386, "Interpretation Approval Date", "DA");
        this.add(1074266387, "Interpretation Approval Time", "TM");
        this.add(1074266388, "Physician Approving Interpretation", "PN");
        this.add(1074266389, "Interpretation DiagnosisDescription", "LT");
        this.add(1074266391, "Interpretation Diagnosis CodeSequence", "SQ");
        this.add(1074266392, "Results Distribution List Sequence", "SQ");
        this.add(1074266393, "Distribution Name", "PN");
        this.add(1074266394, "Distribution Address", "LO");
        this.add(1074266624, "Interpretation ID", "SH");
        this.add(1074266626, "Interpretation ID Issuer", "LO");
        this.add(1074266640, "Interpretation Type ID", "CS");
        this.add(1074266642, "Interpretation Status ID", "CS");
        this.add(1074266880, "Impressions", "ST");
        this.add(0x40084000, "Results Comments", "ST");
    }

    private void addAttributeGroup4010() {
        this.add(0x40100001, "Low Energy Detectors", "CS");
        this.add(1074790402, "High Energy Detectors", "CS");
        this.add(0x40100004, "Detector Geometry Sequence", "SQ");
        this.add(0x40101001, "Threat ROI Voxel Sequence", "SQ");
        this.add(0x40101004, "Threat ROI Base", "FL");
        this.add(1074794501, "Threat ROI Extents", "FL");
        this.add(1074794502, "Threat ROI Bitmap", "OB");
        this.add(1074794503, "Route Segment ID", "SH");
        this.add(1074794504, "Gantry Type", "CS");
        this.add(1074794505, "OOI Owner Type", "CS");
        this.add(1074794506, "Route Segment Sequence", "SQ");
        this.add(0x40101010, "Potential Threat Object ID", "US");
        this.add(0x40101011, "Threat Sequence", "SQ");
        this.add(1074794514, "Threat Category", "CS");
        this.add(1074794515, "Threat Category Description", "LT");
        this.add(0x40101014, "ATD Ability Assessment", "CS");
        this.add(1074794517, "ATD Assessment Flag", "CS");
        this.add(1074794518, "ATD Assessment Probability", "FL");
        this.add(1074794519, "Mass", "FL");
        this.add(1074794520, "Density", "FL");
        this.add(1074794521, "Z Effective", "FL");
        this.add(1074794522, "Boarding Pass ID", "SH");
        this.add(1074794523, "Center of Mass", "FL");
        this.add(1074794524, "Center of PTO", "FL");
        this.add(1074794525, "Bounding Polygon", "FL");
        this.add(1074794526, "Route Segment Start Location ID", "SH");
        this.add(1074794527, "Route Segment End Location ID", "SH");
        this.add(1074794528, "Route Segment Location ID Type", "CS");
        this.add(1074794529, "Abort Reason", "CS");
        this.add(1074794531, "Volume of PTO", "FL");
        this.add(1074794532, "Abort Flag", "CS");
        this.add(1074794533, "Route Segment Start Time", "DT");
        this.add(1074794534, "Route Segment End Time", "DT");
        this.add(1074794535, "TDR Type", "CS");
        this.add(1074794536, "International Route Segment", "CS");
        this.add(1074794537, "Threat Detection Algorithm andVersion", "LO");
        this.add(1074794538, "Assigned Location", "SH");
        this.add(1074794539, "Alarm Decision Time", "DT");
        this.add(1074794545, "Alarm Decision", "CS");
        this.add(1074794547, "Number of Total Objects", "US");
        this.add(1074794548, "Number of Alarm Objects", "US");
        this.add(1074794551, "PTO Representation Sequence", "SQ");
        this.add(1074794552, "ATD Assessment Sequence", "SQ");
        this.add(1074794553, "TIP Type", "CS");
        this.add(1074794554, "DICOS Version", "CS");
        this.add(0x40101041, "OOI Owner Creation Time", "DT");
        this.add(1074794562, "OOI Type", "CS");
        this.add(1074794563, "OOI Size", "FL");
        this.add(0x40101044, "Acquisition Status", "CS");
        this.add(1074794565, "Basis Materials Code Sequence", "SQ");
        this.add(1074794566, "Phantom Type", "CS");
        this.add(1074794567, "OOI Owner Sequence", "SQ");
        this.add(1074794568, "Scan Type", "CS");
        this.add(1074794577, "Itinerary ID", "LO");
        this.add(1074794578, "Itinerary ID Type", "SH");
        this.add(1074794579, "Itinerary ID Assigning Authority", "LO");
        this.add(1074794580, "Route ID", "SH");
        this.add(1074794581, "Route ID Assigning Authority", "SH");
        this.add(1074794582, "Inbound Arrival Type", "CS");
        this.add(1074794584, "Carrier ID", "SH");
        this.add(1074794585, "Carrier ID Assigning Authority", "CS");
        this.add(1074794592, "Source Orientation", "FL");
        this.add(1074794593, "Source Position", "FL");
        this.add(1074794594, "Belt Height", "FL");
        this.add(1074794596, "Algorithm Routing Code Sequence", "SQ");
        this.add(1074794599, "Transport Classification", "CS");
        this.add(1074794600, "OOI Type Descriptor", "LT");
        this.add(1074794601, "Total Processing Time", "FL");
        this.add(1074794604, "Detector Calibration Data", "OB");
        this.add(1074794605, "Additional Screening Performed", "CS");
        this.add(1074794606, "Additional Inspection SelectionCriteria", "CS");
        this.add(1074794607, "Additional Inspection MethodSequence", "SQ");
        this.add(1074794608, "AIT Device Type", "CS");
        this.add(1074794609, "QR Measurements Sequence", "SQ");
        this.add(1074794610, "Target Material Sequence", "SQ");
        this.add(1074794611, "SNR Threshold", "FD");
        this.add(1074794613, "Image Scale Representation", "DS");
        this.add(1074794614, "Referenced PTO Sequence", "SQ");
        this.add(1074794615, "Referenced TDR InstanceSequence", "SQ");
        this.add(1074794616, "PTO Location Description", "ST");
        this.add(1074794617, "Anomaly Locator IndicatorSequence", "SQ");
        this.add(1074794618, "Anomaly Locator Indicator", "FL");
        this.add(1074794619, "PTO Region Sequence", "SQ");
        this.add(1074794620, "Inspection Selection Criteria", "CS");
        this.add(1074794621, "Secondary Inspection MethodSequence", "SQ");
        this.add(1074794622, "PRCS to RCS Orientation", "DS");
    }

    private void addAttributeGroup4FFE() {
        this.add(1342046209, "MAC Parameters Sequence", "SQ");
    }

    private void addAttributeGroup5200() {
        this.add(1375769129, "Shared Functional GroupsSequence", "SQ");
        this.add(1375769136, "Per-frame Functional GroupsSequence", "SQ");
    }

    private void addAttributeGroup5400() {
        this.add(1409286400, "Waveform Sequence", "SQ");
        this.add(1409290244, "Waveform Bits Allocated", "US");
        this.add(1409290246, "Waveform Sample Interpretation", "CS");
    }

    private void addAttributeGroup5600() {
        this.add(1442840592, "First Order Phase Correction Angle", "OF");
        this.add(1442840608, "Spectroscopy Data", "OF");
    }

    private void addAttributeGroup7FE0() {
        this.add(2145386504, "Float Pixel Data", "OF");
        this.add(2145386505, "Double Float Pixel Data", "OD");
        this.add(2145386528, "Coefficients SDVN", "OW");
        this.add(2145386544, "Coefficients SDHN", "OW");
        this.add(2145386560, "Coefficients SDDN", "OW");
    }

    private void addAttributeGroupFFFA() {
        this.add(-327686, "Digital Signatures Sequence", "SQ");
    }

    private void add(int code, String name, String vr) {
        this.table.put(code, new String[]{name, vr});
    }
}

