/*
 * Decompiled with CFR 0.152.
 */
package io.scif.formats;

import io.scif.AbstractChecker;
import io.scif.AbstractFormat;
import io.scif.AbstractMetadata;
import io.scif.AbstractParser;
import io.scif.AbstractWriter;
import io.scif.ByteArrayPlane;
import io.scif.ByteArrayReader;
import io.scif.DefaultImageMetadata;
import io.scif.Format;
import io.scif.FormatException;
import io.scif.HasColorTable;
import io.scif.ImageMetadata;
import io.scif.Plane;
import io.scif.codec.CodecOptions;
import io.scif.codec.CodecService;
import io.scif.codec.CompressionType;
import io.scif.codec.JPEG2000BoxType;
import io.scif.codec.JPEG2000Codec;
import io.scif.codec.JPEG2000CodecOptions;
import io.scif.codec.JPEG2000SegmentMarker;
import io.scif.config.SCIFIOConfig;
import io.scif.io.RandomAccessInputStream;
import io.scif.util.FormatTools;
import java.io.IOException;
import java.util.ArrayList;
import net.imagej.axis.Axes;
import net.imglib2.display.ColorTable;
import net.imglib2.display.ColorTable16;
import net.imglib2.display.ColorTable8;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.util.Bytes;

@Plugin(type=Format.class, name="JPEG-2000")
public class JPEG2000Format
extends AbstractFormat {
    @Override
    protected String[] makeSuffixArray() {
        return new String[]{"jp2", "j2k", "jpf"};
    }

    public static class Index {
        private int imageIndex;
        private long planeIndex;

        public Index() {
            this(-1, -1L);
        }

        public Index(int image, long plane) {
            this.imageIndex = image;
            this.planeIndex = plane;
        }

        public void setImageIndex(int image) {
            this.imageIndex = image;
        }

        public void setPlaneIndex(long plane) {
            this.planeIndex = plane;
        }

        public int getImageIndex() {
            return this.imageIndex;
        }

        public long getPlaneIndex() {
            return this.planeIndex;
        }
    }

    public static class Writer
    extends AbstractWriter<Metadata> {
        @Parameter
        private CodecService codecService;

        @Override
        protected String[] makeCompressionTypes() {
            return new String[]{CompressionType.J2K_LOSSY.getCompression(), CompressionType.J2K.getCompression()};
        }

        @Override
        public void writePlane(int imageIndex, long planeIndex, Plane plane, long[] planeMin, long[] planeMax) throws FormatException, IOException {
            this.getStream().write(this.compressBuffer(imageIndex, planeIndex, plane, planeMin, planeMax));
        }

        public byte[] compressBuffer(int imageIndex, long planeIndex, Plane plane, long[] planeMin, long[] planeMax) throws FormatException, IOException {
            byte[] buf = plane.getBytes();
            this.checkParams(imageIndex, planeIndex, buf, planeMin, planeMax);
            boolean littleEndian = ((Metadata)this.getMetadata()).get(imageIndex).isLittleEndian();
            int bytesPerPixel = ((Metadata)this.getMetadata()).get(imageIndex).getBitsPerPixel() / 8;
            int nChannels = (int)((Metadata)this.getMetadata()).get(imageIndex).getAxisLength(Axes.CHANNEL);
            CodecOptions options = this.getCodecOptions();
            if (options == null) {
                options = JPEG2000CodecOptions.getDefaultOptions();
            }
            options.width = (int)planeMax[((Metadata)this.getMetadata()).get(imageIndex).getAxisIndex(Axes.X)];
            options.height = (int)planeMax[((Metadata)this.getMetadata()).get(imageIndex).getAxisIndex(Axes.Y)];
            options.channels = nChannels;
            options.bitsPerSample = bytesPerPixel * 8;
            options.littleEndian = littleEndian;
            options.interleaved = plane.getImageMetadata().getInterleavedAxisCount() > 0;
            options.lossless = this.getCompression() == null || this.getCompression().equals(CompressionType.J2K.getCompression());
            options.colorModel = this.getColorModel();
            JPEG2000Codec codec = this.codecService.getCodec(JPEG2000Codec.class);
            return codec.compress(buf, options);
        }

        @Override
        public boolean canDoStacks() {
            return false;
        }

        @Override
        public int[] getPixelTypes(String codec) {
            return new int[]{0, 1, 2, 3, 4, 5};
        }
    }

    public static class Reader
    extends ByteArrayReader<Metadata> {
        @Parameter
        private CodecService codecService;

        @Override
        protected String[] createDomainArray() {
            return new String[]{"Graphics"};
        }

        @Override
        public ByteArrayPlane openPlane(int imageIndex, long planeIndex, ByteArrayPlane plane, long[] planeMin, long[] planeMax, SCIFIOConfig config) throws FormatException, IOException {
            byte[] buf = plane.getBytes();
            Metadata meta = (Metadata)this.getMetadata();
            plane.setColorTable(meta.getColorTable(imageIndex, planeIndex));
            FormatTools.checkPlaneForReading(meta, imageIndex, planeIndex, buf.length, planeMin, planeMax);
            if (meta.getLastIndex().getImageIndex() == imageIndex && meta.getLastIndex().getPlaneIndex() == planeIndex && meta.getLastIndexBytes() != null) {
                RandomAccessInputStream s = new RandomAccessInputStream(this.getContext(), meta.getLastIndexBytes());
                this.readPlane(s, imageIndex, planeMin, planeMax, plane);
                s.close();
                return plane;
            }
            JPEG2000CodecOptions options = JPEG2000CodecOptions.getDefaultOptions();
            options.interleaved = meta.get(imageIndex).getInterleavedAxisCount() > 0;
            options.littleEndian = meta.get(imageIndex).isLittleEndian();
            if (meta.getResolutionLevels() != null) {
                options.resolution = Math.abs(imageIndex - meta.getResolutionLevels());
            } else if (meta.getAll().size() > 1) {
                options.resolution = imageIndex;
            }
            this.getStream().seek(meta.getPixelsOffset());
            JPEG2000Codec codec = this.codecService.getCodec(JPEG2000Codec.class);
            byte[] lastIndexPlane = codec.decompress(this.getStream(), (CodecOptions)options);
            meta.setLastIndexBytes(lastIndexPlane);
            RandomAccessInputStream s = new RandomAccessInputStream(this.getContext(), lastIndexPlane);
            this.readPlane(s, imageIndex, planeMin, planeMax, plane);
            s.close();
            meta.setLastIndex(imageIndex, planeIndex);
            return plane;
        }
    }

    public static class Parser
    extends AbstractParser<Metadata> {
        private long codestreamOffset;
        private long maximumReadOffset;
        private Integer headerSizeX;
        private Integer headerSizeY;
        private Short headerSizeC;
        private Integer headerPixelType;
        private Integer codestreamSizeX;
        private Integer codestreamSizeY;
        private Short codestreamSizeC;
        private Integer codestreamPixelType;
        private boolean isRawCodestream = false;
        private ArrayList<String> comments;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void parse(RandomAccessInputStream stream, Metadata meta, long maximumReadOffset) throws IOException {
            int pixelType;
            short sizeC;
            int sizeY;
            int sizeX;
            meta.createImageMetadata(1);
            ImageMetadata iMeta = meta.get(0);
            this.maximumReadOffset = maximumReadOffset;
            this.comments = new ArrayList();
            boolean isLittleEndian = stream.isLittleEndian();
            try {
                this.parseBoxes(meta);
            }
            finally {
                this.getSource().order(isLittleEndian);
            }
            if (this.isRawCodestream()) {
                this.log().info((Object)"Codestream is raw, using codestream dimensions.");
                sizeX = this.getCodestreamSizeX();
                sizeY = this.getCodestreamSizeY();
                sizeC = this.getCodestreamSizeC();
                pixelType = this.getCodestreamPixelType();
            } else {
                this.log().info((Object)"Codestream is JP2 boxed, using header dimensions.");
                sizeX = this.getHeaderSizeX();
                sizeY = this.getHeaderSizeY();
                sizeC = this.getHeaderSizeC();
                pixelType = this.getHeaderPixelType();
            }
            iMeta.setAxisLength(Axes.X, (long)sizeX);
            iMeta.setAxisLength(Axes.Y, (long)sizeY);
            iMeta.setAxisLength(Axes.CHANNEL, (long)sizeC);
            iMeta.setPixelType(pixelType);
            meta.setPixelsOffset(this.getCodestreamOffset());
            iMeta.setLittleEndian(false);
            for (String comment : this.getComments()) {
                int equal = comment.indexOf("=");
                if (equal >= 0) {
                    String key = comment.substring(0, equal);
                    String value = comment.substring(equal + 1);
                    meta.getTable().put(key, value);
                    continue;
                }
                meta.getTable().put("Comment", comment);
            }
        }

        @Override
        protected void typedParse(RandomAccessInputStream stream, Metadata meta, SCIFIOConfig config) throws IOException, FormatException {
            this.parse(stream, meta, stream.length());
        }

        public long getCodestreamOffset() {
            return this.codestreamOffset;
        }

        public ArrayList<String> getComments() {
            return this.comments;
        }

        private void parseBoxes(Metadata meta) throws IOException {
            long originalPos = this.getSource().getFilePointer();
            long nextPos = 0L;
            long pos = originalPos;
            this.log().trace((Object)("Parsing JPEG 2000 boxes at " + pos));
            int length = 0;
            while (pos < this.maximumReadOffset) {
                pos = this.getSource().getFilePointer();
                length = this.getSource().readInt();
                int boxCode = this.getSource().readInt();
                JPEG2000BoxType boxType = JPEG2000BoxType.get(boxCode);
                if (boxType == JPEG2000BoxType.SIGNATURE_WRONG_ENDIANNESS) {
                    this.log().trace((Object)"Swapping endianness during box parsing.");
                    this.getSource().order(!this.getSource().isLittleEndian());
                    length = Bytes.swap((int)length);
                }
                nextPos = pos + (long)length;
                if (length >= 8) {
                    length -= 8;
                }
                if (boxType == null) {
                    this.log().warn((Object)("Unknown JPEG 2000 box 0x" + Integer.toHexString(boxCode) + " at " + pos));
                    if (pos == originalPos) {
                        this.getSource().seek(originalPos);
                        if (JPEG2000SegmentMarker.get(this.getSource().readUnsignedShort()) != null) {
                            this.log().info((Object)"File is a raw codestream not a JP2.");
                            this.isRawCodestream = true;
                            this.getSource().seek(originalPos);
                            this.parseContiguousCodestream(meta, this.getSource().length());
                        }
                    }
                } else {
                    this.log().trace((Object)("Found JPEG 2000 '" + boxType.getName() + "' box at " + pos));
                    switch (boxType) {
                        case CONTIGUOUS_CODESTREAM: {
                            try {
                                this.parseContiguousCodestream(meta, length == 0 ? this.getSource().length() : (long)length);
                            }
                            catch (Exception e) {
                                this.log().warn((Object)"Could not parse contiguous codestream.", (Throwable)e);
                            }
                            break;
                        }
                        case HEADER: {
                            this.getSource().skipBytes(4);
                            String s = this.getSource().readString(4);
                            if (s.equals("ihdr")) {
                                this.headerSizeY = this.getSource().readInt();
                                this.headerSizeX = this.getSource().readInt();
                                this.headerSizeC = this.getSource().readShort();
                                int type = this.getSource().read();
                                this.getSource().skipBytes(3);
                                this.headerPixelType = this.convertPixelType(type);
                            }
                            this.parseBoxes(meta);
                            break;
                        }
                        case PALETTE: {
                            short nEntries = this.getSource().readShort();
                            int nColumns = this.getSource().read();
                            int[] bitDepths = new int[nColumns];
                            for (int i = 0; i < bitDepths.length; ++i) {
                                bitDepths[i] = this.getSource().read() & 0x7F;
                                while (bitDepths[i] % 8 != 0) {
                                    int n = i;
                                    bitDepths[n] = bitDepths[n] + 1;
                                }
                            }
                            int[][] lut = new int[nColumns][nEntries];
                            for (int i = 0; i < nColumns; ++i) {
                                for (int j = 0; j < lut[i].length; ++j) {
                                    if (bitDepths[i] == 8) {
                                        lut[i][j] = this.getSource().read();
                                        continue;
                                    }
                                    if (bitDepths[i] != 16) continue;
                                    lut[i][j] = this.getSource().readShort();
                                }
                            }
                            meta.setLut(lut);
                            break;
                        }
                    }
                }
                if (nextPos < 0L || nextPos >= this.maximumReadOffset || length == 0) {
                    this.log().trace((Object)"Exiting box parser loop.");
                    break;
                }
                this.log().trace((Object)("Seeking to next box at " + nextPos));
                this.getSource().seek(nextPos);
            }
        }

        private void parseContiguousCodestream(Metadata meta, long length) throws IOException {
            if (this.codestreamOffset == 0L) {
                this.codestreamOffset = this.getSource().getFilePointer();
            }
            int segmentMarkerCode = 0;
            int segmentLength = 0;
            long pos = this.getSource().getFilePointer();
            long nextPos = 0L;
            this.log().trace((Object)("Parsing JPEG 2000 contiguous codestream of length " + length + " at " + pos));
            long maximumReadOffset = pos + length;
            boolean terminate = false;
            while (pos < maximumReadOffset && !terminate) {
                pos = this.getSource().getFilePointer();
                segmentMarkerCode = this.getSource().readUnsignedShort();
                JPEG2000SegmentMarker segmentMarker = JPEG2000SegmentMarker.get(segmentMarkerCode);
                if (segmentMarker == JPEG2000SegmentMarker.SOC_WRONG_ENDIANNESS) {
                    this.log().trace((Object)"Swapping endianness during segment marker parsing.");
                    this.getSource().order(!this.getSource().isLittleEndian());
                    segmentMarkerCode = JPEG2000SegmentMarker.SOC.getCode();
                    segmentMarker = JPEG2000SegmentMarker.SOC;
                }
                segmentLength = segmentMarker == JPEG2000SegmentMarker.SOC || segmentMarker == JPEG2000SegmentMarker.SOD || segmentMarker == JPEG2000SegmentMarker.EPH || segmentMarker == JPEG2000SegmentMarker.EOC || segmentMarkerCode >= JPEG2000SegmentMarker.RESERVED_DELIMITER_MARKER_MIN.getCode() && segmentMarkerCode <= JPEG2000SegmentMarker.RESERVED_DELIMITER_MARKER_MAX.getCode() ? 0 : this.getSource().readUnsignedShort();
                nextPos = pos + (long)segmentLength + 2L;
                if (segmentMarker == null) {
                    this.log().warn((Object)("Unknown JPEG 2000 segment marker 0x" + Integer.toHexString(segmentMarkerCode) + " at " + pos));
                } else {
                    if (this.log().isTrace()) {
                        this.log().trace((Object)String.format("Found JPEG 2000 segment marker '%s' of length %d at %d", segmentMarker.getName(), segmentLength, pos));
                    }
                    switch (segmentMarker) {
                        case SOT: 
                        case SOD: 
                        case EOC: {
                            terminate = true;
                            break;
                        }
                        case SIZ: {
                            this.getSource().skipBytes(2);
                            this.codestreamSizeX = this.getSource().readInt();
                            this.log().trace((Object)("Read reference grid width " + this.codestreamSizeX + " at " + this.getSource().getFilePointer()));
                            this.codestreamSizeY = this.getSource().readInt();
                            this.log().trace((Object)("Read reference grid height " + this.codestreamSizeY + " at " + this.getSource().getFilePointer()));
                            this.getSource().skipBytes(24);
                            this.codestreamSizeC = this.getSource().readShort();
                            this.log().trace((Object)("Read total components " + this.codestreamSizeC + " at " + this.getSource().getFilePointer()));
                            int type = this.getSource().read();
                            this.getSource().skipBytes(3);
                            this.codestreamPixelType = this.convertPixelType(type);
                            this.log().trace((Object)("Read codestream pixel type " + this.codestreamPixelType + " at " + this.getSource().getFilePointer()));
                            break;
                        }
                        case COD: {
                            this.getSource().skipBytes(5);
                            meta.setResolutionLevels(this.getSource().readUnsignedByte());
                            this.log().trace((Object)("Found number of resolution levels " + meta.getResolutionLevels() + " at " + this.getSource().getFilePointer()));
                            break;
                        }
                        case COM: {
                            this.getSource().skipBytes(2);
                            String comment = this.getSource().readString(segmentLength - 4);
                            this.comments.add(comment);
                            break;
                        }
                    }
                }
                if (nextPos < 0L || nextPos >= maximumReadOffset || terminate) {
                    this.log().trace((Object)"Exiting segment marker parse loop.");
                    break;
                }
                this.log().trace((Object)("Seeking to next segment marker at " + nextPos));
                this.getSource().seek(nextPos);
            }
        }

        public boolean isRawCodestream() {
            return this.isRawCodestream;
        }

        public Integer getHeaderSizeX() {
            return this.headerSizeX;
        }

        public Integer getHeaderSizeY() {
            return this.headerSizeY;
        }

        public Short getHeaderSizeC() {
            return this.headerSizeC;
        }

        public Integer getHeaderPixelType() {
            return this.headerPixelType;
        }

        public Integer getCodestreamSizeX() {
            return this.codestreamSizeX;
        }

        public Integer getCodestreamSizeY() {
            return this.codestreamSizeY;
        }

        public Short getCodestreamSizeC() {
            return this.codestreamSizeC;
        }

        public Integer getCodestreamPixelType() {
            return this.codestreamPixelType;
        }

        private int convertPixelType(int type) {
            boolean isSigned;
            int bits = (type & 0x7F) + 1;
            boolean bl = isSigned = (type & 0x80) >> 7 == 1;
            if (bits <= 8) {
                return isSigned ? 0 : 1;
            }
            if (bits <= 16) {
                return isSigned ? 2 : 3;
            }
            if (bits <= 32) {
                return isSigned ? 4 : 5;
            }
            return 1;
        }
    }

    public static class Checker
    extends AbstractChecker {
        @Override
        public boolean suffixNecessary() {
            return false;
        }

        @Override
        public boolean suffixSufficient() {
            return false;
        }

        @Override
        public boolean isFormat(RandomAccessInputStream stream) throws IOException {
            boolean validStart;
            int blockLen = 40;
            if (!FormatTools.validStream(stream, 40, false)) {
                return false;
            }
            boolean bl = validStart = (stream.readShort() & 0xFFFF) == 65359;
            if (!validStart) {
                stream.skipBytes(2);
                boolean bl2 = validStart = stream.readInt() == JPEG2000BoxType.SIGNATURE.getCode();
                if (validStart) {
                    stream.skipBytes(12);
                    validStart = !stream.readString(4).equals("jpx ");
                }
            }
            stream.seek(stream.length() - 2L);
            boolean validEnd = (stream.readShort() & 0xFFFF) == 65497;
            return validStart && validEnd;
        }
    }

    public static class Metadata
    extends AbstractMetadata
    implements HasColorTable {
        private long pixelsOffset;
        private Index lastIndex = new Index();
        private byte[] lastIndexBytes;
        private Integer resolutionLevels;
        private int[][] lut;
        byte[][] byteLut;
        short[][] shortLut;

        public long getPixelsOffset() {
            return this.pixelsOffset;
        }

        public void setPixelsOffset(long pixelsOffset) {
            this.pixelsOffset = pixelsOffset;
        }

        public Index getLastIndex() {
            if (this.lastIndex == null) {
                this.lastIndex = new Index();
            }
            return this.lastIndex;
        }

        public void setLastIndex(int imageIndex, long planeIndex) {
            if (this.lastIndex == null) {
                this.lastIndex = new Index(imageIndex, planeIndex);
            } else {
                this.lastIndex.setImageIndex(imageIndex);
                this.lastIndex.setPlaneIndex(imageIndex);
            }
        }

        public byte[] getLastIndexBytes() {
            return this.lastIndexBytes;
        }

        public void setLastIndexBytes(byte[] lastIndexBytes) {
            this.lastIndexBytes = lastIndexBytes;
        }

        public Integer getResolutionLevels() {
            return this.resolutionLevels;
        }

        public void setResolutionLevels(Integer resolutionLevels) {
            this.resolutionLevels = resolutionLevels;
        }

        public int[][] getLut() {
            return this.lut;
        }

        public void setLut(int[][] lut) {
            this.lut = lut;
        }

        @Override
        public void populateImageMetadata() {
            ImageMetadata iMeta = this.get(0);
            iMeta.setAxisTypes(Axes.CHANNEL, Axes.X, Axes.Y);
            iMeta.setIndexed(iMeta.getAxisLength(Axes.CHANNEL) <= 1L && this.getLut() != null);
            iMeta.setPlanarAxisCount(3);
            if (this.getResolutionLevels() != null) {
                int imageCount = this.resolutionLevels + 1;
                for (int i = 1; i < imageCount; ++i) {
                    DefaultImageMetadata ms = new DefaultImageMetadata(iMeta);
                    this.add(ms);
                    ms.setAxisLength(Axes.X, iMeta.getAxisLength(Axes.X) / 2L);
                    ms.setAxisLength(Axes.Y, iMeta.getAxisLength(Axes.Y) / 2L);
                    ms.setThumbnail(true);
                }
            }
        }

        @Override
        public int getImageCount() {
            return 1;
        }

        @Override
        public void close(boolean fileOnly) throws IOException {
            super.close(fileOnly);
            if (!fileOnly) {
                this.resolutionLevels = null;
                this.lut = null;
                this.byteLut = null;
                this.shortLut = null;
                this.pixelsOffset = 0L;
                this.lastIndex = null;
                this.lastIndexBytes = null;
            }
        }

        @Override
        public ColorTable getColorTable(int imageIndex, long planeIndex) {
            if (this.lut == null) {
                return null;
            }
            if (FormatTools.getBytesPerPixel(this.get(0).getPixelType()) == 1) {
                if (this.byteLut == null) {
                    this.byteLut = new byte[this.lut.length][this.lut[0].length];
                    for (int i = 0; i < this.lut.length; ++i) {
                        for (int j = 0; j < this.lut[i].length; ++j) {
                            this.byteLut[i][j] = (byte)(this.lut[i][j] & 0xFF);
                        }
                    }
                }
                return new ColorTable8(this.byteLut);
            }
            if (FormatTools.getBytesPerPixel(this.get(0).getPixelType()) == 1) {
                if (this.shortLut == null) {
                    this.shortLut = new short[this.lut.length][this.lut[0].length];
                    for (int i = 0; i < this.lut.length; ++i) {
                        for (int j = 0; j < this.lut[i].length; ++j) {
                            this.shortLut[i][j] = (short)(this.lut[i][j] & 0xFFFF);
                        }
                    }
                }
                return new ColorTable16(this.shortLut);
            }
            return null;
        }
    }
}

