/*
 * Decompiled with CFR 0.152.
 */
package io.scif.codec;

import io.scif.FormatException;
import io.scif.codec.ByteVector;
import io.scif.codec.CodecOptions;
import io.scif.codec.CodecService;
import io.scif.codec.JPEGCodec;
import io.scif.io.RandomAccessInputStream;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import java.io.IOException;
import java.util.Hashtable;
import org.scijava.AbstractContextual;
import org.scijava.Context;
import org.scijava.log.LogService;
import org.scijava.plugin.Parameter;
import org.scijava.util.IntRect;

public class JPEGTileDecoder
extends AbstractContextual {
    @Parameter
    private LogService log;
    private TileConsumer consumer;
    private TileCache tiles;
    private RandomAccessInputStream in;

    public JPEGTileDecoder(Context ctx) {
        this.setContext(ctx);
    }

    public void initialize(String id, int imageWidth) {
        try {
            this.initialize(new RandomAccessInputStream(this.getContext(), id), imageWidth);
        }
        catch (IOException e) {
            this.log.debug((Object)"", (Throwable)e);
        }
    }

    public void initialize(RandomAccessInputStream in, int imageWidth) {
        this.initialize(in, 0, imageWidth);
    }

    public void initialize(RandomAccessInputStream in, int y, int h) {
        this.in = in;
        this.tiles = new TileCache(this.getContext(), y, h);
        try {
            long fp = in.getFilePointer();
            boolean littleEndian = in.isLittleEndian();
            in.order(false);
            while (in.getFilePointer() < in.length() - 1L) {
                int code = in.readShort() & 0xFFFF;
                int length = in.readShort() & 0xFFFF;
                long pointer = in.getFilePointer();
                if (length > 65280 || code < 65280) {
                    in.seek(pointer - 3L);
                    continue;
                }
                if (code == 65472) {
                    in.skipBytes(1);
                    int height = in.readShort() & 0xFFFF;
                    int width = in.readShort() & 0xFFFF;
                    if (height != 0 && width != 0) break;
                    throw new RuntimeException("Width or height > 65500 is not supported.");
                }
                if (pointer + (long)length - 2L >= in.length()) break;
                in.seek(pointer + (long)length - 2L);
            }
            in.seek(fp);
            in.order(littleEndian);
        }
        catch (IOException fp) {
            // empty catch block
        }
        try {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            byte[] data = new byte[this.in.available()];
            this.in.readFully(data);
            Image image = toolkit.createImage(data);
            ImageProducer producer = image.getSource();
            this.consumer = new TileConsumer(producer, y, h);
            producer.startProduction(this.consumer);
            while (producer.isConsumer(this.consumer)) {
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public byte[] getScanline(int y) {
        try {
            return this.tiles.get(0, y, this.consumer.getWidth(), 1);
        }
        catch (FormatException e) {
            this.log.debug((Object)"", (Throwable)e);
            return null;
        }
    }

    public int getWidth() {
        return this.consumer.getWidth();
    }

    public int getHeight() {
        return this.consumer.getHeight();
    }

    public void close() {
        try {
            if (this.in != null) {
                this.in.close();
            }
        }
        catch (IOException e) {
            this.log.debug((Object)"", (Throwable)e);
        }
        this.tiles = null;
        this.consumer = null;
    }

    class TileCache {
        private static final int ROW_COUNT = 128;
        private final Hashtable<IntRect, byte[]> compressedTiles = new Hashtable();
        private final JPEGCodec codec;
        private final CodecOptions options = new CodecOptions();
        private final ByteVector toCompress = new ByteVector();
        @Parameter
        private CodecService codecService;
        private int row = 0;
        private IntRect lastRegion = null;
        private byte[] lastTile = null;
        private int yy = 0;
        private int hh = 0;

        public TileCache(Context ctx, int yy, int hh) {
            ctx.inject((Object)this);
            this.options.interleaved = true;
            this.options.littleEndian = false;
            this.yy = yy;
            this.hh = hh;
            this.codec = this.codecService.getCodec(JPEGCodec.class);
        }

        public void add(byte[] pixels, int x, int y, int w) throws FormatException {
            this.toCompress.add(pixels);
            ++this.row;
            if (y % 128 == 127 || y == JPEGTileDecoder.this.getHeight() - 1 || y == this.yy + this.hh - 1) {
                IntRect r = new IntRect(x, y - this.row + 1, w, this.row);
                this.options.width = w;
                this.options.height = this.row;
                this.options.channels = 1;
                this.options.bitsPerSample = 8;
                this.options.signed = false;
                byte[] compressed = this.codec.compress(this.toCompress.toByteArray(), this.options);
                this.compressedTiles.put(r, compressed);
                this.toCompress.clear();
            }
        }

        public void add(int[] pixels, int x, int y, int w) throws FormatException {
            byte[] buf = new byte[pixels.length * 3];
            for (int i = 0; i < pixels.length; ++i) {
                buf[i * 3] = (byte)((pixels[i] & 0xFF0000) >> 16);
                buf[i * 3 + 1] = (byte)((pixels[i] & 0xFF00) >> 8);
                buf[i * 3 + 2] = (byte)(pixels[i] & 0xFF);
            }
            this.toCompress.add(buf);
            ++this.row;
            if (y % 128 == 127 || y == JPEGTileDecoder.this.getHeight() - 1 || y == this.yy + this.hh - 1) {
                IntRect r = new IntRect(x, y - this.row + 1, w, this.row);
                this.options.width = w;
                this.options.height = this.row;
                this.options.channels = 3;
                this.options.bitsPerSample = 8;
                this.options.signed = false;
                byte[] compressed = this.codec.compress(this.toCompress.toByteArray(), this.options);
                this.compressedTiles.put(r, compressed);
                this.toCompress.clear();
                this.row = 0;
            }
        }

        public byte[] get(int x, int y, int w, int h) throws FormatException {
            IntRect[] keys = this.compressedTiles.keySet().toArray(new IntRect[0]);
            IntRect r = new IntRect(x, y, w, h);
            for (IntRect key : keys) {
                if (!key.intersects(r)) continue;
                r = key;
            }
            if (!r.equals((Object)this.lastRegion)) {
                this.lastRegion = r;
                byte[] compressed = null;
                compressed = this.compressedTiles.get(r);
                if (compressed == null) {
                    return null;
                }
                this.lastTile = this.codec.decompress(compressed, this.options);
            }
            int pixel = this.options.channels * (this.options.bitsPerSample / 8);
            byte[] buf = new byte[w * h * pixel];
            for (int i = 0; i < h; ++i) {
                System.arraycopy(this.lastTile, r.width * pixel * (i + y - r.y) + (x - r.x), buf, i * w * pixel, pixel * w);
            }
            return buf;
        }
    }

    class TileConsumer
    implements ImageConsumer {
        private int width;
        private int height;
        private final ImageProducer producer;
        private int yy = 0;
        private int hh = 0;

        public TileConsumer(ImageProducer producer) {
            this.producer = producer;
        }

        public TileConsumer(ImageProducer producer, int y, int h) {
            this(producer);
            this.yy = y;
            this.hh = h;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        @Override
        public void imageComplete(int status) {
            this.producer.removeConsumer(this);
        }

        @Override
        public void setDimensions(int width, int height) {
            this.width = width;
            this.height = height;
            if (this.hh <= 0) {
                this.hh = height;
            }
        }

        @Override
        public void setPixels(int x, int y, int w, int h, ColorModel model, byte[] pixels, int off, int scanSize) {
            double percent = (double)y / (double)this.height * 100.0;
            JPEGTileDecoder.this.log.debug((Object)("Storing row " + y + " of " + this.height + " (" + percent + "%)"));
            if (y >= this.yy + this.hh) {
                this.imageComplete(0);
                return;
            }
            if (y < this.yy) {
                return;
            }
            try {
                JPEGTileDecoder.this.tiles.add(pixels, x, y, w);
            }
            catch (FormatException e) {
                JPEGTileDecoder.this.log.debug((Object)"", (Throwable)e);
            }
        }

        @Override
        public void setPixels(int x, int y, int w, int h, ColorModel model, int[] pixels, int off, int scanSize) {
            double percent = (double)y / (double)(this.yy + this.hh) * 100.0;
            JPEGTileDecoder.this.log.debug((Object)("Storing row " + y + " of " + (this.yy + this.hh) + " (" + percent + "%)"));
            if (y >= this.yy + this.hh) {
                this.imageComplete(0);
                return;
            }
            if (y < this.yy) {
                return;
            }
            try {
                JPEGTileDecoder.this.tiles.add(pixels, x, y, w);
            }
            catch (FormatException e) {
                JPEGTileDecoder.this.log.debug((Object)"", (Throwable)e);
            }
        }

        @Override
        public void setProperties(Hashtable<?, ?> props) {
        }

        @Override
        public void setColorModel(ColorModel model) {
        }

        @Override
        public void setHints(int hintFlags) {
        }
    }
}

