/*
 * Decompiled with CFR 0.152.
 */
package io.scif;

import io.scif.AbstractGroupable;
import io.scif.DataPlane;
import io.scif.FormatException;
import io.scif.Metadata;
import io.scif.Plane;
import io.scif.Reader;
import io.scif.TypedMetadata;
import io.scif.TypedReader;
import io.scif.config.SCIFIOConfig;
import io.scif.io.RandomAccessInputStream;
import io.scif.util.FormatTools;
import io.scif.util.SCIFIOMetadataTools;
import java.io.File;
import java.io.IOException;
import net.imagej.axis.Axes;

public abstract class AbstractReader<M extends TypedMetadata, P extends DataPlane<?>>
extends AbstractGroupable
implements TypedReader<M, P> {
    private M metadata;
    private boolean normalizeData;
    private String[] domains;
    private final Class<P> planeClass;

    public AbstractReader(Class<P> planeClass) {
        this.planeClass = planeClass;
    }

    protected abstract String[] createDomainArray();

    @Override
    public P openPlane(int imageIndex, long planeIndex) throws FormatException, IOException {
        return (P)this.openPlane(imageIndex, planeIndex, new SCIFIOConfig());
    }

    @Override
    public P openPlane(int imageIndex, long planeIndex, long[] planeMin, long[] planeMax) throws FormatException, IOException {
        return (P)this.openPlane(imageIndex, planeIndex, planeMin, planeMax, new SCIFIOConfig());
    }

    @Override
    public P openPlane(int imageIndex, long planeIndex, Plane plane) throws FormatException, IOException {
        return (P)this.openPlane(imageIndex, planeIndex, (P)((DataPlane)this.castToTypedPlane(plane)));
    }

    @Override
    public P openPlane(int imageIndex, long planeIndex, Plane plane, long[] planeMin, long[] planeMax) throws FormatException, IOException {
        return (P)this.openPlane(imageIndex, planeIndex, (P)((DataPlane)this.castToTypedPlane(plane)), planeMin, planeMax);
    }

    @Override
    public P openPlane(int imageIndex, long planeIndex, SCIFIOConfig config) throws FormatException, IOException {
        long[] planeMax = this.metadata.get(imageIndex).getAxesLengthsPlanar();
        long[] planeMin = new long[planeMax.length];
        return (P)this.openPlane(imageIndex, planeIndex, planeMin, planeMax, config);
    }

    @Override
    public P openPlane(int imageIndex, long planeIndex, long[] planeMin, long[] planeMax, SCIFIOConfig config) throws FormatException, IOException {
        DataPlane plane = null;
        try {
            plane = this.createPlane(planeMin, planeMax);
        }
        catch (IllegalArgumentException e) {
            throw new FormatException("Image plane too large. Only 2GB of data can be extracted at one time. You can workaround the problem by opening the plane in tiles; for further details, see: http://www.openmicroscopy.org/site/support/faq/bio-formats/i-see-an-outofmemory-or-negativearraysize-error-message-when-attempting-to-open-an-svs-or-jpeg-2000-file.-what-does-this-mean", e);
        }
        return (P)this.openPlane(imageIndex, planeIndex, plane, planeMin, planeMax, config);
    }

    @Override
    public Plane openPlane(int imageIndex, long planeIndex, Plane plane, SCIFIOConfig config) throws FormatException, IOException {
        return this.openPlane(imageIndex, planeIndex, (P)((DataPlane)this.castToTypedPlane(plane)), config);
    }

    @Override
    public Plane openPlane(int imageIndex, long planeIndex, Plane plane, long[] planeMin, long[] planeMax, SCIFIOConfig config) throws FormatException, IOException {
        return this.openPlane(imageIndex, planeIndex, (DataPlane)this.castToTypedPlane(plane), planeMin, planeMax, config);
    }

    @Override
    public String getCurrentFile() {
        return this.getStream() == null ? null : this.getStream().getFileName();
    }

    @Override
    public String[] getDomains() {
        if (this.domains == null) {
            this.domains = this.createDomainArray();
        }
        return this.domains;
    }

    @Override
    public RandomAccessInputStream getStream() {
        return this.metadata == null ? null : this.metadata.getSource();
    }

    @Override
    public Reader[] getUnderlyingReaders() {
        return null;
    }

    @Override
    public long getOptimalTileWidth(int imageIndex) {
        return this.metadata.get(imageIndex).getAxisLength(Axes.X);
    }

    @Override
    public long getOptimalTileHeight(int imageIndex) {
        int bpp = FormatTools.getBytesPerPixel(this.metadata.get(imageIndex).getPixelType());
        long width = this.metadata.get(imageIndex).getAxisLength(Axes.X);
        long rgbcCount = this.metadata.get(imageIndex).getAxisLength(Axes.CHANNEL);
        long maxHeight = 0x100000L / (width * rgbcCount * (long)bpp);
        return Math.min(maxHeight, this.metadata.get(imageIndex).getAxisLength(Axes.Y));
    }

    @Override
    public void setMetadata(Metadata meta) throws IOException {
        this.setMetadata((M)((TypedMetadata)SCIFIOMetadataTools.castMeta(meta)));
    }

    @Override
    public M getMetadata() {
        return this.metadata;
    }

    @Override
    public void setNormalized(boolean normalize) {
        this.normalizeData = normalize;
    }

    @Override
    public boolean isNormalized() {
        return this.normalizeData;
    }

    @Override
    public boolean hasCompanionFiles() {
        return false;
    }

    @Override
    public void setSource(String fileName) throws IOException {
        this.setSource(fileName, new SCIFIOConfig());
    }

    @Override
    public void setSource(File file) throws IOException {
        this.setSource(file, new SCIFIOConfig());
    }

    @Override
    public void setSource(RandomAccessInputStream stream) throws IOException {
        this.setSource(stream, new SCIFIOConfig());
    }

    @Override
    public void setSource(String fileName, SCIFIOConfig config) throws IOException {
        if (this.getStream() != null && this.getStream().getFileName() != null && this.getStream().getFileName().equals(fileName)) {
            this.getStream().seek(0L);
            return;
        }
        this.close();
        RandomAccessInputStream stream = new RandomAccessInputStream(this.getContext(), fileName);
        try {
            this.setMetadata(this.getFormat().createParser().parse(stream, config));
        }
        catch (FormatException e) {
            stream.close();
            throw new IOException(e);
        }
        this.setSource(stream);
    }

    @Override
    public void setSource(File file, SCIFIOConfig config) throws IOException {
        this.setSource(file.getName(), config);
    }

    @Override
    public void setSource(RandomAccessInputStream stream, SCIFIOConfig config) throws IOException {
        String currentSource = this.getStream() == null ? null : this.getStream().getFileName();
        String newSource = stream.getFileName();
        if (!(this.metadata == null || currentSource != null && newSource != null && this.getStream().getFileName().equals(stream.getFileName()))) {
            this.close();
        }
        if (this.metadata == null) {
            try {
                TypedMetadata meta = (TypedMetadata)this.getFormat().createParser().parse(stream, config);
                this.setMetadata((M)meta);
            }
            catch (FormatException e) {
                throw new IOException(e);
            }
        }
    }

    @Override
    public Plane readPlane(RandomAccessInputStream s, int imageIndex, long[] planeMin, long[] planeMax, Plane plane) throws IOException {
        return this.readPlane(s, imageIndex, planeMin, planeMax, (P)((DataPlane)this.castToTypedPlane(plane)));
    }

    @Override
    public Plane readPlane(RandomAccessInputStream s, int imageIndex, long[] planeMin, long[] planeMax, int scanlinePad, Plane plane) throws IOException {
        return this.readPlane(s, imageIndex, planeMin, planeMax, scanlinePad, (P)((DataPlane)this.castToTypedPlane(plane)));
    }

    @Override
    public long getPlaneCount(int imageIndex) {
        return this.metadata.get(imageIndex).getPlaneCount();
    }

    @Override
    public int getImageCount() {
        return this.metadata.getImageCount();
    }

    public <T extends Plane> T castToTypedPlane(Plane plane) {
        if (!this.planeClass.isAssignableFrom(plane.getClass())) {
            throw new IllegalArgumentException("Incompatible plane types. Attempted to cast: " + plane.getClass() + " to: " + this.planeClass);
        }
        Plane p = plane;
        return (T)p;
    }

    @Override
    public P openPlane(int imageIndex, long planeIndex, P plane) throws FormatException, IOException {
        return this.openPlane(imageIndex, planeIndex, plane, new SCIFIOConfig());
    }

    @Override
    public P openPlane(int imageIndex, long planeIndex, P plane, SCIFIOConfig config) throws FormatException, IOException {
        return (P)this.openPlane(imageIndex, planeIndex, (DataPlane)plane, plane.getOffsets(), plane.getLengths(), config);
    }

    @Override
    public P openPlane(int imageIndex, long planeIndex, P plane, long[] planeMin, long[] planeMax) throws FormatException, IOException {
        return (P)this.openPlane(imageIndex, planeIndex, (DataPlane)plane, plane.getOffsets(), plane.getLengths(), new SCIFIOConfig());
    }

    @Override
    public void setMetadata(M meta) throws IOException {
        if (this.metadata != null && this.metadata != meta) {
            this.close();
        }
        if (this.metadata == null) {
            this.metadata = meta;
        }
    }

    @Override
    public P readPlane(RandomAccessInputStream s, int imageIndex, long[] planeMin, long[] planeMax, P plane) throws IOException {
        return this.readPlane(s, imageIndex, planeMin, planeMax, 0, plane);
    }

    @Override
    public P readPlane(RandomAccessInputStream s, int imageIndex, long[] planeMin, long[] planeMax, int scanlinePad, P plane) throws IOException {
        int bpp = FormatTools.getBytesPerPixel(this.metadata.get(imageIndex).getPixelType());
        byte[] bytes = plane.getBytes();
        int xIndex = this.metadata.get(imageIndex).getAxisIndex(Axes.X);
        int yIndex = this.metadata.get(imageIndex).getAxisIndex(Axes.Y);
        if (SCIFIOMetadataTools.wholePlane(imageIndex, this.metadata, planeMin, planeMax) && scanlinePad == 0) {
            s.read(bytes);
        } else if (SCIFIOMetadataTools.wholeRow(imageIndex, this.metadata, planeMin, planeMax) && scanlinePad == 0) {
            if (this.metadata.get(imageIndex).getInterleavedAxisCount() > 0) {
                int bytesToSkip = bpp;
                int bytesToRead = bytesToSkip = (int)((long)bytesToSkip * planeMax[xIndex]);
                for (int i = 0; i < planeMin.length; ++i) {
                    if (i == xIndex) continue;
                    bytesToSkip = i == yIndex ? (int)((long)bytesToSkip * planeMin[i]) : (int)((long)bytesToSkip * planeMax[i]);
                    bytesToRead = (int)((long)bytesToRead * planeMax[i]);
                }
                s.skip(bytesToSkip);
                s.read(bytes, 0, bytesToRead);
            } else {
                int rowLen = (int)((long)bpp * planeMax[xIndex]);
                int h = (int)planeMax[yIndex];
                int y = (int)planeMin[yIndex];
                long c = this.metadata.get(imageIndex).getAxisLength(Axes.CHANNEL);
                if (c <= 0L || !this.metadata.get(imageIndex).isMultichannel()) {
                    c = 1L;
                }
                int channel = 0;
                while ((long)channel < c) {
                    s.skipBytes(y * rowLen);
                    s.read(bytes, channel * h * rowLen, h * rowLen);
                    if ((long)channel < c - 1L) {
                        s.skipBytes((int)(this.metadata.get(imageIndex).getAxisLength(Axes.Y) - (long)y - (long)h) * rowLen);
                    }
                    ++channel;
                }
            }
        } else {
            int scanlineWidth = (int)this.metadata.get(imageIndex).getAxisLength(Axes.X) + scanlinePad;
            if (this.metadata.get(imageIndex).getInterleavedAxisCount() > 0) {
                long planeProduct = bpp;
                for (int i = 0; i < planeMin.length; ++i) {
                    if (i == xIndex || i == yIndex) continue;
                    planeProduct *= this.metadata.get(imageIndex).getAxisLength(i);
                }
                int bytesToSkip = scanlineWidth * (int)planeProduct;
                s.skipBytes((int)planeMin[yIndex] * bytesToSkip);
                int bytesToRead = bytesToSkip = bpp;
                bytesToRead = (int)((long)bytesToRead * planeMax[xIndex]);
                bytesToRead = (int)((long)bytesToRead * planeProduct);
                bytesToSkip = (int)((long)bytesToSkip * planeMin[xIndex]);
                bytesToSkip = (int)((long)bytesToSkip * planeProduct);
                int row = 0;
                while ((long)row < planeMax[yIndex]) {
                    s.skipBytes(bytesToSkip);
                    s.read(bytes, row * bytesToRead, bytesToRead);
                    if ((long)row < planeMax[yIndex] - 1L) {
                        s.skipBytes((int)(planeProduct * ((long)scanlineWidth - planeMax[xIndex] - planeMin[xIndex])));
                    }
                    ++row;
                }
            } else {
                long c = this.metadata.get(imageIndex).getAxisLength(Axes.CHANNEL);
                int w = (int)planeMax[xIndex];
                int h = (int)planeMax[yIndex];
                int x = (int)planeMin[xIndex];
                int y = (int)planeMin[yIndex];
                int channel = 0;
                while ((long)channel < c) {
                    s.skipBytes(y * scanlineWidth * bpp);
                    for (int row = 0; row < h; ++row) {
                        s.skipBytes(x * bpp);
                        s.read(bytes, channel * w * h * bpp + row * w * bpp, w * bpp);
                        if (row >= h - 1 && (long)channel >= c - 1L) continue;
                        s.skipBytes(bpp * (scanlineWidth - w - x));
                    }
                    if ((long)channel < c - 1L) {
                        s.skipBytes(scanlineWidth * bpp * (int)(this.metadata.get(imageIndex).getAxisLength(Axes.Y) - (long)y - (long)h));
                    }
                    ++channel;
                }
            }
        }
        return plane;
    }

    @Override
    public Class<P> getPlaneClass() {
        return this.planeClass;
    }

    @Override
    public void close(boolean fileOnly) throws IOException {
        if (this.metadata != null) {
            this.metadata.close(fileOnly);
        }
        if (!fileOnly) {
            this.metadata = null;
        }
    }
}

