/*
 * Decompiled with CFR 0.152.
 */
package io.scif;

import io.scif.AbstractHasFormat;
import io.scif.Checker;
import io.scif.config.SCIFIOConfig;
import io.scif.io.RandomAccessInputStream;
import io.scif.util.FormatTools;
import java.io.IOException;

public abstract class AbstractChecker
extends AbstractHasFormat
implements Checker {
    @Override
    public boolean suffixNecessary() {
        return true;
    }

    @Override
    public boolean suffixSufficient() {
        return true;
    }

    @Override
    public boolean isFormat(String name) {
        return this.isFormat(name, new SCIFIOConfig());
    }

    @Override
    public boolean isFormat(String name, SCIFIOConfig config) {
        boolean open = config.checkerIsOpen();
        if (!this.suffixSufficient() && !open) {
            return false;
        }
        if (this.suffixNecessary() || this.suffixSufficient()) {
            boolean suffixMatch = FormatTools.checkSuffix(name, this.getFormat().getSuffixes());
            if (this.suffixNecessary() && !suffixMatch) {
                return false;
            }
            if (suffixMatch && this.suffixSufficient()) {
                return true;
            }
        }
        if (!open) {
            return false;
        }
        try {
            RandomAccessInputStream stream = new RandomAccessInputStream(this.getContext(), name);
            boolean isFormat = this.isFormat(stream);
            stream.close();
            return isFormat;
        }
        catch (IOException exc) {
            this.log().debug((Object)"", (Throwable)exc);
            return false;
        }
    }

    @Override
    public boolean isFormat(RandomAccessInputStream stream) throws IOException {
        return false;
    }

    @Override
    public boolean checkHeader(byte[] block) {
        try {
            RandomAccessInputStream stream = new RandomAccessInputStream(this.getContext(), block);
            boolean isFormat = this.isFormat(stream);
            stream.close();
            return isFormat;
        }
        catch (IOException e) {
            this.log().debug((Object)"", (Throwable)e);
            return false;
        }
    }
}

