/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.jtransforms.fft;

import edu.emory.mathcs.jtransforms.fft.FloatFFT_1D;
import edu.emory.mathcs.jtransforms.fft.FloatFFT_2D;
import edu.emory.mathcs.jtransforms.fft.FloatingPointEqualityChecker;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@RunWith(value=Parameterized.class)
public class FloatFFT_2DTest {
    public static final String DEFAULT_MESSAGE = "%d-threaded FFT of size %dx%d: ";
    public static final int SEED = 20110625;
    private final FloatFFT_1D cfft;
    private final FloatFFT_2D fft;
    private final int numCols;
    private final int numRows;
    private final FloatFFT_1D rfft;
    private final Random random;

    @Parameterized.Parameters
    public static Collection<Object[]> getParameters() {
        int[] nArray = new int[]{2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 16, 32, 64, 100, 120, 128, 256, 310, 511, 512, 1024};
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        for (int i = 0; i < nArray.length; ++i) {
            for (int j = 0; j < nArray.length; ++j) {
                arrayList.add(new Object[]{nArray[i], nArray[j], 1, 20110625});
                arrayList.add(new Object[]{nArray[i], nArray[j], 4, 20110625});
            }
        }
        return arrayList;
    }

    public FloatFFT_2DTest(int n, int n2, int n3, long l) {
        this.numRows = n;
        this.numCols = n2;
        this.rfft = new FloatFFT_1D(n2);
        this.cfft = new FloatFFT_1D(n);
        this.fft = new FloatFFT_2D(n, n2);
        this.random = new Random(l);
        ConcurrencyUtils.setNumberOfThreads(n3);
        ConcurrencyUtils.setThreadsBeginN_2D(4);
    }

    public void complexForward(float[][] fArray) {
        for (int i = 0; i < this.numRows; ++i) {
            this.rfft.complexForward(fArray[i]);
        }
        float[] fArray2 = new float[2 * this.numRows];
        for (int i = 0; i < this.numCols; ++i) {
            int n;
            for (n = 0; n < this.numRows; ++n) {
                fArray2[2 * n] = fArray[n][2 * i];
                fArray2[2 * n + 1] = fArray[n][2 * i + 1];
            }
            this.cfft.complexForward(fArray2);
            for (n = 0; n < this.numRows; ++n) {
                fArray[n][2 * i] = fArray2[2 * n];
                fArray[n][2 * i + 1] = fArray2[2 * n + 1];
            }
        }
    }

    public FloatingPointEqualityChecker createEqualityChecker(float f, float f2) {
        String string = String.format(DEFAULT_MESSAGE, ConcurrencyUtils.getNumberOfThreads(), this.numRows, this.numCols);
        return new FloatingPointEqualityChecker(string, 0.0, 0.0, f, f2);
    }

    @Test
    public void testComplexForward1fInput() {
        float f;
        int n;
        int n2;
        FloatingPointEqualityChecker floatingPointEqualityChecker = this.createEqualityChecker(Math.ulp(1.0f), 0.0f);
        float[] fArray = new float[2 * this.numRows * this.numCols];
        float[][] fArray2 = new float[this.numRows][2 * this.numCols];
        for (n2 = 0; n2 < this.numRows; ++n2) {
            for (n = 0; n < 2 * this.numCols; ++n) {
                fArray[2 * n2 * this.numCols + n] = f = this.random.nextFloat();
                fArray2[n2][n] = f;
            }
        }
        this.fft.complexForward(fArray);
        this.complexForward(fArray2);
        for (n2 = 0; n2 < this.numRows; ++n2) {
            for (n = 0; n < this.numCols; ++n) {
                f = fArray2[n2][n];
                float f2 = fArray[2 * n2 * this.numCols + n];
                floatingPointEqualityChecker.assertEquals("[" + n2 + "][" + n + "]", f, f2);
            }
        }
    }

    @Test
    public void testComplexForward2fInput() {
        float f;
        int n;
        int n2;
        FloatingPointEqualityChecker floatingPointEqualityChecker = this.createEqualityChecker(Math.ulp(1.0f), 0.0f);
        float[][] fArray = new float[this.numRows][2 * this.numCols];
        float[][] fArray2 = new float[this.numRows][2 * this.numCols];
        for (n2 = 0; n2 < this.numRows; ++n2) {
            for (n = 0; n < 2 * this.numCols; ++n) {
                fArray[n2][n] = f = this.random.nextFloat();
                fArray2[n2][n] = f;
            }
        }
        this.fft.complexForward(fArray);
        this.complexForward(fArray2);
        for (n2 = 0; n2 < this.numRows; ++n2) {
            for (n = 0; n < 2 * this.numCols; ++n) {
                f = fArray2[n2][n];
                float f2 = fArray[n2][n];
                floatingPointEqualityChecker.assertEquals("[" + n2 + "][" + n + "]", f, f2);
            }
        }
    }

    @Test
    public void testComplexInverseScaled1fInput() {
        float f;
        int n;
        float f2 = 2.0E-4f;
        float f3 = 0.005f;
        float f4 = f2 * f3;
        FloatingPointEqualityChecker floatingPointEqualityChecker = this.createEqualityChecker(f2, f4);
        float[] fArray = new float[2 * this.numRows * this.numCols];
        float[] fArray2 = new float[2 * this.numRows * this.numCols];
        for (n = 0; n < fArray2.length; ++n) {
            fArray2[n] = f = this.random.nextFloat();
            fArray[n] = f;
        }
        this.fft.complexForward(fArray2);
        this.fft.complexInverse(fArray2, true);
        for (n = 0; n < fArray2.length; ++n) {
            f = fArray[n];
            float f5 = fArray2[n];
            floatingPointEqualityChecker.assertEquals("[" + n + "]", f, f5);
        }
    }

    @Test
    public void testComplexInverseScaled2fInput() {
        float f;
        int n;
        int n2;
        float f2 = 2.0E-4f;
        float f3 = 0.005f;
        float f4 = f2 * f3;
        FloatingPointEqualityChecker floatingPointEqualityChecker = this.createEqualityChecker(f2, f4);
        float[][] fArray = new float[this.numRows][2 * this.numCols];
        float[][] fArray2 = new float[this.numRows][2 * this.numCols];
        for (n2 = 0; n2 < this.numRows; ++n2) {
            for (n = 0; n < 2 * this.numCols; ++n) {
                fArray2[n2][n] = f = this.random.nextFloat();
                fArray[n2][n] = f;
            }
        }
        this.fft.complexForward(fArray2);
        this.fft.complexInverse(fArray2, true);
        for (n2 = 0; n2 < this.numRows; ++n2) {
            for (n = 0; n < 2 * this.numCols; ++n) {
                f = fArray[n2][n];
                float f5 = fArray2[n2][n];
                floatingPointEqualityChecker.assertEquals("[" + n2 + "][" + n + "]", f, f5);
            }
        }
    }

    @Test
    public void testComplexInverseUnScaled1fInput() {
        int n;
        float f = 2.0E-4f;
        float f2 = 0.005f;
        if (this.numRows == 1024 || this.numCols == 1024) {
            f = 0.02f;
            f2 = 0.5f;
            if (this.numRows == 256 || this.numCols == 256) {
                f = 0.04f;
            }
            if (this.numRows == 310 || this.numCols == 310) {
                f = 0.05f;
            }
            if (this.numRows == 511 || this.numCols == 511) {
                f = 0.05f;
                f2 = 0.1f;
            }
            if (this.numRows == 512 || this.numCols == 512) {
                f = 0.04f;
            }
        }
        float f3 = f * f2;
        FloatingPointEqualityChecker floatingPointEqualityChecker = this.createEqualityChecker(f, f3);
        float[] fArray = new float[2 * this.numRows * this.numCols];
        float[] fArray2 = new float[2 * this.numRows * this.numCols];
        for (n = 0; n < fArray2.length; ++n) {
            float f4;
            fArray2[n] = f4 = this.random.nextFloat();
            fArray[n] = f4;
        }
        this.fft.complexForward(fArray2);
        this.fft.complexInverse(fArray2, false);
        n = this.numRows * this.numCols;
        for (int i = 0; i < fArray2.length; ++i) {
            float f5 = (float)n * fArray[i];
            float f6 = fArray2[i];
            floatingPointEqualityChecker.assertEquals("[" + i + "]", f5, f6);
        }
    }

    @Test
    public void testComplexInverseUnScaled2fInput() {
        int n;
        int n2;
        float f = 2.0E-4f;
        float f2 = 0.005f;
        if (this.numRows == 1024 || this.numCols == 1024) {
            f = 0.02f;
            f2 = 0.5f;
            if (this.numRows == 256 || this.numCols == 256) {
                f = 0.04f;
            }
            if (this.numRows == 310 || this.numCols == 310) {
                f = 0.05f;
            }
            if (this.numRows == 511 || this.numCols == 511) {
                f = 0.05f;
                f2 = 0.1f;
            }
            if (this.numRows == 512 || this.numCols == 512) {
                f = 0.04f;
            }
        }
        float f3 = f * f2;
        FloatingPointEqualityChecker floatingPointEqualityChecker = this.createEqualityChecker(f, f3);
        float[][] fArray = new float[this.numRows][2 * this.numCols];
        float[][] fArray2 = new float[this.numRows][2 * this.numCols];
        for (n2 = 0; n2 < this.numRows; ++n2) {
            for (n = 0; n < 2 * this.numCols; ++n) {
                float f4;
                fArray2[n2][n] = f4 = this.random.nextFloat();
                fArray[n2][n] = f4;
            }
        }
        this.fft.complexForward(fArray2);
        this.fft.complexInverse(fArray2, false);
        n2 = this.numRows * this.numCols;
        for (n = 0; n < this.numRows; ++n) {
            for (int i = 0; i < 2 * this.numCols; ++i) {
                float f5 = (float)n2 * fArray[n][i];
                float f6 = fArray2[n][i];
                floatingPointEqualityChecker.assertEquals("[" + n + "][" + i + "]", f5, f6);
            }
        }
    }

    @Test
    public void testRealForward1fInput() {
        int n;
        int n2;
        float f;
        int n3;
        if (!ConcurrencyUtils.isPowerOf2(this.numRows)) {
            return;
        }
        if (!ConcurrencyUtils.isPowerOf2(this.numCols)) {
            return;
        }
        float f2 = 0.005f;
        float f3 = 0.01f;
        if (this.numRows == 1024 || this.numCols == 1024) {
            f2 = 0.01f;
        }
        float f4 = f2 * f3;
        FloatingPointEqualityChecker floatingPointEqualityChecker = this.createEqualityChecker(f2, f4);
        float[] fArray = new float[this.numRows * this.numCols];
        float[][] fArray2 = new float[this.numRows][2 * this.numCols];
        boolean[] blArray = new boolean[this.numRows * this.numCols];
        Arrays.fill(blArray, false);
        for (n3 = 0; n3 < this.numRows; ++n3) {
            for (int i = 0; i < this.numCols; ++i) {
                fArray[n3 * this.numCols + i] = f = this.random.nextFloat();
                fArray2[n3][2 * i] = f;
                fArray2[n3][2 * i + 1] = 0.0f;
            }
        }
        this.fft.realForward(fArray);
        this.complexForward(fArray2);
        for (n2 = 1; n2 < this.numRows; ++n2) {
            for (n = 2; n < this.numCols; ++n) {
                float f5 = fArray2[n2][n];
                n3 = n2 * this.numCols + n;
                f = fArray[n3];
                floatingPointEqualityChecker.assertEquals("[" + n3 + "]", f5, f);
                blArray[n3] = true;
            }
        }
        for (n2 = 2; n2 < this.numCols; ++n2) {
            float f6 = fArray2[0][n2];
            f = fArray[n2];
            floatingPointEqualityChecker.assertEquals("[0][" + n2 + "]", f6, f);
            blArray[n2] = true;
        }
        for (n2 = 1; n2 < this.numRows / 2; ++n2) {
            float f7 = fArray2[n2][0];
            n3 = n2 * this.numCols;
            f = fArray[n2 * this.numCols];
            floatingPointEqualityChecker.assertEquals("[" + n3 + "]", f7, f);
            blArray[n3] = true;
            f7 = fArray2[n2][1];
            n3 = n2 * this.numCols + 1;
            f = fArray[n3];
            floatingPointEqualityChecker.assertEquals("[" + n3 + "]", f7, f);
            blArray[n3] = true;
            f7 = fArray2[this.numRows - n2][this.numCols];
            n3 = (this.numRows - n2) * this.numCols + 1;
            f = fArray[n3];
            floatingPointEqualityChecker.assertEquals("[" + n3 + "]", f7, f);
            blArray[n3] = true;
            f7 = fArray2[this.numRows - n2][this.numCols + 1];
            n3 = (this.numRows - n2) * this.numCols;
            f = fArray[n3];
            floatingPointEqualityChecker.assertEquals("[" + n3 + "]", f7, f);
            blArray[n3] = true;
        }
        float f8 = fArray2[0][0];
        f = fArray[0];
        floatingPointEqualityChecker.assertEquals("[0]", f8, f);
        blArray[0] = true;
        f8 = fArray2[0][this.numCols];
        f = fArray[1];
        floatingPointEqualityChecker.assertEquals("[1]", f8, f);
        blArray[1] = true;
        f8 = fArray2[this.numRows / 2][0];
        n3 = this.numRows / 2 * this.numCols;
        f = fArray[n3];
        floatingPointEqualityChecker.assertEquals("[" + n3 + "]", f8, f);
        blArray[n3] = true;
        f8 = fArray2[this.numRows / 2][this.numCols];
        n3 = this.numRows / 2 * this.numCols + 1;
        f = fArray[n3];
        floatingPointEqualityChecker.assertEquals("[" + this.numRows / 2 + "][" + this.numCols + "]", f8, f);
        blArray[n3] = true;
        for (n2 = 0; n2 < this.numRows; ++n2) {
            for (n = 0; n < this.numCols; ++n) {
                n3 = n2 * this.numCols + n;
                Assert.assertTrue((String)String.format("[%d]", n3), (boolean)blArray[n3]);
            }
        }
    }

    @Test
    public void testRealForward2fInput() {
        int n;
        int n2;
        if (!ConcurrencyUtils.isPowerOf2(this.numRows)) {
            return;
        }
        if (!ConcurrencyUtils.isPowerOf2(this.numCols)) {
            return;
        }
        float f = 0.005f;
        float f2 = 0.01f;
        if (this.numRows == 1024 || this.numCols == 1024) {
            f = 0.01f;
        }
        float f3 = f * f2;
        FloatingPointEqualityChecker floatingPointEqualityChecker = this.createEqualityChecker(f, f3);
        float[][] fArray = new float[this.numRows][this.numCols];
        float[][] fArray2 = new float[this.numRows][2 * this.numCols];
        boolean[][] blArray = new boolean[this.numRows][this.numCols];
        for (int i = 0; i < this.numRows; ++i) {
            for (int j = 0; j < this.numCols; ++j) {
                float f4;
                fArray[i][j] = f4 = this.random.nextFloat();
                fArray2[i][2 * j] = f4;
                fArray2[i][2 * j + 1] = 0.0f;
                blArray[i][j] = false;
            }
        }
        this.fft.realForward(fArray);
        this.complexForward(fArray2);
        for (n2 = 1; n2 < this.numRows; ++n2) {
            for (n = 2; n < this.numCols; ++n) {
                float f5 = fArray2[n2][n];
                float f6 = fArray[n2][n];
                floatingPointEqualityChecker.assertEquals("[" + n2 + "][" + n + "]", f5, f6);
                blArray[n2][n] = true;
            }
        }
        for (n2 = 2; n2 < this.numCols; ++n2) {
            float f7 = fArray2[0][n2];
            float f8 = fArray[0][n2];
            floatingPointEqualityChecker.assertEquals("[0][" + n2 + "]", f7, f8);
            blArray[0][n2] = true;
        }
        for (n2 = 1; n2 < this.numRows / 2; ++n2) {
            float f9 = fArray2[n2][0];
            float f10 = fArray[n2][0];
            floatingPointEqualityChecker.assertEquals("[" + n2 + "][0]", f9, f10);
            blArray[n2][0] = true;
            f9 = fArray2[n2][1];
            f10 = fArray[n2][1];
            floatingPointEqualityChecker.assertEquals("[" + n2 + "][1]", f9, f10);
            blArray[n2][1] = true;
            f9 = fArray2[this.numRows - n2][this.numCols];
            f10 = fArray[this.numRows - n2][1];
            floatingPointEqualityChecker.assertEquals("[" + (this.numRows - n2) + "][1]", f9, f10);
            blArray[this.numRows - n2][1] = true;
            f9 = fArray2[this.numRows - n2][this.numCols + 1];
            f10 = fArray[this.numRows - n2][0];
            floatingPointEqualityChecker.assertEquals("[" + (this.numRows - n2) + "][0]", f9, f10);
            blArray[this.numRows - n2][0] = true;
        }
        float f11 = fArray2[0][0];
        float f12 = fArray[0][0];
        floatingPointEqualityChecker.assertEquals("[0][0]", f11, f12);
        blArray[0][0] = true;
        f11 = fArray2[0][this.numCols];
        f12 = fArray[0][1];
        floatingPointEqualityChecker.assertEquals("[0][1]", f11, f12);
        blArray[0][1] = true;
        f11 = fArray2[this.numRows / 2][0];
        f12 = fArray[this.numRows / 2][0];
        floatingPointEqualityChecker.assertEquals("[" + this.numRows / 2 + "][0]", f11, f12);
        blArray[this.numRows / 2][0] = true;
        f11 = fArray2[this.numRows / 2][this.numCols];
        f12 = fArray[this.numRows / 2][1];
        floatingPointEqualityChecker.assertEquals("[" + this.numRows / 2 + "][1]", f11, f12);
        blArray[this.numRows / 2][1] = true;
        for (n2 = 0; n2 < this.numRows; ++n2) {
            for (n = 0; n < this.numCols; ++n) {
                Assert.assertTrue((String)String.format("[%d][%d]", n2, n), (boolean)blArray[n2][n]);
            }
        }
    }

    @Test
    public void testRealForwardFull1fInput() {
        float f;
        int n;
        int n2;
        float f2 = 2.0E-5f;
        float f3 = 0.005f;
        if (this.numRows == 100 || this.numCols == 100) {
            f2 = Math.max(f2, 0.005f);
        }
        if (this.numRows == 310 || this.numCols == 310) {
            f3 = Math.max(f3, 0.05f);
            f2 = Math.max(f2, 0.01f);
        }
        if (this.numRows == 511 || this.numCols == 511) {
            f3 = Math.max(f3, 0.05f);
            f2 = Math.max(f2, 0.02f);
        }
        if (this.numRows == 512 || this.numCols == 512) {
            f3 = Math.max(f3, 0.01f);
            f2 = Math.max(f2, 0.02f);
        }
        if (this.numRows == 1024 || this.numCols == 1024) {
            f3 = Math.max(f3, 0.01f);
            f2 = Math.max(f2, 0.02f);
        }
        if (this.numRows == 1024 && (this.numCols == 310 || this.numCols == 511)) {
            f2 = Math.max(f2, 0.04f);
        }
        float f4 = f2 * f3;
        FloatingPointEqualityChecker floatingPointEqualityChecker = this.createEqualityChecker(f2, f4);
        float[] fArray = new float[2 * this.numRows * this.numCols];
        float[][] fArray2 = new float[this.numRows][2 * this.numCols];
        for (n2 = 0; n2 < this.numRows; ++n2) {
            for (n = 0; n < this.numCols; ++n) {
                fArray[n2 * this.numCols + n] = f = this.random.nextFloat();
                fArray2[n2][2 * n] = f;
                fArray2[n2][2 * n + 1] = 0.0f;
            }
        }
        this.fft.realForwardFull(fArray);
        this.complexForward(fArray2);
        for (n2 = 0; n2 < this.numRows; ++n2) {
            for (n = 0; n < 2 * this.numCols; ++n) {
                f = fArray2[n2][n];
                int n3 = 2 * n2 * this.numCols + n;
                float f5 = fArray[n3];
                floatingPointEqualityChecker.assertEquals("[" + n3 + "]", f, f5);
            }
        }
    }

    @Test
    public void testRealForwardFull2fInput() {
        float f;
        int n;
        int n2;
        float f2 = 2.0E-5f;
        float f3 = 0.005f;
        if (this.numRows == 100 || this.numCols == 100) {
            f2 = Math.max(f2, 0.005f);
        }
        if (this.numRows == 310 || this.numCols == 310) {
            f3 = Math.max(f3, 0.05f);
            f2 = Math.max(f2, 0.01f);
        }
        if (this.numRows == 511 || this.numCols == 511) {
            f3 = Math.max(f3, 0.05f);
            f2 = Math.max(f2, 0.02f);
        }
        if (this.numRows == 512 || this.numCols == 512) {
            f3 = Math.max(f3, 0.01f);
            f2 = Math.max(f2, 0.02f);
        }
        if (this.numRows == 1024 || this.numCols == 1024) {
            f3 = Math.max(f3, 0.01f);
            f2 = Math.max(f2, 0.02f);
        }
        if (this.numRows == 1024 && (this.numCols == 310 || this.numCols == 511)) {
            f2 = Math.max(f2, 0.04f);
        }
        float f4 = f2 * f3;
        FloatingPointEqualityChecker floatingPointEqualityChecker = this.createEqualityChecker(f2, f4);
        float[][] fArray = new float[this.numRows][2 * this.numCols];
        float[][] fArray2 = new float[this.numRows][2 * this.numCols];
        for (n2 = 0; n2 < this.numRows; ++n2) {
            for (n = 0; n < this.numCols; ++n) {
                fArray[n2][n] = f = this.random.nextFloat();
                fArray2[n2][2 * n] = f;
                fArray2[n2][2 * n + 1] = 0.0f;
            }
        }
        this.fft.realForwardFull(fArray);
        this.complexForward(fArray2);
        for (n2 = 0; n2 < this.numRows; ++n2) {
            for (n = 0; n < 2 * this.numCols; ++n) {
                f = fArray2[n2][n];
                float f5 = fArray[n2][n];
                floatingPointEqualityChecker.assertEquals("[" + n2 + "][" + n + "]", f, f5);
            }
        }
    }

    @Test
    public void testRealInverseFullScaled1fInput() {
        float f;
        int n;
        FloatingPointEqualityChecker floatingPointEqualityChecker = this.createEqualityChecker(1.0E-7f, 1.0E-7f);
        float[] fArray = new float[2 * this.numRows * this.numCols];
        float[] fArray2 = new float[2 * this.numRows * this.numCols];
        for (n = 0; n < this.numRows; ++n) {
            for (int i = 0; i < this.numCols; ++i) {
                f = this.random.nextFloat();
                int n2 = n * this.numCols + i;
                fArray[n2] = f;
                fArray2[2 * n2] = f;
                fArray2[2 * n2 + 1] = 0.0f;
            }
        }
        this.fft.complexInverse(fArray2, true);
        this.fft.realInverseFull(fArray, true);
        for (n = 0; n < fArray.length; ++n) {
            float f2 = fArray2[n];
            f = fArray[n];
            floatingPointEqualityChecker.assertEquals("[" + n + "]", f2, f);
        }
    }

    @Test
    public void testRealInverseFullScaled2fInput() {
        float f;
        int n;
        int n2;
        FloatingPointEqualityChecker floatingPointEqualityChecker = this.createEqualityChecker(1.0E-7f, 1.0E-7f);
        float[][] fArray = new float[this.numRows][2 * this.numCols];
        float[][] fArray2 = new float[this.numRows][2 * this.numCols];
        for (n2 = 0; n2 < this.numRows; ++n2) {
            for (n = 0; n < this.numCols; ++n) {
                fArray[n2][n] = f = this.random.nextFloat();
                fArray2[n2][2 * n] = f;
                fArray2[n2][2 * n + 1] = 0.0f;
            }
        }
        this.fft.realInverseFull(fArray, true);
        this.fft.complexInverse(fArray2, true);
        for (n2 = 0; n2 < this.numRows; ++n2) {
            for (n = 0; n < 2 * this.numCols; ++n) {
                f = fArray2[n2][n];
                float f2 = fArray[n2][n];
                floatingPointEqualityChecker.assertEquals("[" + n2 + "][" + n + "]", f, f2);
            }
        }
    }

    @Test
    public void testRealInverseFullUnscaled1fInput() {
        float f;
        int n;
        float f2 = 2.0E-5f;
        float f3 = 5.0E-7f;
        if (this.numRows == 310 && this.numCols == 1024 || this.numRows == 1024 && this.numCols == 310) {
            f2 = 0.1f;
            f3 = 0.002f;
        }
        if (this.numRows == 511 && this.numCols == 1024) {
            f2 = 0.001f;
            f3 = 0.05f;
        }
        if (this.numRows == 1024 && this.numCols == 511) {
            f2 = 0.5f;
            f3 = 0.05f;
        }
        if (this.numRows == 1024 || this.numCols == 1024) {
            f2 = Math.max(f2, 0.01f);
            f3 = Math.max(f3, 0.02f);
        }
        float f4 = f2 * f3;
        FloatingPointEqualityChecker floatingPointEqualityChecker = this.createEqualityChecker(f2, f4);
        float[] fArray = new float[2 * this.numRows * this.numCols];
        float[] fArray2 = new float[2 * this.numRows * this.numCols];
        for (n = 0; n < this.numRows; ++n) {
            for (int i = 0; i < this.numCols; ++i) {
                f = this.random.nextFloat();
                int n2 = n * this.numCols + i;
                fArray[n2] = f;
                fArray2[2 * n2] = f;
                fArray2[2 * n2 + 1] = 0.0f;
            }
        }
        this.fft.complexInverse(fArray2, false);
        this.fft.realInverseFull(fArray, false);
        for (n = 0; n < fArray.length; ++n) {
            float f5 = fArray2[n];
            f = fArray[n];
            floatingPointEqualityChecker.assertEquals("[" + n + "]", f5, f);
        }
    }

    @Test
    public void testRealInverseFullUnscaled2fInput() {
        float f;
        int n;
        int n2;
        float f2 = 2.0E-5f;
        float f3 = 5.0E-7f;
        if (this.numRows == 310 && this.numCols == 1024 || this.numRows == 1024 && this.numCols == 310) {
            f2 = 0.1f;
            f3 = 0.002f;
        }
        if (this.numRows == 511 && this.numCols == 1024) {
            f2 = 0.001f;
            f3 = 0.05f;
        }
        if (this.numRows == 1024 && this.numCols == 511) {
            f2 = 0.5f;
            f3 = 0.05f;
        }
        if (this.numRows == 1024 || this.numCols == 1024) {
            f2 = Math.max(f2, 0.01f);
            f3 = Math.max(f3, 0.02f);
        }
        float f4 = f2 * f3;
        FloatingPointEqualityChecker floatingPointEqualityChecker = this.createEqualityChecker(f2, f4);
        float[][] fArray = new float[this.numRows][2 * this.numCols];
        float[][] fArray2 = new float[this.numRows][2 * this.numCols];
        for (n2 = 0; n2 < this.numRows; ++n2) {
            for (n = 0; n < this.numCols; ++n) {
                fArray[n2][n] = f = this.random.nextFloat();
                fArray2[n2][2 * n] = f;
                fArray2[n2][2 * n + 1] = 0.0f;
            }
        }
        this.fft.realInverseFull(fArray, false);
        this.fft.complexInverse(fArray2, false);
        for (n2 = 0; n2 < this.numRows; ++n2) {
            for (n = 0; n < 2 * this.numCols; ++n) {
                f = fArray2[n2][n];
                float f5 = fArray[n2][n];
                floatingPointEqualityChecker.assertEquals("[" + n2 + "][" + n + "]", f, f5);
            }
        }
    }

    @Test
    public void testRealInverseScaled1fInput() {
        float f;
        int n;
        float f2 = 5.0E-4f;
        float f3 = 0.005f;
        float f4 = f2 * f3;
        FloatingPointEqualityChecker floatingPointEqualityChecker = this.createEqualityChecker(f2, f4);
        if (!ConcurrencyUtils.isPowerOf2(this.numRows)) {
            return;
        }
        if (!ConcurrencyUtils.isPowerOf2(this.numCols)) {
            return;
        }
        float[] fArray = new float[this.numRows * this.numCols];
        float[] fArray2 = new float[fArray.length];
        for (n = 0; n < fArray.length; ++n) {
            fArray[n] = f = this.random.nextFloat();
            fArray2[n] = f;
        }
        this.fft.realForward(fArray);
        this.fft.realInverse(fArray, true);
        for (n = 0; n < fArray.length; ++n) {
            f = fArray2[n];
            float f5 = fArray[n];
            floatingPointEqualityChecker.assertEquals("[" + n + "]", f, f5);
        }
    }

    @Test
    public void testRealInverseScaled2fInput() {
        float f;
        int n;
        int n2;
        float f2 = 5.0E-4f;
        float f3 = 0.005f;
        float f4 = f2 * f3;
        FloatingPointEqualityChecker floatingPointEqualityChecker = this.createEqualityChecker(f2, f4);
        if (!ConcurrencyUtils.isPowerOf2(this.numRows)) {
            return;
        }
        if (!ConcurrencyUtils.isPowerOf2(this.numCols)) {
            return;
        }
        float[][] fArray = new float[this.numRows][this.numCols];
        float[][] fArray2 = new float[this.numRows][this.numCols];
        for (n2 = 0; n2 < this.numRows; ++n2) {
            for (n = 0; n < this.numCols; ++n) {
                fArray[n2][n] = f = this.random.nextFloat();
                fArray2[n2][n] = f;
            }
        }
        this.fft.realForward(fArray);
        this.fft.realInverse(fArray, true);
        for (n2 = 0; n2 < this.numRows; ++n2) {
            for (n = 0; n < this.numCols; ++n) {
                f = fArray2[n2][n];
                float f5 = fArray[n2][n];
                floatingPointEqualityChecker.assertEquals("[" + n2 + "][" + n + "]", f, f5);
            }
        }
    }
}

