/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.neighborhood;

import net.imglib2.Interval;
import net.imglib2.Localizable;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessible;
import net.imglib2.algorithm.neighborhood.HyperSphereNeighborhoodFactory;
import net.imglib2.algorithm.neighborhood.HypersphereNeighborhoodLocalizableSampler;
import net.imglib2.algorithm.neighborhood.Neighborhood;

public class HyperSphereNeighborhoodRandomAccess<T>
extends HypersphereNeighborhoodLocalizableSampler<T>
implements RandomAccess<Neighborhood<T>> {
    public HyperSphereNeighborhoodRandomAccess(RandomAccessible<T> source, long radius, HyperSphereNeighborhoodFactory<T> factory) {
        super(source, radius, factory, null);
    }

    public HyperSphereNeighborhoodRandomAccess(RandomAccessible<T> source, long radius, HyperSphereNeighborhoodFactory<T> factory, Interval interval) {
        super(source, radius, factory, interval);
    }

    protected HyperSphereNeighborhoodRandomAccess(HyperSphereNeighborhoodRandomAccess<T> c) {
        super(c);
    }

    public void fwd(int d) {
        int n = d;
        this.currentPos[n] = this.currentPos[n] + 1L;
    }

    public void bck(int d) {
        int n = d;
        this.currentPos[n] = this.currentPos[n] - 1L;
    }

    public void move(int distance, int d) {
        int n = d;
        this.currentPos[n] = this.currentPos[n] + (long)distance;
    }

    public void move(long distance, int d) {
        int n = d;
        this.currentPos[n] = this.currentPos[n] + distance;
    }

    public void move(Localizable localizable) {
        for (int d = 0; d < this.n; ++d) {
            int n = d;
            this.currentPos[n] = this.currentPos[n] + localizable.getLongPosition(d);
        }
    }

    public void move(int[] distance) {
        for (int d = 0; d < this.n; ++d) {
            int n = d;
            this.currentPos[n] = this.currentPos[n] + (long)distance[d];
        }
    }

    public void move(long[] distance) {
        for (int d = 0; d < this.n; ++d) {
            int n = d;
            this.currentPos[n] = this.currentPos[n] + distance[d];
        }
    }

    public void setPosition(Localizable localizable) {
        for (int d = 0; d < this.n; ++d) {
            this.currentPos[d] = localizable.getLongPosition(d);
        }
    }

    public void setPosition(int[] position) {
        for (int d = 0; d < this.n; ++d) {
            this.currentPos[d] = position[d];
        }
    }

    public void setPosition(long[] position) {
        for (int d = 0; d < this.n; ++d) {
            this.currentPos[d] = position[d];
        }
    }

    public void setPosition(int position, int d) {
        this.currentPos[d] = position;
    }

    public void setPosition(long position, int d) {
        this.currentPos[d] = position;
    }

    public HyperSphereNeighborhoodRandomAccess<T> copy() {
        return new HyperSphereNeighborhoodRandomAccess<T>(this);
    }

    public HyperSphereNeighborhoodRandomAccess<T> copyRandomAccess() {
        return this.copy();
    }
}

