/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.morphology;

import java.util.List;
import net.imglib2.Dimensions;
import net.imglib2.Interval;
import net.imglib2.IterableInterval;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.algorithm.morphology.Dilation;
import net.imglib2.algorithm.morphology.Erosion;
import net.imglib2.algorithm.morphology.MorphologyUtils;
import net.imglib2.algorithm.neighborhood.Shape;
import net.imglib2.img.Img;
import net.imglib2.img.ImgFactory;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.RealType;
import net.imglib2.view.ExtendedRandomAccessibleInterval;
import net.imglib2.view.IntervalView;
import net.imglib2.view.Views;

public class Closing {
    public static final <T extends RealType<T>> Img<T> close(Img<T> source, List<Shape> strels, int numThreads) {
        Img<T> dilated = Dilation.dilate(source, strels, numThreads);
        Img<T> eroded = Erosion.erode(dilated, strels, numThreads);
        return eroded;
    }

    public static final <T extends Type<T> & Comparable<T>> Img<T> close(Img<T> source, List<Shape> strels, T minVal, T maxVal, int numThreads) {
        Img<T> dilated = Dilation.dilate(source, strels, minVal, numThreads);
        Img<T> eroded = Erosion.erode(dilated, strels, maxVal, numThreads);
        return eroded;
    }

    public static final <T extends RealType<T>> Img<T> close(Img<T> source, Shape strel, int numThreads) {
        Img<T> dilated = Dilation.dilate(source, strel, numThreads);
        Img<T> eroded = Erosion.erode(dilated, strel, numThreads);
        return eroded;
    }

    public static final <T extends Type<T> & Comparable<T>> Img<T> close(Img<T> source, Shape strel, T minVal, T maxVal, int numThreads) {
        Img<T> dilated = Dilation.dilate(source, strel, minVal, numThreads);
        Img<T> eroded = Erosion.erode(dilated, strel, maxVal, numThreads);
        return eroded;
    }

    public static <T extends RealType<T>> void close(RandomAccessible<T> source, IterableInterval<T> target, List<Shape> strels, int numThreads) {
        RealType maxVal = (RealType)MorphologyUtils.createVariable(source, target);
        maxVal.setReal(maxVal.getMaxValue());
        RealType minVal = (RealType)MorphologyUtils.createVariable(source, target);
        minVal.setReal(minVal.getMinValue());
        Closing.close(source, target, strels, minVal, maxVal, numThreads);
    }

    public static <T extends Type<T> & Comparable<T>> void close(RandomAccessible<T> source, IterableInterval<T> target, List<Shape> strels, T minVal, T maxVal, int numThreads) {
        ImgFactory<T> factory = MorphologyUtils.getSuitableFactory(target, maxVal);
        Img img = factory.create(target, maxVal);
        long[] min = new long[target.numDimensions()];
        target.min(min);
        IntervalView translated = Views.translate((RandomAccessibleInterval)img, (long[])min);
        Dilation.dilate(source, translated, strels, minVal, numThreads);
        ExtendedRandomAccessibleInterval extended = Views.extendValue((RandomAccessibleInterval)translated, maxVal);
        Erosion.erode(extended, target, strels, maxVal, numThreads);
    }

    public static <T extends RealType<T>> void close(RandomAccessible<T> source, IterableInterval<T> target, Shape strel, int numThreads) {
        RealType maxVal = (RealType)MorphologyUtils.createVariable(source, target);
        maxVal.setReal(maxVal.getMaxValue());
        RealType minVal = (RealType)MorphologyUtils.createVariable(source, target);
        minVal.setReal(minVal.getMinValue());
        Closing.close(source, target, strel, minVal, maxVal, numThreads);
    }

    public static <T extends Type<T> & Comparable<T>> void close(RandomAccessible<T> source, IterableInterval<T> target, Shape strel, T minVal, T maxVal, int numThreads) {
        ImgFactory<T> factory = MorphologyUtils.getSuitableFactory(target, minVal);
        Img img = factory.create(target, minVal);
        long[] min = new long[target.numDimensions()];
        target.min(min);
        IntervalView translated = Views.translate((RandomAccessibleInterval)img, (long[])min);
        Dilation.dilate(source, translated, strel, minVal, numThreads);
        ExtendedRandomAccessibleInterval extended = Views.extendValue((RandomAccessibleInterval)translated, maxVal);
        Erosion.erode(extended, target, strel, maxVal, numThreads);
    }

    public static <T extends RealType<T>> void closeInPlace(RandomAccessibleInterval<T> source, Interval interval, List<Shape> strels, int numThreads) {
        RealType maxVal = (RealType)MorphologyUtils.createVariable(source, interval);
        maxVal.setReal(maxVal.getMaxValue());
        RealType minVal = (RealType)MorphologyUtils.createVariable(source, interval);
        minVal.setReal(minVal.getMinValue());
        Closing.closeInPlace(source, interval, strels, minVal, maxVal, numThreads);
    }

    public static <T extends Type<T> & Comparable<T>> void closeInPlace(RandomAccessibleInterval<T> source, Interval interval, List<Shape> strels, T minVal, T maxVal, int numThreads) {
        for (Shape strel : strels) {
            Closing.closeInPlace(source, interval, strel, minVal, maxVal, numThreads);
        }
    }

    public static <T extends RealType<T>> void closeInPlace(RandomAccessibleInterval<T> source, Interval interval, Shape strel, int numThreads) {
        RealType maxVal = (RealType)MorphologyUtils.createVariable(source, interval);
        maxVal.setReal(maxVal.getMaxValue());
        RealType minVal = (RealType)MorphologyUtils.createVariable(source, interval);
        minVal.setReal(minVal.getMinValue());
        Closing.closeInPlace(source, interval, strel, minVal, maxVal, numThreads);
    }

    public static <T extends Type<T> & Comparable<T>> void closeInPlace(RandomAccessibleInterval<T> source, Interval interval, Shape strel, T minVal, T maxVal, int numThreads) {
        ExtendedRandomAccessibleInterval extended = Views.extendValue(source, maxVal);
        ImgFactory<T> factory = MorphologyUtils.getSuitableFactory((Dimensions)interval, maxVal);
        Img img = factory.create((Dimensions)interval, maxVal);
        long[] min = new long[interval.numDimensions()];
        interval.min(min);
        IntervalView translated = Views.translate((RandomAccessibleInterval)img, (long[])min);
        Closing.close(extended, translated, strel, minVal, maxVal, numThreads);
        MorphologyUtils.copy(translated, extended, numThreads);
    }

    private Closing() {
    }
}

