/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.gauss;

import net.imglib2.Dimensions;
import net.imglib2.Interval;
import net.imglib2.Localizable;
import net.imglib2.Point;
import net.imglib2.RandomAccessible;
import net.imglib2.algorithm.gauss.AbstractGauss;
import net.imglib2.algorithm.gauss.SamplingLineIterator;
import net.imglib2.img.Img;
import net.imglib2.img.ImgFactory;
import net.imglib2.img.NativeImg;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.img.array.ArrayImgFactory;
import net.imglib2.img.basictypeaccess.array.FloatArray;
import net.imglib2.img.cell.CellImgFactory;
import net.imglib2.outofbounds.OutOfBoundsFactory;
import net.imglib2.outofbounds.OutOfBoundsMirrorFactory;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.view.Views;

@Deprecated
public final class GaussFloat
extends AbstractGauss<FloatType> {
    protected boolean isArray;

    public GaussFloat(double[] sigma, RandomAccessible<FloatType> input, Interval interval, ImgFactory<FloatType> factory) {
        super(sigma, input, interval, factory.create((Dimensions)interval, (Object)new FloatType()), (Localizable)new Point(sigma.length), factory, new FloatType());
    }

    public GaussFloat(double[] sigma, RandomAccessible<FloatType> input, Interval interval, RandomAccessible<FloatType> output, Localizable outputOffset, ImgFactory<FloatType> factory) {
        super(sigma, input, interval, output, outputOffset, factory, new FloatType());
    }

    public GaussFloat(double[] sigma, Img<FloatType> input) {
        this(sigma, (RandomAccessible<FloatType>)Views.extend(input, (OutOfBoundsFactory)new OutOfBoundsMirrorFactory(OutOfBoundsMirrorFactory.Boundary.SINGLE)), (Interval)input, (ImgFactory<FloatType>)input.factory());
    }

    public GaussFloat(double[] sigma, Img<FloatType> input, OutOfBoundsFactory<FloatType, Img<FloatType>> outOfBounds) {
        this(sigma, (RandomAccessible<FloatType>)Views.extend(input, outOfBounds), (Interval)input, (ImgFactory<FloatType>)input.factory());
    }

    public static Img<FloatType> gauss(double[] sigma, Img<FloatType> input) {
        GaussFloat gauss = new GaussFloat(sigma, input);
        gauss.call();
        return (Img)gauss.getResult();
    }

    public static Img<FloatType> gauss(double[] sigma, Img<FloatType> input, OutOfBoundsFactory<FloatType, Img<FloatType>> outOfBounds) {
        GaussFloat gauss = new GaussFloat(sigma, input, outOfBounds);
        gauss.call();
        return (Img)gauss.getResult();
    }

    public static Img<FloatType> gauss(double[] sigma, RandomAccessible<FloatType> input, Interval interval, ImgFactory<FloatType> factory) {
        GaussFloat gauss = new GaussFloat(sigma, input, interval, factory);
        gauss.call();
        return (Img)gauss.getResult();
    }

    public static void gauss(double[] sigma, RandomAccessible<FloatType> input, Interval interval, RandomAccessible<FloatType> output, Localizable outputOffset, ImgFactory<FloatType> factory) {
        GaussFloat gauss = new GaussFloat(sigma, input, interval, output, outputOffset, factory);
        gauss.call();
    }

    @Override
    protected Img<FloatType> getProcessingLine(long sizeProcessLine) {
        ArrayImg processLine;
        if (sizeProcessLine <= Integer.MAX_VALUE) {
            this.isArray = true;
            processLine = new ArrayImgFactory().create(new long[]{sizeProcessLine}, (NativeType)new FloatType());
        } else {
            this.isArray = false;
            processLine = new CellImgFactory(0x7FFFFFF).create(new long[]{sizeProcessLine}, (NativeType)new FloatType());
        }
        return processLine;
    }

    @Override
    protected void processLine(SamplingLineIterator<FloatType> input, double[] kernel) {
        if (!this.isArray()) {
            super.processLine(input, kernel);
            return;
        }
        int kernelSize = kernel.length;
        int kernelSizeMinus1 = kernelSize - 1;
        int kernelSizeHalf = kernelSize / 2;
        int kernelSizeHalfMinus1 = kernelSizeHalf - 1;
        float[] v = ((FloatArray)((NativeImg)input.getProcessLine()).update(null)).getCurrentStorageArray();
        int imgSize = v.length;
        int indexLeft = 0;
        int indexRight = 0;
        if (imgSize >= kernelSize) {
            v[0] = v[0] + (float)((double)input.get().get() * kernel[0]);
            for (int i = 1; i < kernelSizeMinus1; ++i) {
                input.fwd();
                float copy = input.get().get();
                indexLeft = -1;
                for (int o = 0; o <= i; ++o) {
                    int n = ++indexLeft;
                    v[n] = v[n] + (float)((double)copy * kernel[i - o]);
                }
            }
            int length = imgSize - kernelSizeMinus1;
            for (int n = 0; n < length; ++n) {
                input.fwd();
                float copy = input.get().get();
                indexLeft = n;
                indexRight = n + kernelSizeMinus1;
                for (int k = 0; k < kernelSizeHalfMinus1; ++k) {
                    float tmp = (float)((double)copy * kernel[k]);
                    int n2 = indexLeft++;
                    v[n2] = v[n2] + tmp;
                    int n3 = indexRight--;
                    v[n3] = v[n3] + tmp;
                }
                float tmp = (float)((double)copy * kernel[kernelSizeHalfMinus1]);
                int n4 = indexLeft++;
                v[n4] = v[n4] + tmp;
                int n5 = indexRight;
                v[n5] = v[n5] + tmp;
                int n6 = indexLeft;
                v[n6] = v[n6] + (float)((double)copy * kernel[kernelSizeHalf]);
            }
            int endLength = imgSize + kernelSizeMinus1;
            for (int i = imgSize; i < endLength; ++i) {
                input.fwd();
                float copy = input.get().get();
                indexLeft = i - kernelSize;
                int k = 0;
                for (long o = (long)(i - kernelSize + 1); o < (long)imgSize; ++o) {
                    int n = ++indexLeft;
                    v[n] = v[n] + (float)((double)copy * kernel[k++]);
                }
            }
        } else {
            int o;
            float copy;
            int i;
            v[0] = v[0] + (float)((double)input.get().get() * kernel[0]);
            for (i = 1; i < imgSize; ++i) {
                input.fwd();
                copy = input.get().get();
                indexLeft = -1;
                for (o = 0; o <= i; ++o) {
                    int n = ++indexLeft;
                    v[n] = v[n] + (float)((double)copy * kernel[i - o]);
                }
            }
            for (i = imgSize; i < imgSize + kernelSizeMinus1; ++i) {
                input.fwd();
                copy = input.get().get();
                o = i - kernelSize + 1;
                int k = 0;
                if (o < 0) {
                    k = -o;
                    o = 0;
                }
                while (o < imgSize) {
                    int n = o++;
                    v[n] = v[n] + (float)((double)copy * kernel[k++]);
                }
            }
        }
    }

    protected boolean isArray() {
        return this.isArray;
    }
}

