/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.image.invert;

import net.imagej.ops.Ops;
import net.imagej.ops.special.computer.AbstractUnaryComputerOp;
import net.imagej.ops.special.computer.Computers;
import net.imagej.ops.special.computer.UnaryComputerOp;
import net.imglib2.IterableInterval;
import net.imglib2.type.numeric.RealType;
import org.scijava.plugin.Plugin;

@Plugin(type=Ops.Image.Invert.class, priority=1.0)
public class InvertII<I extends RealType<I>, O extends RealType<O>>
extends AbstractUnaryComputerOp<IterableInterval<I>, IterableInterval<O>>
implements Ops.Image.Invert {
    private UnaryComputerOp<IterableInterval<I>, IterableInterval<O>> mapper;

    @Override
    public void initialize() {
        RealType inType = (RealType)((RealType)((IterableInterval)this.in()).firstElement()).createVariable();
        double minVal = inType.getMinValue();
        AbstractUnaryComputerOp invert = minVal < 0.0 ? new SignedRealInvert() : new UnsignedRealInvert(inType.getMaxValue());
        this.mapper = Computers.unary(this.ops(), Ops.Map.class, this.out(), this.in(), invert);
    }

    @Override
    public void compute(IterableInterval<I> input, IterableInterval<O> output) {
        this.mapper.compute(input, output);
    }

    private class UnsignedRealInvert<II extends RealType<II>, OO extends RealType<OO>>
    extends AbstractUnaryComputerOp<II, OO> {
        private final double max;

        public UnsignedRealInvert(double max) {
            this.max = max;
        }

        @Override
        public void compute(II x, OO output) {
            double value = this.max - x.getRealDouble();
            output.setReal(value);
        }
    }

    private class SignedRealInvert<II extends RealType<II>, OO extends RealType<OO>>
    extends AbstractUnaryComputerOp<II, OO> {
        private SignedRealInvert() {
        }

        @Override
        public void compute(II x, OO output) {
            double value = x.getRealDouble() * -1.0 - 1.0;
            output.setReal(value);
        }
    }
}

