/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.geom.geom3d;

import net.imagej.ops.Contingent;
import net.imagej.ops.Ops;
import net.imagej.ops.geom.geom3d.mesh.Facet;
import net.imagej.ops.geom.geom3d.mesh.Mesh;
import net.imagej.ops.geom.geom3d.mesh.TriangularFacet;
import net.imagej.ops.special.function.AbstractUnaryFunctionOp;
import net.imglib2.type.numeric.real.DoubleType;
import org.apache.commons.math3.geometry.Vector;
import org.apache.commons.math3.geometry.euclidean.threed.Vector3D;
import org.scijava.plugin.Plugin;

@Plugin(type=Ops.Geometric.Size.class, label="Geometric3D: Volume", priority=9999.0)
public class DefaultVolumeMesh
extends AbstractUnaryFunctionOp<Mesh, DoubleType>
implements Ops.Geometric.Size,
Contingent {
    @Override
    public DoubleType calculate(Mesh input) {
        double volume = 0.0;
        for (Facet f : input.getFacets()) {
            TriangularFacet tf = (TriangularFacet)f;
            volume += this.signedVolumeOfTriangle(tf.getP0(), tf.getP1(), tf.getP2());
        }
        return new DoubleType(Math.abs(volume));
    }

    private double signedVolumeOfTriangle(Vector3D p0, Vector3D p1, Vector3D p2) {
        return p0.dotProduct((Vector)p1.crossProduct((Vector)p2)) / 6.0;
    }

    @Override
    public boolean conforms() {
        return ((Mesh)this.in()).triangularFacets();
    }
}

