/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.filter.fftSize;

import net.imagej.ops.AbstractOp;
import net.imagej.ops.Ops;
import net.imglib2.Dimensions;
import net.imglib2.algorithm.fft2.FFTMethods;
import org.scijava.ItemIO;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Ops.Filter.FFTSize.class)
public class ComputeFFTSize
extends AbstractOp
implements Ops.Filter.FFTSize {
    @Parameter
    private Dimensions inputDimensions;
    @Parameter(type=ItemIO.BOTH)
    private long[] paddedSize;
    @Parameter(type=ItemIO.BOTH)
    private long[] fftSize;
    @Parameter
    private boolean forward;
    @Parameter
    private boolean fast;

    public void run() {
        if (this.fast && this.forward) {
            FFTMethods.dimensionsRealToComplexFast((Dimensions)this.inputDimensions, (long[])this.paddedSize, (long[])this.fftSize);
        } else if (!this.fast && this.forward) {
            FFTMethods.dimensionsRealToComplexSmall((Dimensions)this.inputDimensions, (long[])this.paddedSize, (long[])this.fftSize);
        }
        if (this.fast && !this.forward) {
            FFTMethods.dimensionsComplexToRealFast((Dimensions)this.inputDimensions, (long[])this.paddedSize, (long[])this.fftSize);
        } else if (!this.fast && !this.forward) {
            FFTMethods.dimensionsComplexToRealSmall((Dimensions)this.inputDimensions, (long[])this.paddedSize, (long[])this.fftSize);
        }
    }
}

