/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ui.awt.menu;

import java.awt.Menu;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import org.scijava.input.Accelerator;
import org.scijava.menu.AbstractMenuCreator;
import org.scijava.menu.ShadowMenu;
import org.scijava.module.ModuleInfo;

public abstract class AbstractAWTMenuCreator<T>
extends AbstractMenuCreator<T, Menu> {
    protected void addLeafToMenu(ShadowMenu shadow, Menu target) {
        MenuItem menuItem = this.createLeaf(shadow);
        target.add(menuItem);
    }

    protected Menu addNonLeafToMenu(ShadowMenu shadow, Menu target) {
        Menu menu = this.createNonLeaf(shadow);
        target.add(menu);
        return menu;
    }

    protected void addSeparatorToMenu(Menu target) {
        target.addSeparator();
    }

    protected MenuItem createLeaf(ShadowMenu shadow) {
        MenuItem menuItem = new MenuItem(shadow.getMenuEntry().getName());
        this.assignProperties(menuItem, shadow);
        this.linkAction(shadow, menuItem);
        return menuItem;
    }

    protected Menu createNonLeaf(ShadowMenu shadow) {
        Menu menu = new Menu(shadow.getMenuEntry().getName());
        this.assignProperties(menu, shadow);
        return menu;
    }

    private void assignProperties(MenuItem menuItem, ShadowMenu shadow) {
        ModuleInfo info;
        Accelerator acc = shadow.getMenuEntry().getAccelerator();
        if (acc != null) {
            int code = acc.getKeyCode().getCode();
            boolean shift = acc.getModifiers().isShiftDown();
            MenuShortcut shortcut = new MenuShortcut(code, shift);
            menuItem.setShortcut(shortcut);
        }
        if ((info = shadow.getModuleInfo()) != null) {
            menuItem.setEnabled(info.isEnabled());
        }
    }

    private void linkAction(final ShadowMenu shadow, MenuItem menuItem) {
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                shadow.run();
            }
        });
    }
}

