/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.plugins.commands.debug;

import java.net.URL;
import net.imagej.Dataset;
import net.imagej.DatasetService;
import net.imagej.ImgPlus;
import net.imglib2.RandomAccess;
import net.imglib2.ops.pointset.TextSpecifiedPointSet;
import net.imglib2.type.numeric.RealType;
import org.scijava.Cancelable;
import org.scijava.ItemIO;
import org.scijava.command.Command;
import org.scijava.platform.PlatformService;
import org.scijava.plugin.Attr;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.widget.Button;

@Plugin(type=Command.class, menuPath="Plugins>Sandbox>PointSet Demo", attrs={@Attr(name="no-legacy")})
public class PointSetDemo
implements Command,
Cancelable {
    @Parameter
    private PlatformService platformService;
    @Parameter(label="PointSet specification", type=ItemIO.INPUT)
    private String specification;
    @Parameter(type=ItemIO.OUTPUT)
    private Dataset output;
    @Parameter
    private DatasetService ds;
    @Parameter(label="Help", description="View a web page detailing the point set language", callback="openWebPage", persist=false)
    private Button openWebPage;
    private String err;

    public void run() {
        TextSpecifiedPointSet pointSet = new TextSpecifiedPointSet(this.specification);
        if (pointSet.getErrorString() != null) {
            this.cancel(pointSet.getErrorString());
            return;
        }
        long[] minBound = new long[pointSet.numDimensions()];
        long[] maxBound = new long[pointSet.numDimensions()];
        pointSet.min(minBound);
        pointSet.max(maxBound);
        int i = 0;
        while (i < minBound.length) {
            if (minBound[i] < 0L || maxBound[i] < 0L) {
                this.cancel("For now won't handle negative space with this test plugin");
                return;
            }
            int n = i++;
            maxBound[n] = maxBound[n] + 10L;
        }
        this.output = this.ds.create(maxBound, "PointSet", null, 8, false, false);
        ImgPlus imgplus = this.output.getImgPlus();
        RandomAccess accessor = imgplus.randomAccess();
        for (long[] pos : pointSet) {
            accessor.setPosition(pos);
            ((RealType)accessor.get()).setReal(255.0f);
        }
    }

    public boolean isCanceled() {
        return this.err != null;
    }

    public void cancel(String reason) {
        this.err = reason;
    }

    public String getCancelReason() {
        return this.err;
    }

    protected void openWebPage() {
        try {
            String urlString = "http://wiki.imagej.net/ImageJ2/Documentation/PointSetDemo";
            URL url = new URL(urlString);
            this.platformService.open(url);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

