/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.plugins.uploaders.ssh;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Proxy;
import com.jcraft.jsch.ProxyHTTP;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UserInfo;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import net.imagej.updater.FilesUploader;
import net.imagej.updater.util.UpdaterUserInterface;
import org.scijava.log.LogService;

final class SSHSessionCreator {
    private SSHSessionCreator() {
    }

    protected static Session connect(ConfigInfo config, UserInfo userInfo) throws JSchException {
        JSch jsch = new JSch();
        File knownHosts = new File(new File(System.getProperty("user.home"), ".ssh"), "known_hosts");
        jsch.setKnownHosts(knownHosts.getAbsolutePath());
        Session session = jsch.getSession(config.username, config.sshHost, config.port);
        if (config.identity != null) {
            jsch.addIdentity(config.identity);
        }
        String proxyHost = System.getProperty("http.proxyHost");
        String proxyPort = System.getProperty("http.proxyPort");
        if (proxyHost != null && proxyPort != null) {
            session.setProxy((Proxy)new ProxyHTTP(proxyHost, Integer.parseInt(proxyPort)));
        }
        session.setUserInfo(userInfo);
        try {
            session.connect();
        }
        catch (JSchException e) {
            if (proxyHost != null && proxyPort != null && e.getMessage().indexOf("Forbidden") >= 0) {
                System.err.println("Trying to connect to " + config.username + "@" + config.sshHost + " without a proxy.");
                session.setProxy(null);
                session.connect();
            }
            throw e;
        }
        return session;
    }

    private static ConfigInfo getIdentity(String username, String sshHost, LogService log) {
        ConfigInfo result = new ConfigInfo();
        result.username = username;
        result.port = 22;
        int colon = sshHost.indexOf(58);
        if (colon < 0) {
            result.sshHost = sshHost;
        } else {
            result.port = Integer.parseInt(sshHost.substring(colon + 1));
            result.sshHost = sshHost.substring(0, colon);
        }
        result.readUserSSHConfig(log);
        if (result.identity == null) {
            result.getUserDefaultKeys();
        }
        return result;
    }

    protected static UserInfo getUserInfo(final String initialPrompt, final String password) {
        return new UserInfo(){
            protected String prompt;
            protected int count;
            {
                this.prompt = initialPrompt;
                this.count = 0;
            }

            public String getPassphrase() {
                return UpdaterUserInterface.get().getPassword(this.prompt);
            }

            public String getPassword() {
                if (this.count == 1 && password != null) {
                    return password;
                }
                return UpdaterUserInterface.get().getPassword(this.prompt);
            }

            public boolean promptPassphrase(String message) {
                this.prompt = message;
                return this.count++ < 3;
            }

            public boolean promptPassword(String message) {
                this.prompt = message;
                return this.count++ < 4;
            }

            public boolean promptYesNo(String message) {
                return UpdaterUserInterface.get().promptYesNo(message, "Password");
            }

            public void showMessage(String message) {
                UpdaterUserInterface.get().info(message, "Password");
            }
        };
    }

    /*
     * Exception decompiling
     */
    public static Session getSession(FilesUploader uploader) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[DOLOOP]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected static Session debugConnect(String host, LogService log) throws JSchException {
        ConfigInfo info = SSHSessionCreator.getIdentity(null, host, log);
        if (info.username == null || info.identity == null) {
            throw new JSchException("Could not determine user name or identity for " + host);
        }
        JSch jsch = new JSch();
        jsch.addIdentity(info.identity);
        File knownHosts = new File(new File(System.getProperty("user.home"), ".ssh"), "known_hosts");
        jsch.setKnownHosts(knownHosts.getAbsolutePath());
        Session session = jsch.getSession(info.username, info.sshHost);
        session.connect();
        return session;
    }

    private static class ConfigInfo {
        protected String username;
        protected String sshHost;
        protected String identity;
        protected int port;

        private ConfigInfo() {
        }

        private void readUserSSHConfig(LogService log) {
            File config = new File(new File(System.getProperty("user.home"), ".ssh"), "config");
            if (!config.exists()) {
                return;
            }
            try {
                String line;
                BufferedReader reader = new BufferedReader(new FileReader(config));
                boolean hostMatches = false;
                while ((line = reader.readLine()) != null) {
                    int space = (line = line.trim()).indexOf(32);
                    if (space < 0) continue;
                    String key = line.substring(0, space).toLowerCase();
                    if (key.equals("host")) {
                        hostMatches = line.substring(5).trim().equals(this.sshHost);
                        continue;
                    }
                    if (!hostMatches) continue;
                    if (key.equals("user")) {
                        if (this.username != null && !this.username.equals("")) continue;
                        this.username = line.substring(5).trim();
                        continue;
                    }
                    if (key.equals("hostname")) {
                        this.sshHost = line.substring(9).trim();
                        continue;
                    }
                    if (!key.equals("identityfile")) continue;
                    this.identity = line.substring(13).trim();
                }
                reader.close();
            }
            catch (Exception e) {
                log.error((Throwable)e);
            }
        }

        private void getUserDefaultKeys() {
            String[] filenames = new String[]{"id_rsa", "id_dsa"};
            File userSSHDir = new File(System.getProperty("user.home"), ".ssh");
            for (String f : filenames) {
                File keyfile = new File(userSSHDir, f);
                if (!keyfile.exists()) continue;
                this.identity = keyfile.getAbsolutePath();
                break;
            }
        }
    }
}

