/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.updater;

import java.io.File;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import net.imagej.updater.CheckForUpdates;
import net.imagej.updater.FileObject;
import net.imagej.updater.FilesCollection;
import net.imagej.updater.UpdateService;
import net.imagej.updater.UpdateSite;
import net.imagej.updater.util.AvailableSites;
import org.scijava.app.AppService;
import org.scijava.command.CommandService;
import org.scijava.event.EventHandler;
import org.scijava.log.LogService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.service.AbstractService;
import org.scijava.service.Service;
import org.scijava.ui.event.UIShownEvent;
import org.xml.sax.SAXException;

@Plugin(type=Service.class)
public class DefaultUpdateService
extends AbstractService
implements UpdateService {
    @Parameter
    private CommandService commandService;
    @Parameter
    private AppService appService;
    @Parameter(required=false)
    private LogService log;
    private FilesCollection filesCollection;

    @Override
    public UpdateSite getUpdateSite(File file) {
        String root;
        String path = file.getAbsolutePath();
        if (!path.startsWith(root = this.rootDir().getAbsolutePath() + File.separator)) {
            return null;
        }
        String shortPath = path.substring(root.length());
        FilesCollection fc = this.filesCollection();
        FileObject fileObject = fc.get(shortPath);
        return fc.getUpdateSite(fileObject.updateSite, true);
    }

    @EventHandler
    protected void onEvent(UIShownEvent evt) {
        this.commandService.run(CheckForUpdates.class, true, new Object[0]);
    }

    private File rootDir() {
        return this.appService.getApp().getBaseDirectory();
    }

    private FilesCollection filesCollection() {
        if (this.filesCollection == null) {
            this.initFilesCollection();
        }
        return this.filesCollection;
    }

    private synchronized void initFilesCollection() {
        FilesCollection fc;
        block7: {
            if (this.filesCollection != null) {
                return;
            }
            fc = new FilesCollection(this.rootDir());
            AvailableSites.initializeAndAddSites(fc);
            try {
                fc.read();
            }
            catch (IOException exc) {
                if (this.log != null) {
                    this.log.error((Object)"Error parsing update sites", (Throwable)exc);
                }
            }
            catch (ParserConfigurationException exc) {
                if (this.log != null) {
                    this.log.error((Object)"Error parsing update sites", (Throwable)exc);
                }
            }
            catch (SAXException exc) {
                if (this.log == null) break block7;
                this.log.error((Object)"Error parsing update sites", (Throwable)exc);
            }
        }
        this.filesCollection = fc;
    }
}

