/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.options;

import org.scijava.command.DynamicCommand;
import org.scijava.event.EventService;
import org.scijava.module.ModuleItem;
import org.scijava.module.ModuleService;
import org.scijava.options.event.OptionsEvent;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.SingletonPlugin;
import org.scijava.prefs.PrefService;

public abstract class OptionsPlugin
extends DynamicCommand
implements SingletonPlugin {
    @Parameter
    protected EventService eventService;
    @Parameter
    private PrefService prefService;
    @Parameter
    private ModuleService moduleService;

    public void load() {
        for (ModuleItem<?> input : this.getInfo().inputs()) {
            this.loadInput(input);
        }
    }

    public void save() {
        for (ModuleItem<?> input : this.getInfo().inputs()) {
            this.saveInput(input);
        }
    }

    public void reset() {
        this.prefService.clear(this.getClass());
    }

    @Override
    public void run() {
        this.save();
        for (ModuleItem<?> input : this.getInfo().inputs()) {
            this.unresolveInput(input.getName());
        }
        this.eventService.publish(new OptionsEvent(this));
    }

    private <T> void loadInput(ModuleItem<T> input) {
        T value = this.moduleService.load(input);
        if (value != null) {
            input.setValue(this, value);
        }
    }

    private <T> void saveInput(ModuleItem<T> input) {
        T value = input.getValue(this);
        this.moduleService.save(input, value);
    }
}

