/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.module;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.scijava.module.MethodCallException;
import org.scijava.module.MethodRef;
import org.scijava.module.Module;
import org.scijava.module.ModuleItem;

public abstract class AbstractModule
implements Module {
    private final HashMap<String, Object> inputs = new HashMap();
    private final HashMap<String, Object> outputs = new HashMap();
    private final HashSet<String> resolvedInputs = new HashSet();
    private final HashSet<String> resolvedOutputs = new HashSet();
    private MethodRef initializerRef;

    @Override
    public void preview() {
    }

    @Override
    public void cancel() {
    }

    @Override
    public void initialize() throws MethodCallException {
        Object delegateObject = this.getDelegateObject();
        if (this.initializerRef == null) {
            String initializer = this.getInfo().getInitializer();
            this.initializerRef = new MethodRef(delegateObject.getClass(), initializer, new Class[0]);
        }
        this.initializerRef.execute(delegateObject, new Object[0]);
        for (ModuleItem<?> item : this.getInfo().inputs()) {
            item.initialize(this);
        }
    }

    @Override
    public Object getDelegateObject() {
        return this;
    }

    @Override
    public Object getInput(String name) {
        return this.inputs.get(name);
    }

    @Override
    public Object getOutput(String name) {
        return this.outputs.get(name);
    }

    @Override
    public Map<String, Object> getInputs() {
        return this.createMap(this.getInfo().inputs(), false);
    }

    @Override
    public Map<String, Object> getOutputs() {
        return this.createMap(this.getInfo().outputs(), true);
    }

    @Override
    public void setInput(String name, Object value) {
        this.inputs.put(name, value);
    }

    @Override
    public void setOutput(String name, Object value) {
        this.outputs.put(name, value);
    }

    @Override
    public void setInputs(Map<String, Object> inputs) {
        for (String name : inputs.keySet()) {
            this.setInput(name, inputs.get(name));
        }
    }

    @Override
    public void setOutputs(Map<String, Object> outputs) {
        for (String name : outputs.keySet()) {
            this.setOutput(name, outputs.get(name));
        }
    }

    @Override
    public boolean isInputResolved(String name) {
        return this.resolvedInputs.contains(name);
    }

    @Override
    public boolean isOutputResolved(String name) {
        return this.resolvedOutputs.contains(name);
    }

    @Override
    public void resolveInput(String name) {
        ModuleItem<?> item = this.getInputItem(name);
        if (item != null) {
            try {
                item.validate(this);
            }
            catch (MethodCallException exc) {
                throw new RuntimeException(exc);
            }
        }
        this.resolvedInputs.add(name);
    }

    @Override
    public void resolveOutput(String name) {
        this.resolvedOutputs.add(name);
    }

    @Override
    public void unresolveInput(String name) {
        this.resolvedInputs.remove(name);
    }

    @Override
    public void unresolveOutput(String name) {
        this.resolvedOutputs.remove(name);
    }

    private Map<String, Object> createMap(Iterable<ModuleItem<?>> items, boolean outputMap) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (ModuleItem<?> item : items) {
            String name = item.getName();
            Object value = outputMap ? this.getOutput(name) : this.getInput(name);
            map.put(name, value);
        }
        return map;
    }

    private ModuleItem<?> getInputItem(String name) {
        for (ModuleItem<?> item : this.getInfo().inputs()) {
            if (!item.getName().equals(name)) continue;
            return item;
        }
        return null;
    }
}

