/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.type.numeric;

import net.imglib2.img.NativeImg;
import net.imglib2.img.NativeImgFactory;
import net.imglib2.img.basictypeaccess.DoubleAccess;
import net.imglib2.img.basictypeaccess.array.DoubleArray;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.ARGBDoubleType;
import net.imglib2.type.numeric.AbstractARGBDoubleType;
import net.imglib2.util.Fraction;

public class NativeARGBDoubleType
extends AbstractARGBDoubleType<NativeARGBDoubleType>
implements NativeType<NativeARGBDoubleType> {
    private int i = 0;
    private int ai = 0;
    private int ri = 1;
    private int gi = 2;
    private int bi = 3;
    protected final NativeImg<NativeARGBDoubleType, ? extends DoubleAccess> img;
    protected DoubleAccess dataAccess;

    public NativeARGBDoubleType(NativeImg<NativeARGBDoubleType, ? extends DoubleAccess> img) {
        this.img = img;
    }

    public NativeARGBDoubleType(double a, double r, double g, double b) {
        this.img = null;
        this.dataAccess = new DoubleArray(4);
        this.set(a, r, g, b);
    }

    public NativeARGBDoubleType(DoubleAccess access) {
        this.img = null;
        this.dataAccess = access;
    }

    public NativeARGBDoubleType() {
        this(0.0, 0.0, 0.0, 0.0);
    }

    @Override
    public NativeImg<NativeARGBDoubleType, ? extends DoubleAccess> createSuitableNativeImg(NativeImgFactory<NativeARGBDoubleType> storageFactory, long[] dim) {
        NativeImg<NativeARGBDoubleType, DoubleAccess> container = storageFactory.createDoubleInstance(dim, new Fraction(4L, 1L));
        NativeARGBDoubleType linkedType = new NativeARGBDoubleType(container);
        container.setLinkedType(linkedType);
        return container;
    }

    @Override
    public void updateContainer(Object c) {
        this.dataAccess = this.img.update(c);
    }

    @Override
    public NativeARGBDoubleType duplicateTypeOnSameNativeImg() {
        return new NativeARGBDoubleType(this.img);
    }

    @Override
    public double getA() {
        return this.dataAccess.getValue(this.ai);
    }

    @Override
    public double getR() {
        return this.dataAccess.getValue(this.ri);
    }

    @Override
    public double getG() {
        return this.dataAccess.getValue(this.gi);
    }

    @Override
    public double getB() {
        return this.dataAccess.getValue(this.bi);
    }

    @Override
    public void setA(double a) {
        this.dataAccess.setValue(this.ai, a);
    }

    @Override
    public void setR(double r) {
        this.dataAccess.setValue(this.ri, r);
    }

    @Override
    public void setG(double g) {
        this.dataAccess.setValue(this.gi, g);
    }

    @Override
    public void setB(double b) {
        this.dataAccess.setValue(this.bi, b);
    }

    @Override
    public void set(double a, double r, double g, double b) {
        this.dataAccess.setValue(this.ai, a);
        this.dataAccess.setValue(this.ri, r);
        this.dataAccess.setValue(this.gi, g);
        this.dataAccess.setValue(this.bi, b);
    }

    @Override
    public void set(ARGBDoubleType c) {
        this.set(c.getA(), c.getR(), c.getG(), c.getB());
    }

    @Override
    public NativeARGBDoubleType createVariable() {
        return new NativeARGBDoubleType();
    }

    @Override
    public NativeARGBDoubleType copy() {
        return new NativeARGBDoubleType(this.getA(), this.getR(), this.getG(), this.getB());
    }

    @Override
    public Fraction getEntitiesPerPixel() {
        return new Fraction(4L, 1L);
    }

    @Override
    public void updateIndex(int index) {
        this.i = index;
        this.ai = this.i * 4;
        this.ri = this.ai + 1;
        this.gi = this.ai + 2;
        this.bi = this.ai + 3;
    }

    @Override
    public void incIndex() {
        ++this.i;
        this.ai += 4;
        this.ri += 4;
        this.gi += 4;
        this.bi += 4;
    }

    @Override
    public void incIndex(int increment) {
        this.i += increment;
        int inc2 = increment * 4;
        this.ai += inc2;
        this.ri += inc2;
        this.gi += inc2;
        this.bi += inc2;
    }

    @Override
    public void decIndex() {
        --this.i;
        this.ai -= 4;
        this.ri -= 4;
        this.gi -= 4;
        this.bi -= 4;
    }

    @Override
    public void decIndex(int decrement) {
        this.i -= decrement;
        int dec2 = decrement * 4;
        this.ai -= dec2;
        this.ri -= dec2;
        this.gi -= dec2;
        this.bi -= dec2;
    }

    @Override
    public int getIndex() {
        return this.i;
    }
}

