/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.img.array;

import net.imglib2.exception.IncompatibleTypeException;
import net.imglib2.img.AbstractImg;
import net.imglib2.img.ImgFactory;
import net.imglib2.img.NativeImgFactory;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.img.basictypeaccess.array.ByteArray;
import net.imglib2.img.basictypeaccess.array.CharArray;
import net.imglib2.img.basictypeaccess.array.DoubleArray;
import net.imglib2.img.basictypeaccess.array.FloatArray;
import net.imglib2.img.basictypeaccess.array.IntArray;
import net.imglib2.img.basictypeaccess.array.LongArray;
import net.imglib2.img.basictypeaccess.array.ShortArray;
import net.imglib2.type.NativeType;
import net.imglib2.util.Fraction;

public class ArrayImgFactory<T extends NativeType<T>>
extends NativeImgFactory<T> {
    @Override
    public ArrayImg<T, ?> create(long[] dim, T type) {
        return (ArrayImg)type.createSuitableNativeImg(this, dim);
    }

    public static int numEntitiesRangeCheck(long[] dimensions, Fraction entitiesPerPixel) {
        long numEntities = entitiesPerPixel.mulCeil(AbstractImg.numElements(dimensions));
        if (numEntities > Integer.MAX_VALUE) {
            throw new RuntimeException("Number of elements in Container too big, use for example CellContainer instead: " + numEntities + " > " + Integer.MAX_VALUE);
        }
        return (int)numEntities;
    }

    @Override
    public ArrayImg<T, ByteArray> createByteInstance(long[] dimensions, Fraction entitiesPerPixel) {
        int numEntities = ArrayImgFactory.numEntitiesRangeCheck(dimensions, entitiesPerPixel);
        return new ArrayImg(new ByteArray(numEntities), dimensions, entitiesPerPixel);
    }

    @Override
    public ArrayImg<T, CharArray> createCharInstance(long[] dimensions, Fraction entitiesPerPixel) {
        int numEntities = ArrayImgFactory.numEntitiesRangeCheck(dimensions, entitiesPerPixel);
        return new ArrayImg(new CharArray(numEntities), dimensions, entitiesPerPixel);
    }

    @Override
    public ArrayImg<T, DoubleArray> createDoubleInstance(long[] dimensions, Fraction entitiesPerPixel) {
        int numEntities = ArrayImgFactory.numEntitiesRangeCheck(dimensions, entitiesPerPixel);
        return new ArrayImg(new DoubleArray(numEntities), dimensions, entitiesPerPixel);
    }

    @Override
    public ArrayImg<T, FloatArray> createFloatInstance(long[] dimensions, Fraction entitiesPerPixel) {
        int numEntities = ArrayImgFactory.numEntitiesRangeCheck(dimensions, entitiesPerPixel);
        return new ArrayImg(new FloatArray(numEntities), dimensions, entitiesPerPixel);
    }

    @Override
    public ArrayImg<T, IntArray> createIntInstance(long[] dimensions, Fraction entitiesPerPixel) {
        int numEntities = ArrayImgFactory.numEntitiesRangeCheck(dimensions, entitiesPerPixel);
        return new ArrayImg(new IntArray(numEntities), dimensions, entitiesPerPixel);
    }

    @Override
    public ArrayImg<T, LongArray> createLongInstance(long[] dimensions, Fraction entitiesPerPixel) {
        int numEntities = ArrayImgFactory.numEntitiesRangeCheck(dimensions, entitiesPerPixel);
        return new ArrayImg(new LongArray(numEntities), dimensions, entitiesPerPixel);
    }

    @Override
    public ArrayImg<T, ShortArray> createShortInstance(long[] dimensions, Fraction entitiesPerPixel) {
        int numEntities = ArrayImgFactory.numEntitiesRangeCheck(dimensions, entitiesPerPixel);
        return new ArrayImg(new ShortArray(numEntities), dimensions, entitiesPerPixel);
    }

    @Override
    public <S> ImgFactory<S> imgFactory(S type) throws IncompatibleTypeException {
        if (NativeType.class.isInstance(type)) {
            return new ArrayImgFactory<T>();
        }
        throw new IncompatibleTypeException(this, type.getClass().getCanonicalName() + " does not implement NativeType.");
    }
}

