/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.converter;

import java.util.ArrayList;
import net.imglib2.converter.Converter;
import net.imglib2.type.numeric.ARGBType;
import net.imglib2.type.numeric.integer.UnsignedByteType;

public final class ChannelARGBConverter
implements Converter<UnsignedByteType, ARGBType> {
    public static final ArrayList<Converter<UnsignedByteType, ARGBType>> converterListRGBA = new ArrayList();
    private final int shift;

    public ChannelARGBConverter(Channel channel) {
        this.shift = channel.shift;
    }

    @Override
    public void convert(UnsignedByteType input, ARGBType output) {
        output.set(input.get() << this.shift);
    }

    static {
        converterListRGBA.add(new ChannelARGBConverter(Channel.R));
        converterListRGBA.add(new ChannelARGBConverter(Channel.G));
        converterListRGBA.add(new ChannelARGBConverter(Channel.B));
        converterListRGBA.add(new ChannelARGBConverter(Channel.A));
    }

    public static enum Channel {
        A(24),
        R(16),
        G(8),
        B(0);

        private final int shift;

        private Channel(int shift) {
            this.shift = shift;
        }
    }
}

