/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beaker.jupyter.handler;

import com.twosigma.beaker.jupyter.commands.MagicCommand;
import com.twosigma.beaker.jupyter.msg.JupyterMessages;
import com.twosigma.jupyter.KernelFunctionality;
import com.twosigma.jupyter.handler.KernelHandler;
import com.twosigma.jupyter.message.Header;
import com.twosigma.jupyter.message.Message;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecuteRequestHandler
extends KernelHandler<Message> {
    private static final Logger logger = LoggerFactory.getLogger(ExecuteRequestHandler.class);
    private int executionCount;
    private KernelFunctionality kernel;
    private MagicCommand magicCommand;

    public ExecuteRequestHandler(KernelFunctionality kernel) {
        super(kernel);
        this.kernel = kernel;
        this.magicCommand = new MagicCommand(kernel);
        this.executionCount = 0;
    }

    @Override
    public void handle(Message message) {
        logger.debug("Processing execute request");
        this.handleMessage(message);
    }

    private synchronized void handleMessage(Message message) {
        Message reply = new Message();
        HashMap<String, Serializable> map = new HashMap<String, Serializable>(1);
        map.put("execution_state", (Serializable)((Object)"busy"));
        reply.setContent(map);
        reply.setHeader(new Header(JupyterMessages.STATUS, message.getHeader().getSession()));
        reply.setParentHeader(message.getHeader());
        reply.setIdentities(message.getIdentities());
        this.publish(reply);
        String code = "";
        if (message.getContent() != null && message.getContent().containsKey("code")) {
            code = ((String)((Object)message.getContent().get("code"))).trim();
        }
        reply.setHeader(new Header(JupyterMessages.EXECUTE_INPUT, message.getHeader().getSession()));
        HashMap<String, Serializable> map1 = new HashMap<String, Serializable>(2);
        map1.put("execution_count", Integer.valueOf(this.executionCount));
        map1.put("code", (Serializable)((Object)code));
        reply.setContent(map1);
        this.publish(reply);
        ++this.executionCount;
        if (!code.startsWith("%")) {
            this.kernel.executeCode(code, message, this.executionCount);
        } else {
            String command = new Scanner(code).next();
            if (this.magicCommand.commands.containsKey(command)) {
                this.magicCommand.commands.get(command).process(code, message, this.executionCount);
            } else {
                this.magicCommand.processUnknownCommand(command, message, this.executionCount);
            }
        }
    }

    @Override
    public void exit() {
    }
}

