/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beaker.chart.xychart.plotitem;

import com.twosigma.beaker.chart.Color;
import com.twosigma.beaker.chart.Filter;
import com.twosigma.beaker.chart.Graphics;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;

public abstract class XYGraphics
extends Graphics {
    private List<Number> xs;
    private List<Number> ys = new ArrayList<Number>();
    private String displayName = "";
    protected Color baseColor;
    private List<Color> colors;
    private Class plotType;
    private Filter lodFilter;
    private Object toolTipBuilder;
    private List<String> toolTips;

    protected List<Number> getBases() {
        return null;
    }

    protected Number getBase() {
        return null;
    }

    protected void setBase(Object base) {
        this.reinit();
    }

    public List<String> getToolTips() {
        return this.toolTips;
    }

    public void setToolTip(Object toolTip) {
        this.toolTipBuilder = toolTip;
        this.reinit();
    }

    public void setToolTip(List<String> toolTips) {
        this.toolTipBuilder = null;
        for (String tooltip : toolTips) {
            if (tooltip == null || tooltip instanceof String) continue;
            throw new IllegalArgumentException("Tooltips should be the list of strings");
        }
        this.toolTips = toolTips;
    }

    public void setX(List<Object> xs) {
        this.xs = new ArrayList<Number>();
        if (xs != null) {
            for (Object x : xs) {
                if (x instanceof Number) {
                    this.xs.add((Number)x);
                    continue;
                }
                if (x instanceof Date) {
                    Date date = (Date)x;
                    this.xs.add(date.getTime());
                    continue;
                }
                throw new IllegalArgumentException("x coordinates should be the list of numbers or java.util.Date objects");
            }
        }
        this.reinit();
    }

    public List<Number> getX() {
        if (this.xs == null) {
            this.generateXs();
        }
        return this.xs;
    }

    public void setY(List<Number> ys) {
        this.ys = new ArrayList<Number>(ys);
        this.reinit();
    }

    public List<Number> getY() {
        return this.ys;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
        this.reinit();
    }

    public String getDisplayName() {
        return this.displayName;
    }

    private void generateXs() {
        this.xs = new ArrayList<Number>(this.ys.size());
        for (int i = 0; i < this.ys.size(); ++i) {
            this.xs.add(i);
        }
    }

    public Filter getLodFilter() {
        return this.lodFilter;
    }

    public void setLodFilter(Filter lodFilter) {
        if (!this.getPossibleFilters().contains((Object)lodFilter)) {
            throw new RuntimeException(String.format("%s doesn't not support '%s' filter.", this.getClass().getSimpleName(), lodFilter.getText()));
        }
        this.lodFilter = lodFilter;
    }

    public void setColor(Object color) {
        if (color instanceof Color) {
            this.baseColor = (Color)color;
        } else if (color instanceof java.awt.Color) {
            this.baseColor = new Color((java.awt.Color)color);
        } else if (color instanceof List) {
            List cs = (List)color;
            this.setColors(cs);
        } else {
            throw new IllegalArgumentException("setColor takes Color or List of Color");
        }
    }

    private void setColors(List<Object> colors) {
        if (colors != null) {
            this.colors = new ArrayList<Color>(colors.size());
            for (Object c : colors) {
                if (c instanceof Color) {
                    this.colors.add((Color)c);
                    continue;
                }
                if (c instanceof java.awt.Color) {
                    this.colors.add(new Color((java.awt.Color)c));
                    continue;
                }
                throw new IllegalArgumentException("setColor takes Color or List of Color");
            }
        } else {
            this.colors = null;
        }
    }

    public List<Color> getColors() {
        return this.colors;
    }

    @Override
    public void setColori(Color color) {
        this.baseColor = color;
    }

    @Override
    public Color getColor() {
        return this.baseColor;
    }

    protected abstract EnumSet<Filter> getPossibleFilters();

    public Class getPlotType() {
        return this.plotType;
    }

    public void setPlotType(Class plotType) {
        this.plotType = plotType;
    }

    private void reinit() {
        if (this.toolTipBuilder == null) {
            return;
        }
        ArrayList<String> toolTip = new ArrayList<String>();
        try {
            for (int i = 0; i < this.xs.size(); ++i) {
                toolTip.add((String)this.runClosure(this.toolTipBuilder, this.xs.get(i), this.ys.get(i), i, this.getBases() != null ? (Number)this.getBases().get(i) : (Number)this.getBase(), this.displayName));
            }
        }
        catch (Throwable x) {
            throw new RuntimeException("Can not create tooltips.", x);
        }
        this.toolTips = toolTip;
    }

    private Object runClosure(Object closure, Object ... params) throws Exception {
        Class<?> clazz = closure.getClass();
        Method getMaximumNumberOfParameters = clazz.getMethod("getMaximumNumberOfParameters", new Class[0]);
        getMaximumNumberOfParameters.setAccessible(true);
        int numberOfParameters = (Integer)getMaximumNumberOfParameters.invoke(closure, new Object[0]);
        Object[] paramTypes = new Class[numberOfParameters];
        Arrays.fill(paramTypes, Object.class);
        Method call = clazz.getMethod("call", (Class<?>[])paramTypes);
        call.setAccessible(true);
        return call.invoke(closure, Arrays.copyOfRange(params, 0, numberOfParameters));
    }
}

