/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beaker.chart.serializer;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.twosigma.beaker.chart.serializer.GraphicsSerializer;
import com.twosigma.beaker.chart.xychart.NanoPlot;
import com.twosigma.beaker.chart.xychart.plotitem.XYGraphics;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class XYGraphicsSerializer<T extends XYGraphics>
extends GraphicsSerializer<T> {
    public static final String DISPLAY_NAME = "display_name";

    @Override
    public void serialize(T xyGraphics, JsonGenerator jgen, SerializerProvider sp) throws IOException, JsonProcessingException {
        List<String> toolTips;
        super.serialize(xyGraphics, jgen, sp);
        boolean isNanoPlot = NanoPlot.class.equals((Object)((XYGraphics)xyGraphics).getPlotType());
        jgen.writeObjectField("x", isNanoPlot ? this.processLargeNumbers(((XYGraphics)xyGraphics).getX()) : ((XYGraphics)xyGraphics).getX());
        jgen.writeObjectField("y", ((XYGraphics)xyGraphics).getY());
        jgen.writeObjectField(DISPLAY_NAME, (Object)((XYGraphics)xyGraphics).getDisplayName());
        if (((XYGraphics)xyGraphics).getLodFilter() != null) {
            jgen.writeObjectField("lod_filter", (Object)((XYGraphics)xyGraphics).getLodFilter().getText());
        }
        if ((toolTips = ((XYGraphics)xyGraphics).getToolTips()) != null) {
            jgen.writeObjectField("tooltips", toolTips);
        }
    }

    private List<String> processLargeNumbers(List<Number> list) {
        ArrayList<String> stringList = new ArrayList<String>(list.size());
        for (Number n : list) {
            if (n != null) {
                stringList.add(n.toString());
                continue;
            }
            stringList.add("");
        }
        return stringList;
    }
}

