/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.jupyter.notebook;

import com.twosigma.beaker.mimetype.MIMEContainer;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import jupyter.Displayers;
import org.scijava.jupyter.notebook.NotebookService;
import org.scijava.jupyter.notebook.displayer.ListDisplayer;
import org.scijava.jupyter.notebook.displayer.StringDisplayer;
import org.scijava.log.LogService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.service.AbstractService;
import org.scijava.service.Service;

@Plugin(type=Service.class)
public class DefaultNotebookService
extends AbstractService
implements NotebookService {
    @Parameter
    private LogService log;

    public DefaultNotebookService() {
        Displayers.register(String.class, StringDisplayer.get());
        Displayers.register(List.class, ListDisplayer.get());
    }

    @Override
    public Object displayMimetype(String mimetype, String content) {
        MIMEContainer.MIME mimeTypeObj = Arrays.asList(MIMEContainer.MIME.values()).stream().filter(m -> m.getMime().equals(mimetype)).findFirst().orElse(null);
        if (mimeTypeObj == null) {
            this.log.error("The mimetype '" + mimetype + "' is not supported");
            return null;
        }
        return new MIMEContainer(mimeTypeObj, content);
    }

    @Override
    public Object displayAuto(Object object) {
        Map richResult = Displayers.display((Object)object);
        String mimetype = (String)richResult.keySet().toArray()[0];
        String content = (String)richResult.get(mimetype);
        return this.displayMimetype(mimetype, content);
    }
}

