/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.jupyter.kernel.configuration;

import com.twosigma.jupyter.Config;
import com.twosigma.jupyter.ConfigurationFile;
import com.twosigma.jupyter.message.MessageSerializer;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import org.scijava.Context;
import org.scijava.log.LogService;
import org.scijava.plugin.Parameter;

public class ScijavaKernelConfigurationFile
implements ConfigurationFile {
    @Parameter
    private transient LogService log;
    private File configFile;
    private Config configuration;
    private String languageName;
    private String logLevel;

    public ScijavaKernelConfigurationFile(Context context, String scriptLanguage, String logLevel, Path connectionFile) {
        context.inject(this);
        this.configFile = connectionFile.toFile();
        this.languageName = scriptLanguage;
        this.logLevel = logLevel;
    }

    public Config getConfig() {
        if (this.configuration == null) {
            try {
                this.configuration = (Config)MessageSerializer.parse((String)new String(Files.readAllBytes(this.configFile.toPath())), Config.class);
            }
            catch (IOException ex) {
                this.log.error("Issue loading connection file : " + ex);
            }
        }
        return this.configuration;
    }

    public String getLanguageName() {
        return this.languageName;
    }

    public String getLogLevel() {
        return this.logLevel;
    }
}

