/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.jupyter.kernel;

import com.twosigma.beaker.evaluator.Evaluator;
import com.twosigma.beaker.jupyter.handler.CommOpenHandler;
import com.twosigma.jupyter.Kernel;
import com.twosigma.jupyter.KernelFunctionality;
import com.twosigma.jupyter.KernelSocketsFactory;
import com.twosigma.jupyter.KernelSocketsFactoryImpl;
import com.twosigma.jupyter.handler.KernelHandler;
import com.twosigma.jupyter.message.Message;
import org.scijava.Context;
import org.scijava.jupyter.kernel.comm.ScijavaCommOpenHandler;
import org.scijava.jupyter.kernel.configuration.ScijavaKernelConfigurationFile;
import org.scijava.jupyter.kernel.evaluator.ScijavaEvaluator;
import org.scijava.jupyter.kernel.handler.ScijavaKernelInfoHandler;
import org.scijava.jupyter.service.JupyterService;
import org.scijava.log.LogService;
import org.scijava.plugin.Parameter;
import org.scijava.script.ScriptLanguage;

public class ScijavaKernel
extends Kernel {
    Context context;
    @Parameter
    private transient LogService log;
    public static ScriptLanguage scriptLanguage;
    private final ScijavaKernelConfigurationFile config;
    private final ScijavaEvaluator evaluator;

    public ScijavaKernel(Context context, String id, ScijavaEvaluator evaluator, ScijavaKernelConfigurationFile config, KernelSocketsFactoryImpl kernelSocketsFactory) {
        super(id, (Evaluator)evaluator, (KernelSocketsFactory)kernelSocketsFactory);
        this.context = context;
        this.context.inject((Object)this);
        this.config = config;
        this.evaluator = evaluator;
        this.log.info("Scijava Kernel started.");
        this.log.info("Language used : " + this.config.getLanguageName());
        this.setLogLevel(config.getLogLevel());
        this.log.info("Log level used is : " + this.config.getLogLevel());
        this.log.info("Scijava Kernel is started and ready to use.");
    }

    public CommOpenHandler getCommOpenHandler(Kernel kernel) {
        return new ScijavaCommOpenHandler((KernelFunctionality)kernel);
    }

    public KernelHandler<Message> getKernelInfoHandler(Kernel kernel) {
        return new ScijavaKernelInfoHandler((KernelFunctionality)kernel, scriptLanguage);
    }

    private void setLogLevel(String logLevel) {
        switch (logLevel) {
            case "debug": {
                this.log.setLevel(4);
                break;
            }
            case "error": {
                this.log.setLevel(1);
                break;
            }
            case "info": {
                this.log.setLevel(3);
                break;
            }
            case "none": {
                this.log.setLevel(0);
                break;
            }
            default: {
                this.log.setLevel(3);
            }
        }
    }

    public static void main(String ... args) {
        Context context = new Context();
        JupyterService jupyter = context.service(JupyterService.class);
        jupyter.runKernel(args);
        context.dispose();
    }
}

