/*
 *  Copyright 2017 TWO SIGMA OPEN SOURCE, LLC
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package com.twosigma.beaker.widgets.box;

import com.twosigma.beaker.widgets.CommFunctionality;

import java.util.List;

/**
 * Displays multiple widgets vertically using the flexible box model.
 */
public class VBox extends Box{
  
  public static final String VIEW_NAME_VALUE = "HBoxView";
  public static final String MODEL_NAME_VALUE = "HBoxModel";


  public VBox(List<CommFunctionality> children) {
    super(children);
    openComm();
  }

  @Override
  public void updateValue(Object value) {

  }
  
  @Override
  public String getModelNameValue() {
    return MODEL_NAME_VALUE;
  }

  @Override
  public String getViewNameValue() {
    return VIEW_NAME_VALUE;
  }

}