/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.compiler.pipeline.accessor;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.renjin.compiler.pipeline.ComputeMethod;
import org.renjin.compiler.pipeline.DeferredNode;
import org.renjin.compiler.pipeline.accessor.Accessor;
import org.renjin.compiler.pipeline.accessor.Accessors;
import org.renjin.compiler.pipeline.accessor.InputGraph;
import org.renjin.sexp.Vector;

public class UnaryVectorOpAccessor
extends Accessor {
    private int operandIndex;
    private Accessor operandAccessor;
    private Method applyMethod;

    public UnaryVectorOpAccessor(DeferredNode node, InputGraph inputGraph) {
        this.operandIndex = inputGraph.getOperandIndex(node);
        this.operandAccessor = Accessors.create(node.getOperands().get(0), inputGraph);
        this.applyMethod = UnaryVectorOpAccessor.findStaticApply(node.getVector());
        assert (this.applyMethod != null);
    }

    public static boolean accept(DeferredNode node) {
        return UnaryVectorOpAccessor.findStaticApply(node.getVector()) != null;
    }

    private static Method findStaticApply(Vector vector2) {
        for (Method method : vector2.getClass().getMethods()) {
            if (!method.getName().equals("compute") || !Modifier.isPublic(method.getModifiers()) || !Modifier.isStatic(method.getModifiers()) || method.getParameterTypes().length != 1) continue;
            return method;
        }
        return null;
    }

    @Override
    public void init(ComputeMethod method) {
        this.operandAccessor.init(method);
    }

    @Override
    public void pushLength(ComputeMethod method) {
        this.operandAccessor.pushLength(method);
    }

    @Override
    public void pushDouble(ComputeMethod method) {
        this.operandAccessor.pushDouble(method);
        MethodVisitor mv = method.getVisitor();
        mv.visitMethodInsn(184, Type.getInternalName(this.applyMethod.getDeclaringClass()), this.applyMethod.getName(), Type.getMethodDescriptor((Method)this.applyMethod));
    }
}

