/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.fft2;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.imglib2.Dimensions;
import net.imglib2.FinalDimensions;
import net.imglib2.Interval;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.algorithm.fft2.FFTMethods;
import net.imglib2.img.Img;
import net.imglib2.img.ImgFactory;
import net.imglib2.outofbounds.OutOfBoundsFactory;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.ComplexType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.complex.ComplexFloatType;
import net.imglib2.util.Util;
import net.imglib2.view.IntervalView;
import net.imglib2.view.Views;

public class FFT {
    public static final <R extends RealType<R>> Img<ComplexFloatType> realToComplex(RandomAccessibleInterval<R> input, ImgFactory<ComplexFloatType> factory) {
        return FFT.realToComplex(Views.extendValue(input, (Type)((RealType)Util.getTypeFromInterval(input)).createVariable()), input, factory, new ComplexFloatType(), Runtime.getRuntime().availableProcessors());
    }

    public static final <R extends RealType<R>> Img<ComplexFloatType> realToComplex(RandomAccessibleInterval<R> input, ImgFactory<ComplexFloatType> factory, int numThreads) {
        return FFT.realToComplex(Views.extendValue(input, (Type)((RealType)Util.getTypeFromInterval(input)).createVariable()), input, factory, new ComplexFloatType(), numThreads);
    }

    public static final <R extends RealType<R>> Img<ComplexFloatType> realToComplex(RandomAccessibleInterval<R> input, ImgFactory<ComplexFloatType> factory, ExecutorService service) {
        return FFT.realToComplex(Views.extendValue(input, (Type)((RealType)Util.getTypeFromInterval(input)).createVariable()), input, factory, new ComplexFloatType(), service);
    }

    public static final <R extends RealType<R>> Img<ComplexFloatType> realToComplex(RandomAccessibleInterval<R> input, OutOfBoundsFactory<R, RandomAccessibleInterval<R>> oobs, ImgFactory<ComplexFloatType> factory) {
        return FFT.realToComplex(Views.extend(input, oobs), input, factory, new ComplexFloatType(), Runtime.getRuntime().availableProcessors());
    }

    public static final <R extends RealType<R>> Img<ComplexFloatType> realToComplex(RandomAccessibleInterval<R> input, OutOfBoundsFactory<R, RandomAccessibleInterval<R>> oobs, ImgFactory<ComplexFloatType> factory, int numThreads) {
        return FFT.realToComplex(Views.extend(input, oobs), input, factory, new ComplexFloatType(), numThreads);
    }

    public static final <R extends RealType<R>> Img<ComplexFloatType> realToComplex(RandomAccessibleInterval<R> input, OutOfBoundsFactory<R, RandomAccessibleInterval<R>> oobs, ImgFactory<ComplexFloatType> factory, ExecutorService service) {
        return FFT.realToComplex(Views.extend(input, oobs), input, factory, new ComplexFloatType(), service);
    }

    public static final <R extends RealType<R>, C extends ComplexType<C>> Img<C> realToComplex(RandomAccessible<R> input, Interval inputInterval, ImgFactory<C> factory, C type) {
        return FFT.realToComplex(input, inputInterval, factory, type, Runtime.getRuntime().availableProcessors());
    }

    public static final <R extends RealType<R>, C extends ComplexType<C>> Img<C> realToComplex(RandomAccessible<R> input, Interval inputInterval, ImgFactory<C> factory, C type, int numThreads) {
        ExecutorService service = Executors.newFixedThreadPool(numThreads);
        Img<C> ret = FFT.realToComplex(input, inputInterval, factory, type, service);
        service.shutdown();
        return ret;
    }

    public static final <R extends RealType<R>, C extends ComplexType<C>> Img<C> realToComplex(RandomAccessible<R> input, Interval inputInterval, ImgFactory<C> factory, C type, ExecutorService service) {
        long[] paddedDimensions = new long[input.numDimensions()];
        long[] fftDimensions = new long[input.numDimensions()];
        FFTMethods.dimensionsRealToComplexFast((Dimensions)inputInterval, paddedDimensions, fftDimensions);
        Img fft = factory.create(fftDimensions, type);
        if (!FFTMethods.dimensionsEqual(inputInterval, paddedDimensions)) {
            inputInterval = FFTMethods.paddingIntervalCentered(inputInterval, (Dimensions)FinalDimensions.wrap((long[])paddedDimensions));
        }
        FFT.realToComplex(Views.interval(input, (Interval)inputInterval), fft, service);
        return fft;
    }

    public static final <C extends ComplexType<C>, R extends RealType<R>> Img<R> complexToReal(RandomAccessibleInterval<C> input, ImgFactory<R> factory, R type) {
        return FFT.complexToReal(input, input, null, factory, type, Runtime.getRuntime().availableProcessors());
    }

    public static final <C extends ComplexType<C>, R extends RealType<R>> Img<R> complexToReal(RandomAccessibleInterval<C> input, ImgFactory<R> factory, R type, int numThreads) {
        return FFT.complexToReal(input, input, null, factory, type, numThreads);
    }

    public static final <C extends ComplexType<C>, R extends RealType<R>> Img<R> complexToReal(RandomAccessibleInterval<C> input, ImgFactory<R> factory, R type, ExecutorService service) {
        return FFT.complexToReal(input, input, null, factory, type, service);
    }

    public static final <C extends ComplexType<C>, R extends RealType<R>> Img<R> complexToReal(RandomAccessibleInterval<C> input, Interval outputDimensions, ImgFactory<R> factory, R type) {
        return FFT.complexToReal(input, input, outputDimensions, factory, type, Runtime.getRuntime().availableProcessors());
    }

    public static final <C extends ComplexType<C>, R extends RealType<R>> Img<R> complexToReal(RandomAccessibleInterval<C> input, Interval outputDimensions, ImgFactory<R> factory, R type, int numThreads) {
        return FFT.complexToReal(input, input, outputDimensions, factory, type, numThreads);
    }

    public static final <C extends ComplexType<C>, R extends RealType<R>> Img<R> complexToReal(RandomAccessibleInterval<C> input, Interval outputDimensions, ImgFactory<R> factory, R type, ExecutorService service) {
        return FFT.complexToReal(input, input, outputDimensions, factory, type, service);
    }

    public static final <C extends ComplexType<C>, R extends RealType<R>> Img<R> complexToReal(RandomAccessible<C> input, Interval inputInterval, ImgFactory<R> factory, R type) {
        return FFT.complexToReal(input, inputInterval, null, factory, type, Runtime.getRuntime().availableProcessors());
    }

    public static final <C extends ComplexType<C>, R extends RealType<R>> Img<R> complexToReal(RandomAccessible<C> input, Interval inputInterval, ImgFactory<R> factory, R type, int numThreads) {
        return FFT.complexToReal(input, inputInterval, null, factory, type, numThreads);
    }

    public static final <C extends ComplexType<C>, R extends RealType<R>> Img<R> complexToReal(RandomAccessible<C> input, Interval inputInterval, ImgFactory<R> factory, R type, ExecutorService service) {
        return FFT.complexToReal(input, inputInterval, null, factory, type, service);
    }

    public static final <C extends ComplexType<C>, R extends RealType<R>> Img<R> complexToReal(RandomAccessible<C> input, Interval inputInterval, Interval outputDimensions, ImgFactory<R> factory, R type) {
        return FFT.complexToReal(input, inputInterval, outputDimensions, factory, type, Runtime.getRuntime().availableProcessors());
    }

    public static final <C extends ComplexType<C>, R extends RealType<R>> Img<R> complexToReal(RandomAccessible<C> input, Interval inputInterval, Interval outputDimensions, ImgFactory<R> factory, R type, int numThreads) {
        ExecutorService service = Executors.newFixedThreadPool(numThreads);
        Img<R> ret = FFT.complexToReal(input, inputInterval, outputDimensions, factory, type, service);
        service.shutdown();
        return ret;
    }

    public static final <C extends ComplexType<C>, R extends RealType<R>> Img<R> complexToReal(RandomAccessible<C> input, Interval inputInterval, Interval outputDimensions, ImgFactory<R> factory, R type, ExecutorService service) {
        int numDimensions = input.numDimensions();
        long[] paddedDimensions = new long[numDimensions];
        long[] realDimensions = new long[numDimensions];
        FFTMethods.dimensionsComplexToRealFast((Dimensions)inputInterval, paddedDimensions, realDimensions);
        if (!FFTMethods.dimensionsEqual(inputInterval, paddedDimensions)) {
            System.out.println("adjusting complex input");
            inputInterval = FFTMethods.paddingIntervalCentered(inputInterval, (Dimensions)FinalDimensions.wrap((long[])paddedDimensions));
        }
        IntervalView fft = Views.interval(input, (Interval)inputInterval);
        if (outputDimensions == null) {
            Img output = factory.create(realDimensions, type);
            for (int d = numDimensions - 1; d > 0; --d) {
                FFTMethods.complexToComplex(fft, d, false);
            }
            FFTMethods.complexToReal(fft, output, 0, true, service);
            return output;
        }
        Img output = factory.create((Dimensions)outputDimensions, type);
        for (int d = numDimensions - 1; d > 0; --d) {
            FFTMethods.complexToComplex(fft, d, false, true, service);
        }
        FFTMethods.complexToReal(fft, output, FFTMethods.unpaddingIntervalCentered(inputInterval, (Dimensions)outputDimensions), 0, true, service);
        return output;
    }

    public static final <R extends RealType<R>, C extends ComplexType<C>> void realToComplex(RandomAccessibleInterval<R> input, RandomAccessibleInterval<C> output) {
        FFT.realToComplex(input, output, Runtime.getRuntime().availableProcessors());
    }

    public static final <R extends RealType<R>, C extends ComplexType<C>> void realToComplex(RandomAccessibleInterval<R> input, RandomAccessibleInterval<C> output, int numThreads) {
        ExecutorService service = Executors.newFixedThreadPool(numThreads);
        FFT.realToComplex(input, output, service);
        service.shutdown();
    }

    public static final <R extends RealType<R>, C extends ComplexType<C>> void realToComplex(RandomAccessibleInterval<R> input, RandomAccessibleInterval<C> output, ExecutorService service) {
        FFTMethods.realToComplex(input, output, 0, false, service);
        for (int d = 1; d < input.numDimensions(); ++d) {
            FFTMethods.complexToComplex(output, d, true, false, service);
        }
    }

    public static final <C extends ComplexType<C>> void complexToComplexForward(RandomAccessibleInterval<C> data) {
        FFT.complexToComplexForward(data, Runtime.getRuntime().availableProcessors());
    }

    public static final <C extends ComplexType<C>> void complexToComplexForward(RandomAccessibleInterval<C> data, int numThreads) {
        ExecutorService service = Executors.newFixedThreadPool(numThreads);
        FFT.complexToComplexForward(data, service);
        service.shutdown();
    }

    public static final <C extends ComplexType<C>> void complexToComplexForward(RandomAccessibleInterval<C> data, ExecutorService service) {
        for (int d = 0; d < data.numDimensions(); ++d) {
            FFTMethods.complexToComplex(data, d, true, false, service);
        }
    }

    public static final <C extends ComplexType<C>> void complexToComplexInverse(RandomAccessibleInterval<C> data) {
        FFT.complexToComplexInverse(data, Runtime.getRuntime().availableProcessors());
    }

    public static final <C extends ComplexType<C>> void complexToComplexInverse(RandomAccessibleInterval<C> data, int numThreads) {
        ExecutorService service = Executors.newFixedThreadPool(numThreads);
        FFT.complexToComplexInverse(data, service);
        service.shutdown();
    }

    public static final <C extends ComplexType<C>> void complexToComplexInverse(RandomAccessibleInterval<C> data, ExecutorService service) {
        for (int d = 0; d < data.numDimensions(); ++d) {
            FFTMethods.complexToComplex(data, d, false, true, service);
        }
    }

    public static final <C extends ComplexType<C>, R extends RealType<R>> void complexToReal(RandomAccessibleInterval<C> input, RandomAccessibleInterval<R> output) {
        FFT.complexToReal(input, output, Runtime.getRuntime().availableProcessors());
    }

    public static final <C extends ComplexType<C>, R extends RealType<R>> void complexToReal(RandomAccessibleInterval<C> input, RandomAccessibleInterval<R> output, int numThreads) {
        ExecutorService service = Executors.newFixedThreadPool(numThreads);
        FFT.complexToReal(input, output, service);
        service.shutdown();
    }

    public static final <C extends ComplexType<C>, R extends RealType<R>> void complexToReal(RandomAccessibleInterval<C> input, RandomAccessibleInterval<R> output, ExecutorService service) {
        for (int d = 1; d < input.numDimensions(); ++d) {
            FFTMethods.complexToComplex(input, d, false, true, service);
        }
        FFTMethods.complexToReal(input, output, 0, true, service);
    }

    public static final <C extends ComplexType<C>, R extends RealType<R>> void complexToRealUnpad(RandomAccessibleInterval<C> input, RandomAccessibleInterval<R> output) {
        FFT.complexToRealUnpad(input, output, Runtime.getRuntime().availableProcessors());
    }

    public static final <C extends ComplexType<C>, R extends RealType<R>> void complexToRealUnpad(RandomAccessibleInterval<C> input, RandomAccessibleInterval<R> output, int numThreads) {
        ExecutorService service = Executors.newFixedThreadPool(numThreads);
        FFT.complexToRealUnpad(input, output, service);
        service.shutdown();
    }

    public static final <C extends ComplexType<C>, R extends RealType<R>> void complexToRealUnpad(RandomAccessibleInterval<C> input, RandomAccessibleInterval<R> output, ExecutorService service) {
        for (int d = 1; d < input.numDimensions(); ++d) {
            FFTMethods.complexToComplex(input, d, false, true, service);
        }
        FFTMethods.complexToReal(input, output, FFTMethods.unpaddingIntervalCentered(input, output), 0, true, service);
    }
}

