/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.jython.shaded.com.ziclix.python.sql.connect;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import org.python.core.Py;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.Untraversable;
import org.scijava.jython.shaded.com.ziclix.python.sql.PyConnection;
import org.scijava.jython.shaded.com.ziclix.python.sql.util.PyArgParser;
import org.scijava.jython.shaded.com.ziclix.python.sql.zxJDBC;

@Untraversable
public class Connect
extends PyObject {
    private static final PyString _doc = new PyString("establish a connection through java.sql.DriverManager");

    @Override
    public PyObject __findattr_ex__(String name) {
        if ("__doc__".equals(name)) {
            return _doc;
        }
        return super.__findattr_ex__(name);
    }

    @Override
    public PyObject __call__(PyObject[] args, String[] keywords) {
        Connection c = null;
        PyArgParser parser2 = new PyArgParser(args, keywords);
        Object arg = parser2.arg(0).__tojava__(Connection.class);
        if (arg == Py.NoConversion) {
            Properties props = new Properties();
            String url = (String)parser2.arg(0).__tojava__(String.class);
            String user2 = (String)parser2.arg(1).__tojava__(String.class);
            String password = (String)parser2.arg(2).__tojava__(String.class);
            String driver = (String)parser2.arg(3).__tojava__(String.class);
            if (url == null) {
                throw zxJDBC.makeException(zxJDBC.DatabaseError, "no url specified");
            }
            if (driver == null) {
                throw zxJDBC.makeException(zxJDBC.DatabaseError, "no driver specified");
            }
            props.put("user", user2 == null ? "" : user2);
            props.put("password", password == null ? "" : password);
            String[] kws = parser2.kws();
            for (int i = 0; i < kws.length; ++i) {
                Object value = parser2.kw(kws[i]).__tojava__(Object.class);
                props.put(kws[i], value);
            }
            try {
                Class.forName(driver);
            }
            catch (Throwable e) {
                throw zxJDBC.makeException(zxJDBC.DatabaseError, "driver [" + driver + "] not found");
            }
            try {
                c = DriverManager.getConnection(url, props);
            }
            catch (SQLException e) {
                throw zxJDBC.makeException(zxJDBC.DatabaseError, e);
            }
        }
        c = (Connection)arg;
        try {
            if (c == null || c.isClosed()) {
                throw zxJDBC.makeException(zxJDBC.DatabaseError, "unable to establish connection");
            }
            return new PyConnection(c);
        }
        catch (SQLException e) {
            throw zxJDBC.makeException(zxJDBC.DatabaseError, e);
        }
    }

    @Override
    public String toString() {
        return "<connect object instance at " + Py.id(this) + ">";
    }
}

