/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.jtransforms.fft;

import edu.emory.mathcs.jtransforms.fft.DoubleFFT_1D;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.concurrent.Future;

public class DoubleFFT_3D {
    private int slices;
    private int rows;
    private int columns;
    private int sliceStride;
    private int rowStride;
    private double[] t;
    private DoubleFFT_1D fftSlices;
    private DoubleFFT_1D fftRows;
    private DoubleFFT_1D fftColumns;
    private int oldNthreads;
    private int nt;
    private boolean isPowerOfTwo = false;
    private boolean useThreads = false;

    public DoubleFFT_3D(int n, int n2, int n3) {
        if (n <= 1 || n2 <= 1 || n3 <= 1) {
            throw new IllegalArgumentException("slices, rows and columns must be greater than 1");
        }
        this.slices = n;
        this.rows = n2;
        this.columns = n3;
        this.sliceStride = n2 * n3;
        this.rowStride = n3;
        if (n * n2 * n3 >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            this.useThreads = true;
        }
        if (ConcurrencyUtils.isPowerOf2(n) && ConcurrencyUtils.isPowerOf2(n2) && ConcurrencyUtils.isPowerOf2(n3)) {
            this.isPowerOfTwo = true;
            this.oldNthreads = ConcurrencyUtils.getNumberOfThreads();
            this.nt = n;
            if (this.nt < n2) {
                this.nt = n2;
            }
            this.nt *= 8;
            if (this.oldNthreads > 1) {
                this.nt *= this.oldNthreads;
            }
            if (2 * n3 == 4) {
                this.nt >>= 1;
            } else if (2 * n3 < 4) {
                this.nt >>= 2;
            }
            this.t = new double[this.nt];
        }
        this.fftSlices = new DoubleFFT_1D(n);
        this.fftRows = n == n2 ? this.fftSlices : new DoubleFFT_1D(n2);
        this.fftColumns = n == n3 ? this.fftSlices : (n2 == n3 ? this.fftRows : new DoubleFFT_1D(n3));
    }

    public void complexForward(final double[] dArray) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            int n2 = this.columns;
            this.columns = 2 * this.columns;
            this.sliceStride = this.rows * this.columns;
            this.rowStride = this.columns;
            if (n != this.oldNthreads) {
                this.nt = this.slices;
                if (this.nt < this.rows) {
                    this.nt = this.rows;
                }
                this.nt *= 8;
                if (n > 1) {
                    this.nt *= n;
                }
                if (this.columns == 4) {
                    this.nt >>= 1;
                } else if (this.columns < 4) {
                    this.nt >>= 2;
                }
                this.t = new double[this.nt];
                this.oldNthreads = n;
            }
            if (n > 1 && this.useThreads) {
                this.xdft3da_subth2(0, -1, dArray, true);
                this.cdft3db_subth(-1, dArray, true);
            } else {
                this.xdft3da_sub2(0, -1, dArray, true);
                this.cdft3db_sub(-1, dArray, true);
            }
            this.columns = n2;
            this.sliceStride = this.rows * this.columns;
            this.rowStride = this.columns;
        } else {
            this.sliceStride = 2 * this.rows * this.columns;
            this.rowStride = 2 * this.columns;
            if (n > 1 && this.useThreads && this.slices >= n && this.rows >= n && this.columns >= n) {
                int n3;
                int n4;
                int n5;
                Future[] futureArray = new Future[n];
                int n6 = this.slices / n;
                for (n5 = 0; n5 < n; ++n5) {
                    n4 = n5 * n6;
                    n3 = n5 == n - 1 ? this.slices : n4 + n6;
                    futureArray[n5] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            for (int i = n4; i < n3; ++i) {
                                int n = i * DoubleFFT_3D.this.sliceStride;
                                for (int j = 0; j < DoubleFFT_3D.this.rows; ++j) {
                                    DoubleFFT_3D.this.fftColumns.complexForward(dArray, n + j * DoubleFFT_3D.this.rowStride);
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
                for (n5 = 0; n5 < n; ++n5) {
                    n4 = n5 * n6;
                    n3 = n5 == n - 1 ? this.slices : n4 + n6;
                    futureArray[n5] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            double[] dArray2 = new double[2 * DoubleFFT_3D.this.rows];
                            for (int i = n4; i < n3; ++i) {
                                int n = i * DoubleFFT_3D.this.sliceStride;
                                for (int j = 0; j < DoubleFFT_3D.this.columns; ++j) {
                                    int n2;
                                    int n32;
                                    int n42;
                                    int n5 = 2 * j;
                                    for (n42 = 0; n42 < DoubleFFT_3D.this.rows; ++n42) {
                                        n32 = n + n5 + n42 * DoubleFFT_3D.this.rowStride;
                                        n2 = 2 * n42;
                                        dArray2[n2] = dArray[n32];
                                        dArray2[n2 + 1] = dArray[n32 + 1];
                                    }
                                    DoubleFFT_3D.this.fftRows.complexForward(dArray2);
                                    for (n42 = 0; n42 < DoubleFFT_3D.this.rows; ++n42) {
                                        n32 = n + n5 + n42 * DoubleFFT_3D.this.rowStride;
                                        n2 = 2 * n42;
                                        dArray[n32] = dArray2[n2];
                                        dArray[n32 + 1] = dArray2[n2 + 1];
                                    }
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
                n6 = this.rows / n;
                for (n5 = 0; n5 < n; ++n5) {
                    n4 = n5 * n6;
                    n3 = n5 == n - 1 ? this.rows : n4 + n6;
                    futureArray[n5] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            double[] dArray2 = new double[2 * DoubleFFT_3D.this.slices];
                            for (int i = n4; i < n3; ++i) {
                                int n = i * DoubleFFT_3D.this.rowStride;
                                for (int j = 0; j < DoubleFFT_3D.this.columns; ++j) {
                                    int n2;
                                    int n32;
                                    int n42;
                                    int n5 = 2 * j;
                                    for (n42 = 0; n42 < DoubleFFT_3D.this.slices; ++n42) {
                                        n32 = n42 * DoubleFFT_3D.this.sliceStride + n + n5;
                                        n2 = 2 * n42;
                                        dArray2[n2] = dArray[n32];
                                        dArray2[n2 + 1] = dArray[n32 + 1];
                                    }
                                    DoubleFFT_3D.this.fftSlices.complexForward(dArray2);
                                    for (n42 = 0; n42 < DoubleFFT_3D.this.slices; ++n42) {
                                        n32 = n42 * DoubleFFT_3D.this.sliceStride + n + n5;
                                        n2 = 2 * n42;
                                        dArray[n32] = dArray2[n2];
                                        dArray[n32 + 1] = dArray2[n2 + 1];
                                    }
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
            } else {
                int n7;
                int n8;
                int n9;
                int n10;
                int n11;
                int n12;
                int n13;
                for (int i = 0; i < this.slices; ++i) {
                    n13 = i * this.sliceStride;
                    for (n12 = 0; n12 < this.rows; ++n12) {
                        this.fftColumns.complexForward(dArray, n13 + n12 * this.rowStride);
                    }
                }
                double[] dArray2 = new double[2 * this.rows];
                for (n13 = 0; n13 < this.slices; ++n13) {
                    n12 = n13 * this.sliceStride;
                    for (n11 = 0; n11 < this.columns; ++n11) {
                        n10 = 2 * n11;
                        for (n9 = 0; n9 < this.rows; ++n9) {
                            n8 = n12 + n10 + n9 * this.rowStride;
                            n7 = 2 * n9;
                            dArray2[n7] = dArray[n8];
                            dArray2[n7 + 1] = dArray[n8 + 1];
                        }
                        this.fftRows.complexForward(dArray2);
                        for (n9 = 0; n9 < this.rows; ++n9) {
                            n8 = n12 + n10 + n9 * this.rowStride;
                            n7 = 2 * n9;
                            dArray[n8] = dArray2[n7];
                            dArray[n8 + 1] = dArray2[n7 + 1];
                        }
                    }
                }
                dArray2 = new double[2 * this.slices];
                for (n13 = 0; n13 < this.rows; ++n13) {
                    n12 = n13 * this.rowStride;
                    for (n11 = 0; n11 < this.columns; ++n11) {
                        n10 = 2 * n11;
                        for (n9 = 0; n9 < this.slices; ++n9) {
                            n8 = n9 * this.sliceStride + n12 + n10;
                            n7 = 2 * n9;
                            dArray2[n7] = dArray[n8];
                            dArray2[n7 + 1] = dArray[n8 + 1];
                        }
                        this.fftSlices.complexForward(dArray2);
                        for (n9 = 0; n9 < this.slices; ++n9) {
                            n8 = n9 * this.sliceStride + n12 + n10;
                            n7 = 2 * n9;
                            dArray[n8] = dArray2[n7];
                            dArray[n8 + 1] = dArray2[n7 + 1];
                        }
                    }
                }
            }
            this.sliceStride = this.rows * this.columns;
            this.rowStride = this.columns;
        }
    }

    public void complexForward(final double[][][] dArray) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            int n2 = this.columns;
            this.columns = 2 * this.columns;
            this.sliceStride = this.rows * this.columns;
            this.rowStride = this.columns;
            if (n != this.oldNthreads) {
                this.nt = this.slices;
                if (this.nt < this.rows) {
                    this.nt = this.rows;
                }
                this.nt *= 8;
                if (n > 1) {
                    this.nt *= n;
                }
                if (this.columns == 4) {
                    this.nt >>= 1;
                } else if (this.columns < 4) {
                    this.nt >>= 2;
                }
                this.t = new double[this.nt];
                this.oldNthreads = n;
            }
            if (n > 1 && this.useThreads) {
                this.xdft3da_subth2(0, -1, dArray, true);
                this.cdft3db_subth(-1, dArray, true);
            } else {
                this.xdft3da_sub2(0, -1, dArray, true);
                this.cdft3db_sub(-1, dArray, true);
            }
            this.columns = n2;
            this.sliceStride = this.rows * this.columns;
            this.rowStride = this.columns;
        } else if (n > 1 && this.useThreads && this.slices >= n && this.rows >= n && this.columns >= n) {
            int n3;
            int n4;
            int n5;
            Future[] futureArray = new Future[n];
            int n6 = this.slices / n;
            for (n5 = 0; n5 < n; ++n5) {
                n4 = n5 * n6;
                n3 = n5 == n - 1 ? this.slices : n4 + n6;
                futureArray[n5] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n4; i < n3; ++i) {
                            for (int j = 0; j < DoubleFFT_3D.this.rows; ++j) {
                                DoubleFFT_3D.this.fftColumns.complexForward(dArray[i][j]);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            for (n5 = 0; n5 < n; ++n5) {
                n4 = n5 * n6;
                n3 = n5 == n - 1 ? this.slices : n4 + n6;
                futureArray[n5] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        double[] dArray2 = new double[2 * DoubleFFT_3D.this.rows];
                        for (int i = n4; i < n3; ++i) {
                            for (int j = 0; j < DoubleFFT_3D.this.columns; ++j) {
                                int n;
                                int n2;
                                int n32 = 2 * j;
                                for (n2 = 0; n2 < DoubleFFT_3D.this.rows; ++n2) {
                                    n = 2 * n2;
                                    dArray2[n] = dArray[i][n2][n32];
                                    dArray2[n + 1] = dArray[i][n2][n32 + 1];
                                }
                                DoubleFFT_3D.this.fftRows.complexForward(dArray2);
                                for (n2 = 0; n2 < DoubleFFT_3D.this.rows; ++n2) {
                                    n = 2 * n2;
                                    dArray[i][n2][n32] = dArray2[n];
                                    dArray[i][n2][n32 + 1] = dArray2[n + 1];
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            n6 = this.rows / n;
            for (n5 = 0; n5 < n; ++n5) {
                n4 = n5 * n6;
                n3 = n5 == n - 1 ? this.rows : n4 + n6;
                futureArray[n5] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        double[] dArray2 = new double[2 * DoubleFFT_3D.this.slices];
                        for (int i = n4; i < n3; ++i) {
                            for (int j = 0; j < DoubleFFT_3D.this.columns; ++j) {
                                int n;
                                int n2;
                                int n32 = 2 * j;
                                for (n2 = 0; n2 < DoubleFFT_3D.this.slices; ++n2) {
                                    n = 2 * n2;
                                    dArray2[n] = dArray[n2][i][n32];
                                    dArray2[n + 1] = dArray[n2][i][n32 + 1];
                                }
                                DoubleFFT_3D.this.fftSlices.complexForward(dArray2);
                                for (n2 = 0; n2 < DoubleFFT_3D.this.slices; ++n2) {
                                    n = 2 * n2;
                                    dArray[n2][i][n32] = dArray2[n];
                                    dArray[n2][i][n32 + 1] = dArray2[n + 1];
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n7;
            int n8;
            int n9;
            int n10;
            int n11;
            for (int i = 0; i < this.slices; ++i) {
                for (n11 = 0; n11 < this.rows; ++n11) {
                    this.fftColumns.complexForward(dArray[i][n11]);
                }
            }
            double[] dArray2 = new double[2 * this.rows];
            for (n11 = 0; n11 < this.slices; ++n11) {
                for (n10 = 0; n10 < this.columns; ++n10) {
                    n9 = 2 * n10;
                    for (n8 = 0; n8 < this.rows; ++n8) {
                        n7 = 2 * n8;
                        dArray2[n7] = dArray[n11][n8][n9];
                        dArray2[n7 + 1] = dArray[n11][n8][n9 + 1];
                    }
                    this.fftRows.complexForward(dArray2);
                    for (n8 = 0; n8 < this.rows; ++n8) {
                        n7 = 2 * n8;
                        dArray[n11][n8][n9] = dArray2[n7];
                        dArray[n11][n8][n9 + 1] = dArray2[n7 + 1];
                    }
                }
            }
            dArray2 = new double[2 * this.slices];
            for (n11 = 0; n11 < this.rows; ++n11) {
                for (n10 = 0; n10 < this.columns; ++n10) {
                    n9 = 2 * n10;
                    for (n8 = 0; n8 < this.slices; ++n8) {
                        n7 = 2 * n8;
                        dArray2[n7] = dArray[n8][n11][n9];
                        dArray2[n7 + 1] = dArray[n8][n11][n9 + 1];
                    }
                    this.fftSlices.complexForward(dArray2);
                    for (n8 = 0; n8 < this.slices; ++n8) {
                        n7 = 2 * n8;
                        dArray[n8][n11][n9] = dArray2[n7];
                        dArray[n8][n11][n9 + 1] = dArray2[n7 + 1];
                    }
                }
            }
        }
    }

    public void complexInverse(final double[] dArray, final boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            int n2 = this.columns;
            this.columns = 2 * this.columns;
            this.sliceStride = this.rows * this.columns;
            this.rowStride = this.columns;
            if (n != this.oldNthreads) {
                this.nt = this.slices;
                if (this.nt < this.rows) {
                    this.nt = this.rows;
                }
                this.nt *= 8;
                if (n > 1) {
                    this.nt *= n;
                }
                if (this.columns == 4) {
                    this.nt >>= 1;
                } else if (this.columns < 4) {
                    this.nt >>= 2;
                }
                this.t = new double[this.nt];
                this.oldNthreads = n;
            }
            if (n > 1 && this.useThreads) {
                this.xdft3da_subth2(0, 1, dArray, bl);
                this.cdft3db_subth(1, dArray, bl);
            } else {
                this.xdft3da_sub2(0, 1, dArray, bl);
                this.cdft3db_sub(1, dArray, bl);
            }
            this.columns = n2;
            this.sliceStride = this.rows * this.columns;
            this.rowStride = this.columns;
        } else {
            this.sliceStride = 2 * this.rows * this.columns;
            this.rowStride = 2 * this.columns;
            if (n > 1 && this.useThreads && this.slices >= n && this.rows >= n && this.columns >= n) {
                int n3;
                int n4;
                int n5;
                Future[] futureArray = new Future[n];
                int n6 = this.slices / n;
                for (n5 = 0; n5 < n; ++n5) {
                    n4 = n5 * n6;
                    n3 = n5 == n - 1 ? this.slices : n4 + n6;
                    futureArray[n5] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            for (int i = n4; i < n3; ++i) {
                                int n = i * DoubleFFT_3D.this.sliceStride;
                                for (int j = 0; j < DoubleFFT_3D.this.rows; ++j) {
                                    DoubleFFT_3D.this.fftColumns.complexInverse(dArray, n + j * DoubleFFT_3D.this.rowStride, bl);
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
                for (n5 = 0; n5 < n; ++n5) {
                    n4 = n5 * n6;
                    n3 = n5 == n - 1 ? this.slices : n4 + n6;
                    futureArray[n5] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            double[] dArray2 = new double[2 * DoubleFFT_3D.this.rows];
                            for (int i = n4; i < n3; ++i) {
                                int n = i * DoubleFFT_3D.this.sliceStride;
                                for (int j = 0; j < DoubleFFT_3D.this.columns; ++j) {
                                    int n2;
                                    int n32;
                                    int n42;
                                    int n5 = 2 * j;
                                    for (n42 = 0; n42 < DoubleFFT_3D.this.rows; ++n42) {
                                        n32 = n + n5 + n42 * DoubleFFT_3D.this.rowStride;
                                        n2 = 2 * n42;
                                        dArray2[n2] = dArray[n32];
                                        dArray2[n2 + 1] = dArray[n32 + 1];
                                    }
                                    DoubleFFT_3D.this.fftRows.complexInverse(dArray2, bl);
                                    for (n42 = 0; n42 < DoubleFFT_3D.this.rows; ++n42) {
                                        n32 = n + n5 + n42 * DoubleFFT_3D.this.rowStride;
                                        n2 = 2 * n42;
                                        dArray[n32] = dArray2[n2];
                                        dArray[n32 + 1] = dArray2[n2 + 1];
                                    }
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
                n6 = this.rows / n;
                for (n5 = 0; n5 < n; ++n5) {
                    n4 = n5 * n6;
                    n3 = n5 == n - 1 ? this.rows : n4 + n6;
                    futureArray[n5] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            double[] dArray2 = new double[2 * DoubleFFT_3D.this.slices];
                            for (int i = n4; i < n3; ++i) {
                                int n = i * DoubleFFT_3D.this.rowStride;
                                for (int j = 0; j < DoubleFFT_3D.this.columns; ++j) {
                                    int n2;
                                    int n32;
                                    int n42;
                                    int n5 = 2 * j;
                                    for (n42 = 0; n42 < DoubleFFT_3D.this.slices; ++n42) {
                                        n32 = n42 * DoubleFFT_3D.this.sliceStride + n + n5;
                                        n2 = 2 * n42;
                                        dArray2[n2] = dArray[n32];
                                        dArray2[n2 + 1] = dArray[n32 + 1];
                                    }
                                    DoubleFFT_3D.this.fftSlices.complexInverse(dArray2, bl);
                                    for (n42 = 0; n42 < DoubleFFT_3D.this.slices; ++n42) {
                                        n32 = n42 * DoubleFFT_3D.this.sliceStride + n + n5;
                                        n2 = 2 * n42;
                                        dArray[n32] = dArray2[n2];
                                        dArray[n32 + 1] = dArray2[n2 + 1];
                                    }
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
            } else {
                int n7;
                int n8;
                int n9;
                int n10;
                int n11;
                int n12;
                int n13;
                for (int i = 0; i < this.slices; ++i) {
                    n13 = i * this.sliceStride;
                    for (n12 = 0; n12 < this.rows; ++n12) {
                        this.fftColumns.complexInverse(dArray, n13 + n12 * this.rowStride, bl);
                    }
                }
                double[] dArray2 = new double[2 * this.rows];
                for (n13 = 0; n13 < this.slices; ++n13) {
                    n12 = n13 * this.sliceStride;
                    for (n11 = 0; n11 < this.columns; ++n11) {
                        n10 = 2 * n11;
                        for (n9 = 0; n9 < this.rows; ++n9) {
                            n8 = n12 + n10 + n9 * this.rowStride;
                            n7 = 2 * n9;
                            dArray2[n7] = dArray[n8];
                            dArray2[n7 + 1] = dArray[n8 + 1];
                        }
                        this.fftRows.complexInverse(dArray2, bl);
                        for (n9 = 0; n9 < this.rows; ++n9) {
                            n8 = n12 + n10 + n9 * this.rowStride;
                            n7 = 2 * n9;
                            dArray[n8] = dArray2[n7];
                            dArray[n8 + 1] = dArray2[n7 + 1];
                        }
                    }
                }
                dArray2 = new double[2 * this.slices];
                for (n13 = 0; n13 < this.rows; ++n13) {
                    n12 = n13 * this.rowStride;
                    for (n11 = 0; n11 < this.columns; ++n11) {
                        n10 = 2 * n11;
                        for (n9 = 0; n9 < this.slices; ++n9) {
                            n8 = n9 * this.sliceStride + n12 + n10;
                            n7 = 2 * n9;
                            dArray2[n7] = dArray[n8];
                            dArray2[n7 + 1] = dArray[n8 + 1];
                        }
                        this.fftSlices.complexInverse(dArray2, bl);
                        for (n9 = 0; n9 < this.slices; ++n9) {
                            n8 = n9 * this.sliceStride + n12 + n10;
                            n7 = 2 * n9;
                            dArray[n8] = dArray2[n7];
                            dArray[n8 + 1] = dArray2[n7 + 1];
                        }
                    }
                }
            }
            this.sliceStride = this.rows * this.columns;
            this.rowStride = this.columns;
        }
    }

    public void complexInverse(final double[][][] dArray, final boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            int n2 = this.columns;
            this.columns = 2 * this.columns;
            this.sliceStride = this.rows * this.columns;
            this.rowStride = this.columns;
            if (n != this.oldNthreads) {
                this.nt = this.slices;
                if (this.nt < this.rows) {
                    this.nt = this.rows;
                }
                this.nt *= 8;
                if (n > 1) {
                    this.nt *= n;
                }
                if (this.columns == 4) {
                    this.nt >>= 1;
                } else if (this.columns < 4) {
                    this.nt >>= 2;
                }
                this.t = new double[this.nt];
                this.oldNthreads = n;
            }
            if (n > 1 && this.useThreads) {
                this.xdft3da_subth2(0, 1, dArray, bl);
                this.cdft3db_subth(1, dArray, bl);
            } else {
                this.xdft3da_sub2(0, 1, dArray, bl);
                this.cdft3db_sub(1, dArray, bl);
            }
            this.columns = n2;
            this.sliceStride = this.rows * this.columns;
            this.rowStride = this.columns;
        } else if (n > 1 && this.useThreads && this.slices >= n && this.rows >= n && this.columns >= n) {
            int n3;
            int n4;
            int n5;
            Future[] futureArray = new Future[n];
            int n6 = this.slices / n;
            for (n5 = 0; n5 < n; ++n5) {
                n4 = n5 * n6;
                n3 = n5 == n - 1 ? this.slices : n4 + n6;
                futureArray[n5] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n4; i < n3; ++i) {
                            for (int j = 0; j < DoubleFFT_3D.this.rows; ++j) {
                                DoubleFFT_3D.this.fftColumns.complexInverse(dArray[i][j], bl);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            for (n5 = 0; n5 < n; ++n5) {
                n4 = n5 * n6;
                n3 = n5 == n - 1 ? this.slices : n4 + n6;
                futureArray[n5] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        double[] dArray2 = new double[2 * DoubleFFT_3D.this.rows];
                        for (int i = n4; i < n3; ++i) {
                            for (int j = 0; j < DoubleFFT_3D.this.columns; ++j) {
                                int n;
                                int n2;
                                int n32 = 2 * j;
                                for (n2 = 0; n2 < DoubleFFT_3D.this.rows; ++n2) {
                                    n = 2 * n2;
                                    dArray2[n] = dArray[i][n2][n32];
                                    dArray2[n + 1] = dArray[i][n2][n32 + 1];
                                }
                                DoubleFFT_3D.this.fftRows.complexInverse(dArray2, bl);
                                for (n2 = 0; n2 < DoubleFFT_3D.this.rows; ++n2) {
                                    n = 2 * n2;
                                    dArray[i][n2][n32] = dArray2[n];
                                    dArray[i][n2][n32 + 1] = dArray2[n + 1];
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            n6 = this.rows / n;
            for (n5 = 0; n5 < n; ++n5) {
                n4 = n5 * n6;
                n3 = n5 == n - 1 ? this.rows : n4 + n6;
                futureArray[n5] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        double[] dArray2 = new double[2 * DoubleFFT_3D.this.slices];
                        for (int i = n4; i < n3; ++i) {
                            for (int j = 0; j < DoubleFFT_3D.this.columns; ++j) {
                                int n;
                                int n2;
                                int n32 = 2 * j;
                                for (n2 = 0; n2 < DoubleFFT_3D.this.slices; ++n2) {
                                    n = 2 * n2;
                                    dArray2[n] = dArray[n2][i][n32];
                                    dArray2[n + 1] = dArray[n2][i][n32 + 1];
                                }
                                DoubleFFT_3D.this.fftSlices.complexInverse(dArray2, bl);
                                for (n2 = 0; n2 < DoubleFFT_3D.this.slices; ++n2) {
                                    n = 2 * n2;
                                    dArray[n2][i][n32] = dArray2[n];
                                    dArray[n2][i][n32 + 1] = dArray2[n + 1];
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n7;
            int n8;
            int n9;
            int n10;
            int n11;
            for (int i = 0; i < this.slices; ++i) {
                for (n11 = 0; n11 < this.rows; ++n11) {
                    this.fftColumns.complexInverse(dArray[i][n11], bl);
                }
            }
            double[] dArray2 = new double[2 * this.rows];
            for (n11 = 0; n11 < this.slices; ++n11) {
                for (n10 = 0; n10 < this.columns; ++n10) {
                    n9 = 2 * n10;
                    for (n8 = 0; n8 < this.rows; ++n8) {
                        n7 = 2 * n8;
                        dArray2[n7] = dArray[n11][n8][n9];
                        dArray2[n7 + 1] = dArray[n11][n8][n9 + 1];
                    }
                    this.fftRows.complexInverse(dArray2, bl);
                    for (n8 = 0; n8 < this.rows; ++n8) {
                        n7 = 2 * n8;
                        dArray[n11][n8][n9] = dArray2[n7];
                        dArray[n11][n8][n9 + 1] = dArray2[n7 + 1];
                    }
                }
            }
            dArray2 = new double[2 * this.slices];
            for (n11 = 0; n11 < this.rows; ++n11) {
                for (n10 = 0; n10 < this.columns; ++n10) {
                    n9 = 2 * n10;
                    for (n8 = 0; n8 < this.slices; ++n8) {
                        n7 = 2 * n8;
                        dArray2[n7] = dArray[n8][n11][n9];
                        dArray2[n7 + 1] = dArray[n8][n11][n9 + 1];
                    }
                    this.fftSlices.complexInverse(dArray2, bl);
                    for (n8 = 0; n8 < this.slices; ++n8) {
                        n7 = 2 * n8;
                        dArray[n8][n11][n9] = dArray2[n7];
                        dArray[n8][n11][n9 + 1] = dArray2[n7 + 1];
                    }
                }
            }
        }
    }

    public void realForward(double[] dArray) {
        if (!this.isPowerOfTwo) {
            throw new IllegalArgumentException("slices, rows and columns must be power of two numbers");
        }
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n != this.oldNthreads) {
            this.nt = this.slices;
            if (this.nt < this.rows) {
                this.nt = this.rows;
            }
            this.nt *= 8;
            if (n > 1) {
                this.nt *= n;
            }
            if (this.columns == 4) {
                this.nt >>= 1;
            } else if (this.columns < 4) {
                this.nt >>= 2;
            }
            this.t = new double[this.nt];
            this.oldNthreads = n;
        }
        if (n > 1 && this.useThreads) {
            this.xdft3da_subth1(1, -1, dArray, true);
            this.cdft3db_subth(-1, dArray, true);
            this.rdft3d_sub(1, dArray);
        } else {
            this.xdft3da_sub1(1, -1, dArray, true);
            this.cdft3db_sub(-1, dArray, true);
            this.rdft3d_sub(1, dArray);
        }
    }

    public void realForward(double[][][] dArray) {
        if (!this.isPowerOfTwo) {
            throw new IllegalArgumentException("slices, rows and columns must be power of two numbers");
        }
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n != this.oldNthreads) {
            this.nt = this.slices;
            if (this.nt < this.rows) {
                this.nt = this.rows;
            }
            this.nt *= 8;
            if (n > 1) {
                this.nt *= n;
            }
            if (this.columns == 4) {
                this.nt >>= 1;
            } else if (this.columns < 4) {
                this.nt >>= 2;
            }
            this.t = new double[this.nt];
            this.oldNthreads = n;
        }
        if (n > 1 && this.useThreads) {
            this.xdft3da_subth1(1, -1, dArray, true);
            this.cdft3db_subth(-1, dArray, true);
            this.rdft3d_sub(1, dArray);
        } else {
            this.xdft3da_sub1(1, -1, dArray, true);
            this.cdft3db_sub(-1, dArray, true);
            this.rdft3d_sub(1, dArray);
        }
    }

    public void realForwardFull(double[] dArray) {
        if (this.isPowerOfTwo) {
            int n = ConcurrencyUtils.getNumberOfThreads();
            if (n != this.oldNthreads) {
                this.nt = this.slices;
                if (this.nt < this.rows) {
                    this.nt = this.rows;
                }
                this.nt *= 8;
                if (n > 1) {
                    this.nt *= n;
                }
                if (this.columns == 4) {
                    this.nt >>= 1;
                } else if (this.columns < 4) {
                    this.nt >>= 2;
                }
                this.t = new double[this.nt];
                this.oldNthreads = n;
            }
            if (n > 1 && this.useThreads) {
                this.xdft3da_subth2(1, -1, dArray, true);
                this.cdft3db_subth(-1, dArray, true);
                this.rdft3d_sub(1, dArray);
            } else {
                this.xdft3da_sub2(1, -1, dArray, true);
                this.cdft3db_sub(-1, dArray, true);
                this.rdft3d_sub(1, dArray);
            }
            this.fillSymmetric(dArray);
        } else {
            this.mixedRadixRealForwardFull(dArray);
        }
    }

    public void realForwardFull(double[][][] dArray) {
        if (this.isPowerOfTwo) {
            int n = ConcurrencyUtils.getNumberOfThreads();
            if (n != this.oldNthreads) {
                this.nt = this.slices;
                if (this.nt < this.rows) {
                    this.nt = this.rows;
                }
                this.nt *= 8;
                if (n > 1) {
                    this.nt *= n;
                }
                if (this.columns == 4) {
                    this.nt >>= 1;
                } else if (this.columns < 4) {
                    this.nt >>= 2;
                }
                this.t = new double[this.nt];
                this.oldNthreads = n;
            }
            if (n > 1 && this.useThreads) {
                this.xdft3da_subth2(1, -1, dArray, true);
                this.cdft3db_subth(-1, dArray, true);
                this.rdft3d_sub(1, dArray);
            } else {
                this.xdft3da_sub2(1, -1, dArray, true);
                this.cdft3db_sub(-1, dArray, true);
                this.rdft3d_sub(1, dArray);
            }
            this.fillSymmetric(dArray);
        } else {
            this.mixedRadixRealForwardFull(dArray);
        }
    }

    public void realInverse(double[] dArray, boolean bl) {
        if (!this.isPowerOfTwo) {
            throw new IllegalArgumentException("slices, rows and columns must be power of two numbers");
        }
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n != this.oldNthreads) {
            this.nt = this.slices;
            if (this.nt < this.rows) {
                this.nt = this.rows;
            }
            this.nt *= 8;
            if (n > 1) {
                this.nt *= n;
            }
            if (this.columns == 4) {
                this.nt >>= 1;
            } else if (this.columns < 4) {
                this.nt >>= 2;
            }
            this.t = new double[this.nt];
            this.oldNthreads = n;
        }
        if (n > 1 && this.useThreads) {
            this.rdft3d_sub(-1, dArray);
            this.cdft3db_subth(1, dArray, bl);
            this.xdft3da_subth1(1, 1, dArray, bl);
        } else {
            this.rdft3d_sub(-1, dArray);
            this.cdft3db_sub(1, dArray, bl);
            this.xdft3da_sub1(1, 1, dArray, bl);
        }
    }

    public void realInverse(double[][][] dArray, boolean bl) {
        if (!this.isPowerOfTwo) {
            throw new IllegalArgumentException("slices, rows and columns must be power of two numbers");
        }
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n != this.oldNthreads) {
            this.nt = this.slices;
            if (this.nt < this.rows) {
                this.nt = this.rows;
            }
            this.nt *= 8;
            if (n > 1) {
                this.nt *= n;
            }
            if (this.columns == 4) {
                this.nt >>= 1;
            } else if (this.columns < 4) {
                this.nt >>= 2;
            }
            this.t = new double[this.nt];
            this.oldNthreads = n;
        }
        if (n > 1 && this.useThreads) {
            this.rdft3d_sub(-1, dArray);
            this.cdft3db_subth(1, dArray, bl);
            this.xdft3da_subth1(1, 1, dArray, bl);
        } else {
            this.rdft3d_sub(-1, dArray);
            this.cdft3db_sub(1, dArray, bl);
            this.xdft3da_sub1(1, 1, dArray, bl);
        }
    }

    public void realInverseFull(double[] dArray, boolean bl) {
        if (this.isPowerOfTwo) {
            int n = ConcurrencyUtils.getNumberOfThreads();
            if (n != this.oldNthreads) {
                this.nt = this.slices;
                if (this.nt < this.rows) {
                    this.nt = this.rows;
                }
                this.nt *= 8;
                if (n > 1) {
                    this.nt *= n;
                }
                if (this.columns == 4) {
                    this.nt >>= 1;
                } else if (this.columns < 4) {
                    this.nt >>= 2;
                }
                this.t = new double[this.nt];
                this.oldNthreads = n;
            }
            if (n > 1 && this.useThreads) {
                this.xdft3da_subth2(1, 1, dArray, bl);
                this.cdft3db_subth(1, dArray, bl);
                this.rdft3d_sub(1, dArray);
            } else {
                this.xdft3da_sub2(1, 1, dArray, bl);
                this.cdft3db_sub(1, dArray, bl);
                this.rdft3d_sub(1, dArray);
            }
            this.fillSymmetric(dArray);
        } else {
            this.mixedRadixRealInverseFull(dArray, bl);
        }
    }

    public void realInverseFull(double[][][] dArray, boolean bl) {
        if (this.isPowerOfTwo) {
            int n = ConcurrencyUtils.getNumberOfThreads();
            if (n != this.oldNthreads) {
                this.nt = this.slices;
                if (this.nt < this.rows) {
                    this.nt = this.rows;
                }
                this.nt *= 8;
                if (n > 1) {
                    this.nt *= n;
                }
                if (this.columns == 4) {
                    this.nt >>= 1;
                } else if (this.columns < 4) {
                    this.nt >>= 2;
                }
                this.t = new double[this.nt];
                this.oldNthreads = n;
            }
            if (n > 1 && this.useThreads) {
                this.xdft3da_subth2(1, 1, dArray, bl);
                this.cdft3db_subth(1, dArray, bl);
                this.rdft3d_sub(1, dArray);
            } else {
                this.xdft3da_sub2(1, 1, dArray, bl);
                this.cdft3db_sub(1, dArray, bl);
                this.rdft3d_sub(1, dArray);
            }
            this.fillSymmetric(dArray);
        } else {
            this.mixedRadixRealInverseFull(dArray, bl);
        }
    }

    private void mixedRadixRealForwardFull(final double[][][] dArray) {
        double[] dArray2 = new double[2 * this.rows];
        int n = this.rows / 2 + 1;
        final int n2 = 2 * this.columns;
        final int n3 = this.rows % 2 == 0 ? this.rows / 2 : (this.rows + 1) / 2;
        int n4 = ConcurrencyUtils.getNumberOfThreads();
        if (n4 > 1 && this.useThreads && this.slices >= n4 && this.columns >= n4 && n >= n4) {
            int n5;
            int n6;
            int n7;
            Future[] futureArray = new Future[n4];
            int n8 = this.slices / n4;
            for (n7 = 0; n7 < n4; ++n7) {
                n6 = n7 * n8;
                n5 = n7 == n4 - 1 ? this.slices : n6 + n8;
                futureArray[n7] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n6; i < n5; ++i) {
                            for (int j = 0; j < DoubleFFT_3D.this.rows; ++j) {
                                DoubleFFT_3D.this.fftColumns.realForwardFull(dArray[i][j]);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            for (n7 = 0; n7 < n4; ++n7) {
                n6 = n7 * n8;
                n5 = n7 == n4 - 1 ? this.slices : n6 + n8;
                futureArray[n7] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        double[] dArray2 = new double[2 * DoubleFFT_3D.this.rows];
                        for (int i = n6; i < n5; ++i) {
                            for (int j = 0; j < DoubleFFT_3D.this.columns; ++j) {
                                int n;
                                int n2;
                                int n3 = 2 * j;
                                for (n2 = 0; n2 < DoubleFFT_3D.this.rows; ++n2) {
                                    n = 2 * n2;
                                    dArray2[n] = dArray[i][n2][n3];
                                    dArray2[n + 1] = dArray[i][n2][n3 + 1];
                                }
                                DoubleFFT_3D.this.fftRows.complexForward(dArray2);
                                for (n2 = 0; n2 < DoubleFFT_3D.this.rows; ++n2) {
                                    n = 2 * n2;
                                    dArray[i][n2][n3] = dArray2[n];
                                    dArray[i][n2][n3 + 1] = dArray2[n + 1];
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            n8 = n / n4;
            for (n7 = 0; n7 < n4; ++n7) {
                n6 = n7 * n8;
                n5 = n7 == n4 - 1 ? n : n6 + n8;
                futureArray[n7] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        double[] dArray2 = new double[2 * DoubleFFT_3D.this.slices];
                        for (int i = n6; i < n5; ++i) {
                            for (int j = 0; j < DoubleFFT_3D.this.columns; ++j) {
                                int n;
                                int n2;
                                int n3 = 2 * j;
                                for (n2 = 0; n2 < DoubleFFT_3D.this.slices; ++n2) {
                                    n = 2 * n2;
                                    dArray2[n] = dArray[n2][i][n3];
                                    dArray2[n + 1] = dArray[n2][i][n3 + 1];
                                }
                                DoubleFFT_3D.this.fftSlices.complexForward(dArray2);
                                for (n2 = 0; n2 < DoubleFFT_3D.this.slices; ++n2) {
                                    n = 2 * n2;
                                    dArray[n2][i][n3] = dArray2[n];
                                    dArray[n2][i][n3 + 1] = dArray2[n + 1];
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            n8 = this.slices / n4;
            for (n7 = 0; n7 < n4; ++n7) {
                n6 = n7 * n8;
                n5 = n7 == n4 - 1 ? this.slices : n6 + n8;
                futureArray[n7] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n6; i < n5; ++i) {
                            int n = (DoubleFFT_3D.this.slices - i) % DoubleFFT_3D.this.slices;
                            for (int j = 1; j < n3; ++j) {
                                int n22 = DoubleFFT_3D.this.rows - j;
                                for (int k = 0; k < DoubleFFT_3D.this.columns; ++k) {
                                    int n32 = 2 * k;
                                    int n4 = n2 - n32;
                                    dArray[n][n22][n4 % n2] = dArray[i][j][n32];
                                    dArray[n][n22][(n4 + 1) % n2] = -dArray[i][j][n32 + 1];
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n9;
            int n10;
            int n11;
            int n12;
            int n13;
            for (n13 = 0; n13 < this.slices; ++n13) {
                for (n12 = 0; n12 < this.rows; ++n12) {
                    this.fftColumns.realForwardFull(dArray[n13][n12]);
                }
            }
            for (n13 = 0; n13 < this.slices; ++n13) {
                for (n12 = 0; n12 < this.columns; ++n12) {
                    n11 = 2 * n12;
                    for (n10 = 0; n10 < this.rows; ++n10) {
                        n9 = 2 * n10;
                        dArray2[n9] = dArray[n13][n10][n11];
                        dArray2[n9 + 1] = dArray[n13][n10][n11 + 1];
                    }
                    this.fftRows.complexForward(dArray2);
                    for (n10 = 0; n10 < this.rows; ++n10) {
                        n9 = 2 * n10;
                        dArray[n13][n10][n11] = dArray2[n9];
                        dArray[n13][n10][n11 + 1] = dArray2[n9 + 1];
                    }
                }
            }
            dArray2 = new double[2 * this.slices];
            for (n13 = 0; n13 < n; ++n13) {
                for (n12 = 0; n12 < this.columns; ++n12) {
                    n11 = 2 * n12;
                    for (n10 = 0; n10 < this.slices; ++n10) {
                        n9 = 2 * n10;
                        dArray2[n9] = dArray[n10][n13][n11];
                        dArray2[n9 + 1] = dArray[n10][n13][n11 + 1];
                    }
                    this.fftSlices.complexForward(dArray2);
                    for (n10 = 0; n10 < this.slices; ++n10) {
                        n9 = 2 * n10;
                        dArray[n10][n13][n11] = dArray2[n9];
                        dArray[n10][n13][n11 + 1] = dArray2[n9 + 1];
                    }
                }
            }
            for (n13 = 0; n13 < this.slices; ++n13) {
                n12 = (this.slices - n13) % this.slices;
                for (n11 = 1; n11 < n3; ++n11) {
                    n10 = this.rows - n11;
                    for (n9 = 0; n9 < this.columns; ++n9) {
                        int n14 = 2 * n9;
                        int n15 = n2 - n14;
                        dArray[n12][n10][n15 % n2] = dArray[n13][n11][n14];
                        dArray[n12][n10][(n15 + 1) % n2] = -dArray[n13][n11][n14 + 1];
                    }
                }
            }
        }
    }

    private void mixedRadixRealInverseFull(final double[][][] dArray, final boolean bl) {
        double[] dArray2 = new double[2 * this.rows];
        int n = this.rows / 2 + 1;
        final int n2 = 2 * this.columns;
        final int n3 = this.rows % 2 == 0 ? this.rows / 2 : (this.rows + 1) / 2;
        int n4 = ConcurrencyUtils.getNumberOfThreads();
        if (n4 > 1 && this.useThreads && this.slices >= n4 && this.columns >= n4 && n >= n4) {
            int n5;
            int n6;
            int n7;
            Future[] futureArray = new Future[n4];
            int n8 = this.slices / n4;
            for (n7 = 0; n7 < n4; ++n7) {
                n6 = n7 * n8;
                n5 = n7 == n4 - 1 ? this.slices : n6 + n8;
                futureArray[n7] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n6; i < n5; ++i) {
                            for (int j = 0; j < DoubleFFT_3D.this.rows; ++j) {
                                DoubleFFT_3D.this.fftColumns.realInverseFull(dArray[i][j], bl);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            for (n7 = 0; n7 < n4; ++n7) {
                n6 = n7 * n8;
                n5 = n7 == n4 - 1 ? this.slices : n6 + n8;
                futureArray[n7] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        double[] dArray2 = new double[2 * DoubleFFT_3D.this.rows];
                        for (int i = n6; i < n5; ++i) {
                            for (int j = 0; j < DoubleFFT_3D.this.columns; ++j) {
                                int n;
                                int n2;
                                int n3 = 2 * j;
                                for (n2 = 0; n2 < DoubleFFT_3D.this.rows; ++n2) {
                                    n = 2 * n2;
                                    dArray2[n] = dArray[i][n2][n3];
                                    dArray2[n + 1] = dArray[i][n2][n3 + 1];
                                }
                                DoubleFFT_3D.this.fftRows.complexInverse(dArray2, bl);
                                for (n2 = 0; n2 < DoubleFFT_3D.this.rows; ++n2) {
                                    n = 2 * n2;
                                    dArray[i][n2][n3] = dArray2[n];
                                    dArray[i][n2][n3 + 1] = dArray2[n + 1];
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            n8 = n / n4;
            for (n7 = 0; n7 < n4; ++n7) {
                n6 = n7 * n8;
                n5 = n7 == n4 - 1 ? n : n6 + n8;
                futureArray[n7] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        double[] dArray2 = new double[2 * DoubleFFT_3D.this.slices];
                        for (int i = n6; i < n5; ++i) {
                            for (int j = 0; j < DoubleFFT_3D.this.columns; ++j) {
                                int n;
                                int n2;
                                int n3 = 2 * j;
                                for (n2 = 0; n2 < DoubleFFT_3D.this.slices; ++n2) {
                                    n = 2 * n2;
                                    dArray2[n] = dArray[n2][i][n3];
                                    dArray2[n + 1] = dArray[n2][i][n3 + 1];
                                }
                                DoubleFFT_3D.this.fftSlices.complexInverse(dArray2, bl);
                                for (n2 = 0; n2 < DoubleFFT_3D.this.slices; ++n2) {
                                    n = 2 * n2;
                                    dArray[n2][i][n3] = dArray2[n];
                                    dArray[n2][i][n3 + 1] = dArray2[n + 1];
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            n8 = this.slices / n4;
            for (n7 = 0; n7 < n4; ++n7) {
                n6 = n7 * n8;
                n5 = n7 == n4 - 1 ? this.slices : n6 + n8;
                futureArray[n7] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n6; i < n5; ++i) {
                            int n = (DoubleFFT_3D.this.slices - i) % DoubleFFT_3D.this.slices;
                            for (int j = 1; j < n3; ++j) {
                                int n22 = DoubleFFT_3D.this.rows - j;
                                for (int k = 0; k < DoubleFFT_3D.this.columns; ++k) {
                                    int n32 = 2 * k;
                                    int n4 = n2 - n32;
                                    dArray[n][n22][n4 % n2] = dArray[i][j][n32];
                                    dArray[n][n22][(n4 + 1) % n2] = -dArray[i][j][n32 + 1];
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n9;
            int n10;
            int n11;
            int n12;
            int n13;
            for (n13 = 0; n13 < this.slices; ++n13) {
                for (n12 = 0; n12 < this.rows; ++n12) {
                    this.fftColumns.realInverseFull(dArray[n13][n12], bl);
                }
            }
            for (n13 = 0; n13 < this.slices; ++n13) {
                for (n12 = 0; n12 < this.columns; ++n12) {
                    n11 = 2 * n12;
                    for (n10 = 0; n10 < this.rows; ++n10) {
                        n9 = 2 * n10;
                        dArray2[n9] = dArray[n13][n10][n11];
                        dArray2[n9 + 1] = dArray[n13][n10][n11 + 1];
                    }
                    this.fftRows.complexInverse(dArray2, bl);
                    for (n10 = 0; n10 < this.rows; ++n10) {
                        n9 = 2 * n10;
                        dArray[n13][n10][n11] = dArray2[n9];
                        dArray[n13][n10][n11 + 1] = dArray2[n9 + 1];
                    }
                }
            }
            dArray2 = new double[2 * this.slices];
            for (n13 = 0; n13 < n; ++n13) {
                for (n12 = 0; n12 < this.columns; ++n12) {
                    n11 = 2 * n12;
                    for (n10 = 0; n10 < this.slices; ++n10) {
                        n9 = 2 * n10;
                        dArray2[n9] = dArray[n10][n13][n11];
                        dArray2[n9 + 1] = dArray[n10][n13][n11 + 1];
                    }
                    this.fftSlices.complexInverse(dArray2, bl);
                    for (n10 = 0; n10 < this.slices; ++n10) {
                        n9 = 2 * n10;
                        dArray[n10][n13][n11] = dArray2[n9];
                        dArray[n10][n13][n11 + 1] = dArray2[n9 + 1];
                    }
                }
            }
            for (n13 = 0; n13 < this.slices; ++n13) {
                n12 = (this.slices - n13) % this.slices;
                for (n11 = 1; n11 < n3; ++n11) {
                    n10 = this.rows - n11;
                    for (n9 = 0; n9 < this.columns; ++n9) {
                        int n14 = 2 * n9;
                        int n15 = n2 - n14;
                        dArray[n12][n10][n15 % n2] = dArray[n13][n11][n14];
                        dArray[n12][n10][(n15 + 1) % n2] = -dArray[n13][n11][n14 + 1];
                    }
                }
            }
        }
    }

    private void mixedRadixRealForwardFull(final double[] dArray) {
        final int n = 2 * this.columns;
        double[] dArray2 = new double[n];
        int n2 = this.rows / 2 + 1;
        final int n3 = this.rows % 2 == 0 ? this.rows / 2 : (this.rows + 1) / 2;
        final int n4 = 2 * this.sliceStride;
        final int n5 = 2 * this.rowStride;
        int n6 = this.slices / 2;
        int n7 = ConcurrencyUtils.getNumberOfThreads();
        if (n7 > 1 && this.useThreads && n6 >= n7 && this.columns >= n7 && n2 >= n7) {
            int n8;
            int n9;
            int n10;
            Future[] futureArray = new Future[n7];
            int n11 = n6 / n7;
            for (int i = 0; i < n7; ++i) {
                n10 = this.slices - 1 - i * n11;
                n9 = i == n7 - 1 ? n6 + 1 : n10 - n11;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        double[] dArray2 = new double[n];
                        for (int i = n10; i >= n9; --i) {
                            int n3 = i * DoubleFFT_3D.this.sliceStride;
                            int n2 = i * n4;
                            for (int j = DoubleFFT_3D.this.rows - 1; j >= 0; --j) {
                                System.arraycopy(dArray, n3 + j * DoubleFFT_3D.this.rowStride, dArray2, 0, DoubleFFT_3D.this.columns);
                                DoubleFFT_3D.this.fftColumns.realForwardFull(dArray2);
                                System.arraycopy(dArray2, 0, dArray, n2 + j * n5, n);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            final double[][][] dArray3 = new double[n6 + 1][this.rows][n];
            for (n10 = 0; n10 < n7; ++n10) {
                n9 = n10 * n11;
                n8 = n10 == n7 - 1 ? n6 + 1 : n9 + n11;
                futureArray[n10] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n9; i < n8; ++i) {
                            int n = i * DoubleFFT_3D.this.sliceStride;
                            for (int j = 0; j < DoubleFFT_3D.this.rows; ++j) {
                                System.arraycopy(dArray, n + j * DoubleFFT_3D.this.rowStride, dArray3[i][j], 0, DoubleFFT_3D.this.columns);
                                DoubleFFT_3D.this.fftColumns.realForwardFull(dArray3[i][j]);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            for (n10 = 0; n10 < n7; ++n10) {
                n9 = n10 * n11;
                n8 = n10 == n7 - 1 ? n6 + 1 : n9 + n11;
                futureArray[n10] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n9; i < n8; ++i) {
                            int n2 = i * n4;
                            for (int j = 0; j < DoubleFFT_3D.this.rows; ++j) {
                                System.arraycopy(dArray3[i][j], 0, dArray, n2 + j * n5, n);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            n11 = this.slices / n7;
            for (n10 = 0; n10 < n7; ++n10) {
                n9 = n10 * n11;
                n8 = n10 == n7 - 1 ? this.slices : n9 + n11;
                futureArray[n10] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        double[] dArray2 = new double[2 * DoubleFFT_3D.this.rows];
                        for (int i = n9; i < n8; ++i) {
                            int n = i * n4;
                            for (int j = 0; j < DoubleFFT_3D.this.columns; ++j) {
                                int n2;
                                int n3;
                                int n42;
                                int n52 = 2 * j;
                                for (n42 = 0; n42 < DoubleFFT_3D.this.rows; ++n42) {
                                    n3 = n + n42 * n5 + n52;
                                    n2 = 2 * n42;
                                    dArray2[n2] = dArray[n3];
                                    dArray2[n2 + 1] = dArray[n3 + 1];
                                }
                                DoubleFFT_3D.this.fftRows.complexForward(dArray2);
                                for (n42 = 0; n42 < DoubleFFT_3D.this.rows; ++n42) {
                                    n3 = n + n42 * n5 + n52;
                                    n2 = 2 * n42;
                                    dArray[n3] = dArray2[n2];
                                    dArray[n3 + 1] = dArray2[n2 + 1];
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            n11 = n2 / n7;
            for (n10 = 0; n10 < n7; ++n10) {
                n9 = n10 * n11;
                n8 = n10 == n7 - 1 ? n2 : n9 + n11;
                futureArray[n10] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        double[] dArray2 = new double[2 * DoubleFFT_3D.this.slices];
                        for (int i = n9; i < n8; ++i) {
                            int n = i * n5;
                            for (int j = 0; j < DoubleFFT_3D.this.columns; ++j) {
                                int n2;
                                int n3;
                                int n42;
                                int n52 = 2 * j;
                                for (n42 = 0; n42 < DoubleFFT_3D.this.slices; ++n42) {
                                    n3 = 2 * n42;
                                    n2 = n42 * n4 + n + n52;
                                    dArray2[n3] = dArray[n2];
                                    dArray2[n3 + 1] = dArray[n2 + 1];
                                }
                                DoubleFFT_3D.this.fftSlices.complexForward(dArray2);
                                for (n42 = 0; n42 < DoubleFFT_3D.this.slices; ++n42) {
                                    n3 = 2 * n42;
                                    n2 = n42 * n4 + n + n52;
                                    dArray[n2] = dArray2[n3];
                                    dArray[n2 + 1] = dArray2[n3 + 1];
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            n11 = this.slices / n7;
            for (n10 = 0; n10 < n7; ++n10) {
                n9 = n10 * n11;
                n8 = n10 == n7 - 1 ? this.slices : n9 + n11;
                futureArray[n10] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n9; i < n8; ++i) {
                            int n11 = (DoubleFFT_3D.this.slices - i) % DoubleFFT_3D.this.slices;
                            int n2 = n11 * n4;
                            int n32 = i * n4;
                            for (int j = 1; j < n3; ++j) {
                                int n42 = DoubleFFT_3D.this.rows - j;
                                int n52 = n42 * n5;
                                int n6 = j * n5;
                                int n7 = n2 + n52;
                                for (int k = 0; k < DoubleFFT_3D.this.columns; ++k) {
                                    int n82 = 2 * k;
                                    int n92 = n - n82;
                                    int n10 = n32 + n6 + n82;
                                    dArray[n7 + n92 % n] = dArray[n10];
                                    dArray[n7 + (n92 + 1) % n] = -dArray[n10 + 1];
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n12;
            int n13;
            int n14;
            int n15;
            int n16;
            int n17;
            int n18;
            for (n18 = this.slices - 1; n18 >= 0; --n18) {
                n17 = n18 * this.sliceStride;
                n16 = n18 * n4;
                for (n15 = this.rows - 1; n15 >= 0; --n15) {
                    System.arraycopy(dArray, n17 + n15 * this.rowStride, dArray2, 0, this.columns);
                    this.fftColumns.realForwardFull(dArray2);
                    System.arraycopy(dArray2, 0, dArray, n16 + n15 * n5, n);
                }
            }
            dArray2 = new double[2 * this.rows];
            for (n18 = 0; n18 < this.slices; ++n18) {
                n17 = n18 * n4;
                for (n16 = 0; n16 < this.columns; ++n16) {
                    n15 = 2 * n16;
                    for (n14 = 0; n14 < this.rows; ++n14) {
                        n13 = 2 * n14;
                        n12 = n17 + n14 * n5 + n15;
                        dArray2[n13] = dArray[n12];
                        dArray2[n13 + 1] = dArray[n12 + 1];
                    }
                    this.fftRows.complexForward(dArray2);
                    for (n14 = 0; n14 < this.rows; ++n14) {
                        n13 = 2 * n14;
                        n12 = n17 + n14 * n5 + n15;
                        dArray[n12] = dArray2[n13];
                        dArray[n12 + 1] = dArray2[n13 + 1];
                    }
                }
            }
            dArray2 = new double[2 * this.slices];
            for (n18 = 0; n18 < n2; ++n18) {
                n17 = n18 * n5;
                for (n16 = 0; n16 < this.columns; ++n16) {
                    n15 = 2 * n16;
                    for (n14 = 0; n14 < this.slices; ++n14) {
                        n13 = 2 * n14;
                        n12 = n14 * n4 + n17 + n15;
                        dArray2[n13] = dArray[n12];
                        dArray2[n13 + 1] = dArray[n12 + 1];
                    }
                    this.fftSlices.complexForward(dArray2);
                    for (n14 = 0; n14 < this.slices; ++n14) {
                        n13 = 2 * n14;
                        n12 = n14 * n4 + n17 + n15;
                        dArray[n12] = dArray2[n13];
                        dArray[n12 + 1] = dArray2[n13 + 1];
                    }
                }
            }
            for (n18 = 0; n18 < this.slices; ++n18) {
                n17 = (this.slices - n18) % this.slices;
                n16 = n17 * n4;
                n15 = n18 * n4;
                for (n14 = 1; n14 < n3; ++n14) {
                    n13 = this.rows - n14;
                    n12 = n13 * n5;
                    int n19 = n14 * n5;
                    int n20 = n16 + n12;
                    for (int i = 0; i < this.columns; ++i) {
                        int n21 = 2 * i;
                        int n22 = n - n21;
                        int n23 = n15 + n19 + n21;
                        dArray[n20 + n22 % n] = dArray[n23];
                        dArray[n20 + (n22 + 1) % n] = -dArray[n23 + 1];
                    }
                }
            }
        }
    }

    private void mixedRadixRealInverseFull(final double[] dArray, final boolean bl) {
        final int n = 2 * this.columns;
        double[] dArray2 = new double[n];
        int n2 = this.rows / 2 + 1;
        final int n3 = this.rows % 2 == 0 ? this.rows / 2 : (this.rows + 1) / 2;
        final int n4 = 2 * this.sliceStride;
        final int n5 = 2 * this.rowStride;
        int n6 = this.slices / 2;
        int n7 = ConcurrencyUtils.getNumberOfThreads();
        if (n7 > 1 && this.useThreads && n6 >= n7 && this.columns >= n7 && n2 >= n7) {
            int n8;
            int n9;
            int n10;
            Future[] futureArray = new Future[n7];
            int n11 = n6 / n7;
            for (int i = 0; i < n7; ++i) {
                n10 = this.slices - 1 - i * n11;
                n9 = i == n7 - 1 ? n6 + 1 : n10 - n11;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        double[] dArray2 = new double[n];
                        for (int i = n10; i >= n9; --i) {
                            int n3 = i * DoubleFFT_3D.this.sliceStride;
                            int n2 = i * n4;
                            for (int j = DoubleFFT_3D.this.rows - 1; j >= 0; --j) {
                                System.arraycopy(dArray, n3 + j * DoubleFFT_3D.this.rowStride, dArray2, 0, DoubleFFT_3D.this.columns);
                                DoubleFFT_3D.this.fftColumns.realInverseFull(dArray2, bl);
                                System.arraycopy(dArray2, 0, dArray, n2 + j * n5, n);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            final double[][][] dArray3 = new double[n6 + 1][this.rows][n];
            for (n10 = 0; n10 < n7; ++n10) {
                n9 = n10 * n11;
                n8 = n10 == n7 - 1 ? n6 + 1 : n9 + n11;
                futureArray[n10] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n9; i < n8; ++i) {
                            int n = i * DoubleFFT_3D.this.sliceStride;
                            for (int j = 0; j < DoubleFFT_3D.this.rows; ++j) {
                                System.arraycopy(dArray, n + j * DoubleFFT_3D.this.rowStride, dArray3[i][j], 0, DoubleFFT_3D.this.columns);
                                DoubleFFT_3D.this.fftColumns.realInverseFull(dArray3[i][j], bl);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            for (n10 = 0; n10 < n7; ++n10) {
                n9 = n10 * n11;
                n8 = n10 == n7 - 1 ? n6 + 1 : n9 + n11;
                futureArray[n10] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n9; i < n8; ++i) {
                            int n2 = i * n4;
                            for (int j = 0; j < DoubleFFT_3D.this.rows; ++j) {
                                System.arraycopy(dArray3[i][j], 0, dArray, n2 + j * n5, n);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            n11 = this.slices / n7;
            for (n10 = 0; n10 < n7; ++n10) {
                n9 = n10 * n11;
                n8 = n10 == n7 - 1 ? this.slices : n9 + n11;
                futureArray[n10] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        double[] dArray2 = new double[2 * DoubleFFT_3D.this.rows];
                        for (int i = n9; i < n8; ++i) {
                            int n = i * n4;
                            for (int j = 0; j < DoubleFFT_3D.this.columns; ++j) {
                                int n2;
                                int n3;
                                int n42;
                                int n52 = 2 * j;
                                for (n42 = 0; n42 < DoubleFFT_3D.this.rows; ++n42) {
                                    n3 = n + n42 * n5 + n52;
                                    n2 = 2 * n42;
                                    dArray2[n2] = dArray[n3];
                                    dArray2[n2 + 1] = dArray[n3 + 1];
                                }
                                DoubleFFT_3D.this.fftRows.complexInverse(dArray2, bl);
                                for (n42 = 0; n42 < DoubleFFT_3D.this.rows; ++n42) {
                                    n3 = n + n42 * n5 + n52;
                                    n2 = 2 * n42;
                                    dArray[n3] = dArray2[n2];
                                    dArray[n3 + 1] = dArray2[n2 + 1];
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            n11 = n2 / n7;
            for (n10 = 0; n10 < n7; ++n10) {
                n9 = n10 * n11;
                n8 = n10 == n7 - 1 ? n2 : n9 + n11;
                futureArray[n10] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        double[] dArray2 = new double[2 * DoubleFFT_3D.this.slices];
                        for (int i = n9; i < n8; ++i) {
                            int n = i * n5;
                            for (int j = 0; j < DoubleFFT_3D.this.columns; ++j) {
                                int n2;
                                int n3;
                                int n42;
                                int n52 = 2 * j;
                                for (n42 = 0; n42 < DoubleFFT_3D.this.slices; ++n42) {
                                    n3 = 2 * n42;
                                    n2 = n42 * n4 + n + n52;
                                    dArray2[n3] = dArray[n2];
                                    dArray2[n3 + 1] = dArray[n2 + 1];
                                }
                                DoubleFFT_3D.this.fftSlices.complexInverse(dArray2, bl);
                                for (n42 = 0; n42 < DoubleFFT_3D.this.slices; ++n42) {
                                    n3 = 2 * n42;
                                    n2 = n42 * n4 + n + n52;
                                    dArray[n2] = dArray2[n3];
                                    dArray[n2 + 1] = dArray2[n3 + 1];
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            n11 = this.slices / n7;
            for (n10 = 0; n10 < n7; ++n10) {
                n9 = n10 * n11;
                n8 = n10 == n7 - 1 ? this.slices : n9 + n11;
                futureArray[n10] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n9; i < n8; ++i) {
                            int n11 = (DoubleFFT_3D.this.slices - i) % DoubleFFT_3D.this.slices;
                            int n2 = n11 * n4;
                            int n32 = i * n4;
                            for (int j = 1; j < n3; ++j) {
                                int n42 = DoubleFFT_3D.this.rows - j;
                                int n52 = n42 * n5;
                                int n6 = j * n5;
                                int n7 = n2 + n52;
                                for (int k = 0; k < DoubleFFT_3D.this.columns; ++k) {
                                    int n82 = 2 * k;
                                    int n92 = n - n82;
                                    int n10 = n32 + n6 + n82;
                                    dArray[n7 + n92 % n] = dArray[n10];
                                    dArray[n7 + (n92 + 1) % n] = -dArray[n10 + 1];
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n12;
            int n13;
            int n14;
            int n15;
            int n16;
            int n17;
            int n18;
            for (n18 = this.slices - 1; n18 >= 0; --n18) {
                n17 = n18 * this.sliceStride;
                n16 = n18 * n4;
                for (n15 = this.rows - 1; n15 >= 0; --n15) {
                    System.arraycopy(dArray, n17 + n15 * this.rowStride, dArray2, 0, this.columns);
                    this.fftColumns.realInverseFull(dArray2, bl);
                    System.arraycopy(dArray2, 0, dArray, n16 + n15 * n5, n);
                }
            }
            dArray2 = new double[2 * this.rows];
            for (n18 = 0; n18 < this.slices; ++n18) {
                n17 = n18 * n4;
                for (n16 = 0; n16 < this.columns; ++n16) {
                    n15 = 2 * n16;
                    for (n14 = 0; n14 < this.rows; ++n14) {
                        n13 = 2 * n14;
                        n12 = n17 + n14 * n5 + n15;
                        dArray2[n13] = dArray[n12];
                        dArray2[n13 + 1] = dArray[n12 + 1];
                    }
                    this.fftRows.complexInverse(dArray2, bl);
                    for (n14 = 0; n14 < this.rows; ++n14) {
                        n13 = 2 * n14;
                        n12 = n17 + n14 * n5 + n15;
                        dArray[n12] = dArray2[n13];
                        dArray[n12 + 1] = dArray2[n13 + 1];
                    }
                }
            }
            dArray2 = new double[2 * this.slices];
            for (n18 = 0; n18 < n2; ++n18) {
                n17 = n18 * n5;
                for (n16 = 0; n16 < this.columns; ++n16) {
                    n15 = 2 * n16;
                    for (n14 = 0; n14 < this.slices; ++n14) {
                        n13 = 2 * n14;
                        n12 = n14 * n4 + n17 + n15;
                        dArray2[n13] = dArray[n12];
                        dArray2[n13 + 1] = dArray[n12 + 1];
                    }
                    this.fftSlices.complexInverse(dArray2, bl);
                    for (n14 = 0; n14 < this.slices; ++n14) {
                        n13 = 2 * n14;
                        n12 = n14 * n4 + n17 + n15;
                        dArray[n12] = dArray2[n13];
                        dArray[n12 + 1] = dArray2[n13 + 1];
                    }
                }
            }
            for (n18 = 0; n18 < this.slices; ++n18) {
                n17 = (this.slices - n18) % this.slices;
                n16 = n17 * n4;
                n15 = n18 * n4;
                for (n14 = 1; n14 < n3; ++n14) {
                    n13 = this.rows - n14;
                    n12 = n13 * n5;
                    int n19 = n14 * n5;
                    int n20 = n16 + n12;
                    for (int i = 0; i < this.columns; ++i) {
                        int n21 = 2 * i;
                        int n22 = n - n21;
                        int n23 = n15 + n19 + n21;
                        dArray[n20 + n22 % n] = dArray[n23];
                        dArray[n20 + (n22 + 1) % n] = -dArray[n23 + 1];
                    }
                }
            }
        }
    }

    private void xdft3da_sub1(int n, int n2, double[] dArray, boolean bl) {
        if (n2 == -1) {
            for (int i = 0; i < this.slices; ++i) {
                int n3;
                int n4;
                int n5;
                int n6;
                int n7 = i * this.sliceStride;
                if (n == 0) {
                    for (n6 = 0; n6 < this.rows; ++n6) {
                        this.fftColumns.complexForward(dArray, n7 + n6 * this.rowStride);
                    }
                } else {
                    for (n6 = 0; n6 < this.rows; ++n6) {
                        this.fftColumns.realForward(dArray, n7 + n6 * this.rowStride);
                    }
                }
                if (this.columns > 4) {
                    for (n6 = 0; n6 < this.columns; n6 += 8) {
                        int n8;
                        int n9;
                        int n10;
                        for (n10 = 0; n10 < this.rows; ++n10) {
                            n5 = n7 + n10 * this.rowStride + n6;
                            n4 = 2 * n10;
                            n3 = 2 * this.rows + 2 * n10;
                            n9 = n3 + 2 * this.rows;
                            n8 = n9 + 2 * this.rows;
                            this.t[n4] = dArray[n5];
                            this.t[n4 + 1] = dArray[n5 + 1];
                            this.t[n3] = dArray[n5 + 2];
                            this.t[n3 + 1] = dArray[n5 + 3];
                            this.t[n9] = dArray[n5 + 4];
                            this.t[n9 + 1] = dArray[n5 + 5];
                            this.t[n8] = dArray[n5 + 6];
                            this.t[n8 + 1] = dArray[n5 + 7];
                        }
                        this.fftRows.complexForward(this.t, 0);
                        this.fftRows.complexForward(this.t, 2 * this.rows);
                        this.fftRows.complexForward(this.t, 4 * this.rows);
                        this.fftRows.complexForward(this.t, 6 * this.rows);
                        for (n10 = 0; n10 < this.rows; ++n10) {
                            n5 = n7 + n10 * this.rowStride + n6;
                            n4 = 2 * n10;
                            n3 = 2 * this.rows + 2 * n10;
                            n9 = n3 + 2 * this.rows;
                            n8 = n9 + 2 * this.rows;
                            dArray[n5] = this.t[n4];
                            dArray[n5 + 1] = this.t[n4 + 1];
                            dArray[n5 + 2] = this.t[n3];
                            dArray[n5 + 3] = this.t[n3 + 1];
                            dArray[n5 + 4] = this.t[n9];
                            dArray[n5 + 5] = this.t[n9 + 1];
                            dArray[n5 + 6] = this.t[n8];
                            dArray[n5 + 7] = this.t[n8 + 1];
                        }
                    }
                    continue;
                }
                if (this.columns == 4) {
                    for (n6 = 0; n6 < this.rows; ++n6) {
                        n5 = n7 + n6 * this.rowStride;
                        n4 = 2 * n6;
                        n3 = 2 * this.rows + 2 * n6;
                        this.t[n4] = dArray[n5];
                        this.t[n4 + 1] = dArray[n5 + 1];
                        this.t[n3] = dArray[n5 + 2];
                        this.t[n3 + 1] = dArray[n5 + 3];
                    }
                    this.fftRows.complexForward(this.t, 0);
                    this.fftRows.complexForward(this.t, 2 * this.rows);
                    for (n6 = 0; n6 < this.rows; ++n6) {
                        n5 = n7 + n6 * this.rowStride;
                        n4 = 2 * n6;
                        n3 = 2 * this.rows + 2 * n6;
                        dArray[n5] = this.t[n4];
                        dArray[n5 + 1] = this.t[n4 + 1];
                        dArray[n5 + 2] = this.t[n3];
                        dArray[n5 + 3] = this.t[n3 + 1];
                    }
                    continue;
                }
                if (this.columns != 2) continue;
                for (n6 = 0; n6 < this.rows; ++n6) {
                    n5 = n7 + n6 * this.rowStride;
                    n4 = 2 * n6;
                    this.t[n4] = dArray[n5];
                    this.t[n4 + 1] = dArray[n5 + 1];
                }
                this.fftRows.complexForward(this.t, 0);
                for (n6 = 0; n6 < this.rows; ++n6) {
                    n5 = n7 + n6 * this.rowStride;
                    n4 = 2 * n6;
                    dArray[n5] = this.t[n4];
                    dArray[n5 + 1] = this.t[n4 + 1];
                }
            }
        } else {
            for (int i = 0; i < this.slices; ++i) {
                int n11;
                int n12;
                int n13;
                int n14;
                int n15 = i * this.sliceStride;
                if (n == 0) {
                    for (n14 = 0; n14 < this.rows; ++n14) {
                        this.fftColumns.complexInverse(dArray, n15 + n14 * this.rowStride, bl);
                    }
                }
                if (this.columns > 4) {
                    for (n14 = 0; n14 < this.columns; n14 += 8) {
                        int n16;
                        int n17;
                        int n18;
                        for (n18 = 0; n18 < this.rows; ++n18) {
                            n13 = n15 + n18 * this.rowStride + n14;
                            n12 = 2 * n18;
                            n11 = 2 * this.rows + 2 * n18;
                            n17 = n11 + 2 * this.rows;
                            n16 = n17 + 2 * this.rows;
                            this.t[n12] = dArray[n13];
                            this.t[n12 + 1] = dArray[n13 + 1];
                            this.t[n11] = dArray[n13 + 2];
                            this.t[n11 + 1] = dArray[n13 + 3];
                            this.t[n17] = dArray[n13 + 4];
                            this.t[n17 + 1] = dArray[n13 + 5];
                            this.t[n16] = dArray[n13 + 6];
                            this.t[n16 + 1] = dArray[n13 + 7];
                        }
                        this.fftRows.complexInverse(this.t, 0, bl);
                        this.fftRows.complexInverse(this.t, 2 * this.rows, bl);
                        this.fftRows.complexInverse(this.t, 4 * this.rows, bl);
                        this.fftRows.complexInverse(this.t, 6 * this.rows, bl);
                        for (n18 = 0; n18 < this.rows; ++n18) {
                            n13 = n15 + n18 * this.rowStride + n14;
                            n12 = 2 * n18;
                            n11 = 2 * this.rows + 2 * n18;
                            n17 = n11 + 2 * this.rows;
                            n16 = n17 + 2 * this.rows;
                            dArray[n13] = this.t[n12];
                            dArray[n13 + 1] = this.t[n12 + 1];
                            dArray[n13 + 2] = this.t[n11];
                            dArray[n13 + 3] = this.t[n11 + 1];
                            dArray[n13 + 4] = this.t[n17];
                            dArray[n13 + 5] = this.t[n17 + 1];
                            dArray[n13 + 6] = this.t[n16];
                            dArray[n13 + 7] = this.t[n16 + 1];
                        }
                    }
                } else if (this.columns == 4) {
                    for (n14 = 0; n14 < this.rows; ++n14) {
                        n13 = n15 + n14 * this.rowStride;
                        n12 = 2 * n14;
                        n11 = 2 * this.rows + 2 * n14;
                        this.t[n12] = dArray[n13];
                        this.t[n12 + 1] = dArray[n13 + 1];
                        this.t[n11] = dArray[n13 + 2];
                        this.t[n11 + 1] = dArray[n13 + 3];
                    }
                    this.fftRows.complexInverse(this.t, 0, bl);
                    this.fftRows.complexInverse(this.t, 2 * this.rows, bl);
                    for (n14 = 0; n14 < this.rows; ++n14) {
                        n13 = n15 + n14 * this.rowStride;
                        n12 = 2 * n14;
                        n11 = 2 * this.rows + 2 * n14;
                        dArray[n13] = this.t[n12];
                        dArray[n13 + 1] = this.t[n12 + 1];
                        dArray[n13 + 2] = this.t[n11];
                        dArray[n13 + 3] = this.t[n11 + 1];
                    }
                } else if (this.columns == 2) {
                    for (n14 = 0; n14 < this.rows; ++n14) {
                        n13 = n15 + n14 * this.rowStride;
                        n12 = 2 * n14;
                        this.t[n12] = dArray[n13];
                        this.t[n12 + 1] = dArray[n13 + 1];
                    }
                    this.fftRows.complexInverse(this.t, 0, bl);
                    for (n14 = 0; n14 < this.rows; ++n14) {
                        n13 = n15 + n14 * this.rowStride;
                        n12 = 2 * n14;
                        dArray[n13] = this.t[n12];
                        dArray[n13 + 1] = this.t[n12 + 1];
                    }
                }
                if (n == 0) continue;
                for (n14 = 0; n14 < this.rows; ++n14) {
                    this.fftColumns.realInverse(dArray, n15 + n14 * this.rowStride, bl);
                }
            }
        }
    }

    private void xdft3da_sub2(int n, int n2, double[] dArray, boolean bl) {
        if (n2 == -1) {
            for (int i = 0; i < this.slices; ++i) {
                int n3;
                int n4;
                int n5;
                int n6;
                int n7 = i * this.sliceStride;
                if (n == 0) {
                    for (n6 = 0; n6 < this.rows; ++n6) {
                        this.fftColumns.complexForward(dArray, n7 + n6 * this.rowStride);
                    }
                } else {
                    for (n6 = 0; n6 < this.rows; ++n6) {
                        this.fftColumns.realForward(dArray, n7 + n6 * this.rowStride);
                    }
                }
                if (this.columns > 4) {
                    for (n6 = 0; n6 < this.columns; n6 += 8) {
                        int n8;
                        int n9;
                        int n10;
                        for (n10 = 0; n10 < this.rows; ++n10) {
                            n5 = n7 + n10 * this.rowStride + n6;
                            n4 = 2 * n10;
                            n3 = 2 * this.rows + 2 * n10;
                            n9 = n3 + 2 * this.rows;
                            n8 = n9 + 2 * this.rows;
                            this.t[n4] = dArray[n5];
                            this.t[n4 + 1] = dArray[n5 + 1];
                            this.t[n3] = dArray[n5 + 2];
                            this.t[n3 + 1] = dArray[n5 + 3];
                            this.t[n9] = dArray[n5 + 4];
                            this.t[n9 + 1] = dArray[n5 + 5];
                            this.t[n8] = dArray[n5 + 6];
                            this.t[n8 + 1] = dArray[n5 + 7];
                        }
                        this.fftRows.complexForward(this.t, 0);
                        this.fftRows.complexForward(this.t, 2 * this.rows);
                        this.fftRows.complexForward(this.t, 4 * this.rows);
                        this.fftRows.complexForward(this.t, 6 * this.rows);
                        for (n10 = 0; n10 < this.rows; ++n10) {
                            n5 = n7 + n10 * this.rowStride + n6;
                            n4 = 2 * n10;
                            n3 = 2 * this.rows + 2 * n10;
                            n9 = n3 + 2 * this.rows;
                            n8 = n9 + 2 * this.rows;
                            dArray[n5] = this.t[n4];
                            dArray[n5 + 1] = this.t[n4 + 1];
                            dArray[n5 + 2] = this.t[n3];
                            dArray[n5 + 3] = this.t[n3 + 1];
                            dArray[n5 + 4] = this.t[n9];
                            dArray[n5 + 5] = this.t[n9 + 1];
                            dArray[n5 + 6] = this.t[n8];
                            dArray[n5 + 7] = this.t[n8 + 1];
                        }
                    }
                    continue;
                }
                if (this.columns == 4) {
                    for (n6 = 0; n6 < this.rows; ++n6) {
                        n5 = n7 + n6 * this.rowStride;
                        n4 = 2 * n6;
                        n3 = 2 * this.rows + 2 * n6;
                        this.t[n4] = dArray[n5];
                        this.t[n4 + 1] = dArray[n5 + 1];
                        this.t[n3] = dArray[n5 + 2];
                        this.t[n3 + 1] = dArray[n5 + 3];
                    }
                    this.fftRows.complexForward(this.t, 0);
                    this.fftRows.complexForward(this.t, 2 * this.rows);
                    for (n6 = 0; n6 < this.rows; ++n6) {
                        n5 = n7 + n6 * this.rowStride;
                        n4 = 2 * n6;
                        n3 = 2 * this.rows + 2 * n6;
                        dArray[n5] = this.t[n4];
                        dArray[n5 + 1] = this.t[n4 + 1];
                        dArray[n5 + 2] = this.t[n3];
                        dArray[n5 + 3] = this.t[n3 + 1];
                    }
                    continue;
                }
                if (this.columns != 2) continue;
                for (n6 = 0; n6 < this.rows; ++n6) {
                    n5 = n7 + n6 * this.rowStride;
                    n4 = 2 * n6;
                    this.t[n4] = dArray[n5];
                    this.t[n4 + 1] = dArray[n5 + 1];
                }
                this.fftRows.complexForward(this.t, 0);
                for (n6 = 0; n6 < this.rows; ++n6) {
                    n5 = n7 + n6 * this.rowStride;
                    n4 = 2 * n6;
                    dArray[n5] = this.t[n4];
                    dArray[n5 + 1] = this.t[n4 + 1];
                }
            }
        } else {
            for (int i = 0; i < this.slices; ++i) {
                int n11;
                int n12;
                int n13;
                int n14;
                int n15 = i * this.sliceStride;
                if (n == 0) {
                    for (n14 = 0; n14 < this.rows; ++n14) {
                        this.fftColumns.complexInverse(dArray, n15 + n14 * this.rowStride, bl);
                    }
                } else {
                    for (n14 = 0; n14 < this.rows; ++n14) {
                        this.fftColumns.realInverse2(dArray, n15 + n14 * this.rowStride, bl);
                    }
                }
                if (this.columns > 4) {
                    for (n14 = 0; n14 < this.columns; n14 += 8) {
                        int n16;
                        int n17;
                        int n18;
                        for (n18 = 0; n18 < this.rows; ++n18) {
                            n13 = n15 + n18 * this.rowStride + n14;
                            n12 = 2 * n18;
                            n11 = 2 * this.rows + 2 * n18;
                            n17 = n11 + 2 * this.rows;
                            n16 = n17 + 2 * this.rows;
                            this.t[n12] = dArray[n13];
                            this.t[n12 + 1] = dArray[n13 + 1];
                            this.t[n11] = dArray[n13 + 2];
                            this.t[n11 + 1] = dArray[n13 + 3];
                            this.t[n17] = dArray[n13 + 4];
                            this.t[n17 + 1] = dArray[n13 + 5];
                            this.t[n16] = dArray[n13 + 6];
                            this.t[n16 + 1] = dArray[n13 + 7];
                        }
                        this.fftRows.complexInverse(this.t, 0, bl);
                        this.fftRows.complexInverse(this.t, 2 * this.rows, bl);
                        this.fftRows.complexInverse(this.t, 4 * this.rows, bl);
                        this.fftRows.complexInverse(this.t, 6 * this.rows, bl);
                        for (n18 = 0; n18 < this.rows; ++n18) {
                            n13 = n15 + n18 * this.rowStride + n14;
                            n12 = 2 * n18;
                            n11 = 2 * this.rows + 2 * n18;
                            n17 = n11 + 2 * this.rows;
                            n16 = n17 + 2 * this.rows;
                            dArray[n13] = this.t[n12];
                            dArray[n13 + 1] = this.t[n12 + 1];
                            dArray[n13 + 2] = this.t[n11];
                            dArray[n13 + 3] = this.t[n11 + 1];
                            dArray[n13 + 4] = this.t[n17];
                            dArray[n13 + 5] = this.t[n17 + 1];
                            dArray[n13 + 6] = this.t[n16];
                            dArray[n13 + 7] = this.t[n16 + 1];
                        }
                    }
                    continue;
                }
                if (this.columns == 4) {
                    for (n14 = 0; n14 < this.rows; ++n14) {
                        n13 = n15 + n14 * this.rowStride;
                        n12 = 2 * n14;
                        n11 = 2 * this.rows + 2 * n14;
                        this.t[n12] = dArray[n13];
                        this.t[n12 + 1] = dArray[n13 + 1];
                        this.t[n11] = dArray[n13 + 2];
                        this.t[n11 + 1] = dArray[n13 + 3];
                    }
                    this.fftRows.complexInverse(this.t, 0, bl);
                    this.fftRows.complexInverse(this.t, 2 * this.rows, bl);
                    for (n14 = 0; n14 < this.rows; ++n14) {
                        n13 = n15 + n14 * this.rowStride;
                        n12 = 2 * n14;
                        n11 = 2 * this.rows + 2 * n14;
                        dArray[n13] = this.t[n12];
                        dArray[n13 + 1] = this.t[n12 + 1];
                        dArray[n13 + 2] = this.t[n11];
                        dArray[n13 + 3] = this.t[n11 + 1];
                    }
                    continue;
                }
                if (this.columns != 2) continue;
                for (n14 = 0; n14 < this.rows; ++n14) {
                    n13 = n15 + n14 * this.rowStride;
                    n12 = 2 * n14;
                    this.t[n12] = dArray[n13];
                    this.t[n12 + 1] = dArray[n13 + 1];
                }
                this.fftRows.complexInverse(this.t, 0, bl);
                for (n14 = 0; n14 < this.rows; ++n14) {
                    n13 = n15 + n14 * this.rowStride;
                    n12 = 2 * n14;
                    dArray[n13] = this.t[n12];
                    dArray[n13 + 1] = this.t[n12 + 1];
                }
            }
        }
    }

    private void xdft3da_sub1(int n, int n2, double[][][] dArray, boolean bl) {
        if (n2 == -1) {
            for (int i = 0; i < this.slices; ++i) {
                int n3;
                int n4;
                int n5;
                if (n == 0) {
                    for (n5 = 0; n5 < this.rows; ++n5) {
                        this.fftColumns.complexForward(dArray[i][n5]);
                    }
                } else {
                    for (n5 = 0; n5 < this.rows; ++n5) {
                        this.fftColumns.realForward(dArray[i][n5], 0);
                    }
                }
                if (this.columns > 4) {
                    for (n5 = 0; n5 < this.columns; n5 += 8) {
                        int n6;
                        int n7;
                        int n8;
                        for (n8 = 0; n8 < this.rows; ++n8) {
                            n4 = 2 * n8;
                            n3 = 2 * this.rows + 2 * n8;
                            n7 = n3 + 2 * this.rows;
                            n6 = n7 + 2 * this.rows;
                            this.t[n4] = dArray[i][n8][n5];
                            this.t[n4 + 1] = dArray[i][n8][n5 + 1];
                            this.t[n3] = dArray[i][n8][n5 + 2];
                            this.t[n3 + 1] = dArray[i][n8][n5 + 3];
                            this.t[n7] = dArray[i][n8][n5 + 4];
                            this.t[n7 + 1] = dArray[i][n8][n5 + 5];
                            this.t[n6] = dArray[i][n8][n5 + 6];
                            this.t[n6 + 1] = dArray[i][n8][n5 + 7];
                        }
                        this.fftRows.complexForward(this.t, 0);
                        this.fftRows.complexForward(this.t, 2 * this.rows);
                        this.fftRows.complexForward(this.t, 4 * this.rows);
                        this.fftRows.complexForward(this.t, 6 * this.rows);
                        for (n8 = 0; n8 < this.rows; ++n8) {
                            n4 = 2 * n8;
                            n3 = 2 * this.rows + 2 * n8;
                            n7 = n3 + 2 * this.rows;
                            n6 = n7 + 2 * this.rows;
                            dArray[i][n8][n5] = this.t[n4];
                            dArray[i][n8][n5 + 1] = this.t[n4 + 1];
                            dArray[i][n8][n5 + 2] = this.t[n3];
                            dArray[i][n8][n5 + 3] = this.t[n3 + 1];
                            dArray[i][n8][n5 + 4] = this.t[n7];
                            dArray[i][n8][n5 + 5] = this.t[n7 + 1];
                            dArray[i][n8][n5 + 6] = this.t[n6];
                            dArray[i][n8][n5 + 7] = this.t[n6 + 1];
                        }
                    }
                    continue;
                }
                if (this.columns == 4) {
                    for (n5 = 0; n5 < this.rows; ++n5) {
                        n4 = 2 * n5;
                        n3 = 2 * this.rows + 2 * n5;
                        this.t[n4] = dArray[i][n5][0];
                        this.t[n4 + 1] = dArray[i][n5][1];
                        this.t[n3] = dArray[i][n5][2];
                        this.t[n3 + 1] = dArray[i][n5][3];
                    }
                    this.fftRows.complexForward(this.t, 0);
                    this.fftRows.complexForward(this.t, 2 * this.rows);
                    for (n5 = 0; n5 < this.rows; ++n5) {
                        n4 = 2 * n5;
                        n3 = 2 * this.rows + 2 * n5;
                        dArray[i][n5][0] = this.t[n4];
                        dArray[i][n5][1] = this.t[n4 + 1];
                        dArray[i][n5][2] = this.t[n3];
                        dArray[i][n5][3] = this.t[n3 + 1];
                    }
                    continue;
                }
                if (this.columns != 2) continue;
                for (n5 = 0; n5 < this.rows; ++n5) {
                    n4 = 2 * n5;
                    this.t[n4] = dArray[i][n5][0];
                    this.t[n4 + 1] = dArray[i][n5][1];
                }
                this.fftRows.complexForward(this.t, 0);
                for (n5 = 0; n5 < this.rows; ++n5) {
                    n4 = 2 * n5;
                    dArray[i][n5][0] = this.t[n4];
                    dArray[i][n5][1] = this.t[n4 + 1];
                }
            }
        } else {
            for (int i = 0; i < this.slices; ++i) {
                int n9;
                int n10;
                int n11;
                if (n == 0) {
                    for (n11 = 0; n11 < this.rows; ++n11) {
                        this.fftColumns.complexInverse(dArray[i][n11], bl);
                    }
                }
                if (this.columns > 4) {
                    for (n11 = 0; n11 < this.columns; n11 += 8) {
                        int n12;
                        int n13;
                        int n14;
                        for (n14 = 0; n14 < this.rows; ++n14) {
                            n10 = 2 * n14;
                            n9 = 2 * this.rows + 2 * n14;
                            n13 = n9 + 2 * this.rows;
                            n12 = n13 + 2 * this.rows;
                            this.t[n10] = dArray[i][n14][n11];
                            this.t[n10 + 1] = dArray[i][n14][n11 + 1];
                            this.t[n9] = dArray[i][n14][n11 + 2];
                            this.t[n9 + 1] = dArray[i][n14][n11 + 3];
                            this.t[n13] = dArray[i][n14][n11 + 4];
                            this.t[n13 + 1] = dArray[i][n14][n11 + 5];
                            this.t[n12] = dArray[i][n14][n11 + 6];
                            this.t[n12 + 1] = dArray[i][n14][n11 + 7];
                        }
                        this.fftRows.complexInverse(this.t, 0, bl);
                        this.fftRows.complexInverse(this.t, 2 * this.rows, bl);
                        this.fftRows.complexInverse(this.t, 4 * this.rows, bl);
                        this.fftRows.complexInverse(this.t, 6 * this.rows, bl);
                        for (n14 = 0; n14 < this.rows; ++n14) {
                            n10 = 2 * n14;
                            n9 = 2 * this.rows + 2 * n14;
                            n13 = n9 + 2 * this.rows;
                            n12 = n13 + 2 * this.rows;
                            dArray[i][n14][n11] = this.t[n10];
                            dArray[i][n14][n11 + 1] = this.t[n10 + 1];
                            dArray[i][n14][n11 + 2] = this.t[n9];
                            dArray[i][n14][n11 + 3] = this.t[n9 + 1];
                            dArray[i][n14][n11 + 4] = this.t[n13];
                            dArray[i][n14][n11 + 5] = this.t[n13 + 1];
                            dArray[i][n14][n11 + 6] = this.t[n12];
                            dArray[i][n14][n11 + 7] = this.t[n12 + 1];
                        }
                    }
                } else if (this.columns == 4) {
                    for (n11 = 0; n11 < this.rows; ++n11) {
                        n10 = 2 * n11;
                        n9 = 2 * this.rows + 2 * n11;
                        this.t[n10] = dArray[i][n11][0];
                        this.t[n10 + 1] = dArray[i][n11][1];
                        this.t[n9] = dArray[i][n11][2];
                        this.t[n9 + 1] = dArray[i][n11][3];
                    }
                    this.fftRows.complexInverse(this.t, 0, bl);
                    this.fftRows.complexInverse(this.t, 2 * this.rows, bl);
                    for (n11 = 0; n11 < this.rows; ++n11) {
                        n10 = 2 * n11;
                        n9 = 2 * this.rows + 2 * n11;
                        dArray[i][n11][0] = this.t[n10];
                        dArray[i][n11][1] = this.t[n10 + 1];
                        dArray[i][n11][2] = this.t[n9];
                        dArray[i][n11][3] = this.t[n9 + 1];
                    }
                } else if (this.columns == 2) {
                    for (n11 = 0; n11 < this.rows; ++n11) {
                        n10 = 2 * n11;
                        this.t[n10] = dArray[i][n11][0];
                        this.t[n10 + 1] = dArray[i][n11][1];
                    }
                    this.fftRows.complexInverse(this.t, 0, bl);
                    for (n11 = 0; n11 < this.rows; ++n11) {
                        n10 = 2 * n11;
                        dArray[i][n11][0] = this.t[n10];
                        dArray[i][n11][1] = this.t[n10 + 1];
                    }
                }
                if (n == 0) continue;
                for (n11 = 0; n11 < this.rows; ++n11) {
                    this.fftColumns.realInverse(dArray[i][n11], bl);
                }
            }
        }
    }

    private void xdft3da_sub2(int n, int n2, double[][][] dArray, boolean bl) {
        if (n2 == -1) {
            for (int i = 0; i < this.slices; ++i) {
                int n3;
                int n4;
                int n5;
                if (n == 0) {
                    for (n5 = 0; n5 < this.rows; ++n5) {
                        this.fftColumns.complexForward(dArray[i][n5]);
                    }
                } else {
                    for (n5 = 0; n5 < this.rows; ++n5) {
                        this.fftColumns.realForward(dArray[i][n5]);
                    }
                }
                if (this.columns > 4) {
                    for (n5 = 0; n5 < this.columns; n5 += 8) {
                        int n6;
                        int n7;
                        int n8;
                        for (n8 = 0; n8 < this.rows; ++n8) {
                            n4 = 2 * n8;
                            n3 = 2 * this.rows + 2 * n8;
                            n7 = n3 + 2 * this.rows;
                            n6 = n7 + 2 * this.rows;
                            this.t[n4] = dArray[i][n8][n5];
                            this.t[n4 + 1] = dArray[i][n8][n5 + 1];
                            this.t[n3] = dArray[i][n8][n5 + 2];
                            this.t[n3 + 1] = dArray[i][n8][n5 + 3];
                            this.t[n7] = dArray[i][n8][n5 + 4];
                            this.t[n7 + 1] = dArray[i][n8][n5 + 5];
                            this.t[n6] = dArray[i][n8][n5 + 6];
                            this.t[n6 + 1] = dArray[i][n8][n5 + 7];
                        }
                        this.fftRows.complexForward(this.t, 0);
                        this.fftRows.complexForward(this.t, 2 * this.rows);
                        this.fftRows.complexForward(this.t, 4 * this.rows);
                        this.fftRows.complexForward(this.t, 6 * this.rows);
                        for (n8 = 0; n8 < this.rows; ++n8) {
                            n4 = 2 * n8;
                            n3 = 2 * this.rows + 2 * n8;
                            n7 = n3 + 2 * this.rows;
                            n6 = n7 + 2 * this.rows;
                            dArray[i][n8][n5] = this.t[n4];
                            dArray[i][n8][n5 + 1] = this.t[n4 + 1];
                            dArray[i][n8][n5 + 2] = this.t[n3];
                            dArray[i][n8][n5 + 3] = this.t[n3 + 1];
                            dArray[i][n8][n5 + 4] = this.t[n7];
                            dArray[i][n8][n5 + 5] = this.t[n7 + 1];
                            dArray[i][n8][n5 + 6] = this.t[n6];
                            dArray[i][n8][n5 + 7] = this.t[n6 + 1];
                        }
                    }
                    continue;
                }
                if (this.columns == 4) {
                    for (n5 = 0; n5 < this.rows; ++n5) {
                        n4 = 2 * n5;
                        n3 = 2 * this.rows + 2 * n5;
                        this.t[n4] = dArray[i][n5][0];
                        this.t[n4 + 1] = dArray[i][n5][1];
                        this.t[n3] = dArray[i][n5][2];
                        this.t[n3 + 1] = dArray[i][n5][3];
                    }
                    this.fftRows.complexForward(this.t, 0);
                    this.fftRows.complexForward(this.t, 2 * this.rows);
                    for (n5 = 0; n5 < this.rows; ++n5) {
                        n4 = 2 * n5;
                        n3 = 2 * this.rows + 2 * n5;
                        dArray[i][n5][0] = this.t[n4];
                        dArray[i][n5][1] = this.t[n4 + 1];
                        dArray[i][n5][2] = this.t[n3];
                        dArray[i][n5][3] = this.t[n3 + 1];
                    }
                    continue;
                }
                if (this.columns != 2) continue;
                for (n5 = 0; n5 < this.rows; ++n5) {
                    n4 = 2 * n5;
                    this.t[n4] = dArray[i][n5][0];
                    this.t[n4 + 1] = dArray[i][n5][1];
                }
                this.fftRows.complexForward(this.t, 0);
                for (n5 = 0; n5 < this.rows; ++n5) {
                    n4 = 2 * n5;
                    dArray[i][n5][0] = this.t[n4];
                    dArray[i][n5][1] = this.t[n4 + 1];
                }
            }
        } else {
            for (int i = 0; i < this.slices; ++i) {
                int n9;
                int n10;
                int n11;
                if (n == 0) {
                    for (n11 = 0; n11 < this.rows; ++n11) {
                        this.fftColumns.complexInverse(dArray[i][n11], bl);
                    }
                } else {
                    for (n11 = 0; n11 < this.rows; ++n11) {
                        this.fftColumns.realInverse2(dArray[i][n11], 0, bl);
                    }
                }
                if (this.columns > 4) {
                    for (n11 = 0; n11 < this.columns; n11 += 8) {
                        int n12;
                        int n13;
                        int n14;
                        for (n14 = 0; n14 < this.rows; ++n14) {
                            n10 = 2 * n14;
                            n9 = 2 * this.rows + 2 * n14;
                            n13 = n9 + 2 * this.rows;
                            n12 = n13 + 2 * this.rows;
                            this.t[n10] = dArray[i][n14][n11];
                            this.t[n10 + 1] = dArray[i][n14][n11 + 1];
                            this.t[n9] = dArray[i][n14][n11 + 2];
                            this.t[n9 + 1] = dArray[i][n14][n11 + 3];
                            this.t[n13] = dArray[i][n14][n11 + 4];
                            this.t[n13 + 1] = dArray[i][n14][n11 + 5];
                            this.t[n12] = dArray[i][n14][n11 + 6];
                            this.t[n12 + 1] = dArray[i][n14][n11 + 7];
                        }
                        this.fftRows.complexInverse(this.t, 0, bl);
                        this.fftRows.complexInverse(this.t, 2 * this.rows, bl);
                        this.fftRows.complexInverse(this.t, 4 * this.rows, bl);
                        this.fftRows.complexInverse(this.t, 6 * this.rows, bl);
                        for (n14 = 0; n14 < this.rows; ++n14) {
                            n10 = 2 * n14;
                            n9 = 2 * this.rows + 2 * n14;
                            n13 = n9 + 2 * this.rows;
                            n12 = n13 + 2 * this.rows;
                            dArray[i][n14][n11] = this.t[n10];
                            dArray[i][n14][n11 + 1] = this.t[n10 + 1];
                            dArray[i][n14][n11 + 2] = this.t[n9];
                            dArray[i][n14][n11 + 3] = this.t[n9 + 1];
                            dArray[i][n14][n11 + 4] = this.t[n13];
                            dArray[i][n14][n11 + 5] = this.t[n13 + 1];
                            dArray[i][n14][n11 + 6] = this.t[n12];
                            dArray[i][n14][n11 + 7] = this.t[n12 + 1];
                        }
                    }
                    continue;
                }
                if (this.columns == 4) {
                    for (n11 = 0; n11 < this.rows; ++n11) {
                        n10 = 2 * n11;
                        n9 = 2 * this.rows + 2 * n11;
                        this.t[n10] = dArray[i][n11][0];
                        this.t[n10 + 1] = dArray[i][n11][1];
                        this.t[n9] = dArray[i][n11][2];
                        this.t[n9 + 1] = dArray[i][n11][3];
                    }
                    this.fftRows.complexInverse(this.t, 0, bl);
                    this.fftRows.complexInverse(this.t, 2 * this.rows, bl);
                    for (n11 = 0; n11 < this.rows; ++n11) {
                        n10 = 2 * n11;
                        n9 = 2 * this.rows + 2 * n11;
                        dArray[i][n11][0] = this.t[n10];
                        dArray[i][n11][1] = this.t[n10 + 1];
                        dArray[i][n11][2] = this.t[n9];
                        dArray[i][n11][3] = this.t[n9 + 1];
                    }
                    continue;
                }
                if (this.columns != 2) continue;
                for (n11 = 0; n11 < this.rows; ++n11) {
                    n10 = 2 * n11;
                    this.t[n10] = dArray[i][n11][0];
                    this.t[n10 + 1] = dArray[i][n11][1];
                }
                this.fftRows.complexInverse(this.t, 0, bl);
                for (n11 = 0; n11 < this.rows; ++n11) {
                    n10 = 2 * n11;
                    dArray[i][n11][0] = this.t[n10];
                    dArray[i][n11][1] = this.t[n10 + 1];
                }
            }
        }
    }

    private void cdft3db_sub(int n, double[] dArray, boolean bl) {
        block27: {
            block25: {
                block28: {
                    block26: {
                        if (n != -1) break block25;
                        if (this.columns <= 4) break block26;
                        for (int i = 0; i < this.rows; ++i) {
                            int n2 = i * this.rowStride;
                            for (int j = 0; j < this.columns; j += 8) {
                                int n3;
                                int n4;
                                int n5;
                                int n6;
                                int n7;
                                int n8;
                                for (n8 = 0; n8 < this.slices; ++n8) {
                                    n7 = n8 * this.sliceStride + n2 + j;
                                    n6 = 2 * n8;
                                    n5 = 2 * this.slices + 2 * n8;
                                    n4 = n5 + 2 * this.slices;
                                    n3 = n4 + 2 * this.slices;
                                    this.t[n6] = dArray[n7];
                                    this.t[n6 + 1] = dArray[n7 + 1];
                                    this.t[n5] = dArray[n7 + 2];
                                    this.t[n5 + 1] = dArray[n7 + 3];
                                    this.t[n4] = dArray[n7 + 4];
                                    this.t[n4 + 1] = dArray[n7 + 5];
                                    this.t[n3] = dArray[n7 + 6];
                                    this.t[n3 + 1] = dArray[n7 + 7];
                                }
                                this.fftSlices.complexForward(this.t, 0);
                                this.fftSlices.complexForward(this.t, 2 * this.slices);
                                this.fftSlices.complexForward(this.t, 4 * this.slices);
                                this.fftSlices.complexForward(this.t, 6 * this.slices);
                                for (n8 = 0; n8 < this.slices; ++n8) {
                                    n7 = n8 * this.sliceStride + n2 + j;
                                    n6 = 2 * n8;
                                    n5 = 2 * this.slices + 2 * n8;
                                    n4 = n5 + 2 * this.slices;
                                    n3 = n4 + 2 * this.slices;
                                    dArray[n7] = this.t[n6];
                                    dArray[n7 + 1] = this.t[n6 + 1];
                                    dArray[n7 + 2] = this.t[n5];
                                    dArray[n7 + 3] = this.t[n5 + 1];
                                    dArray[n7 + 4] = this.t[n4];
                                    dArray[n7 + 5] = this.t[n4 + 1];
                                    dArray[n7 + 6] = this.t[n3];
                                    dArray[n7 + 7] = this.t[n3 + 1];
                                }
                            }
                        }
                        break block27;
                    }
                    if (this.columns != 4) break block28;
                    for (int i = 0; i < this.rows; ++i) {
                        int n9;
                        int n10;
                        int n11;
                        int n12;
                        int n13 = i * this.rowStride;
                        for (n12 = 0; n12 < this.slices; ++n12) {
                            n11 = n12 * this.sliceStride + n13;
                            n10 = 2 * n12;
                            n9 = 2 * this.slices + 2 * n12;
                            this.t[n10] = dArray[n11];
                            this.t[n10 + 1] = dArray[n11 + 1];
                            this.t[n9] = dArray[n11 + 2];
                            this.t[n9 + 1] = dArray[n11 + 3];
                        }
                        this.fftSlices.complexForward(this.t, 0);
                        this.fftSlices.complexForward(this.t, 2 * this.slices);
                        for (n12 = 0; n12 < this.slices; ++n12) {
                            n11 = n12 * this.sliceStride + n13;
                            n10 = 2 * n12;
                            n9 = 2 * this.slices + 2 * n12;
                            dArray[n11] = this.t[n10];
                            dArray[n11 + 1] = this.t[n10 + 1];
                            dArray[n11 + 2] = this.t[n9];
                            dArray[n11 + 3] = this.t[n9 + 1];
                        }
                    }
                    break block27;
                }
                if (this.columns != 2) break block27;
                for (int i = 0; i < this.rows; ++i) {
                    int n14;
                    int n15;
                    int n16;
                    int n17 = i * this.rowStride;
                    for (n16 = 0; n16 < this.slices; ++n16) {
                        n15 = n16 * this.sliceStride + n17;
                        n14 = 2 * n16;
                        this.t[n14] = dArray[n15];
                        this.t[n14 + 1] = dArray[n15 + 1];
                    }
                    this.fftSlices.complexForward(this.t, 0);
                    for (n16 = 0; n16 < this.slices; ++n16) {
                        n15 = n16 * this.sliceStride + n17;
                        n14 = 2 * n16;
                        dArray[n15] = this.t[n14];
                        dArray[n15 + 1] = this.t[n14 + 1];
                    }
                }
                break block27;
            }
            if (this.columns > 4) {
                for (int i = 0; i < this.rows; ++i) {
                    int n18 = i * this.rowStride;
                    for (int j = 0; j < this.columns; j += 8) {
                        int n19;
                        int n20;
                        int n21;
                        int n22;
                        int n23;
                        int n24;
                        for (n24 = 0; n24 < this.slices; ++n24) {
                            n23 = n24 * this.sliceStride + n18 + j;
                            n22 = 2 * n24;
                            n21 = 2 * this.slices + 2 * n24;
                            n20 = n21 + 2 * this.slices;
                            n19 = n20 + 2 * this.slices;
                            this.t[n22] = dArray[n23];
                            this.t[n22 + 1] = dArray[n23 + 1];
                            this.t[n21] = dArray[n23 + 2];
                            this.t[n21 + 1] = dArray[n23 + 3];
                            this.t[n20] = dArray[n23 + 4];
                            this.t[n20 + 1] = dArray[n23 + 5];
                            this.t[n19] = dArray[n23 + 6];
                            this.t[n19 + 1] = dArray[n23 + 7];
                        }
                        this.fftSlices.complexInverse(this.t, 0, bl);
                        this.fftSlices.complexInverse(this.t, 2 * this.slices, bl);
                        this.fftSlices.complexInverse(this.t, 4 * this.slices, bl);
                        this.fftSlices.complexInverse(this.t, 6 * this.slices, bl);
                        for (n24 = 0; n24 < this.slices; ++n24) {
                            n23 = n24 * this.sliceStride + n18 + j;
                            n22 = 2 * n24;
                            n21 = 2 * this.slices + 2 * n24;
                            n20 = n21 + 2 * this.slices;
                            n19 = n20 + 2 * this.slices;
                            dArray[n23] = this.t[n22];
                            dArray[n23 + 1] = this.t[n22 + 1];
                            dArray[n23 + 2] = this.t[n21];
                            dArray[n23 + 3] = this.t[n21 + 1];
                            dArray[n23 + 4] = this.t[n20];
                            dArray[n23 + 5] = this.t[n20 + 1];
                            dArray[n23 + 6] = this.t[n19];
                            dArray[n23 + 7] = this.t[n19 + 1];
                        }
                    }
                }
            } else if (this.columns == 4) {
                for (int i = 0; i < this.rows; ++i) {
                    int n25;
                    int n26;
                    int n27;
                    int n28;
                    int n29 = i * this.rowStride;
                    for (n28 = 0; n28 < this.slices; ++n28) {
                        n27 = n28 * this.sliceStride + n29;
                        n26 = 2 * n28;
                        n25 = 2 * this.slices + 2 * n28;
                        this.t[n26] = dArray[n27];
                        this.t[n26 + 1] = dArray[n27 + 1];
                        this.t[n25] = dArray[n27 + 2];
                        this.t[n25 + 1] = dArray[n27 + 3];
                    }
                    this.fftSlices.complexInverse(this.t, 0, bl);
                    this.fftSlices.complexInverse(this.t, 2 * this.slices, bl);
                    for (n28 = 0; n28 < this.slices; ++n28) {
                        n27 = n28 * this.sliceStride + n29;
                        n26 = 2 * n28;
                        n25 = 2 * this.slices + 2 * n28;
                        dArray[n27] = this.t[n26];
                        dArray[n27 + 1] = this.t[n26 + 1];
                        dArray[n27 + 2] = this.t[n25];
                        dArray[n27 + 3] = this.t[n25 + 1];
                    }
                }
            } else if (this.columns == 2) {
                for (int i = 0; i < this.rows; ++i) {
                    int n30;
                    int n31;
                    int n32;
                    int n33 = i * this.rowStride;
                    for (n32 = 0; n32 < this.slices; ++n32) {
                        n31 = n32 * this.sliceStride + n33;
                        n30 = 2 * n32;
                        this.t[n30] = dArray[n31];
                        this.t[n30 + 1] = dArray[n31 + 1];
                    }
                    this.fftSlices.complexInverse(this.t, 0, bl);
                    for (n32 = 0; n32 < this.slices; ++n32) {
                        n31 = n32 * this.sliceStride + n33;
                        n30 = 2 * n32;
                        dArray[n31] = this.t[n30];
                        dArray[n31 + 1] = this.t[n30 + 1];
                    }
                }
            }
        }
    }

    private void cdft3db_sub(int n, double[][][] dArray, boolean bl) {
        block27: {
            block25: {
                block28: {
                    block26: {
                        if (n != -1) break block25;
                        if (this.columns <= 4) break block26;
                        for (int i = 0; i < this.rows; ++i) {
                            for (int j = 0; j < this.columns; j += 8) {
                                int n2;
                                int n3;
                                int n4;
                                int n5;
                                int n6;
                                for (n6 = 0; n6 < this.slices; ++n6) {
                                    n5 = 2 * n6;
                                    n4 = 2 * this.slices + 2 * n6;
                                    n3 = n4 + 2 * this.slices;
                                    n2 = n3 + 2 * this.slices;
                                    this.t[n5] = dArray[n6][i][j];
                                    this.t[n5 + 1] = dArray[n6][i][j + 1];
                                    this.t[n4] = dArray[n6][i][j + 2];
                                    this.t[n4 + 1] = dArray[n6][i][j + 3];
                                    this.t[n3] = dArray[n6][i][j + 4];
                                    this.t[n3 + 1] = dArray[n6][i][j + 5];
                                    this.t[n2] = dArray[n6][i][j + 6];
                                    this.t[n2 + 1] = dArray[n6][i][j + 7];
                                }
                                this.fftSlices.complexForward(this.t, 0);
                                this.fftSlices.complexForward(this.t, 2 * this.slices);
                                this.fftSlices.complexForward(this.t, 4 * this.slices);
                                this.fftSlices.complexForward(this.t, 6 * this.slices);
                                for (n6 = 0; n6 < this.slices; ++n6) {
                                    n5 = 2 * n6;
                                    n4 = 2 * this.slices + 2 * n6;
                                    n3 = n4 + 2 * this.slices;
                                    n2 = n3 + 2 * this.slices;
                                    dArray[n6][i][j] = this.t[n5];
                                    dArray[n6][i][j + 1] = this.t[n5 + 1];
                                    dArray[n6][i][j + 2] = this.t[n4];
                                    dArray[n6][i][j + 3] = this.t[n4 + 1];
                                    dArray[n6][i][j + 4] = this.t[n3];
                                    dArray[n6][i][j + 5] = this.t[n3 + 1];
                                    dArray[n6][i][j + 6] = this.t[n2];
                                    dArray[n6][i][j + 7] = this.t[n2 + 1];
                                }
                            }
                        }
                        break block27;
                    }
                    if (this.columns != 4) break block28;
                    for (int i = 0; i < this.rows; ++i) {
                        int n7;
                        int n8;
                        int n9;
                        for (n9 = 0; n9 < this.slices; ++n9) {
                            n8 = 2 * n9;
                            n7 = 2 * this.slices + 2 * n9;
                            this.t[n8] = dArray[n9][i][0];
                            this.t[n8 + 1] = dArray[n9][i][1];
                            this.t[n7] = dArray[n9][i][2];
                            this.t[n7 + 1] = dArray[n9][i][3];
                        }
                        this.fftSlices.complexForward(this.t, 0);
                        this.fftSlices.complexForward(this.t, 2 * this.slices);
                        for (n9 = 0; n9 < this.slices; ++n9) {
                            n8 = 2 * n9;
                            n7 = 2 * this.slices + 2 * n9;
                            dArray[n9][i][0] = this.t[n8];
                            dArray[n9][i][1] = this.t[n8 + 1];
                            dArray[n9][i][2] = this.t[n7];
                            dArray[n9][i][3] = this.t[n7 + 1];
                        }
                    }
                    break block27;
                }
                if (this.columns != 2) break block27;
                for (int i = 0; i < this.rows; ++i) {
                    int n10;
                    int n11;
                    for (n11 = 0; n11 < this.slices; ++n11) {
                        n10 = 2 * n11;
                        this.t[n10] = dArray[n11][i][0];
                        this.t[n10 + 1] = dArray[n11][i][1];
                    }
                    this.fftSlices.complexForward(this.t, 0);
                    for (n11 = 0; n11 < this.slices; ++n11) {
                        n10 = 2 * n11;
                        dArray[n11][i][0] = this.t[n10];
                        dArray[n11][i][1] = this.t[n10 + 1];
                    }
                }
                break block27;
            }
            if (this.columns > 4) {
                for (int i = 0; i < this.rows; ++i) {
                    for (int j = 0; j < this.columns; j += 8) {
                        int n12;
                        int n13;
                        int n14;
                        int n15;
                        int n16;
                        for (n16 = 0; n16 < this.slices; ++n16) {
                            n15 = 2 * n16;
                            n14 = 2 * this.slices + 2 * n16;
                            n13 = n14 + 2 * this.slices;
                            n12 = n13 + 2 * this.slices;
                            this.t[n15] = dArray[n16][i][j];
                            this.t[n15 + 1] = dArray[n16][i][j + 1];
                            this.t[n14] = dArray[n16][i][j + 2];
                            this.t[n14 + 1] = dArray[n16][i][j + 3];
                            this.t[n13] = dArray[n16][i][j + 4];
                            this.t[n13 + 1] = dArray[n16][i][j + 5];
                            this.t[n12] = dArray[n16][i][j + 6];
                            this.t[n12 + 1] = dArray[n16][i][j + 7];
                        }
                        this.fftSlices.complexInverse(this.t, 0, bl);
                        this.fftSlices.complexInverse(this.t, 2 * this.slices, bl);
                        this.fftSlices.complexInverse(this.t, 4 * this.slices, bl);
                        this.fftSlices.complexInverse(this.t, 6 * this.slices, bl);
                        for (n16 = 0; n16 < this.slices; ++n16) {
                            n15 = 2 * n16;
                            n14 = 2 * this.slices + 2 * n16;
                            n13 = n14 + 2 * this.slices;
                            n12 = n13 + 2 * this.slices;
                            dArray[n16][i][j] = this.t[n15];
                            dArray[n16][i][j + 1] = this.t[n15 + 1];
                            dArray[n16][i][j + 2] = this.t[n14];
                            dArray[n16][i][j + 3] = this.t[n14 + 1];
                            dArray[n16][i][j + 4] = this.t[n13];
                            dArray[n16][i][j + 5] = this.t[n13 + 1];
                            dArray[n16][i][j + 6] = this.t[n12];
                            dArray[n16][i][j + 7] = this.t[n12 + 1];
                        }
                    }
                }
            } else if (this.columns == 4) {
                for (int i = 0; i < this.rows; ++i) {
                    int n17;
                    int n18;
                    int n19;
                    for (n19 = 0; n19 < this.slices; ++n19) {
                        n18 = 2 * n19;
                        n17 = 2 * this.slices + 2 * n19;
                        this.t[n18] = dArray[n19][i][0];
                        this.t[n18 + 1] = dArray[n19][i][1];
                        this.t[n17] = dArray[n19][i][2];
                        this.t[n17 + 1] = dArray[n19][i][3];
                    }
                    this.fftSlices.complexInverse(this.t, 0, bl);
                    this.fftSlices.complexInverse(this.t, 2 * this.slices, bl);
                    for (n19 = 0; n19 < this.slices; ++n19) {
                        n18 = 2 * n19;
                        n17 = 2 * this.slices + 2 * n19;
                        dArray[n19][i][0] = this.t[n18];
                        dArray[n19][i][1] = this.t[n18 + 1];
                        dArray[n19][i][2] = this.t[n17];
                        dArray[n19][i][3] = this.t[n17 + 1];
                    }
                }
            } else if (this.columns == 2) {
                for (int i = 0; i < this.rows; ++i) {
                    int n20;
                    int n21;
                    for (n21 = 0; n21 < this.slices; ++n21) {
                        n20 = 2 * n21;
                        this.t[n20] = dArray[n21][i][0];
                        this.t[n20 + 1] = dArray[n21][i][1];
                    }
                    this.fftSlices.complexInverse(this.t, 0, bl);
                    for (n21 = 0; n21 < this.slices; ++n21) {
                        n20 = 2 * n21;
                        dArray[n21][i][0] = this.t[n20];
                        dArray[n21][i][1] = this.t[n20 + 1];
                    }
                }
            }
        }
    }

    private void xdft3da_subth1(final int n, final int n2, final double[] dArray, final boolean bl) {
        final int n3 = Math.min(ConcurrencyUtils.getNumberOfThreads(), this.slices);
        int n4 = 8 * this.rows;
        if (this.columns == 4) {
            n4 >>= 1;
        } else if (this.columns < 4) {
            n4 >>= 2;
        }
        Future[] futureArray = new Future[n3];
        for (int i = 0; i < n3; ++i) {
            final int n5 = i;
            final int n6 = n4 * i;
            futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                public void run() {
                    if (n2 == -1) {
                        for (int i = n5; i < DoubleFFT_3D.this.slices; i += n3) {
                            int n16;
                            int n22;
                            int n32;
                            int n4;
                            int n52 = i * DoubleFFT_3D.this.sliceStride;
                            if (n == 0) {
                                for (n4 = 0; n4 < DoubleFFT_3D.this.rows; ++n4) {
                                    DoubleFFT_3D.this.fftColumns.complexForward(dArray, n52 + n4 * DoubleFFT_3D.this.rowStride);
                                }
                            } else {
                                for (n4 = 0; n4 < DoubleFFT_3D.this.rows; ++n4) {
                                    DoubleFFT_3D.this.fftColumns.realForward(dArray, n52 + n4 * DoubleFFT_3D.this.rowStride);
                                }
                            }
                            if (DoubleFFT_3D.this.columns > 4) {
                                for (n4 = 0; n4 < DoubleFFT_3D.this.columns; n4 += 8) {
                                    int n62;
                                    int n7;
                                    int n8;
                                    for (n8 = 0; n8 < DoubleFFT_3D.this.rows; ++n8) {
                                        n32 = n52 + n8 * DoubleFFT_3D.this.rowStride + n4;
                                        n22 = n6 + 2 * n8;
                                        n16 = n6 + 2 * DoubleFFT_3D.this.rows + 2 * n8;
                                        n7 = n16 + 2 * DoubleFFT_3D.this.rows;
                                        n62 = n7 + 2 * DoubleFFT_3D.this.rows;
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n22] = dArray[n32];
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n22 + 1] = dArray[n32 + 1];
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n16] = dArray[n32 + 2];
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n16 + 1] = dArray[n32 + 3];
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n7] = dArray[n32 + 4];
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n7 + 1] = dArray[n32 + 5];
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n62] = dArray[n32 + 6];
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n62 + 1] = dArray[n32 + 7];
                                    }
                                    DoubleFFT_3D.this.fftRows.complexForward(DoubleFFT_3D.this.t, n6);
                                    DoubleFFT_3D.this.fftRows.complexForward(DoubleFFT_3D.this.t, n6 + 2 * DoubleFFT_3D.this.rows);
                                    DoubleFFT_3D.this.fftRows.complexForward(DoubleFFT_3D.this.t, n6 + 4 * DoubleFFT_3D.this.rows);
                                    DoubleFFT_3D.this.fftRows.complexForward(DoubleFFT_3D.this.t, n6 + 6 * DoubleFFT_3D.this.rows);
                                    for (n8 = 0; n8 < DoubleFFT_3D.this.rows; ++n8) {
                                        n32 = n52 + n8 * DoubleFFT_3D.this.rowStride + n4;
                                        n22 = n6 + 2 * n8;
                                        n16 = n6 + 2 * DoubleFFT_3D.this.rows + 2 * n8;
                                        n7 = n16 + 2 * DoubleFFT_3D.this.rows;
                                        n62 = n7 + 2 * DoubleFFT_3D.this.rows;
                                        dArray[n32] = DoubleFFT_3D.this.t[n22];
                                        dArray[n32 + 1] = DoubleFFT_3D.this.t[n22 + 1];
                                        dArray[n32 + 2] = DoubleFFT_3D.this.t[n16];
                                        dArray[n32 + 3] = DoubleFFT_3D.this.t[n16 + 1];
                                        dArray[n32 + 4] = DoubleFFT_3D.this.t[n7];
                                        dArray[n32 + 5] = DoubleFFT_3D.this.t[n7 + 1];
                                        dArray[n32 + 6] = DoubleFFT_3D.this.t[n62];
                                        dArray[n32 + 7] = DoubleFFT_3D.this.t[n62 + 1];
                                    }
                                }
                                continue;
                            }
                            if (DoubleFFT_3D.this.columns == 4) {
                                for (n4 = 0; n4 < DoubleFFT_3D.this.rows; ++n4) {
                                    n32 = n52 + n4 * DoubleFFT_3D.this.rowStride;
                                    n22 = n6 + 2 * n4;
                                    n16 = n6 + 2 * DoubleFFT_3D.this.rows + 2 * n4;
                                    ((DoubleFFT_3D)DoubleFFT_3D.this).t[n22] = dArray[n32];
                                    ((DoubleFFT_3D)DoubleFFT_3D.this).t[n22 + 1] = dArray[n32 + 1];
                                    ((DoubleFFT_3D)DoubleFFT_3D.this).t[n16] = dArray[n32 + 2];
                                    ((DoubleFFT_3D)DoubleFFT_3D.this).t[n16 + 1] = dArray[n32 + 3];
                                }
                                DoubleFFT_3D.this.fftRows.complexForward(DoubleFFT_3D.this.t, n6);
                                DoubleFFT_3D.this.fftRows.complexForward(DoubleFFT_3D.this.t, n6 + 2 * DoubleFFT_3D.this.rows);
                                for (n4 = 0; n4 < DoubleFFT_3D.this.rows; ++n4) {
                                    n32 = n52 + n4 * DoubleFFT_3D.this.rowStride;
                                    n22 = n6 + 2 * n4;
                                    n16 = n6 + 2 * DoubleFFT_3D.this.rows + 2 * n4;
                                    dArray[n32] = DoubleFFT_3D.this.t[n22];
                                    dArray[n32 + 1] = DoubleFFT_3D.this.t[n22 + 1];
                                    dArray[n32 + 2] = DoubleFFT_3D.this.t[n16];
                                    dArray[n32 + 3] = DoubleFFT_3D.this.t[n16 + 1];
                                }
                                continue;
                            }
                            if (DoubleFFT_3D.this.columns != 2) continue;
                            for (n4 = 0; n4 < DoubleFFT_3D.this.rows; ++n4) {
                                n32 = n52 + n4 * DoubleFFT_3D.this.rowStride;
                                n22 = n6 + 2 * n4;
                                ((DoubleFFT_3D)DoubleFFT_3D.this).t[n22] = dArray[n32];
                                ((DoubleFFT_3D)DoubleFFT_3D.this).t[n22 + 1] = dArray[n32 + 1];
                            }
                            DoubleFFT_3D.this.fftRows.complexForward(DoubleFFT_3D.this.t, n6);
                            for (n4 = 0; n4 < DoubleFFT_3D.this.rows; ++n4) {
                                n32 = n52 + n4 * DoubleFFT_3D.this.rowStride;
                                n22 = n6 + 2 * n4;
                                dArray[n32] = DoubleFFT_3D.this.t[n22];
                                dArray[n32 + 1] = DoubleFFT_3D.this.t[n22 + 1];
                            }
                        }
                    } else {
                        for (int i = n5; i < DoubleFFT_3D.this.slices; i += n3) {
                            int n17;
                            int n9;
                            int n10;
                            int n11;
                            int n12 = i * DoubleFFT_3D.this.sliceStride;
                            if (n == 0) {
                                for (n11 = 0; n11 < DoubleFFT_3D.this.rows; ++n11) {
                                    DoubleFFT_3D.this.fftColumns.complexInverse(dArray, n12 + n11 * DoubleFFT_3D.this.rowStride, bl);
                                }
                            }
                            if (DoubleFFT_3D.this.columns > 4) {
                                for (n11 = 0; n11 < DoubleFFT_3D.this.columns; n11 += 8) {
                                    int n13;
                                    int n14;
                                    int n15;
                                    for (n15 = 0; n15 < DoubleFFT_3D.this.rows; ++n15) {
                                        n10 = n12 + n15 * DoubleFFT_3D.this.rowStride + n11;
                                        n9 = n6 + 2 * n15;
                                        n17 = n6 + 2 * DoubleFFT_3D.this.rows + 2 * n15;
                                        n14 = n17 + 2 * DoubleFFT_3D.this.rows;
                                        n13 = n14 + 2 * DoubleFFT_3D.this.rows;
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n9] = dArray[n10];
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n9 + 1] = dArray[n10 + 1];
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n17] = dArray[n10 + 2];
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n17 + 1] = dArray[n10 + 3];
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n14] = dArray[n10 + 4];
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n14 + 1] = dArray[n10 + 5];
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n13] = dArray[n10 + 6];
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n13 + 1] = dArray[n10 + 7];
                                    }
                                    DoubleFFT_3D.this.fftRows.complexInverse(DoubleFFT_3D.this.t, n6, bl);
                                    DoubleFFT_3D.this.fftRows.complexInverse(DoubleFFT_3D.this.t, n6 + 2 * DoubleFFT_3D.this.rows, bl);
                                    DoubleFFT_3D.this.fftRows.complexInverse(DoubleFFT_3D.this.t, n6 + 4 * DoubleFFT_3D.this.rows, bl);
                                    DoubleFFT_3D.this.fftRows.complexInverse(DoubleFFT_3D.this.t, n6 + 6 * DoubleFFT_3D.this.rows, bl);
                                    for (n15 = 0; n15 < DoubleFFT_3D.this.rows; ++n15) {
                                        n10 = n12 + n15 * DoubleFFT_3D.this.rowStride + n11;
                                        n9 = n6 + 2 * n15;
                                        n17 = n6 + 2 * DoubleFFT_3D.this.rows + 2 * n15;
                                        n14 = n17 + 2 * DoubleFFT_3D.this.rows;
                                        n13 = n14 + 2 * DoubleFFT_3D.this.rows;
                                        dArray[n10] = DoubleFFT_3D.this.t[n9];
                                        dArray[n10 + 1] = DoubleFFT_3D.this.t[n9 + 1];
                                        dArray[n10 + 2] = DoubleFFT_3D.this.t[n17];
                                        dArray[n10 + 3] = DoubleFFT_3D.this.t[n17 + 1];
                                        dArray[n10 + 4] = DoubleFFT_3D.this.t[n14];
                                        dArray[n10 + 5] = DoubleFFT_3D.this.t[n14 + 1];
                                        dArray[n10 + 6] = DoubleFFT_3D.this.t[n13];
                                        dArray[n10 + 7] = DoubleFFT_3D.this.t[n13 + 1];
                                    }
                                }
                            } else if (DoubleFFT_3D.this.columns == 4) {
                                for (n11 = 0; n11 < DoubleFFT_3D.this.rows; ++n11) {
                                    n10 = n12 + n11 * DoubleFFT_3D.this.rowStride;
                                    n9 = n6 + 2 * n11;
                                    n17 = n6 + 2 * DoubleFFT_3D.this.rows + 2 * n11;
                                    ((DoubleFFT_3D)DoubleFFT_3D.this).t[n9] = dArray[n10];
                                    ((DoubleFFT_3D)DoubleFFT_3D.this).t[n9 + 1] = dArray[n10 + 1];
                                    ((DoubleFFT_3D)DoubleFFT_3D.this).t[n17] = dArray[n10 + 2];
                                    ((DoubleFFT_3D)DoubleFFT_3D.this).t[n17 + 1] = dArray[n10 + 3];
                                }
                                DoubleFFT_3D.this.fftRows.complexInverse(DoubleFFT_3D.this.t, n6, bl);
                                DoubleFFT_3D.this.fftRows.complexInverse(DoubleFFT_3D.this.t, n6 + 2 * DoubleFFT_3D.this.rows, bl);
                                for (n11 = 0; n11 < DoubleFFT_3D.this.rows; ++n11) {
                                    n10 = n12 + n11 * DoubleFFT_3D.this.rowStride;
                                    n9 = n6 + 2 * n11;
                                    n17 = n6 + 2 * DoubleFFT_3D.this.rows + 2 * n11;
                                    dArray[n10] = DoubleFFT_3D.this.t[n9];
                                    dArray[n10 + 1] = DoubleFFT_3D.this.t[n9 + 1];
                                    dArray[n10 + 2] = DoubleFFT_3D.this.t[n17];
                                    dArray[n10 + 3] = DoubleFFT_3D.this.t[n17 + 1];
                                }
                            } else if (DoubleFFT_3D.this.columns == 2) {
                                for (n11 = 0; n11 < DoubleFFT_3D.this.rows; ++n11) {
                                    n10 = n12 + n11 * DoubleFFT_3D.this.rowStride;
                                    n9 = n6 + 2 * n11;
                                    ((DoubleFFT_3D)DoubleFFT_3D.this).t[n9] = dArray[n10];
                                    ((DoubleFFT_3D)DoubleFFT_3D.this).t[n9 + 1] = dArray[n10 + 1];
                                }
                                DoubleFFT_3D.this.fftRows.complexInverse(DoubleFFT_3D.this.t, n6, bl);
                                for (n11 = 0; n11 < DoubleFFT_3D.this.rows; ++n11) {
                                    n10 = n12 + n11 * DoubleFFT_3D.this.rowStride;
                                    n9 = n6 + 2 * n11;
                                    dArray[n10] = DoubleFFT_3D.this.t[n9];
                                    dArray[n10 + 1] = DoubleFFT_3D.this.t[n9 + 1];
                                }
                            }
                            if (n == 0) continue;
                            for (n11 = 0; n11 < DoubleFFT_3D.this.rows; ++n11) {
                                DoubleFFT_3D.this.fftColumns.realInverse(dArray, n12 + n11 * DoubleFFT_3D.this.rowStride, bl);
                            }
                        }
                    }
                }
            });
        }
        ConcurrencyUtils.waitForCompletion(futureArray);
    }

    private void xdft3da_subth2(final int n, final int n2, final double[] dArray, final boolean bl) {
        final int n3 = Math.min(ConcurrencyUtils.getNumberOfThreads(), this.slices);
        int n4 = 8 * this.rows;
        if (this.columns == 4) {
            n4 >>= 1;
        } else if (this.columns < 4) {
            n4 >>= 2;
        }
        Future[] futureArray = new Future[n3];
        for (int i = 0; i < n3; ++i) {
            final int n5 = i;
            final int n6 = n4 * i;
            futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                public void run() {
                    if (n2 == -1) {
                        for (int i = n5; i < DoubleFFT_3D.this.slices; i += n3) {
                            int n16;
                            int n22;
                            int n32;
                            int n4;
                            int n52 = i * DoubleFFT_3D.this.sliceStride;
                            if (n == 0) {
                                for (n4 = 0; n4 < DoubleFFT_3D.this.rows; ++n4) {
                                    DoubleFFT_3D.this.fftColumns.complexForward(dArray, n52 + n4 * DoubleFFT_3D.this.rowStride);
                                }
                            } else {
                                for (n4 = 0; n4 < DoubleFFT_3D.this.rows; ++n4) {
                                    DoubleFFT_3D.this.fftColumns.realForward(dArray, n52 + n4 * DoubleFFT_3D.this.rowStride);
                                }
                            }
                            if (DoubleFFT_3D.this.columns > 4) {
                                for (n4 = 0; n4 < DoubleFFT_3D.this.columns; n4 += 8) {
                                    int n62;
                                    int n7;
                                    int n8;
                                    for (n8 = 0; n8 < DoubleFFT_3D.this.rows; ++n8) {
                                        n32 = n52 + n8 * DoubleFFT_3D.this.rowStride + n4;
                                        n22 = n6 + 2 * n8;
                                        n16 = n6 + 2 * DoubleFFT_3D.this.rows + 2 * n8;
                                        n7 = n16 + 2 * DoubleFFT_3D.this.rows;
                                        n62 = n7 + 2 * DoubleFFT_3D.this.rows;
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n22] = dArray[n32];
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n22 + 1] = dArray[n32 + 1];
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n16] = dArray[n32 + 2];
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n16 + 1] = dArray[n32 + 3];
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n7] = dArray[n32 + 4];
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n7 + 1] = dArray[n32 + 5];
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n62] = dArray[n32 + 6];
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n62 + 1] = dArray[n32 + 7];
                                    }
                                    DoubleFFT_3D.this.fftRows.complexForward(DoubleFFT_3D.this.t, n6);
                                    DoubleFFT_3D.this.fftRows.complexForward(DoubleFFT_3D.this.t, n6 + 2 * DoubleFFT_3D.this.rows);
                                    DoubleFFT_3D.this.fftRows.complexForward(DoubleFFT_3D.this.t, n6 + 4 * DoubleFFT_3D.this.rows);
                                    DoubleFFT_3D.this.fftRows.complexForward(DoubleFFT_3D.this.t, n6 + 6 * DoubleFFT_3D.this.rows);
                                    for (n8 = 0; n8 < DoubleFFT_3D.this.rows; ++n8) {
                                        n32 = n52 + n8 * DoubleFFT_3D.this.rowStride + n4;
                                        n22 = n6 + 2 * n8;
                                        n16 = n6 + 2 * DoubleFFT_3D.this.rows + 2 * n8;
                                        n7 = n16 + 2 * DoubleFFT_3D.this.rows;
                                        n62 = n7 + 2 * DoubleFFT_3D.this.rows;
                                        dArray[n32] = DoubleFFT_3D.this.t[n22];
                                        dArray[n32 + 1] = DoubleFFT_3D.this.t[n22 + 1];
                                        dArray[n32 + 2] = DoubleFFT_3D.this.t[n16];
                                        dArray[n32 + 3] = DoubleFFT_3D.this.t[n16 + 1];
                                        dArray[n32 + 4] = DoubleFFT_3D.this.t[n7];
                                        dArray[n32 + 5] = DoubleFFT_3D.this.t[n7 + 1];
                                        dArray[n32 + 6] = DoubleFFT_3D.this.t[n62];
                                        dArray[n32 + 7] = DoubleFFT_3D.this.t[n62 + 1];
                                    }
                                }
                                continue;
                            }
                            if (DoubleFFT_3D.this.columns == 4) {
                                for (n4 = 0; n4 < DoubleFFT_3D.this.rows; ++n4) {
                                    n32 = n52 + n4 * DoubleFFT_3D.this.rowStride;
                                    n22 = n6 + 2 * n4;
                                    n16 = n6 + 2 * DoubleFFT_3D.this.rows + 2 * n4;
                                    ((DoubleFFT_3D)DoubleFFT_3D.this).t[n22] = dArray[n32];
                                    ((DoubleFFT_3D)DoubleFFT_3D.this).t[n22 + 1] = dArray[n32 + 1];
                                    ((DoubleFFT_3D)DoubleFFT_3D.this).t[n16] = dArray[n32 + 2];
                                    ((DoubleFFT_3D)DoubleFFT_3D.this).t[n16 + 1] = dArray[n32 + 3];
                                }
                                DoubleFFT_3D.this.fftRows.complexForward(DoubleFFT_3D.this.t, n6);
                                DoubleFFT_3D.this.fftRows.complexForward(DoubleFFT_3D.this.t, n6 + 2 * DoubleFFT_3D.this.rows);
                                for (n4 = 0; n4 < DoubleFFT_3D.this.rows; ++n4) {
                                    n32 = n52 + n4 * DoubleFFT_3D.this.rowStride;
                                    n22 = n6 + 2 * n4;
                                    n16 = n6 + 2 * DoubleFFT_3D.this.rows + 2 * n4;
                                    dArray[n32] = DoubleFFT_3D.this.t[n22];
                                    dArray[n32 + 1] = DoubleFFT_3D.this.t[n22 + 1];
                                    dArray[n32 + 2] = DoubleFFT_3D.this.t[n16];
                                    dArray[n32 + 3] = DoubleFFT_3D.this.t[n16 + 1];
                                }
                                continue;
                            }
                            if (DoubleFFT_3D.this.columns != 2) continue;
                            for (n4 = 0; n4 < DoubleFFT_3D.this.rows; ++n4) {
                                n32 = n52 + n4 * DoubleFFT_3D.this.rowStride;
                                n22 = n6 + 2 * n4;
                                ((DoubleFFT_3D)DoubleFFT_3D.this).t[n22] = dArray[n32];
                                ((DoubleFFT_3D)DoubleFFT_3D.this).t[n22 + 1] = dArray[n32 + 1];
                            }
                            DoubleFFT_3D.this.fftRows.complexForward(DoubleFFT_3D.this.t, n6);
                            for (n4 = 0; n4 < DoubleFFT_3D.this.rows; ++n4) {
                                n32 = n52 + n4 * DoubleFFT_3D.this.rowStride;
                                n22 = n6 + 2 * n4;
                                dArray[n32] = DoubleFFT_3D.this.t[n22];
                                dArray[n32 + 1] = DoubleFFT_3D.this.t[n22 + 1];
                            }
                        }
                    } else {
                        for (int i = n5; i < DoubleFFT_3D.this.slices; i += n3) {
                            int n17;
                            int n9;
                            int n10;
                            int n11;
                            int n12 = i * DoubleFFT_3D.this.sliceStride;
                            if (n == 0) {
                                for (n11 = 0; n11 < DoubleFFT_3D.this.rows; ++n11) {
                                    DoubleFFT_3D.this.fftColumns.complexInverse(dArray, n12 + n11 * DoubleFFT_3D.this.rowStride, bl);
                                }
                            } else {
                                for (n11 = 0; n11 < DoubleFFT_3D.this.rows; ++n11) {
                                    DoubleFFT_3D.this.fftColumns.realInverse2(dArray, n12 + n11 * DoubleFFT_3D.this.rowStride, bl);
                                }
                            }
                            if (DoubleFFT_3D.this.columns > 4) {
                                for (n11 = 0; n11 < DoubleFFT_3D.this.columns; n11 += 8) {
                                    int n13;
                                    int n14;
                                    int n15;
                                    for (n15 = 0; n15 < DoubleFFT_3D.this.rows; ++n15) {
                                        n10 = n12 + n15 * DoubleFFT_3D.this.rowStride + n11;
                                        n9 = n6 + 2 * n15;
                                        n17 = n6 + 2 * DoubleFFT_3D.this.rows + 2 * n15;
                                        n14 = n17 + 2 * DoubleFFT_3D.this.rows;
                                        n13 = n14 + 2 * DoubleFFT_3D.this.rows;
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n9] = dArray[n10];
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n9 + 1] = dArray[n10 + 1];
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n17] = dArray[n10 + 2];
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n17 + 1] = dArray[n10 + 3];
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n14] = dArray[n10 + 4];
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n14 + 1] = dArray[n10 + 5];
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n13] = dArray[n10 + 6];
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n13 + 1] = dArray[n10 + 7];
                                    }
                                    DoubleFFT_3D.this.fftRows.complexInverse(DoubleFFT_3D.this.t, n6, bl);
                                    DoubleFFT_3D.this.fftRows.complexInverse(DoubleFFT_3D.this.t, n6 + 2 * DoubleFFT_3D.this.rows, bl);
                                    DoubleFFT_3D.this.fftRows.complexInverse(DoubleFFT_3D.this.t, n6 + 4 * DoubleFFT_3D.this.rows, bl);
                                    DoubleFFT_3D.this.fftRows.complexInverse(DoubleFFT_3D.this.t, n6 + 6 * DoubleFFT_3D.this.rows, bl);
                                    for (n15 = 0; n15 < DoubleFFT_3D.this.rows; ++n15) {
                                        n10 = n12 + n15 * DoubleFFT_3D.this.rowStride + n11;
                                        n9 = n6 + 2 * n15;
                                        n17 = n6 + 2 * DoubleFFT_3D.this.rows + 2 * n15;
                                        n14 = n17 + 2 * DoubleFFT_3D.this.rows;
                                        n13 = n14 + 2 * DoubleFFT_3D.this.rows;
                                        dArray[n10] = DoubleFFT_3D.this.t[n9];
                                        dArray[n10 + 1] = DoubleFFT_3D.this.t[n9 + 1];
                                        dArray[n10 + 2] = DoubleFFT_3D.this.t[n17];
                                        dArray[n10 + 3] = DoubleFFT_3D.this.t[n17 + 1];
                                        dArray[n10 + 4] = DoubleFFT_3D.this.t[n14];
                                        dArray[n10 + 5] = DoubleFFT_3D.this.t[n14 + 1];
                                        dArray[n10 + 6] = DoubleFFT_3D.this.t[n13];
                                        dArray[n10 + 7] = DoubleFFT_3D.this.t[n13 + 1];
                                    }
                                }
                                continue;
                            }
                            if (DoubleFFT_3D.this.columns == 4) {
                                for (n11 = 0; n11 < DoubleFFT_3D.this.rows; ++n11) {
                                    n10 = n12 + n11 * DoubleFFT_3D.this.rowStride;
                                    n9 = n6 + 2 * n11;
                                    n17 = n6 + 2 * DoubleFFT_3D.this.rows + 2 * n11;
                                    ((DoubleFFT_3D)DoubleFFT_3D.this).t[n9] = dArray[n10];
                                    ((DoubleFFT_3D)DoubleFFT_3D.this).t[n9 + 1] = dArray[n10 + 1];
                                    ((DoubleFFT_3D)DoubleFFT_3D.this).t[n17] = dArray[n10 + 2];
                                    ((DoubleFFT_3D)DoubleFFT_3D.this).t[n17 + 1] = dArray[n10 + 3];
                                }
                                DoubleFFT_3D.this.fftRows.complexInverse(DoubleFFT_3D.this.t, n6, bl);
                                DoubleFFT_3D.this.fftRows.complexInverse(DoubleFFT_3D.this.t, n6 + 2 * DoubleFFT_3D.this.rows, bl);
                                for (n11 = 0; n11 < DoubleFFT_3D.this.rows; ++n11) {
                                    n10 = n12 + n11 * DoubleFFT_3D.this.rowStride;
                                    n9 = n6 + 2 * n11;
                                    n17 = n6 + 2 * DoubleFFT_3D.this.rows + 2 * n11;
                                    dArray[n10] = DoubleFFT_3D.this.t[n9];
                                    dArray[n10 + 1] = DoubleFFT_3D.this.t[n9 + 1];
                                    dArray[n10 + 2] = DoubleFFT_3D.this.t[n17];
                                    dArray[n10 + 3] = DoubleFFT_3D.this.t[n17 + 1];
                                }
                                continue;
                            }
                            if (DoubleFFT_3D.this.columns != 2) continue;
                            for (n11 = 0; n11 < DoubleFFT_3D.this.rows; ++n11) {
                                n10 = n12 + n11 * DoubleFFT_3D.this.rowStride;
                                n9 = n6 + 2 * n11;
                                ((DoubleFFT_3D)DoubleFFT_3D.this).t[n9] = dArray[n10];
                                ((DoubleFFT_3D)DoubleFFT_3D.this).t[n9 + 1] = dArray[n10 + 1];
                            }
                            DoubleFFT_3D.this.fftRows.complexInverse(DoubleFFT_3D.this.t, n6, bl);
                            for (n11 = 0; n11 < DoubleFFT_3D.this.rows; ++n11) {
                                n10 = n12 + n11 * DoubleFFT_3D.this.rowStride;
                                n9 = n6 + 2 * n11;
                                dArray[n10] = DoubleFFT_3D.this.t[n9];
                                dArray[n10 + 1] = DoubleFFT_3D.this.t[n9 + 1];
                            }
                        }
                    }
                }
            });
        }
        ConcurrencyUtils.waitForCompletion(futureArray);
    }

    private void xdft3da_subth1(final int n, final int n2, final double[][][] dArray, final boolean bl) {
        final int n3 = Math.min(ConcurrencyUtils.getNumberOfThreads(), this.slices);
        int n4 = 8 * this.rows;
        if (this.columns == 4) {
            n4 >>= 1;
        } else if (this.columns < 4) {
            n4 >>= 2;
        }
        Future[] futureArray = new Future[n3];
        for (int i = 0; i < n3; ++i) {
            final int n5 = i;
            final int n6 = n4 * i;
            futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                public void run() {
                    if (n2 == -1) {
                        for (int i = n5; i < DoubleFFT_3D.this.slices; i += n3) {
                            int n12;
                            int n22;
                            int n32;
                            if (n == 0) {
                                for (n32 = 0; n32 < DoubleFFT_3D.this.rows; ++n32) {
                                    DoubleFFT_3D.this.fftColumns.complexForward(dArray[i][n32]);
                                }
                            } else {
                                for (n32 = 0; n32 < DoubleFFT_3D.this.rows; ++n32) {
                                    DoubleFFT_3D.this.fftColumns.realForward(dArray[i][n32], 0);
                                }
                            }
                            if (DoubleFFT_3D.this.columns > 4) {
                                for (n32 = 0; n32 < DoubleFFT_3D.this.columns; n32 += 8) {
                                    int n4;
                                    int n52;
                                    int n62;
                                    for (n62 = 0; n62 < DoubleFFT_3D.this.rows; ++n62) {
                                        n22 = n6 + 2 * n62;
                                        n12 = n6 + 2 * DoubleFFT_3D.this.rows + 2 * n62;
                                        n52 = n12 + 2 * DoubleFFT_3D.this.rows;
                                        n4 = n52 + 2 * DoubleFFT_3D.this.rows;
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n22] = dArray[i][n62][n32];
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n22 + 1] = dArray[i][n62][n32 + 1];
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n12] = dArray[i][n62][n32 + 2];
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n12 + 1] = dArray[i][n62][n32 + 3];
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n52] = dArray[i][n62][n32 + 4];
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n52 + 1] = dArray[i][n62][n32 + 5];
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n4] = dArray[i][n62][n32 + 6];
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n4 + 1] = dArray[i][n62][n32 + 7];
                                    }
                                    DoubleFFT_3D.this.fftRows.complexForward(DoubleFFT_3D.this.t, n6);
                                    DoubleFFT_3D.this.fftRows.complexForward(DoubleFFT_3D.this.t, n6 + 2 * DoubleFFT_3D.this.rows);
                                    DoubleFFT_3D.this.fftRows.complexForward(DoubleFFT_3D.this.t, n6 + 4 * DoubleFFT_3D.this.rows);
                                    DoubleFFT_3D.this.fftRows.complexForward(DoubleFFT_3D.this.t, n6 + 6 * DoubleFFT_3D.this.rows);
                                    for (n62 = 0; n62 < DoubleFFT_3D.this.rows; ++n62) {
                                        n22 = n6 + 2 * n62;
                                        n12 = n6 + 2 * DoubleFFT_3D.this.rows + 2 * n62;
                                        n52 = n12 + 2 * DoubleFFT_3D.this.rows;
                                        n4 = n52 + 2 * DoubleFFT_3D.this.rows;
                                        dArray[i][n62][n32] = DoubleFFT_3D.this.t[n22];
                                        dArray[i][n62][n32 + 1] = DoubleFFT_3D.this.t[n22 + 1];
                                        dArray[i][n62][n32 + 2] = DoubleFFT_3D.this.t[n12];
                                        dArray[i][n62][n32 + 3] = DoubleFFT_3D.this.t[n12 + 1];
                                        dArray[i][n62][n32 + 4] = DoubleFFT_3D.this.t[n52];
                                        dArray[i][n62][n32 + 5] = DoubleFFT_3D.this.t[n52 + 1];
                                        dArray[i][n62][n32 + 6] = DoubleFFT_3D.this.t[n4];
                                        dArray[i][n62][n32 + 7] = DoubleFFT_3D.this.t[n4 + 1];
                                    }
                                }
                                continue;
                            }
                            if (DoubleFFT_3D.this.columns == 4) {
                                for (n32 = 0; n32 < DoubleFFT_3D.this.rows; ++n32) {
                                    n22 = n6 + 2 * n32;
                                    n12 = n6 + 2 * DoubleFFT_3D.this.rows + 2 * n32;
                                    ((DoubleFFT_3D)DoubleFFT_3D.this).t[n22] = dArray[i][n32][0];
                                    ((DoubleFFT_3D)DoubleFFT_3D.this).t[n22 + 1] = dArray[i][n32][1];
                                    ((DoubleFFT_3D)DoubleFFT_3D.this).t[n12] = dArray[i][n32][2];
                                    ((DoubleFFT_3D)DoubleFFT_3D.this).t[n12 + 1] = dArray[i][n32][3];
                                }
                                DoubleFFT_3D.this.fftRows.complexForward(DoubleFFT_3D.this.t, n6);
                                DoubleFFT_3D.this.fftRows.complexForward(DoubleFFT_3D.this.t, n6 + 2 * DoubleFFT_3D.this.rows);
                                for (n32 = 0; n32 < DoubleFFT_3D.this.rows; ++n32) {
                                    n22 = n6 + 2 * n32;
                                    n12 = n6 + 2 * DoubleFFT_3D.this.rows + 2 * n32;
                                    dArray[i][n32][0] = DoubleFFT_3D.this.t[n22];
                                    dArray[i][n32][1] = DoubleFFT_3D.this.t[n22 + 1];
                                    dArray[i][n32][2] = DoubleFFT_3D.this.t[n12];
                                    dArray[i][n32][3] = DoubleFFT_3D.this.t[n12 + 1];
                                }
                                continue;
                            }
                            if (DoubleFFT_3D.this.columns != 2) continue;
                            for (n32 = 0; n32 < DoubleFFT_3D.this.rows; ++n32) {
                                n22 = n6 + 2 * n32;
                                ((DoubleFFT_3D)DoubleFFT_3D.this).t[n22] = dArray[i][n32][0];
                                ((DoubleFFT_3D)DoubleFFT_3D.this).t[n22 + 1] = dArray[i][n32][1];
                            }
                            DoubleFFT_3D.this.fftRows.complexForward(DoubleFFT_3D.this.t, n6);
                            for (n32 = 0; n32 < DoubleFFT_3D.this.rows; ++n32) {
                                n22 = n6 + 2 * n32;
                                dArray[i][n32][0] = DoubleFFT_3D.this.t[n22];
                                dArray[i][n32][1] = DoubleFFT_3D.this.t[n22 + 1];
                            }
                        }
                    } else {
                        for (int i = n5; i < DoubleFFT_3D.this.slices; i += n3) {
                            int n13;
                            int n7;
                            int n8;
                            if (n == 0) {
                                for (n8 = 0; n8 < DoubleFFT_3D.this.rows; ++n8) {
                                    DoubleFFT_3D.this.fftColumns.complexInverse(dArray[i][n8], bl);
                                }
                            }
                            if (DoubleFFT_3D.this.columns > 4) {
                                for (n8 = 0; n8 < DoubleFFT_3D.this.columns; n8 += 8) {
                                    int n9;
                                    int n10;
                                    int n11;
                                    for (n11 = 0; n11 < DoubleFFT_3D.this.rows; ++n11) {
                                        n7 = n6 + 2 * n11;
                                        n13 = n6 + 2 * DoubleFFT_3D.this.rows + 2 * n11;
                                        n10 = n13 + 2 * DoubleFFT_3D.this.rows;
                                        n9 = n10 + 2 * DoubleFFT_3D.this.rows;
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n7] = dArray[i][n11][n8];
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n7 + 1] = dArray[i][n11][n8 + 1];
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n13] = dArray[i][n11][n8 + 2];
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n13 + 1] = dArray[i][n11][n8 + 3];
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n10] = dArray[i][n11][n8 + 4];
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n10 + 1] = dArray[i][n11][n8 + 5];
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n9] = dArray[i][n11][n8 + 6];
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n9 + 1] = dArray[i][n11][n8 + 7];
                                    }
                                    DoubleFFT_3D.this.fftRows.complexInverse(DoubleFFT_3D.this.t, n6, bl);
                                    DoubleFFT_3D.this.fftRows.complexInverse(DoubleFFT_3D.this.t, n6 + 2 * DoubleFFT_3D.this.rows, bl);
                                    DoubleFFT_3D.this.fftRows.complexInverse(DoubleFFT_3D.this.t, n6 + 4 * DoubleFFT_3D.this.rows, bl);
                                    DoubleFFT_3D.this.fftRows.complexInverse(DoubleFFT_3D.this.t, n6 + 6 * DoubleFFT_3D.this.rows, bl);
                                    for (n11 = 0; n11 < DoubleFFT_3D.this.rows; ++n11) {
                                        n7 = n6 + 2 * n11;
                                        n13 = n6 + 2 * DoubleFFT_3D.this.rows + 2 * n11;
                                        n10 = n13 + 2 * DoubleFFT_3D.this.rows;
                                        n9 = n10 + 2 * DoubleFFT_3D.this.rows;
                                        dArray[i][n11][n8] = DoubleFFT_3D.this.t[n7];
                                        dArray[i][n11][n8 + 1] = DoubleFFT_3D.this.t[n7 + 1];
                                        dArray[i][n11][n8 + 2] = DoubleFFT_3D.this.t[n13];
                                        dArray[i][n11][n8 + 3] = DoubleFFT_3D.this.t[n13 + 1];
                                        dArray[i][n11][n8 + 4] = DoubleFFT_3D.this.t[n10];
                                        dArray[i][n11][n8 + 5] = DoubleFFT_3D.this.t[n10 + 1];
                                        dArray[i][n11][n8 + 6] = DoubleFFT_3D.this.t[n9];
                                        dArray[i][n11][n8 + 7] = DoubleFFT_3D.this.t[n9 + 1];
                                    }
                                }
                            } else if (DoubleFFT_3D.this.columns == 4) {
                                for (n8 = 0; n8 < DoubleFFT_3D.this.rows; ++n8) {
                                    n7 = n6 + 2 * n8;
                                    n13 = n6 + 2 * DoubleFFT_3D.this.rows + 2 * n8;
                                    ((DoubleFFT_3D)DoubleFFT_3D.this).t[n7] = dArray[i][n8][0];
                                    ((DoubleFFT_3D)DoubleFFT_3D.this).t[n7 + 1] = dArray[i][n8][1];
                                    ((DoubleFFT_3D)DoubleFFT_3D.this).t[n13] = dArray[i][n8][2];
                                    ((DoubleFFT_3D)DoubleFFT_3D.this).t[n13 + 1] = dArray[i][n8][3];
                                }
                                DoubleFFT_3D.this.fftRows.complexInverse(DoubleFFT_3D.this.t, n6, bl);
                                DoubleFFT_3D.this.fftRows.complexInverse(DoubleFFT_3D.this.t, n6 + 2 * DoubleFFT_3D.this.rows, bl);
                                for (n8 = 0; n8 < DoubleFFT_3D.this.rows; ++n8) {
                                    n7 = n6 + 2 * n8;
                                    n13 = n6 + 2 * DoubleFFT_3D.this.rows + 2 * n8;
                                    dArray[i][n8][0] = DoubleFFT_3D.this.t[n7];
                                    dArray[i][n8][1] = DoubleFFT_3D.this.t[n7 + 1];
                                    dArray[i][n8][2] = DoubleFFT_3D.this.t[n13];
                                    dArray[i][n8][3] = DoubleFFT_3D.this.t[n13 + 1];
                                }
                            } else if (DoubleFFT_3D.this.columns == 2) {
                                for (n8 = 0; n8 < DoubleFFT_3D.this.rows; ++n8) {
                                    n7 = n6 + 2 * n8;
                                    ((DoubleFFT_3D)DoubleFFT_3D.this).t[n7] = dArray[i][n8][0];
                                    ((DoubleFFT_3D)DoubleFFT_3D.this).t[n7 + 1] = dArray[i][n8][1];
                                }
                                DoubleFFT_3D.this.fftRows.complexInverse(DoubleFFT_3D.this.t, n6, bl);
                                for (n8 = 0; n8 < DoubleFFT_3D.this.rows; ++n8) {
                                    n7 = n6 + 2 * n8;
                                    dArray[i][n8][0] = DoubleFFT_3D.this.t[n7];
                                    dArray[i][n8][1] = DoubleFFT_3D.this.t[n7 + 1];
                                }
                            }
                            if (n == 0) continue;
                            for (n8 = 0; n8 < DoubleFFT_3D.this.rows; ++n8) {
                                DoubleFFT_3D.this.fftColumns.realInverse(dArray[i][n8], bl);
                            }
                        }
                    }
                }
            });
        }
        ConcurrencyUtils.waitForCompletion(futureArray);
    }

    private void xdft3da_subth2(final int n, final int n2, final double[][][] dArray, final boolean bl) {
        final int n3 = Math.min(ConcurrencyUtils.getNumberOfThreads(), this.slices);
        int n4 = 8 * this.rows;
        if (this.columns == 4) {
            n4 >>= 1;
        } else if (this.columns < 4) {
            n4 >>= 2;
        }
        Future[] futureArray = new Future[n3];
        for (int i = 0; i < n3; ++i) {
            final int n5 = i;
            final int n6 = n4 * i;
            futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                public void run() {
                    if (n2 == -1) {
                        for (int i = n5; i < DoubleFFT_3D.this.slices; i += n3) {
                            int n12;
                            int n22;
                            int n32;
                            if (n == 0) {
                                for (n32 = 0; n32 < DoubleFFT_3D.this.rows; ++n32) {
                                    DoubleFFT_3D.this.fftColumns.complexForward(dArray[i][n32]);
                                }
                            } else {
                                for (n32 = 0; n32 < DoubleFFT_3D.this.rows; ++n32) {
                                    DoubleFFT_3D.this.fftColumns.realForward(dArray[i][n32]);
                                }
                            }
                            if (DoubleFFT_3D.this.columns > 4) {
                                for (n32 = 0; n32 < DoubleFFT_3D.this.columns; n32 += 8) {
                                    int n4;
                                    int n52;
                                    int n62;
                                    for (n62 = 0; n62 < DoubleFFT_3D.this.rows; ++n62) {
                                        n22 = n6 + 2 * n62;
                                        n12 = n6 + 2 * DoubleFFT_3D.this.rows + 2 * n62;
                                        n52 = n12 + 2 * DoubleFFT_3D.this.rows;
                                        n4 = n52 + 2 * DoubleFFT_3D.this.rows;
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n22] = dArray[i][n62][n32];
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n22 + 1] = dArray[i][n62][n32 + 1];
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n12] = dArray[i][n62][n32 + 2];
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n12 + 1] = dArray[i][n62][n32 + 3];
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n52] = dArray[i][n62][n32 + 4];
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n52 + 1] = dArray[i][n62][n32 + 5];
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n4] = dArray[i][n62][n32 + 6];
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n4 + 1] = dArray[i][n62][n32 + 7];
                                    }
                                    DoubleFFT_3D.this.fftRows.complexForward(DoubleFFT_3D.this.t, n6);
                                    DoubleFFT_3D.this.fftRows.complexForward(DoubleFFT_3D.this.t, n6 + 2 * DoubleFFT_3D.this.rows);
                                    DoubleFFT_3D.this.fftRows.complexForward(DoubleFFT_3D.this.t, n6 + 4 * DoubleFFT_3D.this.rows);
                                    DoubleFFT_3D.this.fftRows.complexForward(DoubleFFT_3D.this.t, n6 + 6 * DoubleFFT_3D.this.rows);
                                    for (n62 = 0; n62 < DoubleFFT_3D.this.rows; ++n62) {
                                        n22 = n6 + 2 * n62;
                                        n12 = n6 + 2 * DoubleFFT_3D.this.rows + 2 * n62;
                                        n52 = n12 + 2 * DoubleFFT_3D.this.rows;
                                        n4 = n52 + 2 * DoubleFFT_3D.this.rows;
                                        dArray[i][n62][n32] = DoubleFFT_3D.this.t[n22];
                                        dArray[i][n62][n32 + 1] = DoubleFFT_3D.this.t[n22 + 1];
                                        dArray[i][n62][n32 + 2] = DoubleFFT_3D.this.t[n12];
                                        dArray[i][n62][n32 + 3] = DoubleFFT_3D.this.t[n12 + 1];
                                        dArray[i][n62][n32 + 4] = DoubleFFT_3D.this.t[n52];
                                        dArray[i][n62][n32 + 5] = DoubleFFT_3D.this.t[n52 + 1];
                                        dArray[i][n62][n32 + 6] = DoubleFFT_3D.this.t[n4];
                                        dArray[i][n62][n32 + 7] = DoubleFFT_3D.this.t[n4 + 1];
                                    }
                                }
                                continue;
                            }
                            if (DoubleFFT_3D.this.columns == 4) {
                                for (n32 = 0; n32 < DoubleFFT_3D.this.rows; ++n32) {
                                    n22 = n6 + 2 * n32;
                                    n12 = n6 + 2 * DoubleFFT_3D.this.rows + 2 * n32;
                                    ((DoubleFFT_3D)DoubleFFT_3D.this).t[n22] = dArray[i][n32][0];
                                    ((DoubleFFT_3D)DoubleFFT_3D.this).t[n22 + 1] = dArray[i][n32][1];
                                    ((DoubleFFT_3D)DoubleFFT_3D.this).t[n12] = dArray[i][n32][2];
                                    ((DoubleFFT_3D)DoubleFFT_3D.this).t[n12 + 1] = dArray[i][n32][3];
                                }
                                DoubleFFT_3D.this.fftRows.complexForward(DoubleFFT_3D.this.t, n6);
                                DoubleFFT_3D.this.fftRows.complexForward(DoubleFFT_3D.this.t, n6 + 2 * DoubleFFT_3D.this.rows);
                                for (n32 = 0; n32 < DoubleFFT_3D.this.rows; ++n32) {
                                    n22 = n6 + 2 * n32;
                                    n12 = n6 + 2 * DoubleFFT_3D.this.rows + 2 * n32;
                                    dArray[i][n32][0] = DoubleFFT_3D.this.t[n22];
                                    dArray[i][n32][1] = DoubleFFT_3D.this.t[n22 + 1];
                                    dArray[i][n32][2] = DoubleFFT_3D.this.t[n12];
                                    dArray[i][n32][3] = DoubleFFT_3D.this.t[n12 + 1];
                                }
                                continue;
                            }
                            if (DoubleFFT_3D.this.columns != 2) continue;
                            for (n32 = 0; n32 < DoubleFFT_3D.this.rows; ++n32) {
                                n22 = n6 + 2 * n32;
                                ((DoubleFFT_3D)DoubleFFT_3D.this).t[n22] = dArray[i][n32][0];
                                ((DoubleFFT_3D)DoubleFFT_3D.this).t[n22 + 1] = dArray[i][n32][1];
                            }
                            DoubleFFT_3D.this.fftRows.complexForward(DoubleFFT_3D.this.t, n6);
                            for (n32 = 0; n32 < DoubleFFT_3D.this.rows; ++n32) {
                                n22 = n6 + 2 * n32;
                                dArray[i][n32][0] = DoubleFFT_3D.this.t[n22];
                                dArray[i][n32][1] = DoubleFFT_3D.this.t[n22 + 1];
                            }
                        }
                    } else {
                        for (int i = n5; i < DoubleFFT_3D.this.slices; i += n3) {
                            int n13;
                            int n7;
                            int n8;
                            if (n == 0) {
                                for (n8 = 0; n8 < DoubleFFT_3D.this.rows; ++n8) {
                                    DoubleFFT_3D.this.fftColumns.complexInverse(dArray[i][n8], bl);
                                }
                            } else {
                                for (n8 = 0; n8 < DoubleFFT_3D.this.rows; ++n8) {
                                    DoubleFFT_3D.this.fftColumns.realInverse2(dArray[i][n8], 0, bl);
                                }
                            }
                            if (DoubleFFT_3D.this.columns > 4) {
                                for (n8 = 0; n8 < DoubleFFT_3D.this.columns; n8 += 8) {
                                    int n9;
                                    int n10;
                                    int n11;
                                    for (n11 = 0; n11 < DoubleFFT_3D.this.rows; ++n11) {
                                        n7 = n6 + 2 * n11;
                                        n13 = n6 + 2 * DoubleFFT_3D.this.rows + 2 * n11;
                                        n10 = n13 + 2 * DoubleFFT_3D.this.rows;
                                        n9 = n10 + 2 * DoubleFFT_3D.this.rows;
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n7] = dArray[i][n11][n8];
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n7 + 1] = dArray[i][n11][n8 + 1];
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n13] = dArray[i][n11][n8 + 2];
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n13 + 1] = dArray[i][n11][n8 + 3];
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n10] = dArray[i][n11][n8 + 4];
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n10 + 1] = dArray[i][n11][n8 + 5];
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n9] = dArray[i][n11][n8 + 6];
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n9 + 1] = dArray[i][n11][n8 + 7];
                                    }
                                    DoubleFFT_3D.this.fftRows.complexInverse(DoubleFFT_3D.this.t, n6, bl);
                                    DoubleFFT_3D.this.fftRows.complexInverse(DoubleFFT_3D.this.t, n6 + 2 * DoubleFFT_3D.this.rows, bl);
                                    DoubleFFT_3D.this.fftRows.complexInverse(DoubleFFT_3D.this.t, n6 + 4 * DoubleFFT_3D.this.rows, bl);
                                    DoubleFFT_3D.this.fftRows.complexInverse(DoubleFFT_3D.this.t, n6 + 6 * DoubleFFT_3D.this.rows, bl);
                                    for (n11 = 0; n11 < DoubleFFT_3D.this.rows; ++n11) {
                                        n7 = n6 + 2 * n11;
                                        n13 = n6 + 2 * DoubleFFT_3D.this.rows + 2 * n11;
                                        n10 = n13 + 2 * DoubleFFT_3D.this.rows;
                                        n9 = n10 + 2 * DoubleFFT_3D.this.rows;
                                        dArray[i][n11][n8] = DoubleFFT_3D.this.t[n7];
                                        dArray[i][n11][n8 + 1] = DoubleFFT_3D.this.t[n7 + 1];
                                        dArray[i][n11][n8 + 2] = DoubleFFT_3D.this.t[n13];
                                        dArray[i][n11][n8 + 3] = DoubleFFT_3D.this.t[n13 + 1];
                                        dArray[i][n11][n8 + 4] = DoubleFFT_3D.this.t[n10];
                                        dArray[i][n11][n8 + 5] = DoubleFFT_3D.this.t[n10 + 1];
                                        dArray[i][n11][n8 + 6] = DoubleFFT_3D.this.t[n9];
                                        dArray[i][n11][n8 + 7] = DoubleFFT_3D.this.t[n9 + 1];
                                    }
                                }
                                continue;
                            }
                            if (DoubleFFT_3D.this.columns == 4) {
                                for (n8 = 0; n8 < DoubleFFT_3D.this.rows; ++n8) {
                                    n7 = n6 + 2 * n8;
                                    n13 = n6 + 2 * DoubleFFT_3D.this.rows + 2 * n8;
                                    ((DoubleFFT_3D)DoubleFFT_3D.this).t[n7] = dArray[i][n8][0];
                                    ((DoubleFFT_3D)DoubleFFT_3D.this).t[n7 + 1] = dArray[i][n8][1];
                                    ((DoubleFFT_3D)DoubleFFT_3D.this).t[n13] = dArray[i][n8][2];
                                    ((DoubleFFT_3D)DoubleFFT_3D.this).t[n13 + 1] = dArray[i][n8][3];
                                }
                                DoubleFFT_3D.this.fftRows.complexInverse(DoubleFFT_3D.this.t, n6, bl);
                                DoubleFFT_3D.this.fftRows.complexInverse(DoubleFFT_3D.this.t, n6 + 2 * DoubleFFT_3D.this.rows, bl);
                                for (n8 = 0; n8 < DoubleFFT_3D.this.rows; ++n8) {
                                    n7 = n6 + 2 * n8;
                                    n13 = n6 + 2 * DoubleFFT_3D.this.rows + 2 * n8;
                                    dArray[i][n8][0] = DoubleFFT_3D.this.t[n7];
                                    dArray[i][n8][1] = DoubleFFT_3D.this.t[n7 + 1];
                                    dArray[i][n8][2] = DoubleFFT_3D.this.t[n13];
                                    dArray[i][n8][3] = DoubleFFT_3D.this.t[n13 + 1];
                                }
                                continue;
                            }
                            if (DoubleFFT_3D.this.columns != 2) continue;
                            for (n8 = 0; n8 < DoubleFFT_3D.this.rows; ++n8) {
                                n7 = n6 + 2 * n8;
                                ((DoubleFFT_3D)DoubleFFT_3D.this).t[n7] = dArray[i][n8][0];
                                ((DoubleFFT_3D)DoubleFFT_3D.this).t[n7 + 1] = dArray[i][n8][1];
                            }
                            DoubleFFT_3D.this.fftRows.complexInverse(DoubleFFT_3D.this.t, n6, bl);
                            for (n8 = 0; n8 < DoubleFFT_3D.this.rows; ++n8) {
                                n7 = n6 + 2 * n8;
                                dArray[i][n8][0] = DoubleFFT_3D.this.t[n7];
                                dArray[i][n8][1] = DoubleFFT_3D.this.t[n7 + 1];
                            }
                        }
                    }
                }
            });
        }
        ConcurrencyUtils.waitForCompletion(futureArray);
    }

    private void cdft3db_subth(final int n, final double[] dArray, final boolean bl) {
        final int n2 = Math.min(ConcurrencyUtils.getNumberOfThreads(), this.rows);
        int n3 = 8 * this.slices;
        if (this.columns == 4) {
            n3 >>= 1;
        } else if (this.columns < 4) {
            n3 >>= 2;
        }
        Future[] futureArray = new Future[n2];
        for (int i = 0; i < n2; ++i) {
            final int n4 = i;
            final int n5 = n3 * i;
            futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                public void run() {
                    block27: {
                        block25: {
                            block28: {
                                block26: {
                                    if (n != -1) break block25;
                                    if (DoubleFFT_3D.this.columns <= 4) break block26;
                                    for (int i = n4; i < DoubleFFT_3D.this.rows; i += n2) {
                                        int n28 = i * DoubleFFT_3D.this.rowStride;
                                        for (int j = 0; j < DoubleFFT_3D.this.columns; j += 8) {
                                            int n29;
                                            int n3;
                                            int n42;
                                            int n52;
                                            int n6;
                                            int n7;
                                            for (n7 = 0; n7 < DoubleFFT_3D.this.slices; ++n7) {
                                                n6 = n7 * DoubleFFT_3D.this.sliceStride + n28 + j;
                                                n52 = n5 + 2 * n7;
                                                n42 = n5 + 2 * DoubleFFT_3D.this.slices + 2 * n7;
                                                n3 = n42 + 2 * DoubleFFT_3D.this.slices;
                                                n29 = n3 + 2 * DoubleFFT_3D.this.slices;
                                                ((DoubleFFT_3D)DoubleFFT_3D.this).t[n52] = dArray[n6];
                                                ((DoubleFFT_3D)DoubleFFT_3D.this).t[n52 + 1] = dArray[n6 + 1];
                                                ((DoubleFFT_3D)DoubleFFT_3D.this).t[n42] = dArray[n6 + 2];
                                                ((DoubleFFT_3D)DoubleFFT_3D.this).t[n42 + 1] = dArray[n6 + 3];
                                                ((DoubleFFT_3D)DoubleFFT_3D.this).t[n3] = dArray[n6 + 4];
                                                ((DoubleFFT_3D)DoubleFFT_3D.this).t[n3 + 1] = dArray[n6 + 5];
                                                ((DoubleFFT_3D)DoubleFFT_3D.this).t[n29] = dArray[n6 + 6];
                                                ((DoubleFFT_3D)DoubleFFT_3D.this).t[n29 + 1] = dArray[n6 + 7];
                                            }
                                            DoubleFFT_3D.this.fftSlices.complexForward(DoubleFFT_3D.this.t, n5);
                                            DoubleFFT_3D.this.fftSlices.complexForward(DoubleFFT_3D.this.t, n5 + 2 * DoubleFFT_3D.this.slices);
                                            DoubleFFT_3D.this.fftSlices.complexForward(DoubleFFT_3D.this.t, n5 + 4 * DoubleFFT_3D.this.slices);
                                            DoubleFFT_3D.this.fftSlices.complexForward(DoubleFFT_3D.this.t, n5 + 6 * DoubleFFT_3D.this.slices);
                                            for (n7 = 0; n7 < DoubleFFT_3D.this.slices; ++n7) {
                                                n6 = n7 * DoubleFFT_3D.this.sliceStride + n28 + j;
                                                n52 = n5 + 2 * n7;
                                                n42 = n5 + 2 * DoubleFFT_3D.this.slices + 2 * n7;
                                                n3 = n42 + 2 * DoubleFFT_3D.this.slices;
                                                n29 = n3 + 2 * DoubleFFT_3D.this.slices;
                                                dArray[n6] = DoubleFFT_3D.this.t[n52];
                                                dArray[n6 + 1] = DoubleFFT_3D.this.t[n52 + 1];
                                                dArray[n6 + 2] = DoubleFFT_3D.this.t[n42];
                                                dArray[n6 + 3] = DoubleFFT_3D.this.t[n42 + 1];
                                                dArray[n6 + 4] = DoubleFFT_3D.this.t[n3];
                                                dArray[n6 + 5] = DoubleFFT_3D.this.t[n3 + 1];
                                                dArray[n6 + 6] = DoubleFFT_3D.this.t[n29];
                                                dArray[n6 + 7] = DoubleFFT_3D.this.t[n29 + 1];
                                            }
                                        }
                                    }
                                    break block27;
                                }
                                if (DoubleFFT_3D.this.columns != 4) break block28;
                                for (int i = n4; i < DoubleFFT_3D.this.rows; i += n2) {
                                    int n30;
                                    int n8;
                                    int n9;
                                    int n10;
                                    int n11 = i * DoubleFFT_3D.this.rowStride;
                                    for (n10 = 0; n10 < DoubleFFT_3D.this.slices; ++n10) {
                                        n9 = n10 * DoubleFFT_3D.this.sliceStride + n11;
                                        n8 = n5 + 2 * n10;
                                        n30 = n5 + 2 * DoubleFFT_3D.this.slices + 2 * n10;
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n8] = dArray[n9];
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n8 + 1] = dArray[n9 + 1];
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n30] = dArray[n9 + 2];
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n30 + 1] = dArray[n9 + 3];
                                    }
                                    DoubleFFT_3D.this.fftSlices.complexForward(DoubleFFT_3D.this.t, n5);
                                    DoubleFFT_3D.this.fftSlices.complexForward(DoubleFFT_3D.this.t, n5 + 2 * DoubleFFT_3D.this.slices);
                                    for (n10 = 0; n10 < DoubleFFT_3D.this.slices; ++n10) {
                                        n9 = n10 * DoubleFFT_3D.this.sliceStride + n11;
                                        n8 = n5 + 2 * n10;
                                        n30 = n5 + 2 * DoubleFFT_3D.this.slices + 2 * n10;
                                        dArray[n9] = DoubleFFT_3D.this.t[n8];
                                        dArray[n9 + 1] = DoubleFFT_3D.this.t[n8 + 1];
                                        dArray[n9 + 2] = DoubleFFT_3D.this.t[n30];
                                        dArray[n9 + 3] = DoubleFFT_3D.this.t[n30 + 1];
                                    }
                                }
                                break block27;
                            }
                            if (DoubleFFT_3D.this.columns != 2) break block27;
                            for (int i = n4; i < DoubleFFT_3D.this.rows; i += n2) {
                                int n31;
                                int n12;
                                int n13;
                                int n14 = i * DoubleFFT_3D.this.rowStride;
                                for (n13 = 0; n13 < DoubleFFT_3D.this.slices; ++n13) {
                                    n12 = n13 * DoubleFFT_3D.this.sliceStride + n14;
                                    n31 = n5 + 2 * n13;
                                    ((DoubleFFT_3D)DoubleFFT_3D.this).t[n31] = dArray[n12];
                                    ((DoubleFFT_3D)DoubleFFT_3D.this).t[n31 + 1] = dArray[n12 + 1];
                                }
                                DoubleFFT_3D.this.fftSlices.complexForward(DoubleFFT_3D.this.t, n5);
                                for (n13 = 0; n13 < DoubleFFT_3D.this.slices; ++n13) {
                                    n12 = n13 * DoubleFFT_3D.this.sliceStride + n14;
                                    n31 = n5 + 2 * n13;
                                    dArray[n12] = DoubleFFT_3D.this.t[n31];
                                    dArray[n12 + 1] = DoubleFFT_3D.this.t[n31 + 1];
                                }
                            }
                            break block27;
                        }
                        if (DoubleFFT_3D.this.columns > 4) {
                            for (int i = n4; i < DoubleFFT_3D.this.rows; i += n2) {
                                int n32 = i * DoubleFFT_3D.this.rowStride;
                                for (int j = 0; j < DoubleFFT_3D.this.columns; j += 8) {
                                    int n15;
                                    int n16;
                                    int n17;
                                    int n18;
                                    int n19;
                                    int n20;
                                    for (n20 = 0; n20 < DoubleFFT_3D.this.slices; ++n20) {
                                        n19 = n20 * DoubleFFT_3D.this.sliceStride + n32 + j;
                                        n18 = n5 + 2 * n20;
                                        n17 = n5 + 2 * DoubleFFT_3D.this.slices + 2 * n20;
                                        n16 = n17 + 2 * DoubleFFT_3D.this.slices;
                                        n15 = n16 + 2 * DoubleFFT_3D.this.slices;
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n18] = dArray[n19];
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n18 + 1] = dArray[n19 + 1];
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n17] = dArray[n19 + 2];
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n17 + 1] = dArray[n19 + 3];
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n16] = dArray[n19 + 4];
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n16 + 1] = dArray[n19 + 5];
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n15] = dArray[n19 + 6];
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n15 + 1] = dArray[n19 + 7];
                                    }
                                    DoubleFFT_3D.this.fftSlices.complexInverse(DoubleFFT_3D.this.t, n5, bl);
                                    DoubleFFT_3D.this.fftSlices.complexInverse(DoubleFFT_3D.this.t, n5 + 2 * DoubleFFT_3D.this.slices, bl);
                                    DoubleFFT_3D.this.fftSlices.complexInverse(DoubleFFT_3D.this.t, n5 + 4 * DoubleFFT_3D.this.slices, bl);
                                    DoubleFFT_3D.this.fftSlices.complexInverse(DoubleFFT_3D.this.t, n5 + 6 * DoubleFFT_3D.this.slices, bl);
                                    for (n20 = 0; n20 < DoubleFFT_3D.this.slices; ++n20) {
                                        n19 = n20 * DoubleFFT_3D.this.sliceStride + n32 + j;
                                        n18 = n5 + 2 * n20;
                                        n17 = n5 + 2 * DoubleFFT_3D.this.slices + 2 * n20;
                                        n16 = n17 + 2 * DoubleFFT_3D.this.slices;
                                        n15 = n16 + 2 * DoubleFFT_3D.this.slices;
                                        dArray[n19] = DoubleFFT_3D.this.t[n18];
                                        dArray[n19 + 1] = DoubleFFT_3D.this.t[n18 + 1];
                                        dArray[n19 + 2] = DoubleFFT_3D.this.t[n17];
                                        dArray[n19 + 3] = DoubleFFT_3D.this.t[n17 + 1];
                                        dArray[n19 + 4] = DoubleFFT_3D.this.t[n16];
                                        dArray[n19 + 5] = DoubleFFT_3D.this.t[n16 + 1];
                                        dArray[n19 + 6] = DoubleFFT_3D.this.t[n15];
                                        dArray[n19 + 7] = DoubleFFT_3D.this.t[n15 + 1];
                                    }
                                }
                            }
                        } else if (DoubleFFT_3D.this.columns == 4) {
                            for (int i = n4; i < DoubleFFT_3D.this.rows; i += n2) {
                                int n33;
                                int n21;
                                int n22;
                                int n23;
                                int n24 = i * DoubleFFT_3D.this.rowStride;
                                for (n23 = 0; n23 < DoubleFFT_3D.this.slices; ++n23) {
                                    n22 = n23 * DoubleFFT_3D.this.sliceStride + n24;
                                    n21 = n5 + 2 * n23;
                                    n33 = n5 + 2 * DoubleFFT_3D.this.slices + 2 * n23;
                                    ((DoubleFFT_3D)DoubleFFT_3D.this).t[n21] = dArray[n22];
                                    ((DoubleFFT_3D)DoubleFFT_3D.this).t[n21 + 1] = dArray[n22 + 1];
                                    ((DoubleFFT_3D)DoubleFFT_3D.this).t[n33] = dArray[n22 + 2];
                                    ((DoubleFFT_3D)DoubleFFT_3D.this).t[n33 + 1] = dArray[n22 + 3];
                                }
                                DoubleFFT_3D.this.fftSlices.complexInverse(DoubleFFT_3D.this.t, n5, bl);
                                DoubleFFT_3D.this.fftSlices.complexInverse(DoubleFFT_3D.this.t, n5 + 2 * DoubleFFT_3D.this.slices, bl);
                                for (n23 = 0; n23 < DoubleFFT_3D.this.slices; ++n23) {
                                    n22 = n23 * DoubleFFT_3D.this.sliceStride + n24;
                                    n21 = n5 + 2 * n23;
                                    n33 = n5 + 2 * DoubleFFT_3D.this.slices + 2 * n23;
                                    dArray[n22] = DoubleFFT_3D.this.t[n21];
                                    dArray[n22 + 1] = DoubleFFT_3D.this.t[n21 + 1];
                                    dArray[n22 + 2] = DoubleFFT_3D.this.t[n33];
                                    dArray[n22 + 3] = DoubleFFT_3D.this.t[n33 + 1];
                                }
                            }
                        } else if (DoubleFFT_3D.this.columns == 2) {
                            for (int i = n4; i < DoubleFFT_3D.this.rows; i += n2) {
                                int n34;
                                int n25;
                                int n26;
                                int n27 = i * DoubleFFT_3D.this.rowStride;
                                for (n26 = 0; n26 < DoubleFFT_3D.this.slices; ++n26) {
                                    n25 = n26 * DoubleFFT_3D.this.sliceStride + n27;
                                    n34 = n5 + 2 * n26;
                                    ((DoubleFFT_3D)DoubleFFT_3D.this).t[n34] = dArray[n25];
                                    ((DoubleFFT_3D)DoubleFFT_3D.this).t[n34 + 1] = dArray[n25 + 1];
                                }
                                DoubleFFT_3D.this.fftSlices.complexInverse(DoubleFFT_3D.this.t, n5, bl);
                                for (n26 = 0; n26 < DoubleFFT_3D.this.slices; ++n26) {
                                    n25 = n26 * DoubleFFT_3D.this.sliceStride + n27;
                                    n34 = n5 + 2 * n26;
                                    dArray[n25] = DoubleFFT_3D.this.t[n34];
                                    dArray[n25 + 1] = DoubleFFT_3D.this.t[n34 + 1];
                                }
                            }
                        }
                    }
                }
            });
        }
        ConcurrencyUtils.waitForCompletion(futureArray);
    }

    private void cdft3db_subth(final int n, final double[][][] dArray, final boolean bl) {
        final int n2 = Math.min(ConcurrencyUtils.getNumberOfThreads(), this.rows);
        int n3 = 8 * this.slices;
        if (this.columns == 4) {
            n3 >>= 1;
        } else if (this.columns < 4) {
            n3 >>= 2;
        }
        Future[] futureArray = new Future[n2];
        for (int i = 0; i < n2; ++i) {
            final int n4 = i;
            final int n5 = n3 * i;
            futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                public void run() {
                    block27: {
                        block25: {
                            block28: {
                                block26: {
                                    if (n != -1) break block25;
                                    if (DoubleFFT_3D.this.columns <= 4) break block26;
                                    for (int i = n4; i < DoubleFFT_3D.this.rows; i += n2) {
                                        for (int j = 0; j < DoubleFFT_3D.this.columns; j += 8) {
                                            int n16;
                                            int n22;
                                            int n3;
                                            int n42;
                                            int n52;
                                            for (n52 = 0; n52 < DoubleFFT_3D.this.slices; ++n52) {
                                                n42 = n5 + 2 * n52;
                                                n3 = n5 + 2 * DoubleFFT_3D.this.slices + 2 * n52;
                                                n22 = n3 + 2 * DoubleFFT_3D.this.slices;
                                                n16 = n22 + 2 * DoubleFFT_3D.this.slices;
                                                ((DoubleFFT_3D)DoubleFFT_3D.this).t[n42] = dArray[n52][i][j];
                                                ((DoubleFFT_3D)DoubleFFT_3D.this).t[n42 + 1] = dArray[n52][i][j + 1];
                                                ((DoubleFFT_3D)DoubleFFT_3D.this).t[n3] = dArray[n52][i][j + 2];
                                                ((DoubleFFT_3D)DoubleFFT_3D.this).t[n3 + 1] = dArray[n52][i][j + 3];
                                                ((DoubleFFT_3D)DoubleFFT_3D.this).t[n22] = dArray[n52][i][j + 4];
                                                ((DoubleFFT_3D)DoubleFFT_3D.this).t[n22 + 1] = dArray[n52][i][j + 5];
                                                ((DoubleFFT_3D)DoubleFFT_3D.this).t[n16] = dArray[n52][i][j + 6];
                                                ((DoubleFFT_3D)DoubleFFT_3D.this).t[n16 + 1] = dArray[n52][i][j + 7];
                                            }
                                            DoubleFFT_3D.this.fftSlices.complexForward(DoubleFFT_3D.this.t, n5);
                                            DoubleFFT_3D.this.fftSlices.complexForward(DoubleFFT_3D.this.t, n5 + 2 * DoubleFFT_3D.this.slices);
                                            DoubleFFT_3D.this.fftSlices.complexForward(DoubleFFT_3D.this.t, n5 + 4 * DoubleFFT_3D.this.slices);
                                            DoubleFFT_3D.this.fftSlices.complexForward(DoubleFFT_3D.this.t, n5 + 6 * DoubleFFT_3D.this.slices);
                                            for (n52 = 0; n52 < DoubleFFT_3D.this.slices; ++n52) {
                                                n42 = n5 + 2 * n52;
                                                n3 = n5 + 2 * DoubleFFT_3D.this.slices + 2 * n52;
                                                n22 = n3 + 2 * DoubleFFT_3D.this.slices;
                                                n16 = n22 + 2 * DoubleFFT_3D.this.slices;
                                                dArray[n52][i][j] = DoubleFFT_3D.this.t[n42];
                                                dArray[n52][i][j + 1] = DoubleFFT_3D.this.t[n42 + 1];
                                                dArray[n52][i][j + 2] = DoubleFFT_3D.this.t[n3];
                                                dArray[n52][i][j + 3] = DoubleFFT_3D.this.t[n3 + 1];
                                                dArray[n52][i][j + 4] = DoubleFFT_3D.this.t[n22];
                                                dArray[n52][i][j + 5] = DoubleFFT_3D.this.t[n22 + 1];
                                                dArray[n52][i][j + 6] = DoubleFFT_3D.this.t[n16];
                                                dArray[n52][i][j + 7] = DoubleFFT_3D.this.t[n16 + 1];
                                            }
                                        }
                                    }
                                    break block27;
                                }
                                if (DoubleFFT_3D.this.columns != 4) break block28;
                                for (int i = n4; i < DoubleFFT_3D.this.rows; i += n2) {
                                    int n17;
                                    int n6;
                                    int n7;
                                    for (n7 = 0; n7 < DoubleFFT_3D.this.slices; ++n7) {
                                        n6 = n5 + 2 * n7;
                                        n17 = n5 + 2 * DoubleFFT_3D.this.slices + 2 * n7;
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n6] = dArray[n7][i][0];
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n6 + 1] = dArray[n7][i][1];
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n17] = dArray[n7][i][2];
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n17 + 1] = dArray[n7][i][3];
                                    }
                                    DoubleFFT_3D.this.fftSlices.complexForward(DoubleFFT_3D.this.t, n5);
                                    DoubleFFT_3D.this.fftSlices.complexForward(DoubleFFT_3D.this.t, n5 + 2 * DoubleFFT_3D.this.slices);
                                    for (n7 = 0; n7 < DoubleFFT_3D.this.slices; ++n7) {
                                        n6 = n5 + 2 * n7;
                                        n17 = n5 + 2 * DoubleFFT_3D.this.slices + 2 * n7;
                                        dArray[n7][i][0] = DoubleFFT_3D.this.t[n6];
                                        dArray[n7][i][1] = DoubleFFT_3D.this.t[n6 + 1];
                                        dArray[n7][i][2] = DoubleFFT_3D.this.t[n17];
                                        dArray[n7][i][3] = DoubleFFT_3D.this.t[n17 + 1];
                                    }
                                }
                                break block27;
                            }
                            if (DoubleFFT_3D.this.columns != 2) break block27;
                            for (int i = n4; i < DoubleFFT_3D.this.rows; i += n2) {
                                int n18;
                                int n8;
                                for (n8 = 0; n8 < DoubleFFT_3D.this.slices; ++n8) {
                                    n18 = n5 + 2 * n8;
                                    ((DoubleFFT_3D)DoubleFFT_3D.this).t[n18] = dArray[n8][i][0];
                                    ((DoubleFFT_3D)DoubleFFT_3D.this).t[n18 + 1] = dArray[n8][i][1];
                                }
                                DoubleFFT_3D.this.fftSlices.complexForward(DoubleFFT_3D.this.t, n5);
                                for (n8 = 0; n8 < DoubleFFT_3D.this.slices; ++n8) {
                                    n18 = n5 + 2 * n8;
                                    dArray[n8][i][0] = DoubleFFT_3D.this.t[n18];
                                    dArray[n8][i][1] = DoubleFFT_3D.this.t[n18 + 1];
                                }
                            }
                            break block27;
                        }
                        if (DoubleFFT_3D.this.columns > 4) {
                            for (int i = n4; i < DoubleFFT_3D.this.rows; i += n2) {
                                for (int j = 0; j < DoubleFFT_3D.this.columns; j += 8) {
                                    int n19;
                                    int n9;
                                    int n10;
                                    int n11;
                                    int n12;
                                    for (n12 = 0; n12 < DoubleFFT_3D.this.slices; ++n12) {
                                        n11 = n5 + 2 * n12;
                                        n10 = n5 + 2 * DoubleFFT_3D.this.slices + 2 * n12;
                                        n9 = n10 + 2 * DoubleFFT_3D.this.slices;
                                        n19 = n9 + 2 * DoubleFFT_3D.this.slices;
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n11] = dArray[n12][i][j];
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n11 + 1] = dArray[n12][i][j + 1];
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n10] = dArray[n12][i][j + 2];
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n10 + 1] = dArray[n12][i][j + 3];
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n9] = dArray[n12][i][j + 4];
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n9 + 1] = dArray[n12][i][j + 5];
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n19] = dArray[n12][i][j + 6];
                                        ((DoubleFFT_3D)DoubleFFT_3D.this).t[n19 + 1] = dArray[n12][i][j + 7];
                                    }
                                    DoubleFFT_3D.this.fftSlices.complexInverse(DoubleFFT_3D.this.t, n5, bl);
                                    DoubleFFT_3D.this.fftSlices.complexInverse(DoubleFFT_3D.this.t, n5 + 2 * DoubleFFT_3D.this.slices, bl);
                                    DoubleFFT_3D.this.fftSlices.complexInverse(DoubleFFT_3D.this.t, n5 + 4 * DoubleFFT_3D.this.slices, bl);
                                    DoubleFFT_3D.this.fftSlices.complexInverse(DoubleFFT_3D.this.t, n5 + 6 * DoubleFFT_3D.this.slices, bl);
                                    for (n12 = 0; n12 < DoubleFFT_3D.this.slices; ++n12) {
                                        n11 = n5 + 2 * n12;
                                        n10 = n5 + 2 * DoubleFFT_3D.this.slices + 2 * n12;
                                        n9 = n10 + 2 * DoubleFFT_3D.this.slices;
                                        n19 = n9 + 2 * DoubleFFT_3D.this.slices;
                                        dArray[n12][i][j] = DoubleFFT_3D.this.t[n11];
                                        dArray[n12][i][j + 1] = DoubleFFT_3D.this.t[n11 + 1];
                                        dArray[n12][i][j + 2] = DoubleFFT_3D.this.t[n10];
                                        dArray[n12][i][j + 3] = DoubleFFT_3D.this.t[n10 + 1];
                                        dArray[n12][i][j + 4] = DoubleFFT_3D.this.t[n9];
                                        dArray[n12][i][j + 5] = DoubleFFT_3D.this.t[n9 + 1];
                                        dArray[n12][i][j + 6] = DoubleFFT_3D.this.t[n19];
                                        dArray[n12][i][j + 7] = DoubleFFT_3D.this.t[n19 + 1];
                                    }
                                }
                            }
                        } else if (DoubleFFT_3D.this.columns == 4) {
                            for (int i = n4; i < DoubleFFT_3D.this.rows; i += n2) {
                                int n20;
                                int n13;
                                int n14;
                                for (n14 = 0; n14 < DoubleFFT_3D.this.slices; ++n14) {
                                    n13 = n5 + 2 * n14;
                                    n20 = n5 + 2 * DoubleFFT_3D.this.slices + 2 * n14;
                                    ((DoubleFFT_3D)DoubleFFT_3D.this).t[n13] = dArray[n14][i][0];
                                    ((DoubleFFT_3D)DoubleFFT_3D.this).t[n13 + 1] = dArray[n14][i][1];
                                    ((DoubleFFT_3D)DoubleFFT_3D.this).t[n20] = dArray[n14][i][2];
                                    ((DoubleFFT_3D)DoubleFFT_3D.this).t[n20 + 1] = dArray[n14][i][3];
                                }
                                DoubleFFT_3D.this.fftSlices.complexInverse(DoubleFFT_3D.this.t, n5, bl);
                                DoubleFFT_3D.this.fftSlices.complexInverse(DoubleFFT_3D.this.t, n5 + 2 * DoubleFFT_3D.this.slices, bl);
                                for (n14 = 0; n14 < DoubleFFT_3D.this.slices; ++n14) {
                                    n13 = n5 + 2 * n14;
                                    n20 = n5 + 2 * DoubleFFT_3D.this.slices + 2 * n14;
                                    dArray[n14][i][0] = DoubleFFT_3D.this.t[n13];
                                    dArray[n14][i][1] = DoubleFFT_3D.this.t[n13 + 1];
                                    dArray[n14][i][2] = DoubleFFT_3D.this.t[n20];
                                    dArray[n14][i][3] = DoubleFFT_3D.this.t[n20 + 1];
                                }
                            }
                        } else if (DoubleFFT_3D.this.columns == 2) {
                            for (int i = n4; i < DoubleFFT_3D.this.rows; i += n2) {
                                int n21;
                                int n15;
                                for (n15 = 0; n15 < DoubleFFT_3D.this.slices; ++n15) {
                                    n21 = n5 + 2 * n15;
                                    ((DoubleFFT_3D)DoubleFFT_3D.this).t[n21] = dArray[n15][i][0];
                                    ((DoubleFFT_3D)DoubleFFT_3D.this).t[n21 + 1] = dArray[n15][i][1];
                                }
                                DoubleFFT_3D.this.fftSlices.complexInverse(DoubleFFT_3D.this.t, n5, bl);
                                for (n15 = 0; n15 < DoubleFFT_3D.this.slices; ++n15) {
                                    n21 = n5 + 2 * n15;
                                    dArray[n15][i][0] = DoubleFFT_3D.this.t[n21];
                                    dArray[n15][i][1] = DoubleFFT_3D.this.t[n21 + 1];
                                }
                            }
                        }
                    }
                }
            });
        }
        ConcurrencyUtils.waitForCompletion(futureArray);
    }

    private void rdft3d_sub(int n, double[] dArray) {
        int n2 = this.slices >> 1;
        int n3 = this.rows >> 1;
        if (n < 0) {
            int n4;
            int n5;
            double d;
            int n6;
            int n7;
            int n8;
            int n9;
            for (int i = 1; i < n2; ++i) {
                int n10 = this.slices - i;
                n9 = i * this.sliceStride;
                n8 = n10 * this.sliceStride;
                n7 = i * this.sliceStride + n3 * this.rowStride;
                n6 = n10 * this.sliceStride + n3 * this.rowStride;
                d = dArray[n9] - dArray[n8];
                int n11 = n9;
                dArray[n11] = dArray[n11] + dArray[n8];
                dArray[n8] = d;
                d = dArray[n8 + 1] - dArray[n9 + 1];
                int n12 = n9 + 1;
                dArray[n12] = dArray[n12] + dArray[n8 + 1];
                dArray[n8 + 1] = d;
                d = dArray[n7] - dArray[n6];
                int n13 = n7;
                dArray[n13] = dArray[n13] + dArray[n6];
                dArray[n6] = d;
                d = dArray[n6 + 1] - dArray[n7 + 1];
                int n14 = n7 + 1;
                dArray[n14] = dArray[n14] + dArray[n6 + 1];
                dArray[n6 + 1] = d;
                for (n5 = 1; n5 < n3; ++n5) {
                    n4 = this.rows - n5;
                    n9 = i * this.sliceStride + n5 * this.rowStride;
                    n8 = n10 * this.sliceStride + n4 * this.rowStride;
                    d = dArray[n9] - dArray[n8];
                    int n15 = n9;
                    dArray[n15] = dArray[n15] + dArray[n8];
                    dArray[n8] = d;
                    d = dArray[n8 + 1] - dArray[n9 + 1];
                    int n16 = n9 + 1;
                    dArray[n16] = dArray[n16] + dArray[n8 + 1];
                    dArray[n8 + 1] = d;
                    n7 = n10 * this.sliceStride + n5 * this.rowStride;
                    n6 = i * this.sliceStride + n4 * this.rowStride;
                    d = dArray[n7] - dArray[n6];
                    int n17 = n7;
                    dArray[n17] = dArray[n17] + dArray[n6];
                    dArray[n6] = d;
                    d = dArray[n6 + 1] - dArray[n7 + 1];
                    int n18 = n7 + 1;
                    dArray[n18] = dArray[n18] + dArray[n6 + 1];
                    dArray[n6 + 1] = d;
                }
            }
            for (n5 = 1; n5 < n3; ++n5) {
                n4 = this.rows - n5;
                n9 = n5 * this.rowStride;
                n8 = n4 * this.rowStride;
                d = dArray[n9] - dArray[n8];
                int n19 = n9;
                dArray[n19] = dArray[n19] + dArray[n8];
                dArray[n8] = d;
                d = dArray[n8 + 1] - dArray[n9 + 1];
                int n20 = n9 + 1;
                dArray[n20] = dArray[n20] + dArray[n8 + 1];
                dArray[n8 + 1] = d;
                n7 = n2 * this.sliceStride + n5 * this.rowStride;
                n6 = n2 * this.sliceStride + n4 * this.rowStride;
                d = dArray[n7] - dArray[n6];
                int n21 = n7;
                dArray[n21] = dArray[n21] + dArray[n6];
                dArray[n6] = d;
                d = dArray[n6 + 1] - dArray[n7 + 1];
                int n22 = n7 + 1;
                dArray[n22] = dArray[n22] + dArray[n6 + 1];
                dArray[n6 + 1] = d;
            }
        } else {
            int n23;
            int n24;
            int n25;
            int n26;
            int n27;
            int n28;
            for (int i = 1; i < n2; ++i) {
                int n29 = this.slices - i;
                n28 = n29 * this.sliceStride;
                n27 = i * this.sliceStride;
                dArray[n28] = 0.5 * (dArray[n27] - dArray[n28]);
                int n30 = n27;
                dArray[n30] = dArray[n30] - dArray[n28];
                dArray[n28 + 1] = 0.5 * (dArray[n27 + 1] + dArray[n28 + 1]);
                int n31 = n27 + 1;
                dArray[n31] = dArray[n31] - dArray[n28 + 1];
                n26 = n29 * this.sliceStride + n3 * this.rowStride;
                n25 = i * this.sliceStride + n3 * this.rowStride;
                dArray[n26] = 0.5 * (dArray[n25] - dArray[n26]);
                int n32 = n25;
                dArray[n32] = dArray[n32] - dArray[n26];
                dArray[n26 + 1] = 0.5 * (dArray[n25 + 1] + dArray[n26 + 1]);
                int n33 = n25 + 1;
                dArray[n33] = dArray[n33] - dArray[n26 + 1];
                for (n24 = 1; n24 < n3; ++n24) {
                    n23 = this.rows - n24;
                    n28 = n29 * this.sliceStride + n23 * this.rowStride;
                    n27 = i * this.sliceStride + n24 * this.rowStride;
                    dArray[n28] = 0.5 * (dArray[n27] - dArray[n28]);
                    int n34 = n27;
                    dArray[n34] = dArray[n34] - dArray[n28];
                    dArray[n28 + 1] = 0.5 * (dArray[n27 + 1] + dArray[n28 + 1]);
                    int n35 = n27 + 1;
                    dArray[n35] = dArray[n35] - dArray[n28 + 1];
                    n26 = i * this.sliceStride + n23 * this.rowStride;
                    n25 = n29 * this.sliceStride + n24 * this.rowStride;
                    dArray[n26] = 0.5 * (dArray[n25] - dArray[n26]);
                    int n36 = n25;
                    dArray[n36] = dArray[n36] - dArray[n26];
                    dArray[n26 + 1] = 0.5 * (dArray[n25 + 1] + dArray[n26 + 1]);
                    int n37 = n25 + 1;
                    dArray[n37] = dArray[n37] - dArray[n26 + 1];
                }
            }
            for (n24 = 1; n24 < n3; ++n24) {
                n23 = this.rows - n24;
                n28 = n23 * this.rowStride;
                n27 = n24 * this.rowStride;
                dArray[n28] = 0.5 * (dArray[n27] - dArray[n28]);
                int n38 = n27;
                dArray[n38] = dArray[n38] - dArray[n28];
                dArray[n28 + 1] = 0.5 * (dArray[n27 + 1] + dArray[n28 + 1]);
                int n39 = n27 + 1;
                dArray[n39] = dArray[n39] - dArray[n28 + 1];
                n26 = n2 * this.sliceStride + n23 * this.rowStride;
                n25 = n2 * this.sliceStride + n24 * this.rowStride;
                dArray[n26] = 0.5 * (dArray[n25] - dArray[n26]);
                int n40 = n25;
                dArray[n40] = dArray[n40] - dArray[n26];
                dArray[n26 + 1] = 0.5 * (dArray[n25 + 1] + dArray[n26 + 1]);
                int n41 = n25 + 1;
                dArray[n41] = dArray[n41] - dArray[n26 + 1];
            }
        }
    }

    private void rdft3d_sub(int n, double[][][] dArray) {
        int n2 = this.slices >> 1;
        int n3 = this.rows >> 1;
        if (n < 0) {
            int n4;
            int n5;
            double d;
            for (int i = 1; i < n2; ++i) {
                int n6 = this.slices - i;
                d = dArray[i][0][0] - dArray[n6][0][0];
                double[] dArray2 = dArray[i][0];
                dArray2[0] = dArray2[0] + dArray[n6][0][0];
                dArray[n6][0][0] = d;
                d = dArray[n6][0][1] - dArray[i][0][1];
                double[] dArray3 = dArray[i][0];
                dArray3[1] = dArray3[1] + dArray[n6][0][1];
                dArray[n6][0][1] = d;
                d = dArray[i][n3][0] - dArray[n6][n3][0];
                double[] dArray4 = dArray[i][n3];
                dArray4[0] = dArray4[0] + dArray[n6][n3][0];
                dArray[n6][n3][0] = d;
                d = dArray[n6][n3][1] - dArray[i][n3][1];
                double[] dArray5 = dArray[i][n3];
                dArray5[1] = dArray5[1] + dArray[n6][n3][1];
                dArray[n6][n3][1] = d;
                for (n5 = 1; n5 < n3; ++n5) {
                    n4 = this.rows - n5;
                    d = dArray[i][n5][0] - dArray[n6][n4][0];
                    double[] dArray6 = dArray[i][n5];
                    dArray6[0] = dArray6[0] + dArray[n6][n4][0];
                    dArray[n6][n4][0] = d;
                    d = dArray[n6][n4][1] - dArray[i][n5][1];
                    double[] dArray7 = dArray[i][n5];
                    dArray7[1] = dArray7[1] + dArray[n6][n4][1];
                    dArray[n6][n4][1] = d;
                    d = dArray[n6][n5][0] - dArray[i][n4][0];
                    double[] dArray8 = dArray[n6][n5];
                    dArray8[0] = dArray8[0] + dArray[i][n4][0];
                    dArray[i][n4][0] = d;
                    d = dArray[i][n4][1] - dArray[n6][n5][1];
                    double[] dArray9 = dArray[n6][n5];
                    dArray9[1] = dArray9[1] + dArray[i][n4][1];
                    dArray[i][n4][1] = d;
                }
            }
            for (n5 = 1; n5 < n3; ++n5) {
                n4 = this.rows - n5;
                d = dArray[0][n5][0] - dArray[0][n4][0];
                double[] dArray10 = dArray[0][n5];
                dArray10[0] = dArray10[0] + dArray[0][n4][0];
                dArray[0][n4][0] = d;
                d = dArray[0][n4][1] - dArray[0][n5][1];
                double[] dArray11 = dArray[0][n5];
                dArray11[1] = dArray11[1] + dArray[0][n4][1];
                dArray[0][n4][1] = d;
                d = dArray[n2][n5][0] - dArray[n2][n4][0];
                double[] dArray12 = dArray[n2][n5];
                dArray12[0] = dArray12[0] + dArray[n2][n4][0];
                dArray[n2][n4][0] = d;
                d = dArray[n2][n4][1] - dArray[n2][n5][1];
                double[] dArray13 = dArray[n2][n5];
                dArray13[1] = dArray13[1] + dArray[n2][n4][1];
                dArray[n2][n4][1] = d;
            }
        } else {
            int n7;
            int n8;
            for (int i = 1; i < n2; ++i) {
                int n9 = this.slices - i;
                dArray[n9][0][0] = 0.5 * (dArray[i][0][0] - dArray[n9][0][0]);
                double[] dArray14 = dArray[i][0];
                dArray14[0] = dArray14[0] - dArray[n9][0][0];
                dArray[n9][0][1] = 0.5 * (dArray[i][0][1] + dArray[n9][0][1]);
                double[] dArray15 = dArray[i][0];
                dArray15[1] = dArray15[1] - dArray[n9][0][1];
                dArray[n9][n3][0] = 0.5 * (dArray[i][n3][0] - dArray[n9][n3][0]);
                double[] dArray16 = dArray[i][n3];
                dArray16[0] = dArray16[0] - dArray[n9][n3][0];
                dArray[n9][n3][1] = 0.5 * (dArray[i][n3][1] + dArray[n9][n3][1]);
                double[] dArray17 = dArray[i][n3];
                dArray17[1] = dArray17[1] - dArray[n9][n3][1];
                for (n8 = 1; n8 < n3; ++n8) {
                    n7 = this.rows - n8;
                    dArray[n9][n7][0] = 0.5 * (dArray[i][n8][0] - dArray[n9][n7][0]);
                    double[] dArray18 = dArray[i][n8];
                    dArray18[0] = dArray18[0] - dArray[n9][n7][0];
                    dArray[n9][n7][1] = 0.5 * (dArray[i][n8][1] + dArray[n9][n7][1]);
                    double[] dArray19 = dArray[i][n8];
                    dArray19[1] = dArray19[1] - dArray[n9][n7][1];
                    dArray[i][n7][0] = 0.5 * (dArray[n9][n8][0] - dArray[i][n7][0]);
                    double[] dArray20 = dArray[n9][n8];
                    dArray20[0] = dArray20[0] - dArray[i][n7][0];
                    dArray[i][n7][1] = 0.5 * (dArray[n9][n8][1] + dArray[i][n7][1]);
                    double[] dArray21 = dArray[n9][n8];
                    dArray21[1] = dArray21[1] - dArray[i][n7][1];
                }
            }
            for (n8 = 1; n8 < n3; ++n8) {
                n7 = this.rows - n8;
                dArray[0][n7][0] = 0.5 * (dArray[0][n8][0] - dArray[0][n7][0]);
                double[] dArray22 = dArray[0][n8];
                dArray22[0] = dArray22[0] - dArray[0][n7][0];
                dArray[0][n7][1] = 0.5 * (dArray[0][n8][1] + dArray[0][n7][1]);
                double[] dArray23 = dArray[0][n8];
                dArray23[1] = dArray23[1] - dArray[0][n7][1];
                dArray[n2][n7][0] = 0.5 * (dArray[n2][n8][0] - dArray[n2][n7][0]);
                double[] dArray24 = dArray[n2][n8];
                dArray24[0] = dArray24[0] - dArray[n2][n7][0];
                dArray[n2][n7][1] = 0.5 * (dArray[n2][n8][1] + dArray[n2][n7][1]);
                double[] dArray25 = dArray[n2][n8];
                dArray25[1] = dArray25[1] - dArray[n2][n7][1];
            }
        }
    }

    private void fillSymmetric(final double[][][] dArray) {
        int n;
        int n2;
        int n3;
        int n4;
        final int n5 = 2 * this.columns;
        final int n6 = this.rows / 2;
        int n7 = this.slices / 2;
        int n8 = ConcurrencyUtils.getNumberOfThreads();
        if (n8 > 1 && this.useThreads && this.slices >= n8) {
            Future[] futureArray = new Future[n8];
            n4 = this.slices / n8;
            for (n3 = 0; n3 < n8; ++n3) {
                n2 = n3 * n4;
                n = n3 == n8 - 1 ? this.slices : n2 + n4;
                futureArray[n3] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n2; i < n; ++i) {
                            int n4 = (DoubleFFT_3D.this.slices - i) % DoubleFFT_3D.this.slices;
                            for (int j = 0; j < DoubleFFT_3D.this.rows; ++j) {
                                int n22 = (DoubleFFT_3D.this.rows - j) % DoubleFFT_3D.this.rows;
                                for (int k = 1; k < DoubleFFT_3D.this.columns; k += 2) {
                                    int n3 = n5 - k;
                                    dArray[n4][n22][n3] = -dArray[i][j][k + 2];
                                    dArray[n4][n22][n3 - 1] = dArray[i][j][k + 1];
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            for (n3 = 0; n3 < n8; ++n3) {
                n2 = n3 * n4;
                n = n3 == n8 - 1 ? this.slices : n2 + n4;
                futureArray[n3] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n2; i < n; ++i) {
                            int n3 = (DoubleFFT_3D.this.slices - i) % DoubleFFT_3D.this.slices;
                            for (int j = 1; j < n6; ++j) {
                                int n22 = DoubleFFT_3D.this.rows - j;
                                dArray[n3][j][((DoubleFFT_3D)DoubleFFT_3D.this).columns] = dArray[i][n22][1];
                                dArray[i][n22][((DoubleFFT_3D)DoubleFFT_3D.this).columns] = dArray[i][n22][1];
                                dArray[n3][j][((DoubleFFT_3D)DoubleFFT_3D.this).columns + 1] = -dArray[i][n22][0];
                                dArray[i][n22][((DoubleFFT_3D)DoubleFFT_3D.this).columns + 1] = dArray[i][n22][0];
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            for (n3 = 0; n3 < n8; ++n3) {
                n2 = n3 * n4;
                n = n3 == n8 - 1 ? this.slices : n2 + n4;
                futureArray[n3] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n2; i < n; ++i) {
                            int n3 = (DoubleFFT_3D.this.slices - i) % DoubleFFT_3D.this.slices;
                            for (int j = 1; j < n6; ++j) {
                                int n22 = DoubleFFT_3D.this.rows - j;
                                dArray[n3][n22][0] = dArray[i][j][0];
                                dArray[n3][n22][1] = -dArray[i][j][1];
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n9;
            for (n9 = 0; n9 < this.slices; ++n9) {
                n4 = (this.slices - n9) % this.slices;
                for (n3 = 0; n3 < this.rows; ++n3) {
                    n2 = (this.rows - n3) % this.rows;
                    for (n = 1; n < this.columns; n += 2) {
                        int n10 = n5 - n;
                        dArray[n4][n2][n10] = -dArray[n9][n3][n + 2];
                        dArray[n4][n2][n10 - 1] = dArray[n9][n3][n + 1];
                    }
                }
            }
            for (n9 = 0; n9 < this.slices; ++n9) {
                n4 = (this.slices - n9) % this.slices;
                for (n3 = 1; n3 < n6; ++n3) {
                    n2 = this.rows - n3;
                    dArray[n4][n3][this.columns] = dArray[n9][n2][1];
                    dArray[n9][n2][this.columns] = dArray[n9][n2][1];
                    dArray[n4][n3][this.columns + 1] = -dArray[n9][n2][0];
                    dArray[n9][n2][this.columns + 1] = dArray[n9][n2][0];
                }
            }
            for (n9 = 0; n9 < this.slices; ++n9) {
                n4 = (this.slices - n9) % this.slices;
                for (n3 = 1; n3 < n6; ++n3) {
                    n2 = this.rows - n3;
                    dArray[n4][n2][0] = dArray[n9][n3][0];
                    dArray[n4][n2][1] = -dArray[n9][n3][1];
                }
            }
        }
        for (int i = 1; i < n7; ++i) {
            n4 = this.slices - i;
            dArray[i][0][this.columns] = dArray[n4][0][1];
            dArray[n4][0][this.columns] = dArray[n4][0][1];
            dArray[i][0][this.columns + 1] = -dArray[n4][0][0];
            dArray[n4][0][this.columns + 1] = dArray[n4][0][0];
            dArray[i][n6][this.columns] = dArray[n4][n6][1];
            dArray[n4][n6][this.columns] = dArray[n4][n6][1];
            dArray[i][n6][this.columns + 1] = -dArray[n4][n6][0];
            dArray[n4][n6][this.columns + 1] = dArray[n4][n6][0];
            dArray[n4][0][0] = dArray[i][0][0];
            dArray[n4][0][1] = -dArray[i][0][1];
            dArray[n4][n6][0] = dArray[i][n6][0];
            dArray[n4][n6][1] = -dArray[i][n6][1];
        }
        dArray[0][0][this.columns] = dArray[0][0][1];
        dArray[0][0][1] = 0.0;
        dArray[0][n6][this.columns] = dArray[0][n6][1];
        dArray[0][n6][1] = 0.0;
        dArray[n7][0][this.columns] = dArray[n7][0][1];
        dArray[n7][0][1] = 0.0;
        dArray[n7][n6][this.columns] = dArray[n7][n6][1];
        dArray[n7][n6][1] = 0.0;
        dArray[n7][0][this.columns + 1] = 0.0;
        dArray[n7][n6][this.columns + 1] = 0.0;
    }

    private void fillSymmetric(final double[] dArray) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        final int n11 = 2 * this.columns;
        final int n12 = this.rows / 2;
        int n13 = this.slices / 2;
        final int n14 = this.rows * n11;
        final int n15 = n11;
        for (n10 = this.slices - 1; n10 >= 1; --n10) {
            n9 = n10 * this.sliceStride;
            n8 = 2 * n9;
            for (n7 = 0; n7 < this.rows; ++n7) {
                n6 = n7 * this.rowStride;
                n5 = 2 * n6;
                for (n4 = 0; n4 < this.columns; n4 += 2) {
                    n3 = n9 + n6 + n4;
                    n2 = n8 + n5 + n4;
                    dArray[n2] = dArray[n3];
                    dArray[n3] = 0.0;
                    dArray[++n2] = dArray[++n3];
                    dArray[n3] = 0.0;
                }
            }
        }
        for (n10 = 1; n10 < this.rows; ++n10) {
            n9 = (this.rows - n10) * this.rowStride;
            n8 = (this.rows - n10) * n15;
            for (n7 = 0; n7 < this.columns; n7 += 2) {
                n3 = n9 + n7;
                n2 = n8 + n7;
                dArray[n2] = dArray[n3];
                dArray[n3] = 0.0;
                dArray[++n2] = dArray[++n3];
                dArray[n3] = 0.0;
            }
        }
        n10 = ConcurrencyUtils.getNumberOfThreads();
        if (n10 > 1 && this.useThreads && this.slices >= n10) {
            int n16;
            int n17;
            Future[] futureArray = new Future[n10];
            n4 = this.slices / n10;
            for (n = 0; n < n10; ++n) {
                n17 = n * n4;
                n16 = n == n10 - 1 ? this.slices : n17 + n4;
                futureArray[n] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n17; i < n16; ++i) {
                            int n = (DoubleFFT_3D.this.slices - i) % DoubleFFT_3D.this.slices * n14;
                            int n2 = i * n14;
                            for (int j = 0; j < DoubleFFT_3D.this.rows; ++j) {
                                int n3 = (DoubleFFT_3D.this.rows - j) % DoubleFFT_3D.this.rows * n15;
                                int n4 = j * n15;
                                for (int k = 1; k < DoubleFFT_3D.this.columns; k += 2) {
                                    int n5 = n + n3 + n11 - k;
                                    int n6 = n2 + n4 + k;
                                    dArray[n5] = -dArray[n6 + 2];
                                    dArray[n5 - 1] = dArray[n6 + 1];
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            for (n = 0; n < n10; ++n) {
                n17 = n * n4;
                n16 = n == n10 - 1 ? this.slices : n17 + n4;
                futureArray[n] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n17; i < n16; ++i) {
                            int n = (DoubleFFT_3D.this.slices - i) % DoubleFFT_3D.this.slices * n14;
                            int n2 = i * n14;
                            for (int j = 1; j < n12; ++j) {
                                int n3 = n2 + (DoubleFFT_3D.this.rows - j) * n15;
                                int n4 = n + j * n15 + DoubleFFT_3D.this.columns;
                                int n5 = n3 + DoubleFFT_3D.this.columns;
                                int n6 = n3 + 1;
                                dArray[n4] = dArray[n6];
                                dArray[n5] = dArray[n6];
                                dArray[n4 + 1] = -dArray[n3];
                                dArray[n5 + 1] = dArray[n3];
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            for (n = 0; n < n10; ++n) {
                n17 = n * n4;
                n16 = n == n10 - 1 ? this.slices : n17 + n4;
                futureArray[n] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n17; i < n16; ++i) {
                            int n = (DoubleFFT_3D.this.slices - i) % DoubleFFT_3D.this.slices * n14;
                            int n2 = i * n14;
                            for (int j = 1; j < n12; ++j) {
                                int n3 = n + (DoubleFFT_3D.this.rows - j) * n15;
                                int n4 = n2 + j * n15;
                                dArray[n3] = dArray[n4];
                                dArray[n3 + 1] = -dArray[n4 + 1];
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (n7 = 0; n7 < this.slices; ++n7) {
                n9 = (this.slices - n7) % this.slices * n14;
                n6 = n7 * n14;
                for (n4 = 0; n4 < this.rows; ++n4) {
                    n8 = (this.rows - n4) % this.rows * n15;
                    n5 = n4 * n15;
                    for (n = 1; n < this.columns; n += 2) {
                        n3 = n9 + n8 + n11 - n;
                        n2 = n6 + n5 + n;
                        dArray[n3] = -dArray[n2 + 2];
                        dArray[n3 - 1] = dArray[n2 + 1];
                    }
                }
            }
            for (n7 = 0; n7 < this.slices; ++n7) {
                n6 = (this.slices - n7) % this.slices * n14;
                n5 = n7 * n14;
                for (n4 = 1; n4 < n12; ++n4) {
                    n8 = n5 + (this.rows - n4) * n15;
                    n3 = n6 + n4 * n15 + this.columns;
                    n2 = n8 + this.columns;
                    n9 = n8 + 1;
                    dArray[n3] = dArray[n9];
                    dArray[n2] = dArray[n9];
                    dArray[n3 + 1] = -dArray[n8];
                    dArray[n2 + 1] = dArray[n8];
                }
            }
            for (n7 = 0; n7 < this.slices; ++n7) {
                n9 = (this.slices - n7) % this.slices * n14;
                n8 = n7 * n14;
                for (n4 = 1; n4 < n12; ++n4) {
                    n3 = n9 + (this.rows - n4) * n15;
                    n2 = n8 + n4 * n15;
                    dArray[n3] = dArray[n2];
                    dArray[n3 + 1] = -dArray[n2 + 1];
                }
            }
        }
        for (int i = 1; i < n13; ++i) {
            n3 = i * n14;
            n2 = (this.slices - i) * n14;
            n9 = n12 * n15;
            n8 = n3 + n9;
            n6 = n2 + n9;
            dArray[n3 + this.columns] = dArray[n2 + 1];
            dArray[n2 + this.columns] = dArray[n2 + 1];
            dArray[n3 + this.columns + 1] = -dArray[n2];
            dArray[n2 + this.columns + 1] = dArray[n2];
            dArray[n8 + this.columns] = dArray[n6 + 1];
            dArray[n6 + this.columns] = dArray[n6 + 1];
            dArray[n8 + this.columns + 1] = -dArray[n6];
            dArray[n6 + this.columns + 1] = dArray[n6];
            dArray[n2] = dArray[n3];
            dArray[n2 + 1] = -dArray[n3 + 1];
            dArray[n6] = dArray[n8];
            dArray[n6 + 1] = -dArray[n8 + 1];
        }
        dArray[this.columns] = dArray[1];
        dArray[1] = 0.0;
        n3 = n12 * n15;
        n2 = n13 * n14;
        n9 = n3 + n2;
        dArray[n3 + this.columns] = dArray[n3 + 1];
        dArray[n3 + 1] = 0.0;
        dArray[n2 + this.columns] = dArray[n2 + 1];
        dArray[n2 + 1] = 0.0;
        dArray[n9 + this.columns] = dArray[n9 + 1];
        dArray[n9 + 1] = 0.0;
        dArray[n2 + this.columns + 1] = 0.0;
        dArray[n9 + this.columns + 1] = 0.0;
    }
}

