/*
 * Decompiled with CFR 0.152.
 */
package io.scif.xml;

import io.scif.io.RandomAccessInputStream;
import io.scif.xml.MetadataHandler;
import io.scif.xml.ParserErrorHandler;
import io.scif.xml.ValidationErrorHandler;
import io.scif.xml.ValidationSAXHandler;
import io.scif.xml.XMLService;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.scijava.log.LogService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.service.AbstractService;
import org.scijava.service.Service;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

@Plugin(type=Service.class)
public class DefaultXMLService
extends AbstractService
implements XMLService {
    private static final String XML_SCHEMA_PATH = "http://www.w3.org/2001/XMLSchema";
    private static final SchemaFactory FACTORY = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
    @Parameter
    private LogService log;
    private final ThreadLocal<HashMap<URI, Schema>> schemas = new ThreadLocal<HashMap<URI, Schema>>(){

        @Override
        protected HashMap<URI, Schema> initialValue() {
            return new HashMap<URI, Schema>();
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Document parseDOM(File file) throws ParserConfigurationException, SAXException, IOException {
        try (FileInputStream is = new FileInputStream(file);){
            Document doc;
            Document document = doc = this.parseDOM(is);
            return document;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Document parseDOM(String xml) throws ParserConfigurationException, SAXException, IOException {
        byte[] bytes = xml.getBytes("UTF-8");
        try (ByteArrayInputStream is = new ByteArrayInputStream(bytes);){
            Document doc;
            Document document = doc = this.parseDOM(is);
            return document;
        }
    }

    @Override
    public Document parseDOM(InputStream is) throws ParserConfigurationException, SAXException, IOException {
        InputStream in = is.markSupported() ? is : new BufferedInputStream(is);
        this.checkUTF8(in);
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = factory.newDocumentBuilder();
        db.setErrorHandler(new ParserErrorHandler(this.log));
        return db.parse(in);
    }

    @Override
    public String getXML(Document doc) throws TransformerConfigurationException, TransformerException {
        DOMSource source = new DOMSource(doc);
        StringWriter stringWriter = new StringWriter();
        StreamResult result = new StreamResult(stringWriter);
        TransformerFactory factory = TransformerFactory.newInstance();
        factory.setErrorListener(new XMLListener());
        Transformer transformer = factory.newTransformer();
        transformer.transform(source, result);
        return stringWriter.getBuffer().toString();
    }

    @Override
    public String sanitizeXML(String s) {
        char[] c = s.toCharArray();
        for (int i = 0; i < s.length(); ++i) {
            if (Character.isISOControl(c[i]) && c[i] != '\n' || !Character.isDefined(c[i])) {
                c[i] = 32;
            }
            if (i <= 0 || c[i - 1] != '&' || c[i] != '#') continue;
            c[i - 1] = 32;
        }
        return new String(c);
    }

    @Override
    public String escapeXML(String s) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '<') {
                sb.append("&lt;");
                continue;
            }
            if (c == '>') {
                sb.append("&gt;");
                continue;
            }
            if (c == '&') {
                sb.append("&amp;");
                continue;
            }
            if (c == '\"') {
                sb.append("&quot;");
                continue;
            }
            if (c == '\'') {
                sb.append("&apos;");
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    @Override
    public String indentXML(String xml) {
        return this.indentXML(xml, 3, false);
    }

    @Override
    public String indentXML(String xml, int spacing) {
        return this.indentXML(xml, spacing, false);
    }

    @Override
    public String indentXML(String xml, boolean preserveCData) {
        return this.indentXML(xml, 3, preserveCData);
    }

    @Override
    public String indentXML(String xml, int spacing, boolean preserveCData) {
        if (xml == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        StringTokenizer st = new StringTokenizer(xml, "<>", true);
        int indent = 0;
        int noSpace = 0;
        boolean first = true;
        boolean element = false;
        while (st.hasMoreTokens()) {
            String token = st.nextToken().trim();
            if (token.equals("")) continue;
            if (token.equals("<")) {
                element = true;
                continue;
            }
            if (element && token.equals(">")) {
                element = false;
                continue;
            }
            if (!element && preserveCData) {
                noSpace = 2;
            }
            if (noSpace == 0) {
                if (first) {
                    first = false;
                } else {
                    sb.append("\n");
                }
            }
            if (element && token.startsWith("/")) {
                indent -= spacing;
            }
            if (noSpace == 0) {
                for (int j = 0; j < indent; ++j) {
                    sb.append(" ");
                }
            }
            if (element) {
                sb.append("<");
            }
            sb.append(token);
            if (element) {
                sb.append(">");
            }
            if (!(noSpace != 0 || !element || token.startsWith("?") || token.startsWith("/") || token.endsWith("/") || token.startsWith("!"))) {
                indent += spacing;
            }
            if (noSpace <= 0) continue;
            --noSpace;
        }
        sb.append("\n");
        return sb.toString();
    }

    @Override
    public Hashtable<String, String> parseXML(String xml) throws IOException {
        MetadataHandler handler = new MetadataHandler();
        this.parseXML(xml, (DefaultHandler)handler);
        return handler.getMetadata();
    }

    @Override
    public void parseXML(String xml, DefaultHandler handler) throws IOException {
        this.parseXML(xml.getBytes("UTF-8"), handler);
    }

    @Override
    public void parseXML(RandomAccessInputStream stream, DefaultHandler handler) throws IOException {
        this.parseXML((InputStream)stream, handler);
    }

    @Override
    public void parseXML(byte[] xml, DefaultHandler handler) throws IOException {
        this.parseXML(new ByteArrayInputStream(xml), handler);
    }

    @Override
    public void parseXML(InputStream xml, DefaultHandler handler) throws IOException {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser parser = factory.newSAXParser();
            parser.parse(xml, handler);
        }
        catch (ParserConfigurationException exc) {
            IOException e = new IOException();
            e.initCause(exc);
            throw e;
        }
        catch (SAXException exc) {
            IOException e = new IOException();
            e.initCause(exc);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Templates getStylesheet(String resourcePath, Class<?> sourceClass) {
        InputStream xsltStream;
        if (sourceClass == null) {
            try {
                xsltStream = new FileInputStream(resourcePath);
            }
            catch (IOException exc) {
                this.log.debug((Object)"Could not open file", (Throwable)exc);
                return null;
            }
        } else {
            xsltStream = sourceClass.getResourceAsStream(resourcePath);
        }
        try {
            StreamSource xsltSource = new StreamSource(xsltStream);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            transformerFactory.setErrorListener(new XMLListener());
            Templates templates = transformerFactory.newTemplates(xsltSource);
            return templates;
        }
        catch (TransformerConfigurationException exc) {
            this.log.debug((Object)"Could not construct template", (Throwable)exc);
        }
        finally {
            try {
                if (xsltStream != null) {
                    xsltStream.close();
                }
            }
            catch (IOException e) {
                this.log.debug((Object)"Could not close file", (Throwable)e);
            }
        }
        return null;
    }

    @Override
    public String avoidUndeclaredNamespaces(String xml) {
        int gt = xml.indexOf(62);
        if (gt > 0 && xml.startsWith("<?xml ")) {
            gt = xml.indexOf(62, gt + 1);
        }
        if (gt > 0) {
            String firstTag = xml.substring(0, gt + 1).toLowerCase();
            while (firstTag.endsWith("-->")) {
                gt = xml.indexOf(62, gt + 1);
                firstTag = xml.substring(0, gt + 1).toLowerCase();
            }
            HashSet<String> namespaces = new HashSet<String>();
            Pattern pattern = Pattern.compile(" xmlns:(\\w+)");
            Matcher matcher = pattern.matcher(firstTag);
            while (matcher.find()) {
                namespaces.add(matcher.group(1));
            }
            pattern = Pattern.compile("</?(\\w+):");
            matcher = pattern.matcher(xml);
            while (matcher.find()) {
                String namespace = matcher.group(1);
                if (namespace.equalsIgnoreCase("OME") || namespace.startsWith("ns") || namespaces.contains(namespace.toLowerCase())) continue;
                int end = matcher.end();
                xml = xml.substring(0, end - 1) + "_" + xml.substring(end);
            }
            Pattern emptyNamespaces = Pattern.compile(" xmlns:(\\w+)=\"\"");
            matcher = emptyNamespaces.matcher(firstTag);
            while (matcher.find()) {
                int start = matcher.start();
                int end = matcher.end();
                xml = xml.substring(0, start + 1) + xml.substring(end);
            }
        }
        return xml;
    }

    @Override
    public String transformXML(String xml, Templates xslt) throws IOException {
        xml = this.avoidUndeclaredNamespaces(xml);
        return this.transformXML(new StreamSource(new StringReader(xml)), xslt);
    }

    @Override
    public String transformXML(Source xmlSource, Templates xslt) throws IOException {
        Transformer trans;
        try {
            trans = xslt.newTransformer();
            trans.setErrorListener(new XMLListener());
        }
        catch (TransformerConfigurationException exc) {
            IOException e = new IOException();
            e.initCause(exc);
            throw e;
        }
        StringWriter xmlWriter = new StringWriter();
        StreamResult xmlResult = new StreamResult(xmlWriter);
        try {
            trans.transform(xmlSource, xmlResult);
        }
        catch (TransformerException exc) {
            IOException e = new IOException();
            e.initCause(exc);
            throw e;
        }
        return xmlWriter.toString();
    }

    @Override
    public boolean validateXML(String xml) {
        return this.validateXML(xml, null);
    }

    @Override
    public boolean validateXML(String xml, String label) {
        if (label == null) {
            label = "XML";
        }
        Exception exception = null;
        this.log.info((Object)"Parsing schema path");
        ValidationSAXHandler saxHandler = new ValidationSAXHandler(this.log);
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser saxParser = factory.newSAXParser();
            ByteArrayInputStream is = new ByteArrayInputStream(xml.getBytes("UTF-8"));
            saxParser.parse((InputStream)is, (DefaultHandler)saxHandler);
        }
        catch (ParserConfigurationException exc) {
            exception = exc;
        }
        catch (SAXException exc) {
            exception = exc;
        }
        catch (IOException exc) {
            exception = exc;
        }
        if (exception != null) {
            this.log.warn((Object)("Error parsing schema path from " + label), (Throwable)exception);
            return false;
        }
        String schemaPath = saxHandler.getSchemaPath();
        if (schemaPath == null) {
            this.log.error((Object)"No schema path found. Validation cannot continue.");
            return false;
        }
        this.log.info((Object)schemaPath);
        this.log.info((Object)("Validating " + label));
        URI schemaLocation = null;
        try {
            schemaLocation = new URI(schemaPath);
        }
        catch (URISyntaxException exc) {
            this.log.info((Object)("Error accessing schema at " + schemaPath), (Throwable)exc);
            return false;
        }
        Schema schema = this.schemas.get().get(schemaLocation);
        if (schema == null) {
            try {
                schema = FACTORY.newSchema(schemaLocation.toURL());
                this.schemas.get().put(schemaLocation, schema);
            }
            catch (MalformedURLException exc) {
                this.log.info((Object)("Error parsing schema at " + schemaPath), (Throwable)exc);
                return false;
            }
            catch (SAXException exc) {
                this.log.info((Object)("Error parsing schema at " + schemaPath), (Throwable)exc);
                return false;
            }
        }
        Validator validator = schema.newValidator();
        StringReader reader = new StringReader(xml);
        InputSource is = new InputSource(reader);
        SAXSource source = new SAXSource(is);
        ValidationErrorHandler errorHandler = new ValidationErrorHandler(this.log);
        validator.setErrorHandler(errorHandler);
        try {
            validator.validate(source);
        }
        catch (IOException exc) {
            exception = exc;
        }
        catch (SAXException exc) {
            exception = exc;
        }
        int errors = errorHandler.getErrorCount();
        if (errors > 0) {
            this.log.info((Object)("Error validating document: " + errors + " errors found"));
            return false;
        }
        this.log.info((Object)"No validation errors found.");
        return errorHandler.ok();
    }

    private void checkUTF8(InputStream is) throws IOException {
        is.mark(3);
        if (is.read() != 239 || is.read() != 187 || is.read() != 191) {
            is.reset();
        }
    }

    private class XMLListener
    implements ErrorListener {
        private XMLListener() {
        }

        @Override
        public void error(TransformerException e) {
            DefaultXMLService.this.log.debug((Object)"", (Throwable)e);
        }

        @Override
        public void fatalError(TransformerException e) {
            DefaultXMLService.this.log.debug((Object)"", (Throwable)e);
        }

        @Override
        public void warning(TransformerException e) {
            DefaultXMLService.this.log.debug((Object)"", (Throwable)e);
        }
    }
}

