/*
 * Decompiled with CFR 0.152.
 */
package io.scif.util;

import io.scif.FormatException;
import io.scif.ImageMetadata;
import io.scif.Metadata;
import io.scif.Plane;
import io.scif.Reader;
import io.scif.Writer;
import io.scif.common.ReflectException;
import io.scif.common.ReflectedUniverse;
import io.scif.config.SCIFIOConfig;
import io.scif.io.RandomAccessInputStream;
import java.io.IOException;
import java.util.List;
import java.util.Vector;
import net.imagej.axis.Axes;
import net.imagej.axis.AxisType;
import net.imagej.axis.CalibratedAxis;
import net.imagej.axis.DefaultLinearAxis;
import net.imagej.axis.LinearAxis;

public final class FormatTools {
    public static final String[] COMPRESSION_SUFFIXES = new String[]{"bz2", "gz"};
    public static final int THUMBNAIL_DIMENSION = 128;
    public static final int INT8 = 0;
    public static final int UINT8 = 1;
    public static final int INT16 = 2;
    public static final int UINT16 = 3;
    public static final int INT32 = 4;
    public static final int UINT32 = 5;
    public static final int FLOAT = 6;
    public static final int DOUBLE = 7;
    private static final String[] pixelTypes = FormatTools.makePixelTypes();
    public static final int MUST_GROUP = 0;
    public static final int CAN_GROUP = 1;
    public static final int CANNOT_GROUP = 2;
    public static final String SERIES_NUM = "%s";
    public static final String SERIES_NAME = "%n";
    public static final String CHANNEL_NUM = "%c";
    public static final String CHANNEL_NAME = "%w";
    public static final String Z_NUM = "%z";
    public static final String T_NUM = "%t";
    public static final String TIMESTAMP = "%A";
    public static final String HCS_DOMAIN = "High-Content Screening (HCS)";
    public static final String LM_DOMAIN = "Light Microscopy";
    public static final String EM_DOMAIN = "Electron Microscopy (EM)";
    public static final String SPM_DOMAIN = "Scanning Probe Microscopy (SPM)";
    public static final String SEM_DOMAIN = "Scanning Electron Microscopy (SEM)";
    public static final String FLIM_DOMAIN = "Fluorescence-Lifetime Imaging";
    public static final String MEDICAL_DOMAIN = "Medical Imaging";
    public static final String HISTOLOGY_DOMAIN = "Histology";
    public static final String GEL_DOMAIN = "Gel/Blot Imaging";
    public static final String ASTRONOMY_DOMAIN = "Astronomy";
    public static final String GRAPHICS_DOMAIN = "Graphics";
    public static final String UNKNOWN_DOMAIN = "Unknown";
    public static final String[] NON_GRAPHICS_DOMAINS = new String[]{"Light Microscopy", "Electron Microscopy (EM)", "Scanning Probe Microscopy (SPM)", "Scanning Electron Microscopy (SEM)", "Fluorescence-Lifetime Imaging", "Medical Imaging", "Histology", "Gel/Blot Imaging", "Astronomy", "High-Content Screening (HCS)", "Unknown"};
    public static final String[] NON_HCS_DOMAINS = new String[]{"Light Microscopy", "Electron Microscopy (EM)", "Scanning Probe Microscopy (SPM)", "Scanning Electron Microscopy (SEM)", "Fluorescence-Lifetime Imaging", "Medical Imaging", "Histology", "Gel/Blot Imaging", "Astronomy", "Unknown"};
    public static final String[] NON_SPECIAL_DOMAINS = new String[]{"Light Microscopy", "Electron Microscopy (EM)", "Scanning Probe Microscopy (SPM)", "Scanning Electron Microscopy (SEM)", "Fluorescence-Lifetime Imaging", "Medical Imaging", "Histology", "Gel/Blot Imaging", "Astronomy", "Unknown"};
    public static final String[] ALL_DOMAINS = new String[]{"High-Content Screening (HCS)", "Light Microscopy", "Electron Microscopy (EM)", "Scanning Probe Microscopy (SPM)", "Scanning Electron Microscopy (SEM)", "Fluorescence-Lifetime Imaging", "Medical Imaging", "Histology", "Gel/Blot Imaging", "Astronomy", "Graphics", "Unknown"};

    static String[] makePixelTypes() {
        String[] pixelTypes = new String[]{"int8", "uint8", "int16", "uint16", "int32", "uint32", "float", "double"};
        return pixelTypes;
    }

    private FormatTools() {
    }

    public static CalibratedAxis createAxis(AxisType axisType) {
        return new DefaultLinearAxis(axisType);
    }

    public static CalibratedAxis[] createAxes(AxisType ... axisTypes) {
        CalibratedAxis[] axes = new CalibratedAxis[axisTypes.length];
        for (int i = 0; i < axisTypes.length; ++i) {
            axes[i] = FormatTools.createAxis(axisTypes[i]);
        }
        return axes;
    }

    public static void calibrate(Metadata m, int imageIndex, double[] scale) {
        FormatTools.calibrate(m, imageIndex, scale, new double[scale.length]);
    }

    public static void calibrate(Metadata m, int imageIndex, double[] scale, double[] origin) {
        int i = 0;
        for (CalibratedAxis axis : m.get(imageIndex).getAxes()) {
            if (i >= scale.length || i >= origin.length) continue;
            FormatTools.calibrate(axis, scale[i], origin[i]);
            ++i;
        }
    }

    public static void calibrate(CalibratedAxis axis, double scale, double origin) {
        if (!(axis instanceof LinearAxis)) {
            throw new IllegalArgumentException("Not a linear axis: " + axis);
        }
        LinearAxis linearAxis = (LinearAxis)axis;
        linearAxis.setScale(scale);
        linearAxis.setOrigin(origin);
    }

    public static void calibrate(CalibratedAxis axis, double scale, double origin, String unit) {
        FormatTools.calibrate(axis, scale, origin);
        axis.setUnit(unit);
    }

    public static double getScale(Metadata m, int imageIndex, AxisType axisType) {
        return FormatTools.getScale(m.get(imageIndex), axisType);
    }

    public static double getScale(ImageMetadata imageMeta, AxisType axisType) {
        CalibratedAxis axis = imageMeta.getAxis(axisType);
        if (axis == null) {
            return 1.0;
        }
        long axisLength = imageMeta.getAxisLength(axis);
        return axis.averageScale(0.0, (double)(axisLength - 1L));
    }

    public static long getNonPlanarAxisPosition(Metadata m, int imageIndex, long planeIndex, AxisType type) {
        ImageMetadata iMeta = m.get(imageIndex);
        int axisIndex = iMeta.getAxisIndex(type);
        if (axisIndex < iMeta.getPlanarAxisCount()) {
            return 0L;
        }
        long[] position = FormatTools.rasterToPosition(iMeta.getAxesLengthsNonPlanar(), planeIndex);
        return position[axisIndex -= iMeta.getPlanarAxisCount()];
    }

    public static long[] rasterToPosition(int imageIndex, long planeIndex, Reader reader) {
        return FormatTools.rasterToPosition(imageIndex, planeIndex, reader.getMetadata());
    }

    public static long[] rasterToPosition(int imageIndex, long planeIndex, Metadata m) {
        long[] axisLengths = m.get(imageIndex).getAxesLengthsNonPlanar();
        return FormatTools.rasterToPosition(axisLengths, planeIndex);
    }

    public static long[] rasterToPosition(long[] lengths, long raster) {
        return FormatTools.rasterToPosition(lengths, raster, new long[lengths.length]);
    }

    public static long[] rasterToPosition(long[] lengths, long raster, long[] pos) {
        long offset = 1L;
        for (int i = 0; i < pos.length; ++i) {
            long offset1 = offset * lengths[i];
            long q = i < pos.length - 1 ? raster % offset1 : raster;
            pos[i] = q / offset;
            raster -= q;
            offset = offset1;
        }
        return pos;
    }

    public static long nextPlaneIndex(int imageIndex, Reader r, long[] pos, long[] offsets, long[] cropLengths) {
        return FormatTools.nextPlaneIndex(imageIndex, r.getMetadata(), pos, offsets, cropLengths);
    }

    public static long nextPlaneIndex(int imageIndex, Metadata m, long[] pos, long[] offsets, long[] cropLengths) {
        return FormatTools.nextPlaneIndex(m.get(imageIndex).getAxesLengthsNonPlanar(), pos, offsets, cropLengths);
    }

    public static long nextPlaneIndex(long[] lengths, long[] pos, long[] offsets, long[] cropLengths) {
        boolean updated = false;
        for (int i = 0; i < pos.length && !updated && pos[i] >= offsets[i]; ++i) {
            if (pos[i] + 1L < offsets[i] + cropLengths[i]) {
                int n = i;
                pos[n] = pos[n] + 1L;
                updated = true;
                continue;
            }
            pos[i] = offsets[i];
        }
        if (updated) {
            return FormatTools.positionToRaster(lengths, pos);
        }
        return -1L;
    }

    public static long positionToRaster(int imageIndex, Reader reader, long[] planeIndices) {
        return FormatTools.positionToRaster(imageIndex, reader.getMetadata(), planeIndices);
    }

    public static long positionToRaster(int imageIndex, Metadata m, long[] planeIndices) {
        long[] planeSizes = m.get(imageIndex).getAxesLengthsNonPlanar();
        return FormatTools.positionToRaster(planeSizes, planeIndices);
    }

    public static long positionToRaster(long[] lengths, long[] pos) {
        long offset = 1L;
        long raster = 0L;
        for (int i = 0; i < pos.length; ++i) {
            raster += offset * pos[i];
            offset *= lengths[i];
        }
        return raster;
    }

    public static long getRasterLength(long[] lengths) {
        long length = 1L;
        for (long lengthVal : lengths) {
            length *= lengthVal;
        }
        return length;
    }

    public static void assertId(Object id, boolean notNull, int depth) {
        String header;
        String msg = null;
        if (id == null && notNull) {
            msg = "Current file should not be null; call setId(String) first";
        } else if (id != null && !notNull) {
            msg = "Current file should be null, but is '" + id + "'; call close() first";
        }
        if (msg == null) {
            return;
        }
        StackTraceElement[] ste = new Exception().getStackTrace();
        if (depth > 0 && ste.length > depth) {
            String c = ste[depth].getClassName();
            if (c.startsWith("io.scif.")) {
                c = c.substring(c.lastIndexOf(".") + 1);
            }
            header = c + "." + ste[depth].getMethodName() + ": ";
        } else {
            header = "";
        }
        throw new IllegalStateException(header + msg);
    }

    public static void assertStream(RandomAccessInputStream stream, boolean notNull, int depth) {
        String header;
        String msg = null;
        if (stream == null && notNull) {
            msg = "Current file should not be null; call setId(String) first";
        } else if (stream != null && !notNull) {
            msg = "Current file should be null, but is '" + stream + "'; call close() first";
        }
        if (msg == null) {
            return;
        }
        StackTraceElement[] ste = new Exception().getStackTrace();
        if (depth > 0 && ste.length > depth) {
            String c = ste[depth].getClassName();
            if (c.startsWith("io.scif.")) {
                c = c.substring(c.lastIndexOf(".") + 1);
            }
            header = c + "." + ste[depth].getMethodName() + ": ";
        } else {
            header = "";
        }
        throw new IllegalStateException(header + msg);
    }

    public static void checkPlaneForReading(Metadata m, int imageIndex, long planeIndex, int bufLength, long[] planeMin, long[] planeMax) throws FormatException {
        FormatTools.assertId(m.getSource(), true, 2);
        FormatTools.checkPlaneForWriting(m, imageIndex, planeIndex, bufLength, planeMin, planeMax);
    }

    public static void checkPlaneForWriting(Metadata m, int imageIndex, long planeIndex, int bufLength, long[] planeMin, long[] planeMax) throws FormatException {
        FormatTools.checkPlaneNumber(m, imageIndex, planeIndex);
        FormatTools.checkTileSize(m, planeMin, planeMax, imageIndex);
        if (bufLength >= 0) {
            FormatTools.checkBufferSize(m, bufLength, planeMax, imageIndex);
        }
    }

    public static void checkPlaneNumber(Metadata m, int imageIndex, long planeIndex) throws FormatException {
        long imageCount = m.get(imageIndex).getPlaneCount();
        if (planeIndex < 0L || planeIndex >= imageCount) {
            throw new FormatException("Invalid plane number: " + planeIndex + " (planeCount=" + planeIndex + ")");
        }
    }

    public static void checkTileSize(Metadata m, long[] planeMin, long[] planeMax, int imageIndex) throws FormatException {
        List<CalibratedAxis> axes = m.get(imageIndex).getAxesPlanar();
        for (int i = 0; i < axes.size(); ++i) {
            long start = planeMin[i];
            long end = planeMax[i];
            long length = m.get(imageIndex).getAxisLength(axes.get(i));
            if (start >= 0L && end >= 0L && start + end <= length) continue;
            throw new FormatException("Invalid planar size: start=" + start + ", end=" + end + ", length in metadata=" + length);
        }
    }

    public static void checkBufferSize(int imageIndex, Metadata m, int len) throws FormatException {
        FormatTools.checkBufferSize(m, len, m.get(imageIndex).getAxesLengthsPlanar(), imageIndex);
    }

    public static void checkBufferSize(Metadata m, int len, long[] planeLengths, int imageIndex) throws FormatException {
        long size = FormatTools.getPlaneSize(m, new long[planeLengths.length], planeLengths, imageIndex);
        if (size > (long)len) {
            throw new FormatException("Buffer too small (got " + len + ", expected " + size + ").");
        }
    }

    public static boolean validStream(RandomAccessInputStream stream, int len, boolean littleEndian) throws IOException {
        stream.seek(0L);
        stream.order(littleEndian);
        return stream.length() >= (long)len;
    }

    public static long getPlaneSize(Reader r, int imageIndex) {
        return FormatTools.getPlaneSize(r.getMetadata(), imageIndex);
    }

    public static long getPlaneSize(Metadata m, int imageIndex) {
        return m.get(imageIndex).getPlaneSize();
    }

    public static long getPlaneSize(Metadata m, int width, int height, int imageIndex) {
        ImageMetadata iMeta = m.get(imageIndex);
        long[] planeMin = new long[iMeta.getPlanarAxisCount()];
        long[] planeMax = new long[iMeta.getPlanarAxisCount()];
        for (int i = 0; i < planeMax.length; ++i) {
            AxisType type = iMeta.getAxis(i).type();
            planeMax[i] = type == Axes.X ? (long)width : (type == Axes.Y ? (long)height : iMeta.getAxisLength(type));
        }
        return FormatTools.getPlaneSize(m, planeMin, planeMax, imageIndex);
    }

    public static long getPlaneSize(Metadata m, long[] planeMin, long[] planeMax, int imageIndex) {
        if (planeMin.length != planeMax.length) {
            throw new IllegalArgumentException("Plane min array size: " + planeMin.length + " does not match plane max array size: " + planeMax.length);
        }
        long length = m.get(imageIndex).getBitsPerPixel() / 8;
        for (int i = 0; i < planeMin.length; ++i) {
            length *= planeMax[i] - planeMin[i];
        }
        return length;
    }

    public static int pixelTypeFromString(String pixelTypeAsString) {
        String lowercaseTypeAsString = pixelTypeAsString.toLowerCase();
        for (int i = 0; i < pixelTypes.length; ++i) {
            if (!pixelTypes[i].equals(lowercaseTypeAsString)) continue;
            return i;
        }
        throw new IllegalArgumentException("Unknown type: '" + pixelTypeAsString + "'");
    }

    public static String getPixelTypeString(int pixelType) {
        if (pixelType < 0 || pixelType >= pixelTypes.length) {
            throw new IllegalArgumentException("Unknown pixel type: " + pixelType);
        }
        return pixelTypes[pixelType];
    }

    public static int getBytesPerPixel(int pixelType) {
        switch (pixelType) {
            case 0: 
            case 1: {
                return 1;
            }
            case 2: 
            case 3: {
                return 2;
            }
            case 4: 
            case 5: 
            case 6: {
                return 4;
            }
            case 7: {
                return 8;
            }
        }
        throw new IllegalArgumentException("Unknown pixel type: " + pixelType);
    }

    public static int getBitsPerPixel(int pixelType) {
        return 8 * FormatTools.getBytesPerPixel(pixelType);
    }

    public static int getBytesPerPixel(String pixelType) {
        return FormatTools.getBytesPerPixel(FormatTools.pixelTypeFromString(pixelType));
    }

    public static boolean isFloatingPoint(int pixelType) {
        switch (pixelType) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return false;
            }
            case 6: 
            case 7: {
                return true;
            }
        }
        throw new IllegalArgumentException("Unknown pixel type: " + pixelType);
    }

    public static boolean isSigned(int pixelType) {
        switch (pixelType) {
            case 0: 
            case 2: 
            case 4: 
            case 6: 
            case 7: {
                return true;
            }
            case 1: 
            case 3: 
            case 5: {
                return false;
            }
        }
        throw new IllegalArgumentException("Unknown pixel type: " + pixelType);
    }

    public static int pixelTypeFromBytes(int bytes, boolean signed, boolean fp) throws FormatException {
        switch (bytes) {
            case 1: {
                return signed ? 0 : 1;
            }
            case 2: {
                return signed ? 2 : 3;
            }
            case 4: {
                return fp ? 6 : (signed ? 4 : 5);
            }
            case 8: {
                return 7;
            }
        }
        throw new FormatException("Unsupported byte depth: " + bytes);
    }

    public static String getFilename(int imageIndex, int image, Reader r, String pattern) throws FormatException, IOException {
        String filename = pattern.replaceAll(SERIES_NUM, String.valueOf(imageIndex));
        String imageName = r.getCurrentFile();
        if (imageName == null) {
            imageName = "Image#" + imageIndex;
        }
        imageName = imageName.replaceAll("/", "_");
        imageName = imageName.replaceAll("\\\\", "_");
        filename = filename.replaceAll(SERIES_NAME, imageName);
        long[] coordinates = FormatTools.rasterToPosition(imageIndex, (long)image, r);
        filename = filename.replaceAll(Z_NUM, String.valueOf(coordinates[0]));
        filename = filename.replaceAll(T_NUM, String.valueOf(coordinates[2]));
        filename = filename.replaceAll(CHANNEL_NUM, String.valueOf(coordinates[1]));
        String channelName = String.valueOf(coordinates[1]);
        channelName = channelName.replaceAll("/", "_");
        channelName = channelName.replaceAll("\\\\", "_");
        filename = filename.replaceAll(CHANNEL_NAME, channelName);
        return filename;
    }

    public static String[] getFilenames(String pattern, Reader r) throws FormatException, IOException {
        Vector<String> filenames = new Vector<String>();
        String filename = null;
        for (int series = 0; series < r.getImageCount(); ++series) {
            for (int image = 0; image < r.getImageCount(); ++image) {
                filename = FormatTools.getFilename(series, image, r, pattern);
                if (filenames.contains(filename)) continue;
                filenames.add(filename);
            }
        }
        return filenames.toArray(new String[0]);
    }

    public static int getImagesPerFile(String pattern, Reader r) throws FormatException, IOException {
        String[] filenames = FormatTools.getFilenames(pattern, r);
        int totalPlanes = 0;
        for (int series = 0; series < r.getImageCount(); ++series) {
            totalPlanes = (int)((long)totalPlanes + r.getMetadata().get(series).getPlaneCount());
        }
        return totalPlanes / filenames.length;
    }

    public static byte[] openThumbBytes(Reader reader, int imageIndex, long planeIndex) throws FormatException, IOException {
        ReflectedUniverse r = new ReflectedUniverse(reader.log());
        byte[][] bytes = null;
        try {
            r.exec("import io.scif.gui.AWTImageTools");
            long planeSize = FormatTools.getPlaneSize(reader, imageIndex);
            Plane plane = null;
            if (planeSize < 0L) {
                Metadata m = reader.getMetadata();
                long[] planeMax = m.get(imageIndex).getAxesLengthsPlanar();
                long[] planeMin = new long[planeMax.length];
                int xIndex = m.get(imageIndex).getAxisIndex(Axes.X);
                int yIndex = m.get(imageIndex).getAxisIndex(Axes.Y);
                long width = m.get(imageIndex).getThumbSizeX() * 4L;
                long height = m.get(imageIndex).getThumbSizeY() * 4L;
                planeMin[xIndex] = (m.get(imageIndex).getAxisLength(Axes.X) - width) / 2L;
                planeMin[yIndex] = (m.get(imageIndex).getAxisLength(Axes.Y) - height) / 2L;
                planeMax[xIndex] = width;
                planeMax[yIndex] = height;
                plane = reader.openPlane(imageIndex, planeIndex, planeMin, planeMax);
            } else {
                plane = reader.openPlane(imageIndex, planeIndex);
            }
            r.setVar("plane", plane);
            r.setVar("reader", reader);
            r.setVar("sizeX", reader.getMetadata().get(imageIndex).getAxisLength(Axes.X));
            r.setVar("sizeY", reader.getMetadata().get(imageIndex).getAxisLength(Axes.Y));
            r.setVar("thumbSizeX", reader.getMetadata().get(imageIndex).getThumbSizeX());
            r.setVar("thumbSizeY", reader.getMetadata().get(imageIndex).getThumbSizeY());
            r.setVar("little", reader.getMetadata().get(imageIndex).isLittleEndian());
            r.setVar("imageIndex", imageIndex);
            r.exec("thumb = AWTImageTools.openThumbImage(plane, reader, imageIndex, sizeX, sizeY, thumbSizeX, thumbSizeY, false)");
            bytes = (byte[][])r.exec("AWTImageTools.getPixelBytes(thumb, little)");
        }
        catch (ReflectException exc) {
            throw new FormatException(exc);
        }
        if (bytes.length == 1) {
            return bytes[0];
        }
        long rgbChannelCount = reader.getMetadata().get(imageIndex).getAxisLength(Axes.CHANNEL);
        byte[] rtn = new byte[(int)rgbChannelCount * bytes[0].length];
        if (reader.getMetadata().get(imageIndex).getInterleavedAxisCount() <= 0) {
            int i = 0;
            while ((long)i < rgbChannelCount) {
                System.arraycopy(bytes[i], 0, rtn, bytes[0].length * i, bytes[i].length);
                ++i;
            }
        } else {
            int bpp = FormatTools.getBytesPerPixel(reader.getMetadata().get(imageIndex).getPixelType());
            for (int i = 0; i < bytes[0].length / bpp; i += bpp) {
                int j = 0;
                while ((long)j < rgbChannelCount) {
                    System.arraycopy(bytes[j], i, rtn, (int)((long)i * rgbChannelCount) + j * bpp, bpp);
                    ++j;
                }
            }
        }
        return rtn;
    }

    public static void convert(Reader input, Writer output, String outputFile) throws FormatException, IOException {
        Plane p = null;
        for (int i = 0; i < input.getImageCount(); ++i) {
            int j = 0;
            while ((long)j < input.getPlaneCount(i)) {
                p = input.openPlane(i, j);
                output.savePlane(i, j, p);
                ++j;
            }
        }
        input.close();
        output.close();
    }

    public static void convert(Reader input, Writer output, String outputFile, SCIFIOConfig config) throws FormatException, IOException {
        Plane p = null;
        for (int i = 0; i < input.getImageCount(); ++i) {
            int j = 0;
            while ((long)j < input.getPlaneCount(i)) {
                p = input.openPlane(i, (long)j, config);
                output.savePlane(i, j, p);
                ++j;
            }
        }
        input.close();
        output.close();
    }

    public static long[] defaultMinMax(int pixelType) {
        long min = 0L;
        long max = 0L;
        switch (pixelType) {
            case 0: {
                min = -128L;
                max = 127L;
                break;
            }
            case 2: {
                min = -32768L;
                max = 32767L;
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                min = Integer.MIN_VALUE;
                max = Integer.MAX_VALUE;
                break;
            }
            case 1: {
                min = 0L;
                max = (long)Math.pow(2.0, 8.0) - 1L;
                break;
            }
            case 3: {
                min = 0L;
                max = (long)Math.pow(2.0, 16.0) - 1L;
                break;
            }
            case 5: {
                min = 0L;
                max = (long)Math.pow(2.0, 32.0) - 1L;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid pixel type");
            }
        }
        return new long[]{min, max};
    }

    public static long[] defaultMinMax(int bitsPerPixel, boolean signed) {
        if (bitsPerPixel <= 0) {
            throw new IllegalArgumentException("Bits per pixel must be positive. Value was: " + bitsPerPixel);
        }
        long min = 0L;
        long max = 0L;
        int bits = bitsPerPixel;
        if (signed) {
            min = (long)(-Math.pow(2.0, --bits));
        }
        max = (long)Math.pow(2.0, bits) - 1L;
        return new long[]{min, max};
    }

    public static long[] defaultMinMax(int pixelType, int bitsPerPixel) {
        if (bitsPerPixel > 0) {
            return FormatTools.defaultMinMax(bitsPerPixel, FormatTools.isSigned(pixelType));
        }
        return FormatTools.defaultMinMax(pixelType);
    }

    public static long[] defaultMinMax(ImageMetadata iMeta) {
        return FormatTools.defaultMinMax(iMeta.getPixelType(), iMeta.getBitsPerPixel());
    }

    public static boolean checkSuffix(String name, String suffix) {
        return FormatTools.checkSuffix(name, new String[]{suffix});
    }

    public static boolean checkSuffix(String name, String[] suffixList) {
        String lname = name.toLowerCase();
        for (String suffix : suffixList) {
            String s = "." + suffix;
            if (lname.endsWith(s)) {
                return true;
            }
            for (String COMPRESSION_SUFFIX : COMPRESSION_SUFFIXES) {
                if (!lname.endsWith(s + "." + COMPRESSION_SUFFIX)) continue;
                return true;
            }
        }
        return false;
    }
}

