/*
 * Decompiled with CFR 0.152.
 */
package io.scif.services;

import io.scif.Checker;
import io.scif.DefaultWriter;
import io.scif.Format;
import io.scif.FormatException;
import io.scif.Metadata;
import io.scif.Parser;
import io.scif.Reader;
import io.scif.Writer;
import io.scif.config.SCIFIOConfig;
import io.scif.io.RandomAccessInputStream;
import io.scif.services.FormatService;
import io.scif.util.FormatTools;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.WeakHashMap;
import org.scijava.app.AppService;
import org.scijava.log.LogService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.plugin.PluginService;
import org.scijava.service.AbstractService;
import org.scijava.service.Service;
import org.scijava.thread.ThreadService;

@Plugin(type=Service.class)
public class DefaultFormatService
extends AbstractService
implements FormatService {
    @Parameter
    private PluginService pluginService;
    @Parameter
    private AppService appService;
    @Parameter
    private ThreadService threadService;
    @Parameter
    private LogService logService;
    private Set<Format> formats;
    private Map<Class<?>, Format> formatMap;
    private Map<Class<?>, Format> checkerMap;
    private Map<Class<?>, Format> parserMap;
    private Map<Class<?>, Format> readerMap;
    private Map<Class<?>, Format> writerMap;
    private Map<Class<?>, Format> metadataMap;
    private Map<String, Format> formatCache;
    private boolean dirtyFormatCache = false;
    private boolean initialized = false;
    private final ThreadLocal<Boolean> threadLock = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };

    @Override
    public String[] getSuffixes() {
        TreeSet<String> ts = new TreeSet<String>();
        for (Format f : this.formats()) {
            for (String s : f.getSuffixes()) {
                ts.add(s);
            }
        }
        return ts.toArray(new String[ts.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addFormat(Format format) {
        if (this.formatMap().get(format.getClass()) != null) {
            return false;
        }
        Set<Format> set = this.formats;
        synchronized (set) {
            if (this.formatMap().get(format.getClass()) == null) {
                this.formats().add(format);
                this.formatMap().put(format.getClass(), format);
                this.addComponents(format);
            }
        }
        if (format.getContext() == null) {
            format.setContext(this.getContext());
        }
        return true;
    }

    @Override
    public boolean removeFormat(Format format) {
        this.removeComponents(format);
        this.formatMap().remove(format.getClass());
        this.dirtyFormatCache = true;
        return this.formats().remove(format);
    }

    @Override
    public void addComponents(Format format) {
        this.checkerMap().put(format.getCheckerClass(), format);
        this.parserMap().put(format.getParserClass(), format);
        this.readerMap().put(format.getReaderClass(), format);
        this.writerMap().put(format.getWriterClass(), format);
        this.metadataMap().put(format.getMetadataClass(), format);
    }

    @Override
    public void removeComponents(Format format) {
        this.checkerMap().remove(format.getCheckerClass());
        this.parserMap().remove(format.getParserClass());
        this.readerMap().remove(format.getReaderClass());
        this.writerMap().remove(format.getWriterClass());
        this.metadataMap().remove(format.getMetadataClass());
    }

    @Override
    public <F extends Format> F getFormatFromClass(Class<F> formatClass) {
        return (F)this.formatMap().get(formatClass);
    }

    @Override
    public Format getFormatFromComponent(Class<?> componentClass) {
        Format fmt = null;
        if (Reader.class.isAssignableFrom(componentClass)) {
            fmt = this.getFormatFromReader(componentClass);
        } else if (Writer.class.isAssignableFrom(componentClass)) {
            fmt = this.getFormatFromWriter(componentClass);
        } else if (Metadata.class.isAssignableFrom(componentClass)) {
            fmt = this.getFormatFromMetadata(componentClass);
        } else if (Parser.class.isAssignableFrom(componentClass)) {
            fmt = this.getFormatFromParser(componentClass);
        } else if (Checker.class.isAssignableFrom(componentClass)) {
            fmt = this.getFormatFromChecker(componentClass);
        }
        return fmt;
    }

    @Override
    public <R extends Reader> Format getFormatFromReader(Class<R> readerClass) {
        return this.readerMap().get(readerClass);
    }

    @Override
    public <W extends Writer> Format getFormatFromWriter(Class<W> writerClass) {
        return this.writerMap().get(writerClass);
    }

    @Override
    public Writer getWriterByExtension(String fileId) throws FormatException {
        boolean matched = false;
        Writer w = null;
        for (Format f : this.formats()) {
            if (matched || !FormatTools.checkSuffix(fileId, f.getSuffixes()) || DefaultWriter.class.isAssignableFrom(f.getWriterClass())) continue;
            w = f.createWriter();
            matched = true;
        }
        if (w == null) {
            throw new FormatException("No compatible output format found for extension: " + fileId);
        }
        return w;
    }

    @Override
    public <C extends Checker> Format getFormatFromChecker(Class<C> checkerClass) {
        return this.checkerMap().get(checkerClass);
    }

    @Override
    public <P extends Parser> Format getFormatFromParser(Class<P> parserClass) {
        return this.parserMap().get(parserClass);
    }

    @Override
    public <M extends Metadata> Format getFormatFromMetadata(Class<M> metadataClass) {
        return this.metadataMap().get(metadataClass);
    }

    @Override
    public Format getFormat(String id) throws FormatException {
        return this.getFormat(id, new SCIFIOConfig().checkerSetOpen(false));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Format getFormat(String id, SCIFIOConfig config) throws FormatException {
        Format format = this.formatCache().get(id);
        if (format == null) {
            format = this.getFormatList(id, config, true).get(0);
            Set<Format> set = this.formats;
            synchronized (set) {
                if (this.formatCache().get(id) == null) {
                    this.formatCache().put(id, format);
                }
            }
        }
        return format;
    }

    @Override
    public List<Format> getFormatList(String id) throws FormatException {
        return this.getFormatList(id, new SCIFIOConfig().checkerSetOpen(false), false);
    }

    @Override
    public List<Format> getFormatList(String id, SCIFIOConfig config, boolean greedy) throws FormatException {
        ArrayList<Format> formatList = new ArrayList<Format>();
        boolean found = false;
        for (Format format : this.formats()) {
            if (found || !format.isEnabled() || !format.createChecker().isFormat(id, config)) continue;
            found = greedy;
            formatList.add(format);
        }
        if (formatList.isEmpty()) {
            throw new FormatException(id + ": No supported format found.");
        }
        return formatList;
    }

    @Override
    public Format getFormat(RandomAccessInputStream source) throws FormatException {
        return this.getFormat(source, new SCIFIOConfig().checkerSetOpen(true));
    }

    @Override
    public Format getFormat(RandomAccessInputStream source, SCIFIOConfig config) throws FormatException {
        return this.getFormatList(source, config, true).get(0);
    }

    @Override
    public List<Format> getFormatList(RandomAccessInputStream source) throws FormatException {
        return this.getFormatList(source, new SCIFIOConfig().checkerSetOpen(true), false);
    }

    @Override
    public List<Format> getFormatList(RandomAccessInputStream source, SCIFIOConfig config, boolean greedy) throws FormatException {
        ArrayList<Format> formatList = new ArrayList<Format>();
        boolean found = false;
        for (Format format : this.formats()) {
            try {
                if (!found && format.isEnabled() && format.createChecker().isFormat(source)) {
                    found = greedy;
                    formatList.add(format);
                }
                source.seek(0L);
            }
            catch (IOException e) {
                throw new FormatException(e);
            }
        }
        if (formatList.isEmpty()) {
            throw new FormatException("No supported format found.");
        }
        return formatList;
    }

    @Override
    public Set<Format> getAllFormats() {
        return this.formats();
    }

    @Override
    public Collection<Format> getOutputFormats() {
        return this.writerMap().values();
    }

    public String getVersion() {
        return this.appService.getApp("SCIFIO").getVersion();
    }

    public void initialize() {
        this.threadService.run(new Runnable(){

            @Override
            public void run() {
                DefaultFormatService.this.threadLock.set(true);
                DefaultFormatService.this.formats = new TreeSet();
                DefaultFormatService.this.formatMap = new HashMap();
                DefaultFormatService.this.checkerMap = new HashMap();
                DefaultFormatService.this.parserMap = new HashMap();
                DefaultFormatService.this.readerMap = new HashMap();
                DefaultFormatService.this.writerMap = new HashMap();
                DefaultFormatService.this.metadataMap = new HashMap();
                DefaultFormatService.this.formatCache = new WeakHashMap();
                for (Format format : DefaultFormatService.this.pluginService.createInstancesOfType(Format.class)) {
                    DefaultFormatService.this.addFormat(format);
                }
                DefaultFormatService.this.initialized = true;
            }
        });
    }

    private Set<Format> formats() {
        this.checkLock();
        return this.formats;
    }

    private Map<Class<?>, Format> formatMap() {
        this.checkLock();
        return this.formatMap;
    }

    private Map<Class<?>, Format> checkerMap() {
        this.checkLock();
        return this.checkerMap;
    }

    private Map<Class<?>, Format> parserMap() {
        this.checkLock();
        return this.parserMap;
    }

    private Map<Class<?>, Format> readerMap() {
        this.checkLock();
        return this.readerMap;
    }

    private Map<Class<?>, Format> writerMap() {
        this.checkLock();
        return this.writerMap;
    }

    private Map<Class<?>, Format> metadataMap() {
        this.checkLock();
        return this.metadataMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Format> formatCache() {
        this.checkLock();
        if (this.dirtyFormatCache) {
            Map<String, Format> map = this.formatCache;
            synchronized (map) {
                if (this.dirtyFormatCache) {
                    this.formatCache.clear();
                    this.dirtyFormatCache = false;
                }
            }
        }
        return this.formatCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkLock() {
        if (!this.initialized && !this.threadLock.get().booleanValue()) {
            DefaultFormatService defaultFormatService = this;
            synchronized (defaultFormatService) {
                while (!this.initialized && !this.threadLock.get().booleanValue()) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        this.logService.error((Object)"DefaultFormatService: Interrupted while waiting for format initialization.", (Throwable)e);
                    }
                }
            }
        }
    }
}

