/*
 * Decompiled with CFR 0.152.
 */
package io.scif.io;

import io.scif.io.NIOService;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.scijava.log.LogService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.service.AbstractService;
import org.scijava.service.Service;

@Plugin(type=Service.class)
public class DefaultNIOService
extends AbstractService
implements NIOService {
    @Parameter
    private LogService log;
    private final boolean useMappedByteBuffer = Boolean.parseBoolean(System.getProperty("mappedBuffers"));

    @Override
    public ByteBuffer allocate(FileChannel channel, FileChannel.MapMode mapMode, long bufferStartPosition, int newSize) throws IOException {
        this.log.debug((Object)("NIO: allocate: mapped=" + this.useMappedByteBuffer + ", start=" + bufferStartPosition + ", size=" + newSize));
        if (this.useMappedByteBuffer) {
            return this.allocateMappedByteBuffer(channel, mapMode, bufferStartPosition, newSize);
        }
        return this.allocateDirect(channel, bufferStartPosition, newSize);
    }

    private ByteBuffer allocateDirect(FileChannel channel, long bufferStartPosition, int newSize) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(newSize);
        channel.read(buffer, bufferStartPosition);
        return buffer;
    }

    private ByteBuffer allocateMappedByteBuffer(FileChannel channel, FileChannel.MapMode mapMode, long bufferStartPosition, int newSize) throws IOException {
        return channel.map(mapMode, bufferStartPosition, newSize);
    }
}

