/*
 * Decompiled with CFR 0.152.
 */
package io.scif.io;

import io.scif.io.Location;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import org.scijava.Context;

public class CaseInsensitiveLocation
extends Location {
    private static final Cache cache = new Cache();

    public CaseInsensitiveLocation(Context context, String pathname) throws IOException {
        super(context, CaseInsensitiveLocation.findCaseInsensitive(new File(pathname)));
    }

    public CaseInsensitiveLocation(Context context, File file) throws IOException {
        super(context, CaseInsensitiveLocation.findCaseInsensitive(file));
    }

    public CaseInsensitiveLocation(Context context, String parent, String child) throws IOException {
        super(context, CaseInsensitiveLocation.findCaseInsensitive(new File(parent + File.separator + child)));
    }

    public CaseInsensitiveLocation(Context context, CaseInsensitiveLocation parent, String child) throws IOException {
        super(context, CaseInsensitiveLocation.findCaseInsensitive(new File(parent.getAbsolutePath(), child)));
    }

    public static void invalidateCache() {
        cache.invalidate();
    }

    public static void invalidateCache(File dir) {
        cache.invalidate(dir);
    }

    private static File findCaseInsensitive(File name) throws IOException {
        return cache.lookup(name);
    }

    private static final class Cache {
        private final HashMap<String, HashMap<String, String>> cache = new HashMap();

        private HashMap<String, String> fill(File dir) throws IOException {
            String dirname = dir.getAbsolutePath();
            HashMap<String, String> s = this.cache.get(dirname);
            if (s == null && dir.exists()) {
                String[] files;
                s = new HashMap();
                this.cache.put(dirname, s);
                for (String name : files = dir.list()) {
                    String lower = name.toLowerCase();
                    if (s.containsKey(lower)) {
                        throw new IOException("Multiple files found for case-insensitive path");
                    }
                    s.put(lower, name);
                }
            }
            return s;
        }

        public void invalidate(File dir) {
            String dirname = dir.getAbsolutePath();
            this.cache.remove(dirname);
        }

        public void invalidate() {
            this.cache.clear();
        }

        public File lookup(File name) throws IOException {
            String realname;
            String lower;
            String f;
            HashMap<String, String> s;
            File parent = name.getParentFile();
            if (parent != null && (s = this.fill(parent)) != null && (f = s.get(lower = (realname = name.getName()).toLowerCase())) != null) {
                return new File(parent, f);
            }
            return name;
        }
    }
}

