/*
 * Decompiled with CFR 0.152.
 */
package io.scif.img.cell.cache;

import io.scif.img.cell.SCIFIOCell;
import io.scif.img.cell.cache.AbstractCacheService;
import io.scif.img.cell.cache.CacheResult;
import io.scif.refs.RefManagerService;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import org.mapdb.DB;
import org.mapdb.DBMaker;
import org.mapdb.HTreeMap;
import org.scijava.log.LogService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.service.Service;
import org.scijava.thread.ThreadService;

@Plugin(type=Service.class)
public class MapDBCache
extends AbstractCacheService<SCIFIOCell<?>> {
    @Parameter
    private ThreadService threadService;
    @Parameter
    private RefManagerService refManagerService;
    @Parameter
    private LogService logService;
    private DB db;
    private final Set<String> caches = new TreeSet<String>();
    private final Map<Integer, Integer> knownKeys = new ConcurrentHashMap<Integer, Integer>();
    private final Set<Integer> retrievedKeys = new HashSet<Integer>();
    private long maxCacheSize = Long.MAX_VALUE;
    private final boolean[] cleaning = new boolean[]{false};
    private final Queue<Set<Integer>> cleaningQueue = new LinkedList<Set<Integer>>();

    @Override
    public void clearCache(String cacheId) {
        if (this.caches.contains(cacheId)) {
            HTreeMap cache = this.db().getHashMap(cacheId);
            for (Object k : cache.keySet()) {
                this.knownKeys.remove(k);
                this.retrievedKeys.remove(k);
                SCIFIOCell cell = (SCIFIOCell)((Object)cache.remove(k));
                if (cell == null) continue;
                cell.cacheOnFinalize(false);
            }
            this.db().commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearAllCaches() {
        MapDBCache mapDBCache = this;
        synchronized (mapDBCache) {
            for (String cache : this.caches) {
                this.clearCache(cache);
            }
        }
    }

    @Override
    public void dropCache(String cacheId) {
        if (this.caches.contains(cacheId)) {
            this.db().getHashMap(cacheId).close();
            this.caches.remove(cacheId);
        }
    }

    @Override
    public void addCache(String cacheId) {
        this.caches.add(cacheId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CacheResult cache(String cacheId, int index, SCIFIOCell<?> cell) {
        if (!cell.isEnabled()[0]) {
            return CacheResult.CELL_DISABLED;
        }
        cell.update();
        if (!this.cacheAll() && !cell.dirty()) {
            return CacheResult.NOT_DIRTY;
        }
        if (!this.caches.contains(cacheId)) {
            return CacheResult.CACHE_NOT_FOUND;
        }
        Integer key = this.getKey(cacheId, index);
        Integer knownHash = null;
        Map<Integer, Integer> map = this.knownKeys;
        synchronized (map) {
            knownHash = this.knownKeys.get(key);
        }
        if (knownHash != null && cell.getCurrentHash() == knownHash.intValue()) {
            return CacheResult.DUPLICATE_FOUND;
        }
        if (knownHash == null && this.retrievedKeys.contains(key)) {
            while (this.retrievedKeys.contains(key)) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e) {
                    this.logService.warn((Object)"Interrupted while waiting for retrieved keys to clear", (Throwable)e);
                }
            }
        }
        HTreeMap cache = this.db().getHashMap(cacheId);
        int knownSize = 0;
        boolean inClean = false;
        Map<Integer, Integer> map2 = this.knownKeys;
        synchronized (map2) {
            knownSize = this.knownKeys.keySet().size() + 1;
            inClean = this.cleaning[0];
        }
        if ((long)knownSize * cell.getElementSize() < this.maxCacheSize) {
            this.diskIsFull(false);
        } else if (this.retrievedKeys.size() > 0 || inClean) {
            if (this.retrievedKeys.size() > 0) {
                this.cleanRetrieved(cacheId);
            }
            while ((long)knownSize * cell.getElementSize() >= this.maxCacheSize && inClean) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e) {
                    this.logService.warn((Object)"Interrupted while waiting for cache to clean", (Throwable)e);
                }
                map2 = this.knownKeys;
                synchronized (map2) {
                    knownSize = this.knownKeys.keySet().size() + 1;
                    inClean = this.cleaning[0];
                }
            }
        } else {
            this.diskIsFull(true);
        }
        if (!this.enabled()) {
            return CacheResult.CACHE_DISABLED;
        }
        if (this.diskFull()) {
            return CacheResult.DISK_FULL;
        }
        map2 = this.knownKeys;
        synchronized (map2) {
            this.knownKeys.put(key, cell.getCurrentHash());
            this.retrievedKeys.remove(key);
        }
        cache.put((Object)key, cell);
        this.db().commit();
        return CacheResult.SUCCESS;
    }

    @Override
    public SCIFIOCell<?> retrieve(String cacheId, int index) {
        SCIFIOCell<?> cell = this.getCell(cacheId, index);
        if (cell != null) {
            this.retrievedKeys.add(this.getKey(cacheId, index));
            this.refManagerService.manage(cell, new Object[0]);
        }
        return cell;
    }

    @Override
    public SCIFIOCell<?> retrieveNoRecache(String cacheId, int index) {
        SCIFIOCell<?> cell = this.getCell(cacheId, index);
        if (cell != null) {
            this.retrievedKeys.add(this.getKey(cacheId, index));
            cell.cacheOnFinalize(false);
            this.refManagerService.manage(cell, new Object[0]);
        }
        return cell;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cleanRetrieved(final String cacheId) {
        Object object = this.knownKeys;
        synchronized (object) {
            for (Integer oldKey : this.retrievedKeys) {
                this.knownKeys.remove(oldKey);
            }
        }
        object = this.cleaningQueue;
        synchronized (object) {
            this.cleaningQueue.add(new HashSet<Integer>(this.retrievedKeys));
        }
        this.retrievedKeys.clear();
        if (!this.cleaning[0]) {
            this.cleaning[0] = true;
            this.threadService.run(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Set toClean = (Set)MapDBCache.this.cleaningQueue.poll();
                    while (MapDBCache.this.cleaning[0]) {
                        Object object = MapDBCache.this.knownKeys;
                        synchronized (object) {
                            for (Integer oldKey : toClean) {
                                if (MapDBCache.this.knownKeys.containsKey(oldKey)) continue;
                                MapDBCache.this.db().getHashMap(cacheId).remove((Object)oldKey);
                            }
                            MapDBCache.this.db().commit();
                        }
                        object = MapDBCache.this.cleaningQueue;
                        synchronized (object) {
                            toClean = (Set)MapDBCache.this.cleaningQueue.poll();
                            ((MapDBCache)MapDBCache.this).cleaning[0] = toClean != null;
                        }
                    }
                }
            });
        }
    }

    @Override
    public void setMaxBytesOnDisk(long maxBytes) {
        this.maxCacheSize = maxBytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        if (this.db == null) {
            return;
        }
        MapDBCache mapDBCache = this;
        synchronized (mapDBCache) {
            for (String cache : this.caches) {
                this.db.delete(cache);
            }
            this.db.commit();
            this.caches.clear();
        }
    }

    private SCIFIOCell<?> getCell(String cacheId, int index) {
        Integer key = this.getKey(cacheId, index);
        HTreeMap cache = this.db().getHashMap(cacheId);
        SCIFIOCell<?> cell = this.getCellFromCache(cache, key);
        if (cell != null) {
            cell.setCacheId(cacheId);
            cell.setIndex(index);
            cell.setService(this);
            cell.cacheOnFinalize(true);
        }
        return cell;
    }

    private SCIFIOCell<?> getCellFromCache(HTreeMap<?, ?> cache, int key) {
        SCIFIOCell cell = null;
        if (this.knownKeys.containsKey(key)) {
            cell = (SCIFIOCell)((Object)cache.get((Object)key));
        }
        return cell;
    }

    private DB db() {
        if (this.db == null) {
            this.createDB();
        }
        return this.db;
    }

    private synchronized void createDB() {
        if (this.db != null) {
            return;
        }
        this.db = DBMaker.newTempFileDB().closeOnJvmShutdown().cacheDisable().transactionDisable().deleteFilesAfterClose().make();
    }
}

