/*
 * Decompiled with CFR 0.152.
 */
package io.scif.formats;

import io.scif.AbstractChecker;
import io.scif.AbstractFormat;
import io.scif.AbstractMetadata;
import io.scif.AbstractParser;
import io.scif.ByteArrayPlane;
import io.scif.ByteArrayReader;
import io.scif.Format;
import io.scif.FormatException;
import io.scif.ImageMetadata;
import io.scif.config.SCIFIOConfig;
import io.scif.io.ByteArrayHandle;
import io.scif.io.RandomAccessInputStream;
import io.scif.io.RandomAccessOutputStream;
import io.scif.util.FormatTools;
import java.io.IOException;
import java.util.StringTokenizer;
import net.imagej.axis.Axes;
import org.scijava.plugin.Plugin;

@Plugin(type=Format.class, name="Portable Gray Map")
public class PGMFormat
extends AbstractFormat {
    @Override
    protected String[] makeSuffixArray() {
        return new String[]{"pgm"};
    }

    public static class Reader
    extends ByteArrayReader<Metadata> {
        @Override
        protected String[] createDomainArray() {
            return new String[]{"Graphics"};
        }

        @Override
        public ByteArrayPlane openPlane(int imageIndex, long planeIndex, ByteArrayPlane plane, long[] planeMin, long[] planeMax, SCIFIOConfig config) throws FormatException, IOException {
            byte[] buf = (byte[])plane.getData();
            Metadata meta = (Metadata)this.getMetadata();
            FormatTools.checkPlaneForReading(meta, imageIndex, planeIndex, buf.length, planeMin, planeMax);
            this.getStream().seek(meta.getOffset());
            if (meta.isRawBits()) {
                this.readPlane(this.getStream(), imageIndex, planeMin, planeMax, plane);
            } else {
                ByteArrayHandle handle = new ByteArrayHandle();
                RandomAccessOutputStream out = new RandomAccessOutputStream(handle);
                out.order(meta.get(imageIndex).isLittleEndian());
                while (this.getStream().getFilePointer() < this.getStream().length()) {
                    String line = this.getStream().readLine().trim();
                    line = line.replaceAll("[^0-9]", " ");
                    StringTokenizer t = new StringTokenizer(line, " ");
                    while (t.hasMoreTokens()) {
                        int q = Integer.parseInt(t.nextToken().trim());
                        if (meta.get(imageIndex).getPixelType() == 3) {
                            out.writeShort(q);
                            continue;
                        }
                        out.writeByte(q);
                    }
                }
                out.close();
                RandomAccessInputStream s = new RandomAccessInputStream(this.getContext(), handle);
                s.seek(0L);
                this.readPlane(s, imageIndex, planeMin, planeMax, plane);
                s.close();
            }
            return plane;
        }
    }

    public static class Parser
    extends AbstractParser<Metadata> {
        @Override
        protected void typedParse(RandomAccessInputStream stream, Metadata meta, SCIFIOConfig config) throws IOException, FormatException {
            long height = -1L;
            long width = -1L;
            int max = -1;
            String magic = null;
            boolean isBlackAndWhite = false;
            int varsRead = 0;
            int numVars = 4;
            while (varsRead < numVars) {
                String[] vars;
                String line = stream.readLine();
                if (line == null) {
                    throw new FormatException("Read entire file without finding complete PGM metadata.");
                }
                if (line.contains("#")) {
                    line = line.substring(0, line.indexOf("#"));
                }
                line = line.replaceAll("[^P0-9]", " ");
                block7: for (String var : vars = line.split(" ")) {
                    switch (++varsRead) {
                        case 1: {
                            magic = var;
                            if (!magic.equals("P1") && !magic.equals("P4")) continue block7;
                            numVars = 3;
                            isBlackAndWhite = true;
                            continue block7;
                        }
                        case 2: {
                            width = Integer.parseInt(var);
                            continue block7;
                        }
                        case 3: {
                            height = Integer.parseInt(var);
                            continue block7;
                        }
                        case 4: {
                            max = Integer.parseInt(var);
                        }
                    }
                }
            }
            if (magic == null || height == -1L || width == -1L || !isBlackAndWhite && max == -1) {
                throw new FormatException("Incomplete PGM metadata found. Read the following metadata: magic = " + magic + "; height = " + height + "; width = " + width + "; max = " + max);
            }
            meta.createImageMetadata(1);
            ImageMetadata iMeta = meta.get(0);
            iMeta.setAxisLength(Axes.X, width);
            iMeta.setAxisLength(Axes.Y, height);
            meta.setRawBits(magic.equals("P4") || magic.equals("P5") || magic.equals("P6"));
            iMeta.setAxisLength(Axes.CHANNEL, magic.equals("P3") || magic.equals("P6") ? 3L : 1L);
            if (!isBlackAndWhite) {
                if (max > 255) {
                    iMeta.setPixelType(3);
                } else {
                    iMeta.setPixelType(1);
                }
            }
            meta.setOffset(stream.getFilePointer());
            meta.getTable().put("Black and white", isBlackAndWhite);
        }
    }

    public static class Checker
    extends AbstractChecker {
        public static final char PGM_MAGIC_CHAR = 'P';

        @Override
        public boolean suffixNecessary() {
            return false;
        }

        @Override
        public boolean isFormat(RandomAccessInputStream stream) throws IOException {
            int blockLen = 2;
            if (!FormatTools.validStream(stream, 2, false)) {
                return false;
            }
            return stream.read() == 80 && Character.isDigit((char)stream.read());
        }
    }

    public static class Metadata
    extends AbstractMetadata {
        private boolean rawBits;
        private long offset;

        public boolean isRawBits() {
            return this.rawBits;
        }

        public void setRawBits(boolean rawBits) {
            this.rawBits = rawBits;
        }

        public long getOffset() {
            return this.offset;
        }

        public void setOffset(long offset) {
            this.offset = offset;
        }

        @Override
        public void populateImageMetadata() {
            ImageMetadata iMeta;
            iMeta.setPlanarAxisCount((iMeta = this.get(0)).getAxisLength(Axes.CHANNEL) == 3L ? 3 : 2);
            iMeta.setLittleEndian(false);
            iMeta.setIndexed(false);
            iMeta.setFalseColor(false);
            iMeta.setMetadataComplete(true);
        }

        @Override
        public void close(boolean fileOnly) throws IOException {
            super.close(fileOnly);
            if (!fileOnly) {
                this.setRawBits(false);
                this.setOffset(0L);
            }
        }
    }
}

