/*
 * Decompiled with CFR 0.152.
 */
package io.scif.formats;

import io.scif.AbstractFormat;
import io.scif.AbstractMetadata;
import io.scif.AbstractParser;
import io.scif.ByteArrayPlane;
import io.scif.ByteArrayReader;
import io.scif.Format;
import io.scif.FormatException;
import io.scif.ImageMetadata;
import io.scif.config.SCIFIOConfig;
import io.scif.io.RandomAccessInputStream;
import io.scif.util.FormatTools;
import java.io.IOException;
import net.imagej.axis.Axes;
import org.scijava.plugin.Plugin;
import org.scijava.util.ArrayUtils;

@Plugin(type=Format.class, name="Flexible Image Transport System")
public class FITSFormat
extends AbstractFormat {
    @Override
    protected String[] makeSuffixArray() {
        return new String[]{"fits", "fts"};
    }

    public static class Reader
    extends ByteArrayReader<Metadata> {
        @Override
        protected String[] createDomainArray() {
            return new String[]{"Astronomy", "Unknown"};
        }

        @Override
        public ByteArrayPlane openPlane(int imageIndex, long planeIndex, ByteArrayPlane plane, long[] planeMin, long[] planeMax, SCIFIOConfig config) throws FormatException, IOException {
            byte[] buf = (byte[])plane.getData();
            FormatTools.checkPlaneForReading(this.getMetadata(), imageIndex, planeIndex, buf.length, planeMin, planeMax);
            this.getStream().seek(((Metadata)this.getMetadata()).getPixelOffset() + planeIndex * FormatTools.getPlaneSize(this, imageIndex));
            return this.readPlane(this.getStream(), imageIndex, planeMin, planeMax, plane);
        }
    }

    public static class Parser
    extends AbstractParser<Metadata> {
        private static final int LINE_LENGTH = 80;

        @Override
        protected void typedParse(RandomAccessInputStream stream, Metadata meta, SCIFIOConfig config) throws IOException, FormatException {
            meta.createImageMetadata(1);
            ImageMetadata iMeta = meta.get(0);
            String line = this.getSource().readString(80);
            if (!line.startsWith("SIMPLE")) {
                throw new FormatException("Unsupported FITS file.");
            }
            String key = "";
            String value = "";
            while (true) {
                int ndx;
                int comment;
                if ((comment = (line = this.getSource().readString(80)).indexOf("/", ndx = line.indexOf("="))) < 0) {
                    comment = line.length();
                }
                if (ndx >= 0) {
                    key = line.substring(0, ndx).trim();
                    value = line.substring(ndx + 1, comment).trim();
                } else {
                    key = line.trim();
                }
                if (key.equals("END") && iMeta.getAxisLength(Axes.X) > 0L) break;
                if (key.equals("BITPIX")) {
                    int bits = Integer.parseInt(value);
                    boolean fp = bits < 0;
                    boolean signed = bits != 8;
                    int bytes = Math.abs(bits) / 8;
                    iMeta.setPixelType(FormatTools.pixelTypeFromBytes(bytes, signed, fp));
                    iMeta.setBitsPerPixel(Math.abs(bits));
                } else if (key.equals("NAXIS1")) {
                    iMeta.setAxisLength(Axes.X, (long)Integer.parseInt(value));
                } else if (key.equals("NAXIS2")) {
                    iMeta.setAxisLength(Axes.Y, (long)Integer.parseInt(value));
                } else if (key.equals("NAXIS3")) {
                    iMeta.setAxisLength(Axes.Z, (long)Integer.parseInt(value));
                }
                meta.getTable().put(key, value);
            }
            while (this.getSource().read() == 32) {
            }
            meta.setPixelOffset(this.getSource().getFilePointer() - 1L);
        }
    }

    public static class Metadata
    extends AbstractMetadata {
        private long pixelOffset;

        public long getPixelOffset() {
            return this.pixelOffset;
        }

        public void setPixelOffset(long pixelOffset) {
            this.pixelOffset = pixelOffset;
        }

        @Override
        public void populateImageMetadata() {
            ImageMetadata iMeta = this.get(0);
            if (iMeta.getAxisLength(Axes.Z) == 0L) {
                iMeta.setAxisLength(Axes.Z, 1L);
            }
            int planeSize = (int)iMeta.getAxisLength(Axes.X) * (int)iMeta.getAxisLength(Axes.Y) * FormatTools.getBytesPerPixel(iMeta.getPixelType());
            try {
                if (ArrayUtils.safeMultiply64((long[])new long[]{planeSize, iMeta.getAxisLength(Axes.Z)}) > this.getSource().length() - this.pixelOffset) {
                    iMeta.setAxisLength(Axes.Z, (long)((int)((this.getSource().length() - this.pixelOffset) / (long)planeSize)));
                }
            }
            catch (IOException e) {
                this.log().error((Object)"Failed to determine input stream length", (Throwable)e);
            }
            iMeta.setAxisTypes(Axes.X, Axes.Y, Axes.Z);
            iMeta.setPlanarAxisCount(2);
            iMeta.setLittleEndian(false);
            iMeta.setIndexed(false);
            iMeta.setFalseColor(false);
            iMeta.setMetadataComplete(true);
        }

        @Override
        public void close() {
            this.pixelOffset = 0L;
        }
    }
}

